/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.presentation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public class CompoundPropertyEditorPresentation
extends PropertyEditorPresentation {
    private final List<PropertyEditorPresentation> m_presentations = new ArrayList<PropertyEditorPresentation>();

    public void add(PropertyEditorPresentation presentation) {
        this.m_presentations.add(presentation);
    }

    @Override
    public void show(PropertyTable propertyTable, Property property, int x, int y, int width, int height) {
        for (PropertyEditorPresentation presentation : this.m_presentations) {
            presentation.show(propertyTable, property, x, y, width, height);
            Dimension size = presentation.getSize(width, height);
            width -= size.width;
        }
    }

    @Override
    public void hide(PropertyTable propertyTable, Property property) {
        for (PropertyEditorPresentation presentation : this.m_presentations) {
            presentation.hide(propertyTable, property);
        }
    }

    @Override
    public Dimension getSize(int wHint, int hHint) {
        Dimension compositeSize = new Dimension(0, 0);
        int i = 0;
        while (i < this.m_presentations.size()) {
            PropertyEditorPresentation presentation = this.m_presentations.get(i);
            if (i == 0) {
                compositeSize = presentation.getSize(wHint, hHint);
            } else {
                Dimension size = presentation.getSize(wHint, hHint);
                compositeSize.width += size.width;
            }
            ++i;
        }
        return compositeSize;
    }
}

