/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.RankList;
import org.eclipse.draw2d.graph.RevertableChange;
import org.eclipse.draw2d.graph.VirtualNodeCreation;

class PopulateRanks
extends GraphVisitor {
    private final Deque<RevertableChange> changes = new ArrayDeque<RevertableChange>();

    PopulateRanks() {
    }

    @Override
    public void visit(DirectedGraph g) {
        if (g.forestRoot != null) {
            int i = g.forestRoot.outgoing.size() - 1;
            while (i >= 0) {
                g.removeEdge((Edge)g.forestRoot.outgoing.get(i));
                --i;
            }
            g.removeNode(g.forestRoot);
        }
        g.ranks = new RankList();
        for (Node node : g.nodes) {
            g.ranks.getRank(node.rank).add(node);
        }
        for (Node node : List.copyOf(g.nodes)) {
            int j = 0;
            while (j < node.outgoing.size()) {
                Edge e = (Edge)node.outgoing.get(j);
                if (e.getLength() > 1) {
                    this.changes.push(new VirtualNodeCreation(e, g));
                    continue;
                }
                ++j;
            }
        }
    }

    @Override
    public void revisit(DirectedGraph g) {
        for (Rank rank : g.ranks) {
            Node prev = null;
            for (Node cur : rank) {
                cur.left = prev;
                if (prev != null) {
                    prev.right = cur;
                }
                prev = cur;
            }
        }
        this.changes.forEach(RevertableChange::revert);
    }
}

