/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.property;

import java.lang.reflect.Constructor;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.ObjectPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.property.editor.beans.ComboPropertyEditor;
import org.eclipse.wb.internal.swing.model.property.editor.beans.TextPropertyEditor;
import org.eclipse.wb.internal.swing.model.property.editor.color.ColorPropertyEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class BeanPropertyEditorTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_ignore_SunBeansEditors() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("background");
        BeanPropertyEditorTest.assertNotNull((Object)property);
        BeanPropertyEditorTest.assertNotInstanceOf(TextPropertyEditor.class, property.getEditor());
        BeanPropertyEditorTest.assertNotInstanceOf(ComboPropertyEditor.class, property.getEditor());
        BeanPropertyEditorTest.assertInstanceOf(ColorPropertyEditor.class, (Object)property.getEditor());
    }

    @Test
    public void test_editorForEditor() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyEditor.java", this.getTestSource("import java.beans.PropertyEditorSupport;", "public class MyEditor extends PropertyEditorSupport {", "}"));
        BeanPropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        BeanPropertyEditorTest.waitForAutoBuild();
        Class<?> editorType = this.m_lastLoader.loadClass("test.MyEditor");
        PropertyEditor propertyEditor = DescriptionPropertiesHelper.getEditorForEditorType(editorType);
        BeanPropertyEditorTest.assertNotNull((Object)propertyEditor);
    }

    @Test
    public void test_editorForEditor_beanInfo() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyIntEditor.java", this.getTestSource("import java.beans.PropertyEditorSupport;", "public class MyIntEditor extends PropertyEditorSupport {", "}"));
        BeanPropertyEditorTest.setFileContentSrc("test/MyComboEditor.java", this.getTestSource("import java.beans.PropertyEditorSupport;", "public class MyComboEditor extends PropertyEditorSupport {", "  private String[] m_items = {'111', '222', '333'};", "  public String[] getTags() {", "    return m_items;", "  }", "  public boolean supportsCustomEditor() {", "    return true;", "  }", "}"));
        BeanPropertyEditorTest.setFileContentSrc("test/MyBean.java", this.getTestSource("public class MyBean extends JButton {", "  private Object m_value;", "  private String m_value2;", "  public Object getValue() {", "    return m_value;", "  }", "  public void setValue(Object value) {", "    m_value = value;", "  }", "  public String getValue2() {", "    return m_value2;", "  }", "  public void setValue2(String value) {", "    m_value2 = value;", "  }", "}"));
        BeanPropertyEditorTest.waitForAutoBuild();
        BeanPropertyEditorTest.setFileContentSrc("test/MyBeanBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;", "import java.beans.Introspector;", "import java.beans.SimpleBeanInfo;", "import java.beans.PropertyDescriptor;", "public class MyBeanBeanInfo extends SimpleBeanInfo {", "  private PropertyDescriptor[] m_descriptors;", "  public MyBeanBeanInfo() {", "    try {", "      BeanInfo info = Introspector.getBeanInfo(JButton.class);", "      PropertyDescriptor[] descriptors = info.getPropertyDescriptors();", "      m_descriptors = new PropertyDescriptor[descriptors.length + 2];", "      System.arraycopy(descriptors, 0, m_descriptors, 0, descriptors.length);", "      m_descriptors[descriptors.length] = new PropertyDescriptor('value', MyBean.class, 'getValue', 'setValue');", "      m_descriptors[descriptors.length].setPropertyEditorClass(MyIntEditor.class);", "      m_descriptors[descriptors.length + 1] = new PropertyDescriptor('value2', MyBean.class, 'getValue2', 'setValue2');", "      m_descriptors[descriptors.length + 1].setPropertyEditorClass(MyComboEditor.class);", "    } catch (Throwable e) {", "    }", "  }", "  public PropertyDescriptor[] getPropertyDescriptors() {", "    return m_descriptors;", "  }", "}"));
        BeanPropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyBean bean = new MyBean();", "    add(bean);", "  }", "}");
        panel.refresh();
        ComponentInfo bean = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = bean.getPropertyByTitle("value");
        BeanPropertyEditorTest.assertNotNull((Object)property);
        PropertyEditor textEditor = property.getEditor();
        BeanPropertyEditorTest.assertInstanceOf(TextPropertyEditor.class, (Object)textEditor);
        BeanPropertyEditorTest.assertNull((Object)textEditor.getPresentation());
        property = bean.getPropertyByTitle("value2");
        BeanPropertyEditorTest.assertNotNull((Object)property);
        PropertyEditor comboEditor = property.getEditor();
        BeanPropertyEditorTest.assertInstanceOf(ComboPropertyEditor.class, (Object)comboEditor);
        BeanPropertyEditorTest.assertNotNull((Object)comboEditor.getPresentation());
    }

    @Test
    public void test_EditorForType_exceptionDuringLoadingEditor() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyEditor.java", this.getTestSource("import java.beans.PropertyEditorSupport;", "public class MyEditor extends PropertyEditorSupport {", "  public MyEditor() {", "    throw new IllegalStateException('actual');", "  }", "}"));
        BeanPropertyEditorTest.setFileContentSrc("test/MyBean.java", this.getTestSource("public class MyBean extends JButton {", "  public void setValue(Object value) {", "  }", "}"));
        BeanPropertyEditorTest.setFileContentSrc("test/MyBeanBeanInfo.java", this.getTestSource("import java.beans.*;", "public class MyBeanBeanInfo extends SimpleBeanInfo {", "  private PropertyDescriptor[] m_descriptors;", "  public MyBeanBeanInfo() {", "    try {", "      BeanInfo info = Introspector.getBeanInfo(JButton.class);", "      m_descriptors = new PropertyDescriptor[1];", "      m_descriptors[0] = new PropertyDescriptor('value', MyBean.class, null, 'setValue');", "      m_descriptors[0].setPropertyEditorClass(MyEditor.class);", "    } catch (Throwable e) {", "    }", "  }", "  public PropertyDescriptor[] getPropertyDescriptors() {", "    return m_descriptors;", "  }", "}"));
        BeanPropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyBean bean = new MyBean();", "    add(bean);", "  }", "}");
        ComponentInfo bean = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = bean.getPropertyByTitle("value");
        BeanPropertyEditorTest.assertNotNull((Object)property);
        BeanPropertyEditorTest.assertInstanceOf(ObjectPropertyEditor.class, (Object)property.getEditor());
    }

    @Test
    public void test_getEditorForType() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyBean.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyBean {", "  // filler", "}"));
        BeanPropertyEditorTest.setFileContentSrc("test/MyBeanEditor.java", this.getTestSource("import java.beans.PropertyEditorSupport;", "public class MyBeanEditor extends PropertyEditorSupport {", "}"));
        BeanPropertyEditorTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Class<?> beanType = this.m_lastLoader.loadClass("test.MyBean");
        PropertyEditor propertyEditor = DescriptionPropertiesHelper.getEditorForType(beanType);
        BeanPropertyEditorTest.assertNotNull((Object)propertyEditor);
    }

    @Test
    public void test_getEditorForType_whenParsing() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyBean.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "// filler filler filler", "public class MyBean {", "}"));
        BeanPropertyEditorTest.setFileContentSrc("test/MyBeanEditor.java", this.getTestSource("import java.beans.PropertyEditorSupport;", "public class MyBeanEditor extends PropertyEditorSupport {", "}"));
        BeanPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setMyBean(MyBean bean) {", "  }", "}"));
        BeanPropertyEditorTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Property property = panel.getPropertyByTitle("myBean");
        BeanPropertyEditorTest.assertNotNull((Object)property);
        BeanPropertyEditorTest.assertInstanceOf(TextPropertyEditor.class, (Object)property.getEditor());
    }

    @Test
    public void test_getAsText_setAsText() throws Exception {
        this.prepare_TextPropertyEditor();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyBean button = new MyBean();", "    add(button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("value");
        BeanPropertyEditorTest.assertNotNull((Object)property);
        TextPropertyEditor propertyEditor = (TextPropertyEditor)property.getEditor();
        BeanPropertyEditorTest.assertNull((Object)propertyEditor.getPresentation());
        BeanPropertyEditorTest.assertEquals(null, (Object)BeanPropertyEditorTest.getPropertyText(property));
        ReflectionUtils.invokeMethod2((Object)propertyEditor, (String)"setEditorText", Property.class, String.class, (Object)property, (Object)"abc");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyBean button = new MyBean();", "    button.setValue(new MyWrapper('abc'));", "    add(button);", "  }", "}");
        BeanPropertyEditorTest.assertEquals((Object)"abc", (Object)BeanPropertyEditorTest.getPropertyText(property));
        ReflectionUtils.invokeMethod2((Object)propertyEditor, (String)"setEditorText", Property.class, String.class, (Object)property, (Object)"");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyBean button = new MyBean();", "    add(button);", "  }", "}");
        BeanPropertyEditorTest.assertEquals(null, (Object)BeanPropertyEditorTest.getPropertyText(property));
    }

    private void prepare_TextPropertyEditor() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyEditor.java", this.getTestSource("import java.beans.PropertyEditorSupport;", "public class MyEditor extends PropertyEditorSupport {", "  public String getAsText() {", "    if (getValue() == null) {", "      return null;", "    }", "    return ((MyWrapper)getValue()).getText();", "  }", "  public void setAsText(String value) {", "    setValue(new MyWrapper(value));", "  }", "  public String getJavaInitializationString() {", "    if (this.getAsText().length() > 0) {", "      return 'new test.MyWrapper(\\'' + getAsText() + '\\')';", "    }", "    return null;", "  }", "}"));
        this.prepare_MyWrapper_MyBean();
    }

    private void prepare_ComboPropertyEditor() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyEditor.java", this.getTestSource("import java.beans.PropertyEditorSupport;", "public class MyEditor extends PropertyEditorSupport {", "  public String getAsText() {", "    if (getValue() == null) {", "      return null;", "    }", "    return ((MyWrapper)getValue()).getText();", "  }", "  public void setAsText(String value) {", "    setValue(new MyWrapper(value));", "  }", "  public String getJavaInitializationString() {", "    if (this.getAsText().length() > 0) {", "      return 'new test.MyWrapper(\\'' + getAsText() + '\\')';", "    }", "    return null;", "  }", "  private String[] m_items = {'111', '222', '333'};", "  public String[] getTags() {", "    return m_items;", "  }", "}"));
        this.prepare_MyWrapper_MyBean();
    }

    private void prepare_MyWrapper_MyBean() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyWrapper.java", this.getTestSource("public class MyWrapper {", "  private final String m_text;", "  public MyWrapper(String text) {", "    m_text = text;", "  }", "  public String getText() {", "    return m_text;", "  }", "}"));
        BeanPropertyEditorTest.setFileContentSrc("test/MyBean.java", this.getTestSource("public class MyBean extends JButton {", "  private Object m_value;", "  public Object getValue() {", "    return m_value;", "  }", "  public void setValue(Object value) {", "    m_value = value;", "  }", "}"));
        BeanPropertyEditorTest.setFileContentSrc("test/MyBeanBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;", "import java.beans.Introspector;", "import java.beans.SimpleBeanInfo;", "import java.beans.PropertyDescriptor;", "public class MyBeanBeanInfo extends SimpleBeanInfo {", "  private PropertyDescriptor[] m_descriptors;", "  public MyBeanBeanInfo() {", "    try {", "      BeanInfo info = Introspector.getBeanInfo(JButton.class);", "      PropertyDescriptor[] descriptors = info.getPropertyDescriptors();", "      m_descriptors = new PropertyDescriptor[descriptors.length + 1];", "      System.arraycopy(descriptors, 0, m_descriptors, 0, descriptors.length);", "      m_descriptors[descriptors.length] = new PropertyDescriptor('value', MyBean.class, 'getValue', 'setValue');", "      m_descriptors[descriptors.length].setPropertyEditorClass(MyEditor.class);", "    } catch (Throwable e) {", "    }", "  }", "  public PropertyDescriptor[] getPropertyDescriptors() {", "    return m_descriptors;", "  }", "}"));
        BeanPropertyEditorTest.waitForAutoBuild();
    }

    private Object createMyWrapper(String value) throws Exception {
        Class<?> wrapperClass = this.m_lastLoader.loadClass("test.MyWrapper");
        Constructor wrapperConstructor = ReflectionUtils.getConstructor(wrapperClass, (Class[])new Class[]{String.class});
        return wrapperConstructor.newInstance(value);
    }

    @Test
    public void test_IValueSourcePropertyEditor_TextPropertyEditor() throws Exception {
        this.prepare_TextPropertyEditor();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyBean button = new MyBean();", "    add(button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("value");
        Object wrapper = this.createMyWrapper("myValue");
        TextPropertyEditor propertyEditor = (TextPropertyEditor)property.getEditor();
        BeanPropertyEditorTest.assertEquals((Object)"new test.MyWrapper(\"myValue\")", (Object)propertyEditor.getValueSource(wrapper));
        property.setValue(wrapper);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyBean button = new MyBean();", "    button.setValue(new MyWrapper('myValue'));", "    add(button);", "  }", "}");
        BeanPropertyEditorTest.assertEquals((Object)"myValue", (Object)BeanPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_IValueSourcePropertyEditor_ComboPropertyEditor() throws Exception {
        this.prepare_ComboPropertyEditor();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyBean button = new MyBean();", "    add(button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("value");
        Object wrapper = this.createMyWrapper("222");
        ComboPropertyEditor propertyEditor = (ComboPropertyEditor)property.getEditor();
        BeanPropertyEditorTest.assertEquals((Object)"new test.MyWrapper(\"222\")", (Object)propertyEditor.getValueSource(wrapper));
        property.setValue(wrapper);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyBean button = new MyBean();", "    button.setValue(new MyWrapper('222'));", "    add(button);", "  }", "}");
        BeanPropertyEditorTest.assertEquals((Object)"222", (Object)BeanPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_PropertyEditorSupport_setSource_1() throws Exception {
        this.configure_PropertyEditorSupport_setSource_forText();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyBean bean = new MyBean(1);", "      add(bean);", "    }", "    {", "      MyBean bean = new MyBean(2);", "      add(bean);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("foo");
        BeanPropertyEditorTest.assertEquals((Object)"1", (Object)BeanPropertyEditorTest.getPropertyText(property));
        button = (ComponentInfo)panel.getChildrenComponents().get(1);
        property = button.getPropertyByTitle("foo");
        BeanPropertyEditorTest.assertEquals((Object)"2", (Object)BeanPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_PropertyEditorSupport_setSource_2() throws Exception {
        this.configure_PropertyEditorSupport_setSource_forText();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyBean bean = new MyBean(5);", "      add(bean);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("foo");
        ReflectionUtils.invokeMethod2((Object)property.getEditor(), (String)"setEditorText", Property.class, String.class, (Object)property, (Object)"000");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyBean bean = new MyBean(5);", "      bean.setFoo(5);", "      add(bean);", "    }", "  }", "}");
        BeanPropertyEditorTest.assertEquals((Object)"5", (Object)BeanPropertyEditorTest.getPropertyText(property));
    }

    @Test
    public void test_PropertyEditorSupport_setSource_forCombo() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyEditor.java", this.getTestSource("import java.beans.PropertyEditorSupport;", "public class MyEditor extends PropertyEditorSupport {", "  public String[] getTags() {", "    if (getSource() instanceof MyBean) {", "      int value = ((MyBean) getSource()).m_value;", "      return new String[] {'' + (value + 0), '' + (value + 1)};", "    }", "    return new String[] {};", "  }", "}"));
        this.configure_PropertyEditorSupport_setSource_justBean();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      MyBean bean = new MyBean(5);", "      add(bean);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("foo");
        PropertyEditor propertyEditor = property.getEditor();
        Object[] tags = (String[])ReflectionUtils.invokeMethod2((Object)propertyEditor, (String)"getTags", Property.class, (Object)property);
        BeanPropertyEditorTest.assertArrayEquals((Object[])tags, (Object[])new String[]{"5", "6"});
    }

    private void configure_PropertyEditorSupport_setSource_forText() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyEditor.java", this.getTestSource("import java.beans.PropertyEditorSupport;", "public class MyEditor extends PropertyEditorSupport {", "  public String getAsText() {", "    return '' + ((MyBean) getSource()).m_value;", "  }", "  public void setAsText(String text) {", "    // do nothing", "  }", "  public String getJavaInitializationString() {", "    return '' + ((MyBean) getSource()).m_value;", "  }", "}"));
        this.configure_PropertyEditorSupport_setSource_justBean();
    }

    private void configure_PropertyEditorSupport_setSource_justBean() throws Exception {
        BeanPropertyEditorTest.setFileContentSrc("test/MyBean.java", this.getTestSource("public class MyBean extends JButton {", "  int m_value;", "  private int m_foo;", "  public MyBean(int value) {", "    m_value = value;", "  }", "  public int getFoo() {", "    return m_foo;", "  }", "  public void setFoo(int foo) {", "    m_foo = foo;", "  }", "}"));
        BeanPropertyEditorTest.setFileContentSrc("test/MyBeanBeanInfo.java", this.getTestSource("import java.beans.*;", "public class MyBeanBeanInfo extends SimpleBeanInfo {", "  private PropertyDescriptor[] m_descriptors;", "  public MyBeanBeanInfo() {", "    try {", "      BeanInfo info = Introspector.getBeanInfo(JButton.class);", "      PropertyDescriptor[] descriptors = info.getPropertyDescriptors();", "      m_descriptors = new PropertyDescriptor[descriptors.length + 1];", "      System.arraycopy(descriptors, 0, m_descriptors, 0, descriptors.length);", "      m_descriptors[descriptors.length] = new PropertyDescriptor('foo', MyBean.class, 'getFoo', 'setFoo');", "      m_descriptors[descriptors.length].setPropertyEditorClass(MyEditor.class);", "    } catch (Throwable e) {", "    }", "  }", "  public PropertyDescriptor[] getPropertyDescriptors() {", "    return m_descriptors;", "  }", "}"));
        BeanPropertyEditorTest.waitForAutoBuild();
    }
}

