/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gef;

import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gef.AbstractLayoutPolicyTest;
import org.junit.Test;

public class GridLayoutPolicyTest
extends AbstractLayoutPolicyTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setLayout() throws Exception {
        String[] source = new String[]{"// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        String[] source2 = new String[]{"// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(1, 0, 0, 0));", "  }", "}"};
        this.check_setLayout(source, "java.awt.GridLayout", source2, 10, 10);
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(0, 3));", "  }", "}");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.canvas.moveTo((Object)panel, 10, 10);
        this.canvas.click();
        this.canvas.assertFeedbackFigures(0);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(0, 3));", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(0, 3));", "    {", "      JButton button = new JButton('Button 1');", "      add(button);", "    }", "    {", "      JButton button = new JButton('Button 2');", "      add(button);", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.canvas.beginDrag(button_2);
        this.canvas.dragTo((Object)button_1, 10, 0);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(0, 3));", "    {", "      JButton button = new JButton('Button 2');", "      add(button);", "    }", "    {", "      JButton button = new JButton('Button 1');", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton('Button');", "      add(button, BorderLayout.NORTH);", "    }", "    {", "      JPanel panel = new JPanel();", "      panel.setLayout(new GridLayout(0, 3));", "      panel.setBackground(Color.PINK);", "      panel.setPreferredSize(new Dimension(0, 150));", "      add(panel, BorderLayout.SOUTH);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo inner = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.canvas.beginDrag(button);
        this.canvas.dragTo((Object)inner, 10, 10);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JPanel panel = new JPanel();", "      panel.setLayout(new GridLayout(0, 3));", "      panel.setBackground(Color.PINK);", "      panel.setPreferredSize(new Dimension(0, 150));", "      add(panel, BorderLayout.SOUTH);", "      {", "        JButton button = new JButton('Button');", "        panel.add(button);", "      }", "    }", "  }", "}");
    }
}

