/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.MigLayout;

import java.util.List;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.swing.SwingImages;
import org.eclipse.wb.tests.designer.swing.model.layout.MigLayout.AbstractMigLayoutTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class MigLayoutConstraintsTest
extends AbstractMigLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_newConstraints() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 1 2 3 4');", "  }", "}");
        panel.refresh();
        ComponentInfo newButton = MigLayoutConstraintsTest.createJButton();
        panel.addChild((ObjectInfo)newButton);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)newButton);
        MigLayoutConstraintsTest.assertEquals((long)0L, (long)constraints.getX());
        MigLayoutConstraintsTest.assertEquals((long)0L, (long)constraints.getY());
        MigLayoutConstraintsTest.assertEquals((long)1L, (long)constraints.getWidth());
        MigLayoutConstraintsTest.assertEquals((long)1L, (long)constraints.getHeight());
        constraints.setX(1);
        constraints.setWidth(2);
        MigLayoutConstraintsTest.assertEquals((long)1L, (long)constraints.getX());
        MigLayoutConstraintsTest.assertEquals((long)2L, (long)constraints.getWidth());
    }

    @Test
    public void test_parseString_getBounds() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 1 2 3 4');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutConstraintsTest.assertCellBounds(button, 1, 2, 3, 4);
    }

    @Test
    public void test_parseCC_getBounds() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), new CC().cell(1,2,3,4));", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutConstraintsTest.assertCellBounds(button, 1, 2, 3, 4);
    }

    @Test
    public void test_parseString_noCell() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[][]'));", "    add(new JButton(C_1), 'wrap');", "    add(new JButton(C_2), 'skip');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutConstraintsTest.assertCellBounds(button_1, 0, 0, 1, 1);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        MigLayoutConstraintsTest.assertCellBounds(button_2, 1, 1, 1, 1);
    }

    @Test
    public void test_parseString_span() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('', '[]'));", "    add(new JButton(C_1), 'span');", "    add(new JButton(C_2), 'cell 0 1');", "    add(new JButton(C_3), 'cell 1 1');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutConstraintsTest.assertCellBounds(button_1, 0, 0, 2, 1);
    }

    @Test
    public void test_parse_hidemode3() throws Exception {
        MigLayoutConstraintsTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton() {", "  }", "  public void setVisible2(boolean b) {", "    setVisible(b);", "  }", "}"));
        MigLayoutConstraintsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout('hidemode 3', '[][]'));", "    {", "      MyButton button = new MyButton();", "      button.setVisible2(false);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutConstraintsTest.assertCellBounds(button, 0, 0, 0, 0);
    }

    @Test
    public void test_write_hidemode() throws Exception {
        this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton();", "      add(button, 'hidemode 0,cell 0 0');", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)MigLayoutConstraintsTest.getJavaInfoByName("button");
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        constraints.setX(1);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton();", "      add(button, 'hidemode 0,cell 1 0');", "    }", "  }", "}");
        this.refresh();
    }

    @Test
    public void test_setBounds_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 1 2 3 4');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        constraints.setX(2);
        constraints.setY(3);
        constraints.setWidth(4);
        constraints.setHeight(5);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 2 3 4 5');", "  }", "}");
    }

    @Test
    public void test_setBounds_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1));", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        constraints.setX(2);
        constraints.setY(3);
        constraints.setWidth(4);
        constraints.setHeight(5);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 2 3 4 5');", "  }", "}");
    }

    @Test
    public void test_updateBounds() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 1 2 3 4');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        constraints.updateX(1);
        constraints.updateY(1);
        constraints.updateWidth(1);
        constraints.updateHeight(1);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 2 3 4 5');", "  }", "}");
    }

    @Test
    public void test_setString() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(), '');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        MigLayoutConstraintsTest.assertEquals((Object)"", (Object)constraints.getString());
        String sourceString = "cell 1 2 3 4,wrap";
        String expectedString = "cell 1 2 3 4,wrap";
        constraints.setString(sourceString);
        MigLayoutConstraintsTest.assertEquals((Object)expectedString, (Object)constraints.getString());
        constraints.write();
        MigLayoutConstraintsTest.assertEquals((Object)expectedString, (Object)this.getCellConstraintsSource(constraints));
        sourceString = "wRaP,cell 1 2 3 4 ";
        expectedString = "cell 1 2 3 4,wrap";
        constraints.setString(sourceString);
        MigLayoutConstraintsTest.assertEquals((Object)expectedString, (Object)constraints.getString());
        try {
            constraints.setString("somethingBad");
            MigLayoutConstraintsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private String getCellConstraintsSource(CellConstraintsSupport cell) {
        ComponentInfo m_component = cell.getComponent();
        if (m_component.getAssociation() instanceof InvocationChildAssociation) {
            MethodInvocation invocation = ((InvocationChildAssociation)m_component.getAssociation()).getInvocation();
            Expression expression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1);
            return ((StringLiteral)expression).getLiteralValue();
        }
        return null;
    }

    @Test
    public void test_cleanUpSource_gapleft() throws Exception {
        this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'gap 1');", "    add(new JButton(C_2), 'gap 2,wrap');", "  }", "}");
        this.refresh();
        MigLayoutConstraintsTest.rewriteConstraints();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'gapx 1');", "    add(new JButton(C_2), 'gapx 2,wrap');", "  }", "}");
    }

    @Test
    public void test_cleanUpSource_gapright() throws Exception {
        this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'gapright 1');", "    add(new JButton(C_2), 'gapright 2,wrap');", "  }", "}");
        this.refresh();
        MigLayoutConstraintsTest.rewriteConstraints();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'gapright 1');", "    add(new JButton(C_2), 'gapright 2,wrap');", "  }", "}");
    }

    @Test
    public void test_cleanUpSource_gaptop() throws Exception {
        this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'gaptop 1');", "    add(new JButton(C_2), 'gaptop 2,wrap');", "  }", "}");
        this.refresh();
        MigLayoutConstraintsTest.rewriteConstraints();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'gapy 1');", "    add(new JButton(C_2), 'gapy 2,wrap');", "  }", "}");
    }

    @Test
    public void test_cleanUpSource_gapbottom() throws Exception {
        this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'gapbottom 1');", "    add(new JButton(C_2), 'gapbottom 2,wrap');", "  }", "}");
        this.refresh();
        MigLayoutConstraintsTest.rewriteConstraints();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'gapbottom 1');", "    add(new JButton(C_2), 'gapbottom 2,wrap');", "  }", "}");
    }

    private static void rewriteConstraints() throws Exception {
        ContainerInfo panel = (ContainerInfo)GlobalState.getActiveObject();
        List components = panel.getChildrenComponents();
        for (ComponentInfo component : components) {
            CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)component);
            constraints.write0();
        }
    }

    @Test
    public void test_makeExplicitCell_flow() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), '');", "  }", "}");
        panel.refresh();
        MigLayoutConstraintsTest.makeExplicitCell(panel);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
    }

    @Test
    public void test_makeExplicitCell_wrap() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'wrap');", "    add(new JButton(C_2), '');", "  }", "}");
        panel.refresh();
        MigLayoutConstraintsTest.makeExplicitCell(panel);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1');", "  }", "}");
    }

    @Test
    public void test_makeExplicitCell_newline() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), '');", "    add(new JButton(C_2), 'newline');", "  }", "}");
        panel.refresh();
        MigLayoutConstraintsTest.makeExplicitCell(panel);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 1');", "  }", "}");
    }

    @Test
    public void test_makeExplicitCell_skip() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), '');", "    add(new JButton(C_2), 'skip');", "  }", "}");
        panel.refresh();
        MigLayoutConstraintsTest.makeExplicitCell(panel);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 2 0');", "  }", "}");
    }

    @Test
    public void test_makeExplicitCell_wrap_skip() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'wrap');", "    add(new JButton(C_2), 'skip');", "  }", "}");
        panel.refresh();
        MigLayoutConstraintsTest.makeExplicitCell(panel);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 1 1');", "  }", "}");
    }

    @Test
    public void test_makeExplicitCell_hasDock() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'north');", "    add(new JButton(C_2), 'skip');", "  }", "}");
        panel.refresh();
        MigLayoutConstraintsTest.makeExplicitCell(panel);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'north');", "    add(new JButton(C_2), 'cell 1 0');", "  }", "}");
    }

    @Test
    public void test_makeExplicitCell_split_span_wrap() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'split, span');", "    add(new JButton(C_2), 'wrap');", "    add(new JButton(C_3), '');", "  }", "}");
        panel.refresh();
        MigLayoutConstraintsTest.makeExplicitCell(panel);
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 0');", "    add(new JButton(C_3), 'cell 0 1');", "  }", "}");
    }

    private static void makeExplicitCell(ContainerInfo container) throws Exception {
        for (ComponentInfo button : container.getChildrenComponents()) {
            CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
            constraints.makeExplicitCell();
            constraints.write();
        }
    }

    @Test
    public void test_alignment_UNKNOWN() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        MigLayoutConstraintsTest.assertSame((Object)MigColumnInfo.Alignment.DEFAULT, (Object)constraints.getHorizontalAlignment());
        MigLayoutConstraintsTest.assertSame((Object)MigRowInfo.Alignment.DEFAULT, (Object)constraints.getVerticalAlignment());
        constraints.setHorizontalAlignment(MigColumnInfo.Alignment.CENTER);
        constraints.setVerticalAlignment(MigRowInfo.Alignment.BOTTOM);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0,alignx center,aligny bottom');", "  }", "}");
        constraints.setHorizontalAlignment(MigColumnInfo.Alignment.FILL);
        constraints.setVerticalAlignment(MigRowInfo.Alignment.FILL);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0,grow');", "  }", "}");
        constraints.setHorizontalAlignment(MigColumnInfo.Alignment.LEFT);
        constraints.setVerticalAlignment(MigRowInfo.Alignment.FILL);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0,alignx left,growy');", "  }", "}");
        constraints.setHorizontalAlignment(MigColumnInfo.Alignment.LEADING);
        constraints.setVerticalAlignment(MigRowInfo.Alignment.BASELINE);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0,alignx leading,aligny baseline');", "  }", "}");
        constraints.setHorizontalAlignment(MigColumnInfo.Alignment.DEFAULT);
        constraints.setVerticalAlignment(MigRowInfo.Alignment.DEFAULT);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
    }

    @Test
    public void test_setAlignment_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0, grow');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        MigLayoutConstraintsTest.assertSame((Object)MigColumnInfo.Alignment.FILL, (Object)constraints.getHorizontalAlignment());
        MigLayoutConstraintsTest.assertSame((Object)MigRowInfo.Alignment.FILL, (Object)constraints.getVerticalAlignment());
        constraints.setHorizontalAlignment(MigColumnInfo.Alignment.DEFAULT);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0,growy');", "  }", "}");
        constraints.setVerticalAlignment(MigRowInfo.Alignment.DEFAULT);
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
    }

    @Test
    public void test_alignmentImageHorizontal_UNKNOWN() throws Exception {
        this.check_alignmentImageHorizontal(MigColumnInfo.Alignment.UNKNOWN, CoreImages.ALIGNMENT_H_SMALL_DEFAULT);
    }

    @Test
    public void test_alignmentImageHorizontal_LEFT() throws Exception {
        this.check_alignmentImageHorizontal(MigColumnInfo.Alignment.LEFT, CoreImages.ALIGNMENT_H_SMALL_LEFT);
    }

    @Test
    public void test_alignmentImageHorizontal_CENTER() throws Exception {
        this.check_alignmentImageHorizontal(MigColumnInfo.Alignment.CENTER, CoreImages.ALIGNMENT_H_SMALL_CENTER);
    }

    @Test
    public void test_alignmentImageHorizontal_RIGHT() throws Exception {
        this.check_alignmentImageHorizontal(MigColumnInfo.Alignment.RIGHT, CoreImages.ALIGNMENT_H_SMALL_RIGHT);
    }

    @Test
    public void test_alignmentImageHorizontal_FILL() throws Exception {
        this.check_alignmentImageHorizontal(MigColumnInfo.Alignment.FILL, CoreImages.ALIGNMENT_H_SMALL_FILL);
    }

    @Test
    public void test_alignmentImageHorizontal_LEADING() throws Exception {
        this.check_alignmentImageHorizontal(MigColumnInfo.Alignment.LEADING, CoreImages.ALIGNMENT_H_SMALL_LEADING);
    }

    @Test
    public void test_alignmentImageHorizontal_TRAILING() throws Exception {
        this.check_alignmentImageHorizontal(MigColumnInfo.Alignment.TRAILING, CoreImages.ALIGNMENT_H_SMALL_TRAILING);
    }

    private void check_alignmentImageHorizontal(MigColumnInfo.Alignment alignment, ImageDescriptor descriptor) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        if (alignment != MigColumnInfo.Alignment.UNKNOWN) {
            constraints.setHorizontalAlignment(alignment);
        }
        MigLayoutConstraintsTest.assertSame((Object)descriptor, (Object)constraints.getSmallAlignmentImageDescriptor(true));
    }

    @Test
    public void test_alignmentImageVertical_UNKNOWN() throws Exception {
        this.check_alignmentImageVertical(MigRowInfo.Alignment.UNKNOWN, CoreImages.ALIGNMENT_V_SMALL_DEFAULT);
    }

    @Test
    public void test_alignmentImageVertical_TOP() throws Exception {
        this.check_alignmentImageVertical(MigRowInfo.Alignment.TOP, CoreImages.ALIGNMENT_V_SMALL_TOP);
    }

    @Test
    public void test_alignmentImageVertical_CENTER() throws Exception {
        this.check_alignmentImageVertical(MigRowInfo.Alignment.CENTER, CoreImages.ALIGNMENT_V_SMALL_CENTER);
    }

    @Test
    public void test_alignmentImageVertical_BOTTOM() throws Exception {
        this.check_alignmentImageVertical(MigRowInfo.Alignment.BOTTOM, CoreImages.ALIGNMENT_V_SMALL_BOTTOM);
    }

    @Test
    public void test_alignmentImageVertical_FILL() throws Exception {
        this.check_alignmentImageVertical(MigRowInfo.Alignment.FILL, CoreImages.ALIGNMENT_V_SMALL_FILL);
    }

    @Test
    public void test_alignmentImageVertical_BASELINE() throws Exception {
        this.check_alignmentImageVertical(MigRowInfo.Alignment.BASELINE, SwingImages.ALIGNMENT_V_SMALL_BASELINE);
    }

    private void check_alignmentImageVertical(MigRowInfo.Alignment alignment, ImageDescriptor descriptor) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        if (alignment != MigRowInfo.Alignment.UNKNOWN) {
            constraints.setVerticalAlignment(alignment);
        }
        MigLayoutConstraintsTest.assertSame((Object)descriptor, (Object)constraints.getSmallAlignmentImageDescriptor(false));
    }

    @Test
    public void test_contextMenu_ConstraintsAction() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(), '');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        IMenuManager manager = MigLayoutConstraintsTest.getContextMenu(new ObjectInfo[]{button});
        final IAction action = MigLayoutConstraintsTest.findChildAction((IContributionManager)manager, "Constraints...");
        MigLayoutConstraintsTest.assertNotNull((Object)action);
        MigLayoutConstraintsTest.assertEquals((Object)"", (Object)constraints.getString());
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                action.run();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Cell properties");
                Text text = context.getTextByLabel("Specification:");
                text.setText("width 100px");
                MigLayoutConstraintsTest.assertEquals((Object)"width 100px", (Object)constraints.getString());
                context.clickButton("Cancel");
            }
        });
        MigLayoutConstraintsTest.assertEquals((Object)"", (Object)constraints.getString());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(), '');", "  }", "}");
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                action.run();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Cell properties");
                Text text = context.getTextByLabel("Specification:");
                text.setText("width 100px");
                context.clickButton("OK");
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(), 'width 100px');", "  }", "}");
    }

    @Test
    public void test_alignmentContentMenuHorizontal_LEFT() throws Exception {
        this.check_contextMenu_alignmentHorizontal("Left", MigColumnInfo.Alignment.LEFT, "alignx left");
    }

    @Test
    public void test_alignmentContentMenuHorizontal_CENTER() throws Exception {
        this.check_contextMenu_alignmentHorizontal("Center", MigColumnInfo.Alignment.CENTER, "alignx center");
    }

    @Test
    public void test_alignmentContentMenuHorizontal_RIGHT() throws Exception {
        this.check_contextMenu_alignmentHorizontal("Right", MigColumnInfo.Alignment.RIGHT, "alignx right");
    }

    @Test
    public void test_alignmentContentMenuHorizontal_FILL() throws Exception {
        this.check_contextMenu_alignmentHorizontal("Fill", MigColumnInfo.Alignment.FILL, "growx");
    }

    @Test
    public void test_alignmentContentMenuHorizontal_LEADING() throws Exception {
        this.check_contextMenu_alignmentHorizontal("Leading", MigColumnInfo.Alignment.LEADING, "alignx leading");
    }

    @Test
    public void test_alignmentContentMenuHorizontal_TRAILING() throws Exception {
        this.check_contextMenu_alignmentHorizontal("Trailing", MigColumnInfo.Alignment.TRAILING, "alignx trailing");
    }

    @Test
    public void test_alignmentContentMenuVertical_TOP() throws Exception {
        this.check_contextMenu_alignmentVertical("Top", MigRowInfo.Alignment.TOP, "aligny top");
    }

    @Test
    public void test_alignmentContentMenuVertical_CENTER() throws Exception {
        this.check_contextMenu_alignmentVertical("Center", MigRowInfo.Alignment.CENTER, "aligny center");
    }

    @Test
    public void test_alignmentContentMenuVertical_BOTTOM() throws Exception {
        this.check_contextMenu_alignmentVertical("Bottom", MigRowInfo.Alignment.BOTTOM, "aligny bottom");
    }

    @Test
    public void test_alignmentContentMenuVertical_FILL() throws Exception {
        this.check_contextMenu_alignmentVertical("Fill", MigRowInfo.Alignment.FILL, "growy");
    }

    @Test
    public void test_alignmentContentMenuVertical_BASELINE() throws Exception {
        this.check_contextMenu_alignmentVertical("Baseline", MigRowInfo.Alignment.BASELINE, "aligny baseline");
    }

    private void check_contextMenu_alignmentHorizontal(String actionText, MigColumnInfo.Alignment expectedHorizontalAlignment, String expectedConstraintsSource) throws Exception {
        this.check_contextMenu_alignment("Horizontal alignment", actionText, expectedHorizontalAlignment, MigRowInfo.Alignment.DEFAULT, expectedConstraintsSource);
    }

    public void check_contextMenu_alignmentVertical(String actionText, MigRowInfo.Alignment expectedVerticalAlignment, String expectedConstraintsSource) throws Exception {
        this.check_contextMenu_alignment("Vertical alignment", actionText, MigColumnInfo.Alignment.DEFAULT, expectedVerticalAlignment, expectedConstraintsSource);
    }

    private void check_contextMenu_alignment(String managerText, String actionText, MigColumnInfo.Alignment expectedHorizontalAlignment, MigRowInfo.Alignment expectedVerticalAlignment, String expectedConstraintsSource) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MenuManager contextMenu = MigLayoutConstraintsTest.getDesignerMenuManager();
        panel.getBroadcastObject().addContextMenu(List.of(button), (ObjectInfo)button, (IMenuManager)contextMenu);
        IMenuManager alignmentManager = MigLayoutConstraintsTest.findChildMenuManager((IContributionManager)contextMenu, managerText);
        MigLayoutConstraintsTest.assertNotNull((Object)alignmentManager);
        IAction alignmentAction = MigLayoutConstraintsTest.findChildAction((IContributionManager)alignmentManager, actionText);
        MigLayoutConstraintsTest.assertNotNull((String)actionText, (Object)alignmentAction);
        alignmentAction.setChecked(true);
        alignmentAction.run();
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        MigLayoutConstraintsTest.assertSame((Object)expectedHorizontalAlignment, (Object)constraints.getHorizontalAlignment());
        MigLayoutConstraintsTest.assertSame((Object)expectedVerticalAlignment, (Object)constraints.getVerticalAlignment());
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0," + expectedConstraintsSource + "');", "  }", "}");
    }

    @Test
    public void test_dock_getDockSide() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'north');", "    add(new JButton(C_2), 'west');", "    add(new JButton(C_3), 'south');", "    add(new JButton(C_4), 'east');", "    add(new JButton(C_5), '');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button_1);
        MigLayoutConstraintsTest.assertSame((Object)CellConstraintsSupport.DockSide.NORTH, (Object)constraints.getDockSide());
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        constraints = MigLayoutInfo.getConstraints((ComponentInfo)button_2);
        MigLayoutConstraintsTest.assertSame((Object)CellConstraintsSupport.DockSide.WEST, (Object)constraints.getDockSide());
        ComponentInfo button_3 = (ComponentInfo)panel.getChildrenComponents().get(2);
        constraints = MigLayoutInfo.getConstraints((ComponentInfo)button_3);
        MigLayoutConstraintsTest.assertSame((Object)CellConstraintsSupport.DockSide.SOUTH, (Object)constraints.getDockSide());
        ComponentInfo button_4 = (ComponentInfo)panel.getChildrenComponents().get(3);
        constraints = MigLayoutInfo.getConstraints((ComponentInfo)button_4);
        MigLayoutConstraintsTest.assertSame((Object)CellConstraintsSupport.DockSide.EAST, (Object)constraints.getDockSide());
        ComponentInfo button_5 = (ComponentInfo)panel.getChildrenComponents().get(4);
        constraints = MigLayoutInfo.getConstraints((ComponentInfo)button_5);
        MigLayoutConstraintsTest.assertSame(null, (Object)constraints.getDockSide());
    }

    @Test
    public void test_dock_setDockSide() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), '');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button);
        this.check_setDockSide(constraints, CellConstraintsSupport.DockSide.NORTH, "north");
        this.check_setDockSide(constraints, CellConstraintsSupport.DockSide.WEST, "west");
        this.check_setDockSide(constraints, CellConstraintsSupport.DockSide.SOUTH, "south");
        this.check_setDockSide(constraints, CellConstraintsSupport.DockSide.EAST, "east");
        this.check_setDockSide(constraints, null, "");
    }

    private void check_setDockSide(CellConstraintsSupport constraints, CellConstraintsSupport.DockSide sideToSet, String expectedConstraints) throws Exception {
        constraints.setDockSide(sideToSet);
        MigLayoutConstraintsTest.assertSame((Object)sideToSet, (Object)constraints.getDockSide());
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), '" + expectedConstraints + "');", "  }", "}");
    }

    @Test
    public void test_isHorizontalSplit_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0,flowx');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutConstraintsTest.assertTrue((boolean)MigLayoutInfo.getConstraints((ComponentInfo)button_1).isHorizontalSplit());
    }

    @Test
    public void test_isHorizontalSplit_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0,flowy');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutConstraintsTest.assertFalse((boolean)MigLayoutInfo.getConstraints((ComponentInfo)button_1).isHorizontalSplit());
    }

    @Test
    public void test_isHorizontalSplit_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutConstraintsTest.assertTrue((boolean)MigLayoutInfo.getConstraints((ComponentInfo)button_1).isHorizontalSplit());
    }

    @Test
    public void test_isHorizontalSplit_4() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout(new LC().flowY()));", "    add(new JButton(C_1), 'cell 0 0');", "    add(new JButton(C_2), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        MigLayoutConstraintsTest.assertFalse((boolean)MigLayoutInfo.getConstraints((ComponentInfo)button_1).isHorizontalSplit());
    }

    @Test
    public void test_setHorizontalSplit_setExplicitTrue() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button_1);
        constraints.setHorizontalSplit(Boolean.TRUE);
        MigLayoutConstraintsTest.assertTrue((boolean)constraints.isHorizontalSplit());
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'flowx,cell 0 0');", "  }", "}");
    }

    @Test
    public void test_setHorizontalSplit_setExplicitFalse() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button_1);
        constraints.setHorizontalSplit(Boolean.FALSE);
        MigLayoutConstraintsTest.assertFalse((boolean)constraints.isHorizontalSplit());
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'flowy,cell 0 0');", "  }", "}");
    }

    @Test
    public void test_setHorizontalSplit_removeExplicit() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'flowy,cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)button_1);
        MigLayoutConstraintsTest.assertFalse((boolean)constraints.isHorizontalSplit());
        constraints.setHorizontalSplit(null);
        MigLayoutConstraintsTest.assertTrue((boolean)constraints.isHorizontalSplit());
        constraints.write();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(C_1), 'cell 0 0');", "  }", "}");
    }
}

