/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.FormLayout;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.swing.FormLayout.Activator;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.FormLayout.AbstractFormLayoutTest;
import org.junit.After;
import org.junit.Test;

public class FormLayoutParametersTest
extends AbstractFormLayoutTest {
    @Override
    @After
    public void tearDown() throws Exception {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setToDefault("FormLayout.enableGrab");
        preferences.setToDefault("FormLayout.enableRightAlignment");
        super.tearDown();
    }

    @Test
    public void test_CREATE_Text() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = FormLayoutParametersTest.createComponent(JTextField.class);
                layout.command_CREATE(newComponent, 1, false, 1, false);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JTextField textField = new JTextField();", "      add(textField, '1, 1, fill, default');", "      textField.setColumns(10);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Text_disabled() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        Activator.getDefault().getPreferenceStore().setValue("FormLayout.enableGrab", false);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = FormLayoutParametersTest.createComponent(JTextField.class);
                layout.command_CREATE(newComponent, 1, false, 1, false);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JTextField textField = new JTextField();", "      add(textField, '1, 1');", "      textField.setColumns(10);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Table() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}");
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = FormLayoutParametersTest.createComponent(JTable.class);
                layout.command_CREATE(newComponent, 1, false, 1, false);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        RowSpec.decode('default:grow'),}));", "    {", "      JTable table = new JTable();", "      add(table, '1, 1, fill, fill');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_Table_onImplicit() throws Exception {
        FormLayoutParametersTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,}));", "  }", "}"));
        FormLayoutParametersTest.waitForAutoBuild();
        final ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = FormLayoutParametersTest.createComponent(JTable.class);
                layout.command_CREATE(newComponent, 1, false, 1, false);
            }
        });
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    {", "      JTable table = new JTable();", "      add(table, '1, 1, fill, fill');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        RowSpec.decode('default:grow'),}));", "    {", "      JTextField textField = new JTextField();", "      add(textField, '2, 1, fill, default');", "    }", "  }", "}");
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = FormLayoutParametersTest.createComponent(JLabel.class);
                layout.command_CREATE(newComponent, 1, false, 1, false);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        RowSpec.decode('default:grow'),}));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, '1, 1, right, default');", "    }", "    {", "      JTextField textField = new JTextField();", "      add(textField, '2, 1, fill, default');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText_gap() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        RowSpec.decode('default:grow'),}));", "    {", "      JTextField textField = new JTextField();", "      add(textField, '3, 1, fill, default');", "    }", "  }", "}");
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = FormLayoutParametersTest.createComponent(JLabel.class);
                layout.command_CREATE(newComponent, 1, false, 1, false);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        RowSpec.decode('default:grow'),}));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, '1, 1, right, default');", "    }", "    {", "      JTextField textField = new JTextField();", "      add(textField, '3, 1, fill, default');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_LabelBeforeText_disabled() throws Exception {
        final ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        RowSpec.decode('default:grow'),}));", "    {", "      JTextField textField = new JTextField();", "      add(textField, '2, 1, fill, default');", "    }", "  }", "}");
        Activator.getDefault().getPreferenceStore().setValue("FormLayout.enableRightAlignment", false);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = FormLayoutParametersTest.createComponent(JLabel.class);
                layout.command_CREATE(newComponent, 1, false, 1, false);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        RowSpec.decode('default:grow'),}));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, '1, 1');", "    }", "    {", "      JTextField textField = new JTextField();", "      add(textField, '2, 1, fill, default');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_TextAfterLabel() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        RowSpec.decode('default:grow'),}));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, '1, 1, right, default');", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = FormLayoutParametersTest.createComponent(JTextField.class);
                layout.command_CREATE(newComponent, 2, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        RowSpec.decode('default:grow'),}));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, '1, 1, right, default');", "    }", "    {", "      JTextField textField = new JTextField();", "      add(textField, '2, 1, fill, default');", "      textField.setColumns(10);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_TextAfterLabel_gap() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        RowSpec.decode('default:grow'),}));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, '1, 1, right, default');", "    }", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FormLayoutInfo layout = (FormLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = FormLayoutParametersTest.createComponent(JTextField.class);
                layout.command_CREATE(newComponent, 3, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.DEFAULT_COLSPEC,", "        FormSpecs.RELATED_GAP_COLSPEC,", "        ColumnSpec.decode('default:grow'),},", "      new RowSpec[] {", "        FormSpecs.DEFAULT_ROWSPEC,", "        RowSpec.decode('default:grow'),}));", "    {", "      JLabel label = new JLabel('New label');", "      add(label, '1, 1, right, default');", "    }", "    {", "      JTextField textField = new JTextField();", "      add(textField, '3, 1, fill, default');", "      textField.setColumns(10);", "    }", "  }", "}");
    }

    @Override
    public String getTestSource(String ... lines) {
        lines = CodeUtils.join((String[])new String[]{"import com.jgoodies.forms.layout.*;", "import com.jgoodies.forms.factories.*;"}, (String[])lines);
        return super.getTestSource(lines);
    }
}

