/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import org.eclipse.wb.core.model.association.ConstructorChildAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JScrollPaneInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class JScrollPaneTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_association_constructor() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    //", "    JScrollPane scroll = new JScrollPane(button);", "    add(scroll);", "  }", "}");
        JScrollPaneInfo scroll = (JScrollPaneInfo)panel.getChildrenComponents().get(0);
        JScrollPaneTest.assertEquals((long)1L, (long)scroll.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)scroll.getChildrenComponents().get(0);
        JScrollPaneTest.assertInstanceOf(ConstructorChildAssociation.class, (Object)button.getAssociation());
        panel.refresh();
        try {
            JScrollPaneTest.assertTrue((boolean)scroll.isEmptyPosition("getColumnHeader"));
            JScrollPaneTest.assertTrue((boolean)scroll.isEmptyPosition("getRowHeader"));
            JScrollPaneTest.assertFalse((boolean)scroll.isEmptyPosition("getViewport"));
        }
        finally {
            panel.refresh_dispose();
        }
    }

    @Test
    public void test_association_setColumnHeaderView() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "    {", "      JButton button = new JButton();", "      scroll.setColumnHeaderView(button);", "    }", "  }", "}");
        JScrollPaneInfo scroll = (JScrollPaneInfo)panel.getChildrenComponents().get(0);
        JScrollPaneTest.assertEquals((long)1L, (long)scroll.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)scroll.getChildrenComponents().get(0);
        JScrollPaneTest.assertInstanceOf(InvocationChildAssociation.class, (Object)button.getAssociation());
        panel.refresh();
        try {
            JScrollPaneTest.assertFalse((boolean)scroll.isEmptyPosition("getColumnHeader"));
            JScrollPaneTest.assertTrue((boolean)scroll.isEmptyPosition("getRowHeader"));
            JScrollPaneTest.assertTrue((boolean)scroll.isEmptyPosition("getViewport"));
            JScrollPaneTest.assertFalse((boolean)scroll.isEmptyPosition("no-such-method"));
        }
        finally {
            panel.refresh_dispose();
        }
    }

    @Test
    public void test_getViewport_add() throws Exception {
        this.parseContainer("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "    {", "      JButton button = new JButton();", "      scroll.getViewport().add(button);", "    }", "  }", "}");
        JScrollPaneTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(scroll)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JScrollPane} {local-unique: scroll} {/new JScrollPane()/ /add(scroll)/ /scroll.setViewportView(button)/}", "    {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /scroll.setViewportView(button)/}");
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "    {", "      JButton button = new JButton();", "      scroll.setViewportView(button);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "  }", "}");
        JScrollPaneInfo scroll = (JScrollPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo newComponent = JScrollPaneTest.createJButton();
        scroll.command_CREATE(newComponent, "setRowHeaderView");
        JScrollPaneTest.assertInstanceOf(InvocationChildAssociation.class, (Object)newComponent.getAssociation());
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "    {", "      JButton button = new JButton();", "      scroll.setRowHeaderView(button);", "    }", "  }", "}");
    }

    @Test
    public void test_OUT() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "    {", "      JButton button = new JButton();", "      scroll.setRowHeaderView(button);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
        JScrollPaneInfo scroll = (JScrollPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)scroll.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        FlowLayoutInfo innerLayout = (FlowLayoutInfo)innerPanel.getLayout();
        innerLayout.move(button, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "    {", "      JButton button = new JButton();", "      scroll.setRowHeaderView(button);", "    }", "  }", "}");
        JScrollPaneInfo scroll = (JScrollPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)scroll.getChildrenComponents().get(0);
        scroll.command_MOVE(button, "setColumnHeaderView");
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "    {", "      JButton button = new JButton();", "      scroll.setColumnHeaderView(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "      {", "        JButton button = new JButton();", "        innerPanel.add(button);", "      }", "    }", "  }", "}");
        JScrollPaneInfo scroll = (JScrollPaneInfo)panel.getChildrenComponents().get(0);
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        scroll.command_ADD(button, "setRowHeaderView");
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JScrollPane scroll = new JScrollPane();", "    add(scroll);", "    {", "      JButton button = new JButton();", "      scroll.setRowHeaderView(button);", "    }", "    {", "      JPanel innerPanel = new JPanel();", "      add(innerPanel);", "    }", "  }", "}");
    }
}

