/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.order.ComponentOrderBeforeSibling;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.GridLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.ImplicitLayoutCreationSupport;
import org.eclipse.wb.internal.swing.model.layout.ImplicitLayoutVariableSupport;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class ContainerTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_association_noConstraints() throws Exception {
        this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ContainerTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
        ComponentInfo button = (ComponentInfo)ContainerTest.getJavaInfoByName("button");
        ContainerTest.assertEquals((Object)"add(button)", (Object)((InvocationChildAssociation)button.getAssociation()).getSource());
    }

    @Test
    public void test_association_addDeprecated() throws Exception {
        this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add('name', button);", "  }", "}");
        ContainerTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add('name', button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add('name', button)/}");
        ComponentInfo button = (ComponentInfo)ContainerTest.getJavaInfoByName("button");
        ContainerTest.assertEquals((Object)"add(\"name\", button)", (Object)button.getAssociation().getSource());
    }

    @Test
    public void test_implicitLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        LayoutInfo layout = panel.getLayout();
        ContainerTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)layout.getCreationSupport());
        ContainerTest.assertInstanceOf(ImplicitLayoutVariableSupport.class, (Object)layout.getVariableSupport());
        ContainerTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)layout.getAssociation());
    }

    @Test
    public void test_getInsets_getClientAreaInsets() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "      button_1.setBorder(new LineBorder(Color.RED, 10));", "    }", "    {", "      Button button_2 = new Button();", "      add(button_2);", "    }", "  }", "}");
        ContainerTest.assert_creation((JavaInfo)panel);
        ContainerTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)panel.getClientAreaInsets());
        ContainerTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)panel.getInsets());
        ContainerInfo button = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)button.getClientAreaInsets());
        ContainerTest.assertEquals((Object)new Insets(10, 10, 10, 10), (Object)button.getInsets());
        button = (ComponentInfo)panel.getChildrenComponents().get(1);
        ContainerTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)button.getClientAreaInsets());
    }

    @Test
    public void test_shouldDrawDotsBorder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new Container());", "    add(new JPanel());", "    add(new JTabbedPane());", "    {", "      JPanel panel = new JPanel();", "      panel.setBorder(new LineBorder(Color.red));", "      add(panel);", "    }", "  }", "}");
        panel.refresh();
        ContainerInfo container_AWT = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerInfo container_JPanel = (ContainerInfo)panel.getChildrenComponents().get(1);
        ContainerInfo container_JTabbedPane = (ContainerInfo)panel.getChildrenComponents().get(2);
        ContainerInfo container_JPanel_withBorder = (ContainerInfo)panel.getChildrenComponents().get(3);
        ContainerTest.assertFalse((boolean)panel.shouldDrawDotsBorder());
        ContainerTest.assertTrue((boolean)container_AWT.shouldDrawDotsBorder());
        ContainerTest.assertTrue((boolean)container_JPanel.shouldDrawDotsBorder());
        ContainerTest.assertFalse((boolean)container_JTabbedPane.shouldDrawDotsBorder());
        ContainerTest.assertFalse((boolean)container_JPanel_withBorder.shouldDrawDotsBorder());
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "    add(new JButton());", "  }", "}");
        ContainerTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setEnabled(true)/ /add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        panel.refresh();
        LayoutInfo newLayout = (LayoutInfo)ContainerTest.createJavaInfo("java.awt.GridLayout");
        ContainerTest.assertInstanceOf(ComponentOrderBeforeSibling.class, (Object)newLayout.getDescription().getOrder());
        panel.setLayout(newLayout);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setEnabled(true);", "    setLayout(new GridLayout(0, 1, 0, 0));", "    add(new JButton());", "  }", "}");
        ContainerTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setEnabled(true)/ /add(new JButton())/ /setLayout(new GridLayout(0, 1, 0, 0))/}", "  {new: java.awt.GridLayout} {empty} {/setLayout(new GridLayout(0, 1, 0, 0))/}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
    }

    @Test
    public void test_inheritParentLayout() throws Exception {
        ContainerInfo newPanel;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout());", "  }", "}");
        GridLayoutInfo parentLayout = (GridLayoutInfo)panel.getLayout();
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(preferences);
        ContainerTest.assertFalse((boolean)preferences.getBoolean("layout.inheritLayoutOfParent"));
        preferencesRepairer.setValue("layout.inheritLayoutOfParent", true);
        try {
            newPanel = (ContainerInfo)ContainerTest.createJavaInfo("javax.swing.JPanel");
            try {
                panel.startEdit();
                parentLayout.add((ComponentInfo)newPanel, null);
            }
            finally {
                panel.endEdit();
            }
            ContainerTest.waitEventLoop(1);
        }
        finally {
            preferencesRepairer.restore();
        }
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      panel.setLayout(new GridLayout(1, 0, 0, 0));", "    }", "  }", "}");
        ContainerTest.assertNotSame((Object)parentLayout, (Object)newPanel.getLayout());
    }

    @Test
    public void test_inheritParentLayout_null() throws Exception {
        ContainerInfo newPanel;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "  }", "}");
        AbsoluteLayoutInfo parentLayout = (AbsoluteLayoutInfo)panel.getLayout();
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(preferences);
        ContainerTest.assertFalse((boolean)preferences.getBoolean("layout.inheritLayoutOfParent"));
        preferencesRepairer.setValue("layout.inheritLayoutOfParent", true);
        try {
            newPanel = (ContainerInfo)ContainerTest.createJavaInfo("javax.swing.JPanel");
            try {
                panel.startEdit();
                parentLayout.command_CREATE((ComponentInfo)newPanel, null);
            }
            finally {
                panel.endEdit();
            }
            ContainerTest.waitEventLoop(1);
        }
        finally {
            preferencesRepairer.restore();
        }
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      panel.setLayout(null);", "    }", "  }", "}");
        ContainerTest.assertNotSame((Object)parentLayout, (Object)newPanel.getLayout());
    }

    @Test
    public void test_setDefaultLayout() throws Exception {
        ContainerInfo newPanel;
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        IPreferenceStore preferences = panel.getDescription().getToolkit().getPreferences();
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(preferences);
        ContainerTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)preferences.getString("layout.default")));
        preferencesRepairer.setValue("layout.default", "borderLayout");
        try {
            newPanel = (ContainerInfo)ContainerTest.createJavaInfo("javax.swing.JPanel");
            try {
                panel.startEdit();
                flowLayout.add((ComponentInfo)newPanel, null);
            }
            finally {
                panel.endEdit();
            }
            ContainerTest.waitEventLoop(1);
        }
        finally {
            preferencesRepairer.restore();
        }
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      panel.setLayout(new BorderLayout(0, 0));", "    }", "  }", "}");
        ContainerTest.assertNotSame((Object)flowLayout, (Object)newPanel.getLayout());
    }

    @Ignore
    @Test
    public void test_clipboard() throws Exception {
        String[] lines1 = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      inner.setLayout(new GridLayout(1, 0));", "      add(inner);", "    }", "  }", "}"};
        final ContainerInfo panel = this.parseContainer(lines1);
        panel.refresh();
        ComponentInfo inner = (ComponentInfo)panel.getChildrenComponents().get(0);
        final JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)inner);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ContainerInfo copy = (ContainerInfo)memento.create((JavaInfo)panel);
                ((FlowLayoutInfo)panel.getLayout()).add((ComponentInfo)copy, null);
                memento.apply();
            }
        });
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      inner.setLayout(new GridLayout(1, 0));", "      add(inner);", "    }", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      panel.setLayout(new GridLayout(1, 0));", "    }", "  }", "}"};
        this.assertEditor(lines);
    }

    @Test
    public void test_setLayoutMenu_0() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ContainerInfo button = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerTest.assertFalse((boolean)button.hasLayout());
        IMenuManager menuManager = ContainerTest.getContextMenu(new ObjectInfo[]{button});
        IMenuManager layoutManager = ContainerTest.findChildMenuManager((IContributionManager)menuManager, "Set layout");
        ContainerTest.assertNull((Object)layoutManager);
    }

    @Test
    public void test_setLayoutMenu_1() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ContainerTest.assertTrue((boolean)panel.hasLayout());
        IMenuManager layoutManager = ContainerTest.get_SetLayout_MenuManager(panel);
        ContainerTest.assertChildAction_existsEnabled(layoutManager, "FlowLayout", true);
        ContainerTest.assertChildAction_existsEnabled(layoutManager, "BorderLayout", true);
        ContainerTest.assertChildAction_existsEnabled(layoutManager, "BoxLayout", true);
        ContainerTest.assertChildAction_existsEnabled(layoutManager, "GridLayout", true);
        ContainerTest.assertChildAction_existsEnabled(layoutManager, "CardLayout", true);
        ContainerTest.assertChildAction_existsEnabled(layoutManager, "GridBagLayout", true);
        IAction action = ContainerTest.findChildAction((IContributionManager)layoutManager, "GridLayout");
        action.run();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridLayout(1, 0, 0, 0));", "  }", "}");
        action = ContainerTest.findChildAction((IContributionManager)layoutManager, "Absolute layout");
        action.run();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "  }", "}");
    }

    @Test
    public void test_setLayoutMenu_2() throws Exception {
        ContainerTest.do_projectDispose();
        ContainerTest.do_projectCreate();
        try {
            ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
            ContainerTest.assertTrue((boolean)panel.hasLayout());
            IMenuManager layoutManager = ContainerTest.get_SetLayout_MenuManager(panel);
            IAction action = ContainerTest.findChildAction((IContributionManager)layoutManager, "JGoodies FormLayout");
            action.run();
            this.assertEditor("import com.jgoodies.forms.layout.FormLayout;", "import com.jgoodies.forms.layout.ColumnSpec;", "import com.jgoodies.forms.layout.RowSpec;", "// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {},", "      new RowSpec[] {}));", "  }", "}");
        }
        finally {
            ContainerTest.do_projectDispose();
        }
    }

    private static IMenuManager get_SetLayout_MenuManager(ContainerInfo panel) throws Exception {
        IMenuManager menuManager = ContainerTest.getContextMenu(new ObjectInfo[]{panel});
        IMenuManager layoutManager = ContainerTest.findChildMenuManager((IContributionManager)menuManager, "Set layout");
        return layoutManager;
    }

    private static void assertChildAction_existsEnabled(IMenuManager layoutManager, String text, boolean enabled) {
        IAction action = ContainerTest.findChildAction((IContributionManager)layoutManager, text);
        ContainerTest.assertNotNull((Object)action);
        ContainerTest.assertEquals((Object)action.isEnabled(), (Object)enabled);
    }

    @Test
    public void test_hasLayout_placeholder() throws Exception {
        ContainerTest.setFileContentSrc("test/MyContainer.java", this.getTestSource("// filler filler filler filler filler", "public class MyContainer extends JPanel {", "  public MyContainer() {", "    throw new IllegalStateException('actual');", "  }", "}"));
        ContainerTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    add(new MyContainer());", "  }", "}");
        ContainerTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyContainer())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyContainer} {empty} {/add(new MyContainer())/}");
        panel.refresh();
        ContainerInfo placeholder = (ContainerInfo)panel.getChildrenComponents().get(0);
        ContainerTest.assertFalse((boolean)placeholder.hasLayout());
        ContainerTest.assertFalse((boolean)placeholder.canSetLayout());
    }

    @Test
    public void test_canSetLayout_enabled() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ContainerTest.assertTrue((boolean)panel.hasLayout());
        ContainerTest.assertTrue((boolean)panel.canSetLayout());
    }

    @Test
    public void test_canSetLayout_disabled() throws Exception {
        ContainerTest.prepareMyPanel_disabledSetLayout();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ContainerTest.assertTrue((boolean)panel.hasLayout());
        ContainerTest.assertFalse((boolean)panel.canSetLayout());
        IMenuManager manager = ContainerTest.get_SetLayout_MenuManager(panel);
        ContainerTest.assertNull((Object)manager);
    }

    public static void prepareMyPanel_disabledSetLayout() throws Exception {
        ContainerTest.setFileContentSrc("test/MyPanel.java", ContainerTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "import javax.swing.JPanel;", "public class MyPanel extends JPanel {", "  public MyPanel() {", "  }", "}"));
        ContainerTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ContainerTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <methods-exclude signature='setLayout(java.awt.LayoutManager)'/>", "  </methods>", "</component>"));
        ContainerTest.waitForAutoBuild();
    }
}

