/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.SwingToolkitDescription;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JPanelInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.junit.Ignore;
import org.junit.Test;

public class ComponentTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_clearSwingTree_removeAll_NPE() throws Exception {
        ComponentTest.setFileContentSrc("test/MyContainer.java", this.getTestSource("public class MyContainer extends JPanel {", "  public void removeAll() {", "    throw new NullPointerException();", "  }", "}"));
        ComponentTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyContainer());", "  }", "}");
        panel.refresh();
        ComponentTest.assertNoErrors((JavaInfo)panel);
    }

    @Ignore
    @Test
    public void test_zeroSize() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends Frame {", "  public Test() {", "    setUndecorated(true);", "    setSize(0, 0);", "  }", "}");
        panel.refresh();
        ComponentTest.assertNoErrors((JavaInfo)panel);
        ComponentTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)panel.getBounds());
        org.eclipse.swt.graphics.Rectangle imageBounds = panel.getImage().getBounds();
        ComponentTest.assertEquals((long)imageBounds.width, (long)1L);
        ComponentTest.assertEquals((long)imageBounds.height, (long)1L);
    }

    @Test
    public void test_JLabel_withHTML() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JPanel inner = new JPanel();", "      add(inner, BorderLayout.NORTH);", "      inner.setLayout(new GridLayout());", "      inner.setBackground(Color.GREEN);", "      {", "        JLabel label = new JLabel('<html>aaaaaaaaa bbbbbbbb cccccccccc ddddddddd eeeeeeeeeee fffffffffffff ggggggggg hhhhhhhhhhhh</html>');", "        inner.add(label);", "      }", "    }", "  }", "}");
        panel.refresh();
        panel.getTopBoundsSupport().setSize(175, 300);
        panel.refresh();
        ComponentInfo label = (ComponentInfo)ComponentTest.getJavaInfoByName("label");
        Rectangle bounds = label.getModelBounds();
        Image rootImage = panel.getImage();
        ImageData imageData = rootImage.getImageData();
        int pixel = imageData.getPixel(bounds.width - 2, bounds.height - 2);
        RGB rgb = imageData.palette.getRGB(pixel);
        ComponentTest.assertEquals((Object)new RGB(0, 255, 0), (Object)rgb);
    }

    @Test
    public void test_addPanel_withExposedChildren() throws Exception {
        ComponentTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private final JButton m_button = new JButton();", "  public MyPanel() {", "    add(m_button);", "  }", "  public JButton getButton() {", "    return m_button;", "  }", "}"));
        ComponentTest.waitForAutoBuild();
        final ContainerInfo panel = (ContainerInfo)this.parseJavaInfo("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ComponentInfo myPanel = (ComponentInfo)ComponentTest.createJavaInfo("test.MyPanel");
                ((FlowLayoutInfo)panel.getLayout()).add(myPanel, null);
            }
        });
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel myPanel = new MyPanel();", "      add(myPanel);", "    }", "  }", "}");
        ComponentTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(myPanel)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyPanel} {local-unique: myPanel} {/new MyPanel()/ /add(myPanel)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {method: public javax.swing.JButton test.MyPanel.getButton()} {property} {}");
    }

    @Test
    public void test_variableName_setName() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getVariableSupport().setName("button2");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button2 = new JButton();", "    add(button2);", "  }", "}");
        PreferencesRepairer preferences = new PreferencesRepairer(panel.getDescription().getToolkit().getPreferences());
        try {
            preferences.setValue("putNameIntoComponent", true);
            button.getVariableSupport().setName("button3");
            panel.refresh();
            this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button3 = new JButton();", "    button3.setName('button3');", "    add(button3);", "  }", "}");
            button.getVariableSupport().setName("button4");
            panel.refresh();
            this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button4 = new JButton();", "    button4.setName('button4');", "    add(button4);", "  }", "}");
        }
        finally {
            preferences.restore();
        }
    }

    @Test
    public void test_variableName_setName_forLazy() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        FlowLayoutInfo layout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newButton = ComponentTest.createJButton();
        SwingToolkitDescription.INSTANCE.getPreferences().setValue("putNameIntoComponent", true);
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        layout.add(newButton, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    add(getButton());", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "      button.setName('button');", "    }", "    return button;", "  }", "}");
        ComponentTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(getButton())/ /add(getButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton empty} {lazy: button getButton()} {/new JButton()/ /add(getButton())/ /button.setName('button')/}");
        newButton.getVariableSupport().setName("button2");
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private JButton button2;", "  public Test() {", "    add(getButton2());", "  }", "  private JButton getButton2() {", "    if (button2 == null) {", "      button2 = new JButton();", "      button2.setName('button2');", "    }", "    return button2;", "  }", "}");
        ComponentTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(getButton2())/ /add(getButton2())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton empty} {lazy: button2 getButton2()} {/new JButton()/ /add(getButton2())/ /button2.setName('button2')/}");
    }

    @Test
    public void test_modal() throws Exception {
        JPanelInfo dialog = (JPanelInfo)this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tnew MyDialog();\n\t}\n\tpublic static class MyDialog extends JDialog {\n\t\tpublic MyDialog() {\n\t\t\tsetModal(true);\n\t\t\tsetVisible(true);\n\t\t}\n\t}\n}\n");
        ComponentTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        dialog.refresh();
        ComponentTest.assertNoErrors((JavaInfo)dialog);
    }
}

