/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMementoTransfer;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class ClipboardTest
extends SwingModelTest {
    @Test
    public void test_hasMemento() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('111');", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        panel.refresh();
        ClipboardTest.assertFalse((boolean)JavaInfoMemento.hasMemento((JavaInfo)panel));
        ClipboardTest.assertTrue((boolean)JavaInfoMemento.hasMemento((JavaInfo)button));
    }

    @Test
    public void test_getComponentClassName() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('111');", "    add(button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)button);
        ClipboardTest.assertEquals((Object)"javax.swing.JButton", (Object)memento.getComponentClassName());
    }

    @Test
    public void test_transfer() throws Exception {
        JavaInfoMemento[] mementos;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton('111');", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ClipboardTest.assertNotNull((Object)ReflectionUtils.invokeMethod((Object)JavaInfoMementoTransfer.getInstance(), (String)"getTypeNames()", (Object[])new Object[0]));
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)button);
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        try {
            clipboard.setContents(new Object[]{new JavaInfoMemento[]{memento}}, new Transfer[]{JavaInfoMementoTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
        Clipboard clipboard2 = new Clipboard(Display.getCurrent());
        try {
            mementos = (JavaInfoMemento[])clipboard2.getContents((Transfer)JavaInfoMementoTransfer.getInstance());
        }
        finally {
            clipboard2.dispose();
        }
        ClipboardTest.assertEquals((long)1L, (long)mementos.length);
        JavaInfo javaInfo = mementos[0].create((JavaInfo)panel);
        ClipboardTest.assertInstanceOf(ComponentInfo.class, (Object)javaInfo);
        Clipboard clipboard3 = new Clipboard(Display.getCurrent());
        try {
            clipboard3.setContents(new Object[]{"some text"}, new Transfer[]{TextTransfer.getInstance()});
            ClipboardTest.assertNull((Object)clipboard3.getContents((Transfer)JavaInfoMementoTransfer.getInstance()));
            ClipboardTest.assertNull((Object)JavaInfoMementoTransfer.getInstance().nativeToJava(null));
        }
        finally {
            clipboard3.dispose();
        }
    }

    @Test
    public void test_singleComponent() throws Exception {
        String[] sourceLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton((Icon) null);", "      button.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);", "      button.setEnabled(false);", "      button.setText(\"222\");", "      add(button);", "    }", "  }", "}"};
        String[] targetLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton((Icon) null);", "      button.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);", "      button.setEnabled(false);", "      button.setText(\"222\");", "      add(button);", "    }", "    {", "      JButton button = new JButton((Icon) null);", "      button.setText(\"222\");", "      button.setEnabled(false);", "      button.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);", "      add(button);", "    }", "  }", "}"};
        this.flow_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_exposedSubComponent() throws Exception {
        ClipboardTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private JButton button;", "  public MyPanel() {", "    button = new JButton();", "    add(button);", "  }", "  public JButton getButton() {", "    return button;", "  }", "}"));
        ClipboardTest.waitForAutoBuild();
        String[] sourceLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel myPanel = new MyPanel();", "      myPanel.getButton().setText(\"exposed button\");", "      add(myPanel);", "    }", "  }", "}"};
        String[] targetLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      MyPanel myPanel = new MyPanel();", "      myPanel.getButton().setText(\"exposed button\");", "      add(myPanel);", "    }", "    {", "      MyPanel myPanel = new MyPanel();", "      myPanel.getButton().setText(\"exposed button\");", "      add(myPanel);", "    }", "  }", "}"};
        this.flow_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_factoryStatic() throws Exception {
        ClipboardTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(String _text) {", "    return new JButton(_text);", "  }", "}"));
        ClipboardTest.waitForAutoBuild();
        String[] sourceLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = StaticFactory.createButton(\"button\");", "      add(button);", "    }", "  }", "}"};
        String[] targetLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = StaticFactory.createButton(\"button\");", "      add(button);", "    }", "    {", "      JButton button = StaticFactory.createButton(\"button\");", "      add(button);", "    }", "  }", "}"};
        this.flow_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_factoryStatic_complex() throws Exception {
        ClipboardTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(String _text, int i, Object o) {", "    return new JButton(_text);", "  }", "}"));
        ClipboardTest.waitForAutoBuild();
        String[] sourceLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = StaticFactory.createButton(\"button\", 1, new Object());", "      add(button);", "    }", "  }", "}"};
        String[] targetLines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = StaticFactory.createButton(\"button\", 1, new Object());", "      add(button);", "    }", "    {", "      JButton button = StaticFactory.createButton(\"button\", 1, (Object) null);", "      add(button);", "    }", "  }", "}"};
        this.flow_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_factoryInstance_single() throws Exception {
        ClipboardTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton(String _text) {", "    return new JButton(_text);", "  }", "}"));
        ClipboardTest.waitForAutoBuild();
        String[] sourceLines = new String[]{"public class Test extends JPanel {", "  private final InstanceFactory m_factory = new InstanceFactory();", "  public Test() {", "    {", "      JButton button = m_factory.createButton(\"button\");", "      add(button);", "    }", "  }", "}"};
        String[] targetLines = new String[]{"public class Test extends JPanel {", "  private final InstanceFactory m_factory = new InstanceFactory();", "  public Test() {", "    {", "      JButton button = m_factory.createButton(\"button\");", "      add(button);", "    }", "    {", "      JButton button = m_factory.createButton(\"button\");", "      add(button);", "    }", "  }", "}"};
        this.flow_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_factoryInstance_new() throws Exception {
        ClipboardTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton(String _text) {", "    return new JButton(_text);", "  }", "}"));
        ClipboardTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final InstanceFactory m_factory = new InstanceFactory();", "  public Test() {", "    {", "      JButton button = m_factory.createButton('button');", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo component = (ComponentInfo)panel.getChildrenComponents().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)component);
        ContainerInfo panel2 = (ContainerInfo)this.parseSource("test", "Test2.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test2 extends JPanel {", "  public Test2() {", "  }", "}"));
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel2.getLayout();
        ComponentInfo component2 = (ComponentInfo)memento.create((JavaInfo)panel2);
        flowLayout.add(component2, null);
        memento.apply();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test2 extends JPanel {", "  private final InstanceFactory instanceFactory = new InstanceFactory();", "  public Test2() {", "    {", "      JButton button = instanceFactory.createButton('button');", "      add(button);", "    }", "  }", "}");
    }

    private ComponentInfo flow_doCopy(String[] sourceLines, String[] targetLines) throws Exception {
        final ContainerInfo container = this.parseContainer(sourceLines);
        final FlowLayoutInfo flowLayout = (FlowLayoutInfo)container.getLayout();
        container.refresh();
        ComponentInfo component = (ComponentInfo)container.getChildrenComponents().get(0);
        final JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)component);
        final ComponentInfo[] pastedComponent = new ComponentInfo[1];
        ExecutionUtils.run((ObjectInfo)container, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ComponentInfo component = (ComponentInfo)memento.create((JavaInfo)container);
                flowLayout.add(component, null);
                memento.apply();
                pastedComponent[0] = component;
            }
        });
        this.assertEditor(targetLines);
        return pastedComponent[0];
    }
}

