/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.laf;

import java.util.List;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.parser.JavaInfoParser;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.laf.LafSupport;
import org.eclipse.wb.internal.swing.laf.model.CategoryInfo;
import org.eclipse.wb.internal.swing.laf.model.LafInfo;
import org.eclipse.wb.internal.swing.laf.model.SeparatorLafInfo;
import org.eclipse.wb.internal.swing.laf.model.SystemLafInfo;
import org.eclipse.wb.internal.swing.laf.model.UndefinedLafInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.After;
import org.junit.Test;

public class LookAndFeelTest
extends SwingModelTest {
    @Override
    @After
    public void tearDown() throws Exception {
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        if (this.m_lastParseInfo != null) {
            LafInfo undefinedLAF = UndefinedLafInfo.INSTANCE;
            LafSupport.selectLAF((JavaInfo)this.m_lastParseInfo, (LafInfo)undefinedLAF);
        }
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getMainMethod() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        MethodDeclaration mainMethod = LafSupport.getMainMethod((AstEditor)this.m_lastEditor);
        LookAndFeelTest.assertNotNull((Object)mainMethod);
    }

    @Test
    public void test_getSetLookAndFeel_no() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        MethodDeclaration mainMethod = LafSupport.getMainMethod((AstEditor)this.m_lastEditor);
        MethodInvocation setLookAndFeelMethod = LafSupport.getSetLookAndFeelMethod((MethodDeclaration)mainMethod);
        LookAndFeelTest.assertNull((Object)setLookAndFeelMethod);
    }

    @Test
    public void test_getSetLookAndFeel_String() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel('com.sun.java.swing.plaf.motif.MotifLookAndFeel');", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
        MethodDeclaration mainMethod = LafSupport.getMainMethod((AstEditor)this.m_lastEditor);
        MethodInvocation setLookAndFeelMethod = LafSupport.getSetLookAndFeelMethod((MethodDeclaration)mainMethod);
        LookAndFeelTest.assertNotNull((Object)setLookAndFeelMethod);
    }

    @Test
    public void test_getSetLookAndFeel_LookAndFeel() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel(\"com.sun.java.swing.plaf.motif.MotifLookAndFeel\");", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
        MethodDeclaration mainMethod = LafSupport.getMainMethod((AstEditor)this.m_lastEditor);
        MethodInvocation setLookAndFeelMethod = LafSupport.getSetLookAndFeelMethod((MethodDeclaration)mainMethod);
        LookAndFeelTest.assertNotNull((Object)setLookAndFeelMethod);
    }

    @Test
    public void test_addSetLookAndFeel() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    try {", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
        LafInfo lafInfo = new LafInfo("Metal", "Metal", MetalLookAndFeel.class.getName());
        lafInfo.applyInMain(this.m_lastEditor);
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel('javax.swing.plaf.metal.MetalLookAndFeel');", "    } catch (Throwable e) {", "      e.printStackTrace();", "    }", "    try {", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
    }

    @Test
    public void test_modifySetLookAndFeel_String() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel('com.sun.java.swing.plaf.motif.MotifLookAndFeel');", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
        LafInfo lafInfo = new LafInfo("Metal", "Metal", MetalLookAndFeel.class.getName());
        lafInfo.applyInMain(this.m_lastEditor);
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel('javax.swing.plaf.metal.MetalLookAndFeel');", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
    }

    @Test
    public void test_modifySetLookAndFeel_LookAndFeel() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel(\"com.sun.java.swing.plaf.motif.MotifLookAndFeel\");", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
        LafInfo lafInfo = new LafInfo("Metal", "Metal", MetalLookAndFeel.class.getName());
        lafInfo.applyInMain(this.m_lastEditor);
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel(\"javax.swing.plaf.metal.MetalLookAndFeel\");", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
    }

    @Test
    public void test_addSetSystemLookAndFeel() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    try {", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
        LafInfo lafInfo = SystemLafInfo.INSTANCE;
        lafInfo.applyInMain(this.m_lastEditor);
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());", "    } catch (Throwable e) {", "      e.printStackTrace();", "    }", "    try {", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
    }

    @Test
    public void test_modifySetSystemLookAndFeel_String() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel('com.sun.java.swing.plaf.motif.MotifLookAndFeel');", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
        LafInfo lafInfo = SystemLafInfo.INSTANCE;
        lafInfo.applyInMain(this.m_lastEditor);
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
    }

    @Test
    public void test_modifySetSystemLookAndFeel_LookAndFeel() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel(\"com.sun.java.swing.plaf.motif.MotifLookAndFeel\");", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
        LafInfo lafInfo = SystemLafInfo.INSTANCE;
        lafInfo.applyInMain(this.m_lastEditor);
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
    }

    @Test
    public void test_removeSetSystemLookAndFeel_without_try() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel(\"com.sun.java.swing.plaf.motif.MotifLookAndFeel\");", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
        LafInfo lafInfo = UndefinedLafInfo.INSTANCE;
        lafInfo.applyInMain(this.m_lastEditor);
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    try {", "      JPanel panel = new JPanel();", "    } catch (Throwable e) {", "    }", "  }", "}");
    }

    @Test
    public void test_removeSetSystemLookAndFeel_with_try() throws Exception {
        this.parseContainer("class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());", "    } catch (Throwable e) {", "      e.printStackTrace();", "    } finally {", "      System.out.println();", "    }", "    try {", "      JPanel panel = new JPanel();", "    } catch (Throwable ex) {", "    }", "  }", "}");
        LafInfo lafInfo = UndefinedLafInfo.INSTANCE;
        lafInfo.applyInMain(this.m_lastEditor);
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    try {", "      JPanel panel = new JPanel();", "    } catch (Throwable ex) {", "    }", "  }", "}");
    }

    @Test
    public void test_getLAFList() throws Exception {
        List categoryList = LafSupport.getLAFCategoriesList();
        LookAndFeelTest.assertNotNull((Object)categoryList);
        LookAndFeelTest.assertFalse((boolean)categoryList.isEmpty());
        for (CategoryInfo categoryInfo : categoryList) {
            List lafList = categoryInfo.getLAFList();
            for (LafInfo lafInfo : lafList) {
                if (lafInfo instanceof SeparatorLafInfo) continue;
                LookAndFeelTest.assertNotNull((Object)lafInfo.getLookAndFeelInstance());
            }
        }
    }

    @Test
    public void test_getLAFList_condition() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.addExtension("org.eclipse.wb.swing.lookAndFeel", "<category id='test' name='Test'>", "  <LookAndFeel id='test1' class='Test1LookAndFeel' jarFile='' name='Test1' condition='true'/>", "  <LookAndFeel id='test2' class='Test2LookAndFeel' jarFile='' name='Test2' condition='false'/>", "</category>");
            testBundle.install();
            LafSupport.reloadLAFList();
            boolean laf1Available = false;
            boolean laf2Available = false;
            for (CategoryInfo categoryInfo : LafSupport.getLAFCategoriesList()) {
                for (LafInfo lafInfo : categoryInfo.getLAFList()) {
                    laf1Available |= "Test1LookAndFeel".equals(lafInfo.getClassName());
                    laf2Available |= "Test2LookAndFeel".equals(lafInfo.getClassName());
                }
            }
            LookAndFeelTest.assertTrue((boolean)laf1Available);
            LookAndFeelTest.assertFalse((boolean)laf2Available);
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_get_selected_LAF_default() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        LafInfo selectedLAF = LafSupport.getSelectedLAF((JavaInfo)panel);
        if (EnvironmentUtils.IS_LINUX) {
            LookAndFeelTest.assertEquals((Object)selectedLAF.getClassName(), (Object)"javax.swing.plaf.metal.MetalLookAndFeel");
        } else {
            LookAndFeelTest.assertInstanceOf(SystemLafInfo.class, (Object)selectedLAF);
        }
    }

    @Test
    public void test_get_selected_changed() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}");
        LafInfo undefinedLAF = UndefinedLafInfo.INSTANCE;
        LafSupport.selectLAF((JavaInfo)panel, (LafInfo)undefinedLAF);
        LafInfo selectedLAF = LafSupport.getSelectedLAF((JavaInfo)panel);
        LookAndFeelTest.assertSame((Object)undefinedLAF, (Object)selectedLAF);
    }

    @Test
    public void test_get_selected_changed_reparse() throws Exception {
        String[] source = new String[]{"class Test {", "  public static void main(String[] args) {", "    JPanel panel = new JPanel();", "  }", "}"};
        ContainerInfo panel = this.parseContainer(source);
        LafInfo undefinedLAF = UndefinedLafInfo.INSTANCE;
        LafSupport.selectLAF((JavaInfo)panel, (LafInfo)undefinedLAF);
        panel = (ContainerInfo)JavaInfoParser.parse((ICompilationUnit)this.m_lastEditor.getModelUnit());
        LafInfo selectedLAF = LafSupport.getSelectedLAF((JavaInfo)panel);
        LookAndFeelTest.assertSame((Object)undefinedLAF, (Object)selectedLAF);
    }

    @Test
    public void test_get_selected_changed_reparse_installed_in_main() throws Exception {
        String[] source = new String[]{"class Test {", "  public static void main(String[] args) {", "    try {", "      UIManager.setLookAndFeel(\"com.sun.java.swing.plaf.motif.MotifLookAndFeel\");", "    } catch (Throwable e) {", "    }", "    JPanel panel = new JPanel();", "  }", "}"};
        ContainerInfo panel = this.parseContainer(source);
        LafInfo systemLAF = SystemLafInfo.INSTANCE;
        LafSupport.selectLAF((JavaInfo)panel, (LafInfo)systemLAF);
        systemLAF.applyInMain(this.m_lastEditor);
        panel = (ContainerInfo)JavaInfoParser.parse((ICompilationUnit)this.m_lastEditor.getModelUnit());
        LafInfo selectedLAF = LafSupport.getSelectedLAF((JavaInfo)panel);
        LookAndFeelTest.assertSame((Object)systemLAF, (Object)selectedLAF);
    }

    @Test
    public void test_get_defaultLAF() throws Exception {
        LafInfo defaultLAF = LafSupport.getDefaultLAF();
        if (EnvironmentUtils.IS_LINUX) {
            LookAndFeelTest.assertEquals((Object)defaultLAF.getClassName(), (Object)"javax.swing.plaf.metal.MetalLookAndFeel");
        } else {
            LookAndFeelTest.assertInstanceOf(SystemLafInfo.class, (Object)defaultLAF);
        }
    }
}

