/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class CustomizeTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noCustomizer() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('button');", "    add(button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNull((Object)action);
    }

    @Test
    public void test_customizer() throws Exception {
        CustomizeTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        CustomizeTest.setFileContentSrc("test/MyCustomizer.java", this.getTestSource("import java.beans.Customizer;", "import java.beans.PropertyChangeListener;", "public class MyCustomizer extends JPanel implements Customizer {", "  public MyCustomizer() {", "    System.setProperty('wbp.test.isDesignTime', Boolean.toString(java.beans.Beans.isDesignTime()));", "  }", "  public void setObject(Object bean) {", "  }", "  public void addPropertyChangeListener(PropertyChangeListener listener) {", "  }", "  public void removePropertyChangeListener(PropertyChangeListener listener) {", "  }", "}"));
        CustomizeTest.waitForAutoBuild();
        CustomizeTest.setFileContentSrc("test/MyButtonBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;", "import java.beans.BeanDescriptor;", "import java.beans.Introspector;", "import java.beans.SimpleBeanInfo;", "public class MyButtonBeanInfo extends SimpleBeanInfo {", "  private BeanDescriptor m_descriptor;", "  public MyButtonBeanInfo() {", "    m_descriptor = new BeanDescriptor(MyButton.class, MyCustomizer.class);", "  }", "  public BeanDescriptor getBeanDescriptor() {", "    return m_descriptor;", "  }", "  public BeanInfo[] getAdditionalBeanInfo() {", "    try {", "      BeanInfo info = Introspector.getBeanInfo(JButton.class);", "      return new BeanInfo[] {info};", "    } catch (Throwable e) {", "    }", "    return null;", "  }", "}"));
        CustomizeTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                action.run();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Customize");
                context.clickButton("OK");
            }
        });
        String value = System.clearProperty("wbp.test.isDesignTime");
        CustomizeTest.assertEquals((Object)"true", (Object)value);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_customizer_chageProperties_OK() throws Exception {
        this.prepare_customizer_changeProperties();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        panel.refresh();
        final ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                action.run();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Customize");
                Object object = button.getObject();
                Object customizer = ReflectionUtils.getFieldObject((Object)object, (String)"customizer");
                ReflectionUtils.invokeMethod((Object)customizer, (String)"doBeanChanges()", (Object[])new Object[0]);
                context.clickButton("OK");
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.setTitle('New title');", "    button.setFreeze(true);", "    add(button);", "  }", "}");
    }

    @Test
    public void test_customizer_chageProperties_Cancel() throws Exception {
        this.prepare_customizer_changeProperties();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.setTitle('Old title');", "    add(button);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final Object buttonObject = button.getObject();
        CustomizeTest.assertEquals((Object)"Old title", (Object)ScriptUtils.evaluate((String)"getTitle()", (Object)buttonObject));
        CustomizeTest.assertEquals((Object)false, (Object)ScriptUtils.evaluate((String)"isFreeze()", (Object)buttonObject));
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                action.run();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Customize");
                Object customizer = ReflectionUtils.getFieldObject((Object)buttonObject, (String)"customizer");
                ReflectionUtils.invokeMethod((Object)customizer, (String)"doBeanChanges()", (Object[])new Object[0]);
                context.clickButton("Cancel");
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.setTitle('Old title');", "    add(button);", "  }", "}");
        CustomizeTest.assertEquals((Object)"Old title", (Object)ScriptUtils.evaluate((String)"getTitle()", (Object)buttonObject));
        CustomizeTest.assertEquals((Object)false, (Object)ScriptUtils.evaluate((String)"isFreeze()", (Object)buttonObject));
    }

    private void prepare_customizer_changeProperties() throws Exception {
        CustomizeTest.setFileContentSrc("test/MyCustomizer.java", this.getTestSource("import java.beans.Customizer;", "import java.beans.PropertyChangeListener;", "public class MyCustomizer extends JPanel implements Customizer {", "  private MyButton button;", "  public void setObject(Object bean) {", "    button = (MyButton) bean;", "    button.customizer = this;", "  }", "  public void doBeanChanges() {", "    button.setTitle('New title');", "    firePropertyChange('title', null, 'New title');", "    button.setFreeze(true);", "    firePropertyChange('freeze', null, true);", "  }", "}"));
        CustomizeTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public Object customizer;", "  private String m_title;", "  public String getTitle() {", "    return m_title;", "  }", "  public void setTitle(String title) {", "    m_title = title;", "  }", "  private boolean m_freeze;", "  public boolean isFreeze() {", "    return m_freeze;", "  }", "  public void setFreeze(boolean freeze) {", "    m_freeze = freeze;", "  }", "}"));
        CustomizeTest.setFileContentSrc("test/MyButtonBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;", "import java.beans.BeanDescriptor;", "import java.beans.Introspector;", "import java.beans.SimpleBeanInfo;", "import java.beans.PropertyDescriptor;", "public class MyButtonBeanInfo extends SimpleBeanInfo {", "  private BeanDescriptor m_descriptor;", "  private PropertyDescriptor[] m_properties;", "  public MyButtonBeanInfo() {", "    m_descriptor = new BeanDescriptor(MyButton.class, MyCustomizer.class);", "    try {", "      m_properties = new PropertyDescriptor[2];", "      m_properties[0] = new PropertyDescriptor('title', MyButton.class, 'getTitle', 'setTitle');", "      m_properties[1] = new PropertyDescriptor('freeze', MyButton.class, 'isFreeze', 'setFreeze');", "    } catch(Throwable e) {", "    }", "  }", "  public BeanDescriptor getBeanDescriptor() {", "    return m_descriptor;", "  }", "  public PropertyDescriptor[] getPropertyDescriptors() {", "    return m_properties;", "  }", "  public BeanInfo[] getAdditionalBeanInfo() {", "    try {", "      BeanInfo info = Introspector.getBeanInfo(JButton.class);", "      return new BeanInfo[] {info};", "    } catch (Throwable e) {", "    }", "    return null;", "  }", "}"));
        CustomizeTest.waitForAutoBuild();
    }

    @Test
    public void test_customizer_EXPLICIT_PROPERTY_CHANGE() throws Exception {
        CustomizeTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  private String m_title;", "  public String getTitle() {", "    return m_title;", "  }", "  public void setTitle(String title) {", "    m_title = title;", "  }", "  private boolean m_freeze;", "  public boolean isFreeze() {", "    return m_freeze;", "  }", "  public void setFreeze(boolean freeze) {", "    m_freeze = freeze;", "  }", "  public Object customizer;", "}"));
        CustomizeTest.setFileContentSrc("test/MyCustomizer.java", this.getTestSource("import java.beans.Customizer;", "import java.beans.PropertyChangeListener;", "public class MyCustomizer extends JPanel implements Customizer {", "  public void setObject(Object bean) {", "    MyButton button = (MyButton)bean;", "    button.customizer = this;", "  }", "}"));
        CustomizeTest.setFileContentSrc("test/MyButtonBeanInfo.java", this.getTestSource("import java.beans.BeanInfo;", "import java.beans.BeanDescriptor;", "import java.beans.Introspector;", "import java.beans.SimpleBeanInfo;", "import java.beans.PropertyDescriptor;", "public class MyButtonBeanInfo extends SimpleBeanInfo {", "  private BeanDescriptor m_descriptor;", "  private PropertyDescriptor[] m_properties;", "  public MyButtonBeanInfo() {", "    m_descriptor = new BeanDescriptor(MyButton.class, MyCustomizer.class);", "    m_descriptor.setValue('EXPLICIT_PROPERTY_CHANGE', Boolean.TRUE);", "    try {", "      m_properties = new PropertyDescriptor[2];", "      m_properties[0] = new PropertyDescriptor('title', MyButton.class, 'getTitle', 'setTitle');", "      m_properties[1] = new PropertyDescriptor('freeze', MyButton.class, 'isFreeze', 'setFreeze');", "    } catch(Throwable e) {", "    }", "  }", "  public BeanDescriptor getBeanDescriptor() {", "    return m_descriptor;", "  }", "  public PropertyDescriptor[] getPropertyDescriptors() {", "    return m_properties;", "  }", "  public BeanInfo[] getAdditionalBeanInfo() {", "    try {", "      BeanInfo info = Introspector.getBeanInfo(JButton.class);", "      return new BeanInfo[] {info};", "    } catch (Throwable e) {", "    }", "    return null;", "  }", "}"));
        CustomizeTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    add(button);", "  }", "}");
        panel.refresh();
        final ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        final IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                action.run();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Customize");
                Object object = button.getObject();
                ReflectionUtils.invokeMethod((Object)object, (String)"setTitle(java.lang.String)", (Object[])new Object[]{"test"});
                ReflectionUtils.invokeMethod((Object)object, (String)"setFreeze(boolean)", (Object[])new Object[]{true});
                Object customizer = ReflectionUtils.getFieldObject((Object)object, (String)"customizer");
                ReflectionUtils.invokeMethod((Object)customizer, (String)"firePropertyChange(java.lang.String,java.lang.Object,java.lang.Object)", (Object[])new Object[]{"title", null, "test"});
                Button okButton = context.getButtonByText("OK");
                CustomizeTest.assertNotNull((Object)okButton);
                context.click((Widget)okButton);
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.setTitle('test');", "    add(button);", "  }", "}");
    }

    @Test
    public void test_useInheritedCustomizer() throws Exception {
        CustomizeTest.setFileContentSrc("test/BeanA.java", this.getTestSource("public class BeanA extends JButton {", "  private static final long serialVersionUID = 0L;", "}"));
        CustomizeTest.setFileContentSrc("test/BeanABeanInfo.java", this.getTestSource("import java.beans.*;", "public class BeanABeanInfo extends SimpleBeanInfo {", "  private final static Class<?> beanClass = BeanA.class;", "  private final static Class<?> customizerClass = BeanCustomizer.class;", "  @Override", "  public BeanDescriptor getBeanDescriptor() {", "    return new BeanDescriptor(beanClass, customizerClass);", "  }", "}"));
        CustomizeTest.setFileContentSrc("test/BeanCustomizer.java", this.getTestSource("import java.beans.*;", "public class BeanCustomizer extends JPanel implements Customizer {", "  private static final long serialVersionUID = 0L;", "  public void setObject(Object bean) {", "  }", "}"));
        CustomizeTest.setFileContentSrc("test/BeanB.java", this.getTestSource("public class BeanB extends BeanA {", "  private static final long serialVersionUID = 0L;", "}"));
        CustomizeTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    BeanB bean = new BeanB();", "    add(bean);", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager manager = CustomizeTest.getContextMenu(new ObjectInfo[]{button});
        IAction action = CustomizeTest.findChildAction((IContributionManager)manager, "&Customize...");
        CustomizeTest.assertNotNull((Object)action);
    }
}

