/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.internal.core.model.property.order.TabOrderInfo;
import org.eclipse.wb.internal.swt.model.property.TabOrderProperty;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class TabOrderPropertyTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setValue() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        composite.refresh();
        TabOrderProperty property = (TabOrderProperty)composite.getPropertyByTitle("tab order");
        TabOrderInfo newValue = new TabOrderInfo();
        newValue.addOrderedInfo((AbstractComponentInfo)composite.getChildrenControls().get(0));
        property.setValue((Object)newValue);
        this.assertEditor("public class Test extends Composite {", "  private Button button;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      button = new Button(this, SWT.NONE);", "    }", "    setTabList(new Control[]{button});", "  }", "}");
    }

    @Test
    public void test_wrongCode() throws Exception {
        this.m_ignoreCompilationProblems = true;
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  private Button button;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      button = new Button(this, SWT.NONE);", "    }", "    setTabList(new Control[]{button, label});", "  }", "}");
        composite.refresh();
        TabOrderProperty property = (TabOrderProperty)composite.getPropertyByTitle("tab order");
        TabOrderPropertyTest.assertEquals((Object)"[button]", (Object)property.getDisplayText());
        property.setValue(property.getValue());
        this.assertEditor("public class Test extends Composite {", "  private Button button;", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new FillLayout());", "    {", "      button = new Button(this, SWT.NONE);", "    }", "    setTabList(new Control[]{button});", "  }", "}");
    }
}

