/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.layout;

import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpGefTest;
import org.junit.Ignore;
import org.junit.Test;

public class AbsoluteLayoutGefTest
extends RcpGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_canvas_CREATE() throws Exception {
        this.prepareComponent();
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        this.loadCreationButton();
        this.canvas.sideMode().create(100, 50);
        this.canvas.target(composite).in(30, 40).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(30, 40, 100, 50);", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_canvas_PASTE() throws Exception {
        this.prepareComponent();
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button buttonA = new Button(this, SWT.NONE);", "      buttonA.setEnabled(false);", "      buttonA.setBounds(10, 10, 100, 50);", "    }", "  }", "}");
        ControlInfo buttonA = (ControlInfo)composite.getChildrenControls().get(0);
        this.canvas.select(buttonA);
        IAction copyAction = this.getCopyAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.canvas.sideMode().create(100, 50);
        this.canvas.target(composite).inX(50).inY(100).move();
        this.canvas.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button buttonA = new Button(this, SWT.NONE);", "      buttonA.setEnabled(false);", "      buttonA.setBounds(10, 10, 100, 50);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setEnabled(false);", "      button.setBounds(50, 100, 100, 50);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_MOVE() throws Exception {
        this.prepareComponent();
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(30, 40, 100, 50);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        this.canvas.sideMode().beginMove(button);
        this.canvas.target(composite).inX(50).inY(80).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(50, 80, 100, 50);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_RESIZE() throws Exception {
        this.prepareComponent();
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(30, 40, 100, 50);", "    }", "  }", "}");
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        this.canvas.beginResize(button, 20);
        this.canvas.dragTo((Object)button, 150, 100).endDrag();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(30, 40, 150, 100);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_ADD() throws Exception {
        this.prepareComponent();
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Composite inner = new Composite(this, SWT.NONE);", "      inner.setBounds(20, 100, 200, 150);", "      {", "        Button button = new Button(inner, SWT.NONE);", "        button.setBounds(10, 20, 100, 50);", "      }", "    }", "  }", "}");
        CompositeInfo inner = (CompositeInfo)composite.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)inner.getChildrenControls().get(0);
        this.canvas.sideMode().beginMove(button);
        this.canvas.target(composite).inX(50).inY(20).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Composite inner = new Composite(this, SWT.NONE);", "      inner.setBounds(20, 100, 200, 150);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(50, 20, 100, 50);", "    }", "  }", "}");
    }

    @Test
    public void test_tree_CREATE() throws Exception {
        this.prepareComponent();
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        ControlInfo newButton = this.loadCreationButton();
        this.tree.moveOn(composite);
        this.tree.assertFeedback_on(composite);
        this.tree.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(0, 0, 100, 50);", "    }", "  }", "}");
        this.tree.assertPrimarySelected(newButton);
    }

    @Ignore
    @Test
    public void test_tree_PASTE() throws Exception {
        this.prepareComponent();
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button buttonA = new Button(this, SWT.NONE);", "      buttonA.setEnabled(false);", "      buttonA.setBounds(10, 10, 100, 50);", "    }", "  }", "}");
        ControlInfo buttonA = (ControlInfo)composite.getChildrenControls().get(0);
        this.canvas.select(buttonA);
        IAction copyAction = this.getCopyAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        AbsoluteLayoutGefTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        this.tree.moveOn(composite);
        this.tree.assertFeedback_on(composite);
        this.tree.click();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button buttonA = new Button(this, SWT.NONE);", "      buttonA.setEnabled(false);", "      buttonA.setBounds(10, 10, 100, 50);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setEnabled(false);", "      button.setBounds(0, 0, 100, 50);", "    }", "  }", "}");
    }

    @Test
    public void test_tree_MOVE() throws Exception {
        this.prepareComponent();
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button buttonA = new Button(this, SWT.NONE);", "      buttonA.setBounds(10, 10, 100, 50);", "    }", "    {", "      Button buttonB = new Button(this, SWT.NONE);", "      buttonB.setBounds(20, 100, 100, 50);", "    }", "  }", "}");
        ControlInfo buttonA = (ControlInfo)composite.getChildrenControls().get(0);
        ControlInfo buttonB = (ControlInfo)composite.getChildrenControls().get(1);
        this.tree.startDrag(buttonB);
        this.tree.dragBefore(buttonA);
        this.tree.assertFeedback_before(buttonA);
        this.tree.endDrag();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Button buttonB = new Button(this, SWT.NONE);", "      buttonB.setBounds(20, 100, 100, 50);", "    }", "    {", "      Button buttonA = new Button(this, SWT.NONE);", "      buttonA.setBounds(10, 10, 100, 50);", "    }", "  }", "}");
        this.tree.assertPrimarySelected(buttonB);
    }

    @Test
    public void test_tree_ADD() throws Exception {
        this.prepareComponent();
        CompositeInfo composite = this.openComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Composite inner = new Composite(this, SWT.NONE);", "      inner.setBounds(20, 100, 200, 150);", "      {", "        Button button = new Button(inner, SWT.NONE);", "        button.setBounds(10, 20, 100, 50);", "      }", "    }", "  }", "}");
        CompositeInfo inner = (CompositeInfo)composite.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)inner.getChildrenControls().get(0);
        this.tree.startDrag(button);
        this.tree.dragOn(composite);
        this.tree.assertFeedback_on(composite);
        this.tree.endDrag();
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    {", "      Composite inner = new Composite(this, SWT.NONE);", "      inner.setBounds(20, 100, 200, 150);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setSize(100, 50);", "    }", "  }", "}");
    }
}

