/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.rcp.model.jface.WizardPageInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class WizardPageTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_0() throws Exception {
        WizardPageInfo wizardPage = (WizardPageInfo)this.parseJavaInfo("import org.eclipse.jface.wizard.*;", "public class Test extends WizardPage {", "  public Test() {", "    super('pageName');", "  }", "  public void createControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    setControl(container);", "  }", "}");
        WizardPageTest.assertHierarchy("{this: org.eclipse.jface.wizard.WizardPage} {this} {/setControl(container)/}", "  {parameter} {parent} {/new Composite(parent, SWT.NULL)/}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: container} {/new Composite(parent, SWT.NULL)/ /setControl(container)/}", "      {implicit-layout: absolute} {implicit-layout} {}");
        CompositeInfo parentComposite = (CompositeInfo)wizardPage.getChildren(CompositeInfo.class).get(0);
        CompositeInfo container = (CompositeInfo)parentComposite.getChildrenControls().get(0);
        wizardPage.refresh();
        WizardPageTest.assertEquals((long)wizardPage.getBounds().width, (long)600L);
        WizardPageTest.assertEquals((long)wizardPage.getBounds().height, (long)500L);
        Assertions.assertThat((int)parentComposite.getBounds().width).isGreaterThan(500);
        Assertions.assertThat((int)parentComposite.getBounds().height).isGreaterThan(230);
        Assertions.assertThat((int)container.getBounds().width).isGreaterThan(500);
        Assertions.assertThat((int)container.getBounds().height).isGreaterThan(220);
        wizardPage.getTopBoundsSupport().setSize(500, 400);
        wizardPage.refresh();
        WizardPageTest.assertEquals((long)wizardPage.getBounds().width, (long)500L);
        WizardPageTest.assertEquals((long)wizardPage.getBounds().height, (long)400L);
    }

    @Test
    public void test_refresh_whenAlreadyDisposed() throws Exception {
        WizardPageInfo wizardPage = (WizardPageInfo)this.parseJavaInfo("import org.eclipse.jface.wizard.*;", "public class Test extends WizardPage {", "  public Test() {", "    super('pageName');", "  }", "  public void createControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    setControl(container);", "  }", "}");
        wizardPage.refresh();
        Shell shell = wizardPage.getComponentObject();
        shell.dispose();
        wizardPage.refresh();
    }

    @Test
    public void test_override_getControl() throws Exception {
        WizardPageInfo wizardPage = (WizardPageInfo)this.parseJavaInfo("import org.eclipse.jface.wizard.*;", "public class Test extends WizardPage {", "  Composite container;", "  public Test() {", "    super('pageName');", "  }", "  public void createControl(Composite parent) {", "    container = new Composite(parent, SWT.NULL);", "    setControl(container);", "  }", "  public Control getControl() {", "    return (container);", "  }", "}");
        WizardPageTest.assertHierarchy("{this: org.eclipse.jface.wizard.WizardPage} {this} {/setControl(container)/}", "  {parameter} {parent} {/new Composite(parent, SWT.NULL)/}", "    {new: org.eclipse.swt.widgets.Composite} {field-unique: container} {/new Composite(parent, SWT.NULL)/ /setControl(container)/ /(container)/ /container/}", "      {implicit-layout: absolute} {implicit-layout} {}");
        wizardPage.refresh();
        WizardPageTest.assertNoErrors((JavaInfo)wizardPage);
    }

    @Test
    public void test_noControl() throws Exception {
        try {
            this.parseJavaInfo("import org.eclipse.jface.wizard.*;", "public class Test extends WizardPage {", "  public Test() {", "    super('pageName');", "  }", "  public void createControl(Composite parent) {", "  }", "}");
            WizardPageTest.fail();
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            WizardPageTest.assertEquals((long)3003L, (long)de.getCode());
            WizardPageTest.assertTrue((boolean)DesignerExceptionUtils.isWarning((Throwable)e));
        }
    }

    @Test
    public void test_simulateException_inCreate() throws Exception {
        String key = "__wbp_WizardPage_simulateException";
        try {
            try {
                System.setProperty(key, "true");
                this.parseJavaInfo("import org.eclipse.jface.wizard.*;", "public class Test extends WizardPage {", "  public Test() {", "    super('pageName');", "  }", "  public void createControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    setControl(container);", "  }", "}");
                WizardPageTest.fail();
            }
            catch (Throwable e) {
                Throwable rootCause = DesignerExceptionUtils.getRootCause((Throwable)e);
                WizardPageTest.assertEquals((Object)"Simulated exception", (Object)rootCause.getMessage());
                System.clearProperty(key);
            }
        }
        finally {
            System.clearProperty(key);
        }
    }

    @Test
    public void test_exceptionInCreate() throws Exception {
        WizardPageTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends Button {", "  public MyButton(Composite parent, int style) {", "    super(parent, style);", "    throw new IllegalStateException('actual');", "  }", "  protected void checkSubclass() {", "  }", "}"));
        WizardPageTest.waitForAutoBuild();
        WizardPageInfo wizardPage = (WizardPageInfo)this.parseJavaInfo("import org.eclipse.jface.wizard.*;", "public class Test extends WizardPage {", "  public Test() {", "    super('pageName');", "  }", "  public void createControl(Composite parent) {", "    setControl(new MyButton(parent, SWT.NONE));", "  }", "}");
        wizardPage.refresh();
        WizardPageTest.assertHierarchy("{this: org.eclipse.jface.wizard.WizardPage} {this} {/setControl(new MyButton(parent, SWT.NONE))/}", "  {parameter} {parent} {/new MyButton(parent, SWT.NONE)/}", "    {new: test.MyButton} {empty} {/setControl(new MyButton(parent, SWT.NONE))/}");
        List badNodes = this.m_lastState.getBadRefreshNodes().nodes();
        Assertions.assertThat((List)badNodes).hasSize(1);
    }

    @Test
    public void test_duplicateMethodInvocation() throws Exception {
        WizardPageInfo wizardPage = (WizardPageInfo)this.parseJavaInfo("import org.eclipse.jface.wizard.*;", "public class Test extends WizardPage {", "  public Test() {", "    super('pageName');", "  }", "  public void createControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    setControl(container);", "    createButton(container, SWT.NONE);", "    createButton(container, SWT.CHECK);", "  }", "  private Button createButton(Composite parent, int style) {", "    Button button = new Button(parent, style);", "    return button;", "  }", "}");
        WizardPageTest.assertHierarchy("{this: org.eclipse.jface.wizard.WizardPage} {this} {/setControl(container)/}", "  {parameter} {parent} {/new Composite(parent, SWT.NULL)/}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: container} {/new Composite(parent, SWT.NULL)/ /setControl(container)/ /new Button(parent, style)/ /createButton(container, SWT.NONE)/ /createButton(container, SWT.CHECK)/}", "      {implicit-layout: absolute} {implicit-layout} {}", "      {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(parent, style)/ /button/ /createButton(container, SWT.NONE)/ /createButton(container, SWT.CHECK)/}");
        wizardPage.refresh();
        WizardPageTest.assertNoErrors((JavaInfo)wizardPage);
    }

    @Test
    public void test_specialRendering_andAssignmentInConstructor() throws Exception {
        WizardPageInfo wizardPage = (WizardPageInfo)this.parseJavaInfo("import java.util.*;", "import org.eclipse.jface.wizard.*;", "public class Test extends WizardPage {", "  private Map m_map;", "  public Test() {", "    super('pageName');", "    m_map = new HashMap();", "  }", "  public void createControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    setControl(container);", "    container.setEnabled(m_map == null);", "  }", "}");
        WizardPageTest.assertHierarchy("{this: org.eclipse.jface.wizard.WizardPage} {this} {/setControl(container)/}", "  {parameter} {parent} {/new Composite(parent, SWT.NULL)/}", "    {new: org.eclipse.swt.widgets.Composite} {local-unique: container} {/new Composite(parent, SWT.NULL)/ /setControl(container)/ /container.setEnabled(m_map == null)/}", "      {implicit-layout: absolute} {implicit-layout} {}");
        wizardPage.refresh();
        ASTNode containerNode = this.m_lastEditor.getEnclosingNode("container =");
        CompositeInfo container = (CompositeInfo)wizardPage.getChildRepresentedBy(containerNode);
        WizardPageTest.assertEquals((Object)false, (Object)container.getWidget().isEnabled());
    }

    @Test
    public void test_ISelection_constructorArgument() throws Exception {
        WizardPageTest.setFileContentSrc("test/MyWizardPage.java", this.getTestSource("import org.eclipse.jface.wizard.*;", "public abstract class MyWizardPage extends WizardPage {", "  public MyWizardPage(ISelection selection) {", "    super('pageName');", "    if (selection == null) {", "      throw new IllegalArgumentException();", "    }", "  }", "}"));
        WizardPageTest.waitForAutoBuild();
        WizardPageTest.useStrictEvaluationMode(false);
        this.parseJavaInfo("public class Test extends MyWizardPage {", "  public Test(ISelection selection) {", "    super(selection);", "  }", "  public void createControl(Composite parent) {", "    Composite container = new Composite(parent, SWT.NULL);", "    setControl(container);", "  }", "}");
        this.refresh();
        WizardPageTest.assertNoErrors(this.m_lastParseInfo);
    }
}

