/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.rcp.model.jface.ApplicationWindowInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionContributionItemInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ContributionItemInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.CoolBarManagerInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ToolBarManagerInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class CoolBarManagerTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_0_emptyCoolBarManager() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "    addCoolBar(SWT.FLAT);", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolBarManager = super.createCoolBarManager(style);", "    return coolBarManager;", "  }", "}");
        CoolBarManagerTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        CoolBarManagerTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addCoolBar(SWT.FLAT)/}", "  {superInvocation: super.createCoolBarManager(style)} {local-unique: coolBarManager} {/super.createCoolBarManager(style)/ /coolBarManager/}");
        CoolBarManagerInfo coolBarManager = (CoolBarManagerInfo)window.getChildren(CoolBarManagerInfo.class).get(0);
        CoolBarManagerTest.assertEquals((Object)"org.eclipse.jface.action.CoolBarManager", (Object)coolBarManager.getObject().getClass().getName());
        CoolBarManagerTest.assertEquals((Object)"org.eclipse.swt.widgets.CoolBar", (Object)coolBarManager.getComponentObject().getClass().getName());
        CoolBarManagerTest.assertNotNull((Object)coolBarManager.getImage());
        CoolBarManagerTest.assertNotNull((Object)coolBarManager.getBounds());
        Assertions.assertThat((int)coolBarManager.getBounds().width).isGreaterThan(400);
        Assertions.assertThat((int)coolBarManager.getBounds().height).isGreaterThan(20);
    }

    @Test
    public void test_addToolBarManager_empty() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "    addCoolBar(SWT.FLAT);", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolBarManager = super.createCoolBarManager(style);", "    {", "      ToolBarManager toolBarManager = new ToolBarManager();", "      coolBarManager.add(toolBarManager);", "    }", "    return coolBarManager;", "  }", "}");
        CoolBarManagerTest.assertNoErrors((JavaInfo)window);
        CoolBarManagerTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addCoolBar(SWT.FLAT)/}", "  {superInvocation: super.createCoolBarManager(style)} {local-unique: coolBarManager} {/super.createCoolBarManager(style)/ /coolBarManager.add(toolBarManager)/ /coolBarManager/}", "    {new: org.eclipse.jface.action.ToolBarManager} {local-unique: toolBarManager} {/new ToolBarManager()/ /coolBarManager.add(toolBarManager)/}");
        CoolBarManagerInfo coolBarManager = (CoolBarManagerInfo)window.getChildren(CoolBarManagerInfo.class).get(0);
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)coolBarManager.getChildrenJava().get(0);
        window.refresh();
        Assertions.assertThat((int)toolBarManager.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)toolBarManager.getBounds().height).isGreaterThan(20);
        CoolBarManagerTest.assertTrue((boolean)toolBarManager.canDelete());
        toolBarManager.delete();
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "    addCoolBar(SWT.FLAT);", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolBarManager = super.createCoolBarManager(style);", "    return coolBarManager;", "  }", "}");
    }

    @Test
    public void test_addToolBarManager_notEmpty() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test() {", "    super(null);", "    createActions();", "    addCoolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    m_action = new Action('Some text') {", "    };", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolBarManager = super.createCoolBarManager(style);", "    {", "      ToolBarManager toolBarManager = new ToolBarManager();", "      coolBarManager.add(toolBarManager);", "      toolBarManager.add(m_action);", "    }", "    return coolBarManager;", "  }", "}");
        CoolBarManagerTest.assertNoErrors((JavaInfo)window);
        CoolBarManagerTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addCoolBar(SWT.FLAT)/}", "  {superInvocation: super.createCoolBarManager(style)} {local-unique: coolBarManager} {/super.createCoolBarManager(style)/ /coolBarManager.add(toolBarManager)/ /coolBarManager/}", "    {new: org.eclipse.jface.action.ToolBarManager} {local-unique: toolBarManager} {/new ToolBarManager()/ /coolBarManager.add(toolBarManager)/ /toolBarManager.add(m_action)/}", "      {void} {void} {/toolBarManager.add(m_action)/}", "  {org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo}", "    {new: org.eclipse.jface.action.Action} {field-unique: m_action} {/new Action('Some text')/ /toolBarManager.add(m_action)/}");
        CoolBarManagerInfo coolBarManager = (CoolBarManagerInfo)window.getChildren(CoolBarManagerInfo.class).get(0);
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)coolBarManager.getChildrenJava().get(0);
        ActionContributionItemInfo contributionItem = (ActionContributionItemInfo)toolBarManager.getItems().get(0);
        window.refresh();
        Assertions.assertThat((int)toolBarManager.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)toolBarManager.getBounds().height).isGreaterThan(20);
        Rectangle bounds = contributionItem.getBounds();
        Assertions.assertThat((int)bounds.width).isGreaterThan(50);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
        Assertions.assertThat((int)bounds.x).isGreaterThan(0);
        Assertions.assertThat((int)bounds.y).isGreaterThanOrEqualTo(0);
        Assertions.assertThat((int)bounds.y).isLessThanOrEqualTo(5);
    }

    @Ignore
    @Test
    public void test_addToolBarManager_usingToolBarContributionItem() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "    addCoolBar(SWT.FLAT);", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolBarManager = super.createCoolBarManager(style);", "    {", "      ToolBarManager toolBarManager = new ToolBarManager();", "      coolBarManager.add(new ToolBarContributionItem(toolBarManager, 'main'));", "    }", "    return coolBarManager;", "  }", "}");
        CoolBarManagerTest.assertNoErrors((JavaInfo)window);
        CoolBarManagerTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addCoolBar(SWT.FLAT)/}", "  {superInvocation: super.createCoolBarManager(style)} {local-unique: coolBarManager} {/super.createCoolBarManager(style)/ /coolBarManager.add(new ToolBarContributionItem(toolBarManager, 'main'))/ /coolBarManager/}", "    {new: org.eclipse.jface.action.ToolBarContributionItem} {empty} {/coolBarManager.add(new ToolBarContributionItem(toolBarManager, 'main'))/}", "      {new: org.eclipse.jface.action.ToolBarManager} {local-unique: toolBarManager} {/new ToolBarManager()/ /new ToolBarContributionItem(toolBarManager, 'main')/}");
        CoolBarManagerInfo coolBarManager = (CoolBarManagerInfo)window.getChildren(CoolBarManagerInfo.class).get(0);
        ContributionItemInfo contributionItem = (ContributionItemInfo)coolBarManager.getItems().get(0);
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)contributionItem.getChildrenJava().get(0);
        window.refresh();
        Rectangle bounds = contributionItem.getBounds();
        Assertions.assertThat((int)bounds.x).isGreaterThan(5);
        CoolBarManagerTest.assertEquals((long)bounds.y, (long)0L);
        Assertions.assertThat((int)bounds.width).isGreaterThan(400);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
        bounds = toolBarManager.getBounds();
        CoolBarManagerTest.assertEquals((long)bounds.x, (long)0L);
        CoolBarManagerTest.assertEquals((long)bounds.y, (long)0L);
        Assertions.assertThat((int)bounds.width).isGreaterThan(400);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
        CoolBarManagerTest.assertFalse((boolean)toolBarManager.canDelete());
        CoolBarManagerTest.assertFalse((boolean)JavaInfoUtils.canReparent((JavaInfo)toolBarManager));
        CoolBarManagerTest.assertTrue((boolean)contributionItem.canDelete());
        contributionItem.delete();
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "    addCoolBar(SWT.FLAT);", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolBarManager = super.createCoolBarManager(style);", "    return coolBarManager;", "  }", "}");
    }

    @Test
    public void test_CREATE() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "    addCoolBar(SWT.FLAT);", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolBarManager = super.createCoolBarManager(style);", "    return coolBarManager;", "  }", "}");
        window.refresh();
        CoolBarManagerInfo coolBarManager = (CoolBarManagerInfo)window.getChildren(CoolBarManagerInfo.class).get(0);
        ToolBarManagerInfo newManager = (ToolBarManagerInfo)CoolBarManagerTest.createJavaInfo("org.eclipse.jface.action.ToolBarManager");
        coolBarManager.command_CREATE((AbstractComponentInfo)newManager, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test() {", "    super(null);", "    addCoolBar(SWT.FLAT);", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolBarManager = super.createCoolBarManager(style);", "    {", "      ToolBarManager toolBarManager = new ToolBarManager();", "      coolBarManager.add(toolBarManager);", "    }", "    return coolBarManager;", "  }", "}");
    }
}

