/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.palette.PaletteEventListener;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VoidInvocationVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.rcp.model.jface.ApplicationWindowInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionContributionItemInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ContributionItemInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ContributionManagerActionCreationSupport;
import org.eclipse.wb.internal.rcp.model.jface.action.CoolBarManagerInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.GroupMarkerInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ToolBarManagerInfo;
import org.eclipse.wb.internal.rcp.model.rcp.ActionFactoryCreationSupport;
import org.eclipse.wb.internal.rcp.palette.ActionExternalEntryInfo;
import org.eclipse.wb.internal.rcp.palette.ActionNewEntryInfo;
import org.eclipse.wb.internal.rcp.palette.ActionUseEntryInfo;
import org.eclipse.wb.internal.swt.utils.ManagerUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class ActionTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_container() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "}");
        ActionTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {}");
        Assertions.assertThat((List)ActionContainerInfo.getActions((JavaInfo)window)).isEmpty();
        ActionContainerInfo container = ActionContainerInfo.get((JavaInfo)window);
        ActionTest.assertNotNull((Object)container);
        ActionTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {}", "  {org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo}");
        ActionTest.assertSame((Object)container, (Object)ActionContainerInfo.get((JavaInfo)window));
        Assertions.assertThat((List)ActionContainerInfo.getActions((JavaInfo)window)).isEmpty();
        IObjectPresentation presentation = container.getPresentation();
        ActionTest.assertEquals((Object)"(actions)", (Object)presentation.getText());
        ActionTest.assertNotNull((Object)presentation.getIcon());
    }

    @Test
    public void test_0() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "  }", "  private void createActions() {", "    {", "      m_action = new Action('The text') {", "        public void run() {", "        }", "      };", "    }", "  }", "}");
        ActionTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {}", "  {org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo}", "    {new: org.eclipse.jface.action.Action} {field-unique: m_action} {/new Action('The text')/}");
        ActionTest.assertNotNull((Object)ActionContainerInfo.get((JavaInfo)window));
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)window).get(0);
        window.refresh();
        ActionTest.assertEquals((Object)"The text", (Object)action.getAction().getText());
        IObjectPresentation presentation = action.getPresentation();
        ActionTest.assertEquals((Object)"m_action", (Object)presentation.getText());
        ActionTest.assertNotNull((Object)presentation.getIcon());
    }

    @Test
    public void test_iconImage_1() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "  }", "  private void createActions() {", "    {", "      m_action = new Action(null, null) {", "      };", "    }", "  }", "}");
        window.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)window).get(0);
        IObjectPresentation presentation = action.getPresentation();
        ImageDescriptor genericActionIcon = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("org.eclipse.jface.action.Action")).getIcon();
        ActionTest.assertTrue((boolean)UiUtils.equals((ImageDescriptor)genericActionIcon, (ImageDescriptor)presentation.getIcon()));
        ManagerUtils.ensure_ResourceManager((JavaInfo)window);
        ClassInstanceCreation actionCreation = (ClassInstanceCreation)action.getCreationSupport().getNode();
        Expression imageDescriptionExpression = (Expression)actionCreation.arguments().get(1);
        this.m_lastEditor.replaceExpression(imageDescriptionExpression, List.of("org.eclipse.jface.resource.ImageDescriptor.createFromURL(", "org.eclipse.core.runtime.Platform.getBundle(\"org.eclipse.ui\").getResource(\"/icons/full/etool16/delete_edit.png\"))"));
        window.refresh();
        ActionTest.assertFalse((boolean)UiUtils.equals((ImageDescriptor)genericActionIcon, (ImageDescriptor)presentation.getIcon()));
    }

    @Test
    public void test_iconImage_2() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "  }", "  private void createActions() {", "    {", "      m_action = new Action(null, null) {", "      };", "    }", "  }", "}");
        window.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)window).get(0);
        IObjectPresentation presentation = action.getPresentation();
        ImageDescriptor genericActionIcon = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("org.eclipse.jface.action.Action")).getIcon();
        ActionTest.assertTrue((boolean)UiUtils.equals((ImageDescriptor)genericActionIcon, (ImageDescriptor)presentation.getIcon()));
        ImageDescriptor expectedImage = ActionFactoryCreationSupport.DEFAULT_ICON;
        ActionFactoryCreationSupport creationSupport = new ActionFactoryCreationSupport(null, null);
        action.setCreationSupport((CreationSupport)creationSupport);
        ActionTest.assertSame((Object)expectedImage, (Object)presentation.getIcon());
    }

    @Test
    public void test_boundProperties() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "  }", "  private void createActions() {", "    {", "      String text = null;", "      ImageDescriptor imageDescriptor = null;", "      m_action = new Action(text, imageDescriptor) {", "      };", "    }", "  }", "}");
        window.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)window).get(0);
        action.getPropertyByTitle("text").setValue((Object)"The text");
        ((GenericProperty)action.getPropertyByTitle("imageDescriptor")).setExpression("null", Property.UNKNOWN_VALUE);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "  }", "  private void createActions() {", "    {", "      String text = null;", "      ImageDescriptor imageDescriptor = null;", "      m_action = new Action('The text', null) {", "      };", "    }", "  }", "}");
    }

    @Test
    public void test_palette_noManager() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "  }", "}");
        PaletteEventListener listener = (PaletteEventListener)window.getBroadcast(PaletteEventListener.class);
        ArrayList categories = new ArrayList();
        listener.categories(categories);
        Assertions.assertThat(categories).isEmpty();
    }

    @Test
    public void test_palette_hasToolBarManager() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      String text = null;", "      ImageDescriptor imageDescriptor = null;", "      m_action = new Action(text, imageDescriptor) {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    return toolbarManager;", "  }", "}");
        PaletteEventListener listener = (PaletteEventListener)window.getBroadcast(PaletteEventListener.class);
        ArrayList categories = new ArrayList();
        listener.categories(categories);
        Assertions.assertThat(categories).hasSize(1);
        CategoryInfo category = (CategoryInfo)categories.get(0);
        List entries = category.getEntries();
        Assertions.assertThat((List)entries).hasSize(3);
        ActionTest.assertInstanceOf(ActionNewEntryInfo.class, entries.get(0));
        ActionTest.assertInstanceOf(ActionExternalEntryInfo.class, entries.get(1));
        ComponentEntryInfo entry = (ComponentEntryInfo)entries.get(2);
        ActionTest.assertEquals((Object)"org.eclipse.jface.action.Separator", (Object)entry.getClassName());
        listener.entries(category, entries);
        Assertions.assertThat((List)entries).hasSize(4);
        ActionTest.assertInstanceOf(ActionUseEntryInfo.class, entries.get(3));
    }

    @Test
    public void test_palette_actionsCategory_beforeMenu() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addToolBar(SWT.FLAT);", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    return toolbarManager;", "  }", "}");
        ArrayList<CategoryInfo> categories = new ArrayList<CategoryInfo>();
        categories.add(new CategoryInfo("org.eclipse.wb.rcp.menu"));
        PaletteEventListener listener = (PaletteEventListener)window.getBroadcast(PaletteEventListener.class);
        listener.categories(categories);
        Assertions.assertThat(categories).hasSize(2);
        ActionTest.assertEquals((Object)"org.eclipse.wb.rcp.jface.actions", (Object)((CategoryInfo)categories.get(0)).getId());
    }

    @Test
    public void test_palette_hasCoolBarManager() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addCoolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      String text = null;", "      ImageDescriptor imageDescriptor = null;", "      m_action = new Action(text, imageDescriptor) {", "      };", "    }", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolbarManager = super.createCoolBarManager(style);", "    return coolbarManager;", "  }", "}");
        PaletteEventListener listener = (PaletteEventListener)window.getBroadcast(PaletteEventListener.class);
        ArrayList categories = new ArrayList();
        listener.categories(categories);
        Assertions.assertThat(categories).hasSize(1);
        CategoryInfo category = (CategoryInfo)categories.get(0);
        List entries = category.getEntries();
        Assertions.assertThat((List)entries).hasSize(4);
        ActionTest.assertInstanceOf(ActionNewEntryInfo.class, entries.get(0));
        ActionTest.assertInstanceOf(ActionExternalEntryInfo.class, entries.get(1));
        ComponentEntryInfo entry = (ComponentEntryInfo)entries.get(2);
        ActionTest.assertEquals((Object)"org.eclipse.jface.action.Separator", (Object)entry.getClassName());
        entry = (ComponentEntryInfo)entries.get(3);
        ActionTest.assertEquals((Object)"org.eclipse.jface.action.ToolBarManager", (Object)entry.getClassName());
        listener.entries(category, entries);
        Assertions.assertThat((List)entries).hasSize(5);
        ActionTest.assertInstanceOf(ActionUseEntryInfo.class, entries.get(4));
    }

    @Test
    public void test_palette_hasMenuBarManager() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    {", "      String text = null;", "      ImageDescriptor imageDescriptor = null;", "      m_action = new Action(text, imageDescriptor) {", "      };", "    }", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    return menuManager;", "  }", "}");
        PaletteEventListener listener = (PaletteEventListener)window.getBroadcast(PaletteEventListener.class);
        ArrayList categories = new ArrayList();
        listener.categories(categories);
        Assertions.assertThat(categories).hasSize(1);
        CategoryInfo category = (CategoryInfo)categories.get(0);
        List entries = category.getEntries();
        Assertions.assertThat((List)entries).hasSize(4);
        ActionTest.assertInstanceOf(ActionNewEntryInfo.class, entries.get(0));
        ActionTest.assertInstanceOf(ActionExternalEntryInfo.class, entries.get(1));
        ComponentEntryInfo entry = (ComponentEntryInfo)entries.get(2);
        ActionTest.assertEquals((Object)"org.eclipse.jface.action.Separator", (Object)entry.getClassName());
        entry = (ComponentEntryInfo)entries.get(3);
        ActionTest.assertEquals((Object)"org.eclipse.jface.action.MenuManager", (Object)entry.getClassName());
        listener.entries(category, entries);
        Assertions.assertThat((List)entries).hasSize(5);
        ActionTest.assertInstanceOf(ActionUseEntryInfo.class, entries.get(4));
    }

    @Test
    public void test_palette_ActionUse_EntryInfo_EmptyVariable() throws Exception {
        ActionTest.setFileContentSrc("test/MyAction.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "import org.eclipse.jface.action.*;", "public class MyAction extends Action {", "}"));
        ActionTest.waitForAutoBuild();
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addToolBar(SWT.FLAT);", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(new MyAction());", "    return toolbarManager;", "  }", "}");
        PaletteEventListener listener = (PaletteEventListener)window.getBroadcast(PaletteEventListener.class);
        CategoryInfo category = new CategoryInfo("org.eclipse.wb.rcp.jface.actions");
        ArrayList entries = new ArrayList();
        listener.entries(category, entries);
        ActionUseEntryInfo entry = (ActionUseEntryInfo)entries.get(0);
        ActionTest.assertNotNull((Object)entry.getId());
        ActionTest.assertNotNull((Object)entry.getName());
        ActionTest.assertNotNull((Object)entry.getDescription());
    }

    @Test
    public void test_IContributionItem_void() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      m_action = new Action('Some text') {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(m_action);", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        ActionTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addToolBar(SWT.FLAT)/}", "  {superInvocation: super.createToolBarManager(style)} {local-unique: toolbarManager} {/super.createToolBarManager(style)/ /toolbarManager.add(m_action)/ /toolbarManager/}", "    {void} {void} {/toolbarManager.add(m_action)/}", "  {org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo}", "    {new: org.eclipse.jface.action.Action} {field-unique: m_action} {/new Action('Some text')/ /toolbarManager.add(m_action)/}");
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)window).get(0);
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ContributionItemInfo contributionItem = (ContributionItemInfo)toolBarManager.getChildrenJava().get(0);
        ActionTest.assertInstanceOf(ContributionManagerActionCreationSupport.class, (Object)contributionItem.getCreationSupport());
        ActionTest.assertInstanceOf(VoidInvocationVariableSupport.class, (Object)contributionItem.getVariableSupport());
        window.refresh();
        Assertions.assertThat((int)contributionItem.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)contributionItem.getBounds().height).isGreaterThan(20);
        Property[] itemProperties = contributionItem.getProperties();
        Property[] actionProperties = action.getProperties();
        ActionTest.assertEquals((long)actionProperties.length, (long)itemProperties.length);
        IObjectPresentation actionPresentation = action.getPresentation();
        IObjectPresentation itemPresentation = contributionItem.getPresentation();
        ActionTest.assertSame((Object)actionPresentation.getIcon(), (Object)itemPresentation.getIcon());
        ActionTest.assertEquals((Object)actionPresentation.getText(), (Object)itemPresentation.getText());
        ActionTest.assertTrue((boolean)contributionItem.canDelete());
        contributionItem.delete();
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      m_action = new Action('Some text') {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    return toolbarManager;", "  }", "}");
    }

    @Test
    public void test_IContributionItem_deleteAction() throws Exception {
        this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      m_action = new Action('Some text') {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(m_action);", "    return toolbarManager;", "  }", "}");
        ActionTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addToolBar(SWT.FLAT)/}", "  {superInvocation: super.createToolBarManager(style)} {local-unique: toolbarManager} {/super.createToolBarManager(style)/ /toolbarManager.add(m_action)/ /toolbarManager/}", "    {void} {void} {/toolbarManager.add(m_action)/}", "  {org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo}", "    {new: org.eclipse.jface.action.Action} {field-unique: m_action} {/new Action('Some text')/ /toolbarManager.add(m_action)/}");
        ActionInfo action = (ActionInfo)ActionTest.getJavaInfoByName("m_action");
        action.delete();
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    return toolbarManager;", "  }", "}");
        ActionTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addToolBar(SWT.FLAT)/}", "  {superInvocation: super.createToolBarManager(style)} {local-unique: toolbarManager} {/super.createToolBarManager(style)/ /toolbarManager/}", "  {org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo}");
    }

    @Test
    public void test_IContributionItem_explicit() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      m_action = new Action('Some text') {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(new ActionContributionItem(m_action));", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        ActionTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addToolBar(SWT.FLAT)/}", "  {superInvocation: super.createToolBarManager(style)} {local-unique: toolbarManager} {/super.createToolBarManager(style)/ /toolbarManager.add(new ActionContributionItem(m_action))/ /toolbarManager/}", "    {new: org.eclipse.jface.action.ActionContributionItem} {empty} {/toolbarManager.add(new ActionContributionItem(m_action))/}", "  {org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo}", "    {new: org.eclipse.jface.action.Action} {field-unique: m_action} {/new Action('Some text')/ /new ActionContributionItem(m_action)/}");
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)window).get(0);
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ContributionItemInfo contributionItem = (ContributionItemInfo)toolBarManager.getChildrenJava().get(0);
        ActionTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)contributionItem.getCreationSupport());
        ActionTest.assertInstanceOf(EmptyVariableSupport.class, (Object)contributionItem.getVariableSupport());
        IObjectPresentation actionPresentation = action.getPresentation();
        IObjectPresentation itemPresentation = contributionItem.getPresentation();
        ActionTest.assertSame((Object)actionPresentation.getIcon(), (Object)itemPresentation.getIcon());
        ActionTest.assertEquals((Object)"(no variable)", (Object)itemPresentation.getText());
        window.refresh();
        Assertions.assertThat((int)contributionItem.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)contributionItem.getBounds().height).isGreaterThan(20);
        Property[] itemProperties = contributionItem.getProperties();
        Assertions.assertThat((int)itemProperties.length).isLessThan(6);
    }

    @Test
    public void test_IContributionItem_sameAction() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    m_action = new Action() {", "    };", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(m_action);", "    toolbarManager.add(m_action);", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ContributionItemInfo item_1 = (ContributionItemInfo)toolBarManager.getItems().get(0);
        ContributionItemInfo item_2 = (ContributionItemInfo)toolBarManager.getItems().get(1);
        ActionTest.assertNotSame((Object)item_1.getObject(), (Object)item_2.getObject());
        ActionTest.assertNotEquals((Object)item_1.getBounds(), (Object)item_2.getBounds());
    }

    @Test
    public void test_IContributionItem_danglingSeparator() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    m_action = new Action() {", "    };", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(new Separator());", "    toolbarManager.add(new Separator());", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ContributionItemInfo item_1 = (ContributionItemInfo)toolBarManager.getItems().get(0);
        ContributionItemInfo item_2 = (ContributionItemInfo)toolBarManager.getItems().get(1);
        ActionTest.assertNotSame((Object)item_1.getObject(), (Object)item_2.getObject());
        ActionTest.assertNotNull((Object)item_1.getBounds());
        ActionTest.assertNotNull((Object)item_2.getBounds());
        ActionTest.assertNotEquals((Object)item_1.getBounds(), (Object)item_2.getBounds());
    }

    @Test
    public void test_GroupMarker() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addToolBar(SWT.FLAT);", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(new GroupMarker('Some long GroupMarker id'));", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        GroupMarkerInfo groupMarker = (GroupMarkerInfo)toolBarManager.getItems().get(0);
        Rectangle bounds = groupMarker.getBounds();
        ActionTest.assertNotNull((Object)bounds);
        Assertions.assertThat((int)bounds.width).isGreaterThan(135);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
    }

    @Test
    public void test_CREATE_1() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      m_action = new Action('Some text') {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)window).get(0);
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        toolBarManager.command_CREATE(action, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      m_action = new Action('Some text') {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(m_action);", "    return toolbarManager;", "  }", "}");
    }

    @Test
    public void test_CREATE_2() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      m_action = new Action('Some text') {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(new Separator());", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)window).get(0);
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ContributionItemInfo separator = (ContributionItemInfo)toolBarManager.getItems().get(0);
        toolBarManager.command_CREATE(action, (AbstractComponentInfo)separator);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction m_action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      m_action = new Action('Some text') {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(m_action);", "    toolbarManager.add(new Separator());", "    return toolbarManager;", "  }", "}");
    }

    @Test
    public void test_CREATE_3() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addToolBar(SWT.FLAT);", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ContributionItemInfo separator = (ContributionItemInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("org.eclipse.jface.action.Separator"), (CreationSupport)new ConstructorCreationSupport());
        toolBarManager.command_CREATE((AbstractComponentInfo)separator, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addToolBar(SWT.FLAT);", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(new Separator());", "    return toolbarManager;", "  }", "}");
    }

    @Test
    public void test_CREATE_externalAction_1() throws Exception {
        ActionTest.setFileContentSrc("test/MyAction.java", ActionTest.getSourceDQ("package test;", "import org.eclipse.jface.action.*;", "public class MyAction extends Action {", "}"));
        ActionTest.waitForAutoBuild();
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ActionInfo action = (ActionInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.MyAction"), (CreationSupport)new ConstructorCreationSupport());
        toolBarManager.command_CREATE(action, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private MyAction myAction;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      myAction = new MyAction();", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(myAction);", "    return toolbarManager;", "  }", "}");
    }

    @Test
    public void test_CREATE_newAction_1() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    return toolbarManager;", "  }", "}");
        window.refresh();
        ActionTest.assertNoErrors((JavaInfo)window);
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        Assertions.assertThat((List)ActionContainerInfo.getActions((JavaInfo)window)).isEmpty();
        ActionInfo action = ActionContainerInfo.createNew((JavaInfo)window);
        toolBarManager.command_CREATE(action, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private Action action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      action = new Action('New Action') {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(action);", "    return toolbarManager;", "  }", "}");
        Assertions.assertThat((List)ActionContainerInfo.getActions((JavaInfo)window)).containsOnly((Object[])new ActionInfo[]{action});
        window.refresh();
        ActionTest.assertNoErrors((JavaInfo)window);
    }

    @Test
    public void test_CREATE_newAction_2() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addToolBar(SWT.FLAT);", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ActionInfo action = ActionContainerInfo.createNew((JavaInfo)window);
        toolBarManager.command_CREATE(action, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private Action action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    {", "      action = new Action('New Action') {", "      };", "    }", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(action);", "    return toolbarManager;", "  }", "}");
        window.refresh();
        ActionTest.assertNoErrors((JavaInfo)window);
    }

    @Test
    public void test_MOVE_1() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addToolBar(SWT.FLAT);", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(new Separator('0'));", "    toolbarManager.add(new Separator('1'));", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ContributionItemInfo separator_0 = (ContributionItemInfo)toolBarManager.getItems().get(0);
        ContributionItemInfo separator_1 = (ContributionItemInfo)toolBarManager.getItems().get(1);
        toolBarManager.command_MOVE((AbstractComponentInfo)separator_1, (AbstractComponentInfo)separator_0);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addToolBar(SWT.FLAT);", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(new Separator('1'));", "    toolbarManager.add(new Separator('0'));", "    return toolbarManager;", "  }", "}");
        toolBarManager.command_MOVE((AbstractComponentInfo)separator_1, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addToolBar(SWT.FLAT);", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(new Separator('0'));", "    toolbarManager.add(new Separator('1'));", "    return toolbarManager;", "  }", "}");
    }

    @Test
    public void test_MOVE_2() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action_1;", "  private IAction action_2;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    action_1 = new Action() {", "    };", "    action_2 = new Action() {", "    };", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(action_1);", "    toolbarManager.add(action_2);", "    return toolbarManager;", "  }", "}");
        ActionTest.assertNoErrors((JavaInfo)window);
        window.refresh();
        ToolBarManagerInfo toolBarManager = (ToolBarManagerInfo)window.getChildren(ToolBarManagerInfo.class).get(0);
        ContributionItemInfo item_1 = (ContributionItemInfo)toolBarManager.getItems().get(0);
        ContributionItemInfo item_2 = (ContributionItemInfo)toolBarManager.getItems().get(1);
        toolBarManager.command_MOVE((AbstractComponentInfo)item_2, (AbstractComponentInfo)item_1);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action_1;", "  private IAction action_2;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addToolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    action_1 = new Action() {", "    };", "    action_2 = new Action() {", "    };", "  }", "  protected ToolBarManager createToolBarManager(int style) {", "    ToolBarManager toolbarManager = super.createToolBarManager(style);", "    toolbarManager.add(action_2);", "    toolbarManager.add(action_1);", "    return toolbarManager;", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_MOVE_2() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addCoolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    action = new Action() {", "    };", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolBarManager = super.createCoolBarManager(style);", "    {", "      ToolBarManager toolBarManager_1 = new ToolBarManager();", "      coolBarManager.add(toolBarManager_1);", "      toolBarManager_1.add(action);", "    }", "    {", "      ToolBarManager toolBarManager_2 = new ToolBarManager();", "      coolBarManager.add(toolBarManager_2);", "    }", "    return coolBarManager;", "  }", "}");
        window.refresh();
        ActionTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addCoolBar(SWT.FLAT)/}", "  {superInvocation: super.createCoolBarManager(style)} {local-unique: coolBarManager} {/super.createCoolBarManager(style)/ /coolBarManager.add(toolBarManager_1)/ /coolBarManager.add(toolBarManager_2)/ /coolBarManager/}", "    {new: org.eclipse.jface.action.ToolBarManager} {local-unique: toolBarManager_1} {/new ToolBarManager()/ /coolBarManager.add(toolBarManager_1)/ /toolBarManager_1.add(action)/}", "      {void} {void} {/toolBarManager_1.add(action)/}", "    {new: org.eclipse.jface.action.ToolBarManager} {local-unique: toolBarManager_2} {/new ToolBarManager()/ /coolBarManager.add(toolBarManager_2)/}", "  {org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo}", "    {new: org.eclipse.jface.action.Action} {field-unique: action} {/new Action()/ /toolBarManager_1.add(action)/}");
        CoolBarManagerInfo coolBar = (CoolBarManagerInfo)window.getChildren(CoolBarManagerInfo.class).get(0);
        ToolBarManagerInfo toolBar_1 = (ToolBarManagerInfo)coolBar.getToolBarManagers().get(0);
        ToolBarManagerInfo toolBar_2 = (ToolBarManagerInfo)coolBar.getToolBarManagers().get(1);
        ActionContributionItemInfo itemInfo = (ActionContributionItemInfo)toolBar_1.getItems().get(0);
        ActionTest.assertTrue((boolean)itemInfo.getCreationSupport().canReorder());
        ActionTest.assertTrue((boolean)itemInfo.getCreationSupport().canReparent());
        ActionTest.assertTrue((boolean)itemInfo.getCreationSupport().canUseParent((JavaInfo)toolBar_2));
        toolBar_2.command_MOVE((AbstractComponentInfo)itemInfo, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addCoolBar(SWT.FLAT);", "  }", "  private void createActions() {", "    action = new Action() {", "    };", "  }", "  protected CoolBarManager createCoolBarManager(int style) {", "    CoolBarManager coolBarManager = super.createCoolBarManager(style);", "    {", "      ToolBarManager toolBarManager_1 = new ToolBarManager();", "      coolBarManager.add(toolBarManager_1);", "    }", "    {", "      ToolBarManager toolBarManager_2 = new ToolBarManager();", "      coolBarManager.add(toolBarManager_2);", "      toolBarManager_2.add(action);", "    }", "    return coolBarManager;", "  }", "}");
        InvocationVoidAssociation association = (InvocationVoidAssociation)itemInfo.getAssociation();
        ActionTest.assertEquals((Object)"toolBarManager_2.add(action)", (Object)association.getSource());
        ActionTest.assertSame((Object)this.m_lastEditor.getAstUnit(), (Object)association.getInvocation().getRoot());
        window.refresh();
        ActionTest.assertNoErrors((JavaInfo)window);
    }
}

