/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.InvocationSecondaryAssociation;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerFactory;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.rcp.model.jface.layout.ColumnPixelDataInfo;
import org.eclipse.wb.internal.rcp.model.jface.layout.ColumnWeightDataInfo;
import org.eclipse.wb.internal.rcp.model.jface.layout.TableColumnLayoutInfo;
import org.eclipse.wb.internal.rcp.model.jface.layout.TreeColumnLayoutInfo;
import org.eclipse.wb.internal.rcp.model.widgets.TableInfo;
import org.eclipse.wb.internal.rcp.model.widgets.TreeColumnInfo;
import org.eclipse.wb.internal.rcp.model.widgets.TreeInfo;
import org.eclipse.wb.internal.rcp.palette.TableCompositeEntryInfo;
import org.eclipse.wb.internal.rcp.palette.TableViewerCompositeEntryInfo;
import org.eclipse.wb.internal.rcp.palette.TreeCompositeEntryInfo;
import org.eclipse.wb.internal.rcp.palette.TreeViewerCompositeEntryInfo;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.ItemInfo;
import org.eclipse.wb.internal.swt.model.widgets.TableColumnInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class AbstractColumnLayoutTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse_TableColumnLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column_1 = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column_1, new ColumnPixelData(150));", "    }", "    {", "      TableColumn column_2 = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column_2, new ColumnWeightData(1, 200));", "    }", "  }", "}");
        shell.refresh();
        TableColumnLayoutInfo layout = (TableColumnLayoutInfo)shell.getLayout();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        ColumnPixelDataInfo layoutData = (ColumnPixelDataInfo)layout.getLayoutData((ItemInfo)column);
        AbstractColumnLayoutTest.assertInstanceOf(InvocationSecondaryAssociation.class, (Object)layoutData.getAssociation());
        AbstractColumnLayoutTest.assertTrue((boolean)layoutData.canDelete());
        AbstractColumnLayoutTest.assertTrue((boolean)column.canDelete());
        AbstractColumnLayoutTest.assertEquals((Object)150, (Object)layoutData.getPropertyByTitle("width").getValue());
        Property typeProperty = column.getPropertyByTitle("LayoutDataType");
        AbstractColumnLayoutTest.assertTrue((boolean)typeProperty.isModified());
        AbstractColumnLayoutTest.assertEquals((Object)"ColumnPixelData", (Object)typeProperty.getValue());
        Property layoutDataProperty = column.getPropertyByTitle("LayoutData");
        Property[] subProperties = AbstractColumnLayoutTest.getSubProperties(layoutDataProperty);
        AbstractColumnLayoutTest.assertNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "Constructor"));
        AbstractColumnLayoutTest.assertNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "Class"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "width"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "resizable"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "addTrim"));
        column = (TableColumnInfo)table.getColumns().get(1);
        layoutData = (ColumnWeightDataInfo)layout.getLayoutData((ItemInfo)column);
        AbstractColumnLayoutTest.assertEquals((Object)1, (Object)layoutData.getPropertyByTitle("weight").getValue());
        AbstractColumnLayoutTest.assertEquals((Object)200, (Object)layoutData.getPropertyByTitle("minimumWidth").getValue());
        typeProperty = column.getPropertyByTitle("LayoutDataType");
        AbstractColumnLayoutTest.assertTrue((boolean)typeProperty.isModified());
        AbstractColumnLayoutTest.assertEquals((Object)"ColumnWeightData", (Object)typeProperty.getValue());
        layoutDataProperty = column.getPropertyByTitle("LayoutData");
        subProperties = AbstractColumnLayoutTest.getSubProperties(layoutDataProperty);
        AbstractColumnLayoutTest.assertNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "Constructor"));
        AbstractColumnLayoutTest.assertNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "Class"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "weight"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "minimumWidth"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "resizable"));
    }

    @Test
    public void test_parse_TreeColumnLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TreeColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TreeColumnLayout treeColumnLayout = new TreeColumnLayout();", "    setLayout(treeColumnLayout);", "    Tree tree = new Tree(this, SWT.NONE);", "    {", "      TreeColumn column_1 = new TreeColumn(tree, SWT.NONE);", "      treeColumnLayout.setColumnData(column_1, new ColumnPixelData(150));", "    }", "    {", "      TreeColumn column_2 = new TreeColumn(tree, SWT.NONE);", "      treeColumnLayout.setColumnData(column_2, new ColumnWeightData(1, 200));", "    }", "  }", "}");
        shell.refresh();
        TreeColumnLayoutInfo layout = (TreeColumnLayoutInfo)shell.getLayout();
        TreeInfo table = (TreeInfo)shell.getChildrenControls().get(0);
        TreeColumnInfo column = (TreeColumnInfo)table.getColumns().get(0);
        ColumnPixelDataInfo layoutData = (ColumnPixelDataInfo)layout.getLayoutData((ItemInfo)column);
        AbstractColumnLayoutTest.assertEquals((Object)150, (Object)layoutData.getPropertyByTitle("width").getValue());
        Property typeProperty = column.getPropertyByTitle("LayoutDataType");
        AbstractColumnLayoutTest.assertTrue((boolean)typeProperty.isModified());
        AbstractColumnLayoutTest.assertEquals((Object)"ColumnPixelData", (Object)typeProperty.getValue());
        Property layoutDataProperty = column.getPropertyByTitle("LayoutData");
        Property[] subProperties = AbstractColumnLayoutTest.getSubProperties(layoutDataProperty);
        AbstractColumnLayoutTest.assertNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "Constructor"));
        AbstractColumnLayoutTest.assertNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "Class"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "width"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "resizable"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "addTrim"));
        column = (TreeColumnInfo)table.getColumns().get(1);
        layoutData = (ColumnWeightDataInfo)layout.getLayoutData((ItemInfo)column);
        AbstractColumnLayoutTest.assertEquals((Object)1, (Object)layoutData.getPropertyByTitle("weight").getValue());
        AbstractColumnLayoutTest.assertEquals((Object)200, (Object)layoutData.getPropertyByTitle("minimumWidth").getValue());
        typeProperty = column.getPropertyByTitle("LayoutDataType");
        AbstractColumnLayoutTest.assertTrue((boolean)typeProperty.isModified());
        AbstractColumnLayoutTest.assertEquals((Object)"ColumnWeightData", (Object)typeProperty.getValue());
        layoutDataProperty = column.getPropertyByTitle("LayoutData");
        subProperties = AbstractColumnLayoutTest.getSubProperties(layoutDataProperty);
        AbstractColumnLayoutTest.assertNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "Constructor"));
        AbstractColumnLayoutTest.assertNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "Class"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "weight"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "minimumWidth"));
        AbstractColumnLayoutTest.assertNotNull((Object)AbstractColumnLayoutTest.getPropertyByTitle(subProperties, "resizable"));
    }

    @Test
    public void test_parse_TableColumnLayout_noTable() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "  }", "}");
        shell.refresh();
        AbstractColumnLayoutTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_parse_TableColumnLayout_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "  }", "}");
        shell.refresh();
        AbstractColumnLayoutTest.assertNoErrors((JavaInfo)shell);
        TableColumnLayoutInfo layout = (TableColumnLayoutInfo)shell.getLayout();
        ControlInfo newTable = BTestUtils.createControl("org.eclipse.swt.widgets.Table");
        SimpleContainer simpleContainer = (SimpleContainer)new SimpleContainerFactory((JavaInfo)layout, true).get().get(0);
        simpleContainer.command_CREATE((Object)newTable);
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    {", "      Table table = new Table(this, SWT.BORDER | SWT.FULL_SELECTION);", "      table.setHeaderVisible(true);", "      table.setLinesVisible(true);", "    }", "  }", "}");
    }

    @Test
    public void test_parse_TableColumnLayout_ADD() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TableColumnLayout());", "    }", "    {", "      Table table = new Table(this, SWT.BORDER | SWT.FULL_SELECTION);", "    }", "  }", "}");
        shell.refresh();
        AbstractColumnLayoutTest.assertNoErrors((JavaInfo)shell);
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        TableColumnLayoutInfo layout = (TableColumnLayoutInfo)composite.getLayout();
        ControlInfo table = (ControlInfo)shell.getChildrenControls().get(1);
        SimpleContainer simpleContainer = (SimpleContainer)new SimpleContainerFactory((JavaInfo)layout, true).get().get(0);
        simpleContainer.command_ADD((Object)table);
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TableColumnLayout());", "      {", "        Table table = new Table(composite, SWT.BORDER | SWT.FULL_SELECTION);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_parse_TreeColumnLayout_noTree() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TreeColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new TreeColumnLayout());", "  }", "}");
        shell.refresh();
        AbstractColumnLayoutTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_parse_TreeColumnLayout_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TreeColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new TreeColumnLayout());", "  }", "}");
        shell.refresh();
        AbstractColumnLayoutTest.assertNoErrors((JavaInfo)shell);
        TreeColumnLayoutInfo layout = (TreeColumnLayoutInfo)shell.getLayout();
        ControlInfo newTree = BTestUtils.createControl("org.eclipse.swt.widgets.Tree");
        SimpleContainer simpleContainer = (SimpleContainer)new SimpleContainerFactory((JavaInfo)layout, true).get().get(0);
        simpleContainer.command_CREATE((Object)newTree);
        this.assertEditor("import org.eclipse.jface.layout.TreeColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new TreeColumnLayout());", "    {", "      Tree tree = new Tree(this, SWT.BORDER);", "    }", "  }", "}");
    }

    @Test
    public void test_parse_TreeColumnLayout_ADD() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TreeColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TreeColumnLayout());", "    }", "    {", "      Tree tree = new Tree(this, SWT.BORDER);", "    }", "  }", "}");
        shell.refresh();
        AbstractColumnLayoutTest.assertNoErrors((JavaInfo)shell);
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        TreeColumnLayoutInfo layout = (TreeColumnLayoutInfo)composite.getLayout();
        ControlInfo tree = (ControlInfo)shell.getChildrenControls().get(1);
        SimpleContainer simpleContainer = (SimpleContainer)new SimpleContainerFactory((JavaInfo)layout, true).get().get(0);
        simpleContainer.command_ADD((Object)tree);
        this.assertEditor("import org.eclipse.jface.layout.TreeColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TreeColumnLayout());", "      {", "        Tree tree = new Tree(composite, SWT.BORDER);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_deleteComposite_whenDeleteTable() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    Composite composite = new Composite(this, SWT.NONE);", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    composite.setLayout(tableColumnLayout);", "    Table table = new Table(composite, SWT.NONE);", "  }", "}");
        shell.refresh();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        TableInfo table = (TableInfo)composite.getChildrenControls().get(0);
        table.delete();
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setWidth_PIXEL() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnPixelData(150));", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        column.getPropertyByTitle("width").setValue((Object)200);
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnPixelData(200));", "    }", "  }", "}");
    }

    @Test
    public void test_setWidth_WEIGHT() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnWeightData(1, 150));", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        column.getPropertyByTitle("width").setValue((Object)200);
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnWeightData(1, 200));", "    }", "  }", "}");
    }

    @Test
    public void test_setLayoutData_PIXEL() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnWeightData(1, 200));", "    }", "  }", "}");
        shell.refresh();
        TableColumnLayoutInfo layout = (TableColumnLayoutInfo)shell.getLayout();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        shell.startEdit();
        layout.setLayoutData((ItemInfo)column, "org.eclipse.jface.viewers.ColumnPixelData");
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnPixelData(150, true, true));", "    }", "  }", "}");
        AbstractColumnLayoutTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(tableColumnLayout)/ /new Table(this, SWT.NONE)/}", "  {new: org.eclipse.jface.layout.TableColumnLayout} {local-unique: tableColumnLayout} {/new TableColumnLayout()/ /setLayout(tableColumnLayout)/ /tableColumnLayout.setColumnData(column, new ColumnPixelData(150, true, true))/}", "  {new: org.eclipse.swt.widgets.Table} {local-unique: table} {/new Table(this, SWT.NONE)/ /new TableColumn(table, SWT.NONE)/}", "    {new: org.eclipse.swt.widgets.TableColumn} {local-unique: column} {/new TableColumn(table, SWT.NONE)/ /tableColumnLayout.setColumnData(column, new ColumnPixelData(150, true, true))/}", "      {new: org.eclipse.jface.viewers.ColumnPixelData} {empty} {/tableColumnLayout.setColumnData(column, new ColumnPixelData(150, true, true))/}");
    }

    @Test
    public void test_setLayoutData_WEIGHT() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnPixelData(100));", "    }", "  }", "}");
        shell.refresh();
        TableColumnLayoutInfo layout = (TableColumnLayoutInfo)shell.getLayout();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        shell.startEdit();
        layout.setLayoutData((ItemInfo)column, "org.eclipse.jface.viewers.ColumnWeightData");
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnWeightData(1, ColumnWeightData.MINIMUM_WIDTH, true));", "    }", "  }", "}");
        AbstractColumnLayoutTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(tableColumnLayout)/ /new Table(this, SWT.NONE)/}", "  {new: org.eclipse.jface.layout.TableColumnLayout} {local-unique: tableColumnLayout} {/new TableColumnLayout()/ /setLayout(tableColumnLayout)/ /tableColumnLayout.setColumnData(column, new ColumnWeightData(1, ColumnWeightData.MINIMUM_WIDTH, true))/}", "  {new: org.eclipse.swt.widgets.Table} {local-unique: table} {/new Table(this, SWT.NONE)/ /new TableColumn(table, SWT.NONE)/}", "    {new: org.eclipse.swt.widgets.TableColumn} {local-unique: column} {/new TableColumn(table, SWT.NONE)/ /tableColumnLayout.setColumnData(column, new ColumnWeightData(1, ColumnWeightData.MINIMUM_WIDTH, true))/}", "      {new: org.eclipse.jface.viewers.ColumnWeightData} {empty} {/tableColumnLayout.setColumnData(column, new ColumnWeightData(1, ColumnWeightData.MINIMUM_WIDTH, true))/}");
    }

    @Test
    public void test_LayoutDataType_Property_PIXEL() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnWeightData(1, 200));", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        Property typeProperty = column.getPropertyByTitle("LayoutDataType");
        typeProperty.setValue((Object)"ColumnPixelData");
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnPixelData(150, true, true));", "    }", "  }", "}");
    }

    @Test
    public void test_LayoutDataType_Property_WEIGHT() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnPixelData(100));", "    }", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        Property typeProperty = column.getPropertyByTitle("LayoutDataType");
        typeProperty.setValue((Object)"ColumnWeightData");
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn column = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(column, new ColumnWeightData(1, ColumnWeightData.MINIMUM_WIDTH, true));", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        TableInfo table = (TableInfo)shell.getChildrenControls().get(0);
        TableColumnInfo column = (TableColumnInfo)AbstractColumnLayoutTest.createJavaInfo("org.eclipse.swt.widgets.TableColumn");
        shell.startEdit();
        AbstractColumnLayoutTest.flowContainer_CREATE((JavaInfo)table, column, null);
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    TableColumnLayout tableColumnLayout = new TableColumnLayout();", "    setLayout(tableColumnLayout);", "    Table table = new Table(this, SWT.NONE);", "    {", "      TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "      tableColumnLayout.setColumnData(tableColumn, new ColumnPixelData(150, true, true));", "      tableColumn.setText('New Column');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_out() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite tableComposite = new Composite(this, SWT.NONE);", "      TableColumnLayout tableColumnLayout = new TableColumnLayout();", "      tableComposite.setLayout(tableColumnLayout);", "      Table table = new Table(tableComposite, SWT.NONE);", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumnLayout.setColumnData(tableColumn, new ColumnPixelData(150, true, true));", "      }", "    }", "    {", "      Table table_2 = new Table(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        CompositeInfo tableComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        TableInfo table = (TableInfo)tableComposite.getChildrenControls().get(0);
        TableInfo table_2 = (TableInfo)shell.getChildrenControls().get(1);
        TableColumnInfo column = (TableColumnInfo)table.getColumns().get(0);
        shell.startEdit();
        AbstractColumnLayoutTest.flowContainer_MOVE((JavaInfo)table_2, column, null);
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite tableComposite = new Composite(this, SWT.NONE);", "      TableColumnLayout tableColumnLayout = new TableColumnLayout();", "      tableComposite.setLayout(tableColumnLayout);", "      Table table = new Table(tableComposite, SWT.NONE);", "    }", "    {", "      Table table_2 = new Table(this, SWT.NONE);", "      {", "        TableColumn tableColumn = new TableColumn(table_2, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_in() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite tableComposite = new Composite(this, SWT.NONE);", "      TableColumnLayout tableColumnLayout = new TableColumnLayout();", "      tableComposite.setLayout(tableColumnLayout);", "      Table table = new Table(tableComposite, SWT.NONE);", "    }", "    {", "      Table table_2 = new Table(this, SWT.NONE);", "      {", "        TableColumn tableColumn = new TableColumn(table_2, SWT.NONE);", "        tableColumn.setWidth(99);", "      }", "    }", "  }", "}");
        shell.refresh();
        CompositeInfo tableComposite = (CompositeInfo)shell.getChildrenControls().get(0);
        TableInfo table = (TableInfo)tableComposite.getChildrenControls().get(0);
        TableInfo table_2 = (TableInfo)shell.getChildrenControls().get(1);
        TableColumnInfo column = (TableColumnInfo)table_2.getColumns().get(0);
        shell.startEdit();
        AbstractColumnLayoutTest.flowContainer_MOVE((JavaInfo)table, column, null);
        this.assertEditor("import org.eclipse.jface.layout.TableColumnLayout;", "public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite tableComposite = new Composite(this, SWT.NONE);", "      TableColumnLayout tableColumnLayout = new TableColumnLayout();", "      tableComposite.setLayout(tableColumnLayout);", "      Table table = new Table(tableComposite, SWT.NONE);", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumnLayout.setColumnData(tableColumn, new ColumnPixelData(99, true, true));", "      }", "    }", "    {", "      Table table_2 = new Table(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_palette_TableComposite() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        RcpToolkitDescription.INSTANCE.getPreferences().setValue("layout.inheritLayoutOfParent", true);
        TableCompositeEntryInfo entry = new TableCompositeEntryInfo();
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getIcon());
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getName());
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getDescription());
        AbstractColumnLayoutTest.assertTrue((boolean)entry.initialize(null, (JavaInfo)shell));
        CreationTool creationTool = (CreationTool)entry.createTool();
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        CompositeInfo newComposite = (CompositeInfo)creationFactory.getNewObject();
        fillLayout.command_CREATE((ControlInfo)newComposite, null);
        AbstractColumnLayoutTest.waitEventLoop(0);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TableColumnLayout());", "      {", "        Table table = new Table(composite, SWT.BORDER | SWT.FULL_SELECTION);", "        table.setHeaderVisible(true);", "        table.setLinesVisible(true);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_palette_TableViewerComposite() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        RcpToolkitDescription.INSTANCE.getPreferences().setValue("layout.inheritLayoutOfParent", true);
        TableViewerCompositeEntryInfo entry = new TableViewerCompositeEntryInfo();
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getIcon());
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getName());
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getDescription());
        AbstractColumnLayoutTest.assertTrue((boolean)entry.initialize(null, (JavaInfo)shell));
        CreationTool creationTool = (CreationTool)entry.createTool();
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        CompositeInfo newComposite = (CompositeInfo)creationFactory.getNewObject();
        fillLayout.command_CREATE((ControlInfo)newComposite, null);
        AbstractColumnLayoutTest.waitEventLoop(0);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TableColumnLayout());", "      {", "        TableViewer tableViewer = new TableViewer(composite, SWT.BORDER | SWT.FULL_SELECTION);", "        Table table = tableViewer.getTable();", "        table.setHeaderVisible(true);", "        table.setLinesVisible(true);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_palette_TreeComposite() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        RcpToolkitDescription.INSTANCE.getPreferences().setValue("layout.inheritLayoutOfParent", true);
        TreeCompositeEntryInfo entry = new TreeCompositeEntryInfo();
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getIcon());
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getName());
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getDescription());
        AbstractColumnLayoutTest.assertTrue((boolean)entry.initialize(null, (JavaInfo)shell));
        CreationTool creationTool = (CreationTool)entry.createTool();
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        CompositeInfo newComposite = (CompositeInfo)creationFactory.getNewObject();
        fillLayout.command_CREATE((ControlInfo)newComposite, null);
        AbstractColumnLayoutTest.waitEventLoop(0);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TreeColumnLayout());", "      {", "        Tree tree = new Tree(composite, SWT.BORDER);", "        tree.setHeaderVisible(true);", "        tree.setLinesVisible(true);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_palette_TreeViewerComposite() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        shell.refresh();
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        RcpToolkitDescription.INSTANCE.getPreferences().setValue("layout.inheritLayoutOfParent", true);
        TreeViewerCompositeEntryInfo entry = new TreeViewerCompositeEntryInfo();
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getIcon());
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getName());
        AbstractColumnLayoutTest.assertNotNull((Object)entry.getDescription());
        AbstractColumnLayoutTest.assertTrue((boolean)entry.initialize(null, (JavaInfo)shell));
        CreationTool creationTool = (CreationTool)entry.createTool();
        ICreationFactory creationFactory = creationTool.getFactory();
        creationFactory.activate();
        CompositeInfo newComposite = (CompositeInfo)creationFactory.getNewObject();
        fillLayout.command_CREATE((ControlInfo)newComposite, null);
        AbstractColumnLayoutTest.waitEventLoop(0);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new TreeColumnLayout());", "      {", "        TreeViewer treeViewer = new TreeViewer(composite, SWT.BORDER);", "        Tree tree = treeViewer.getTree();", "        tree.setHeaderVisible(true);", "        tree.setLinesVisible(true);", "      }", "    }", "  }", "}");
    }
}

