/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.gef.core.CancelOperationError;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Test;

public class ComponentsTreePageTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_ObjectEventListener_select_existingComponent() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.assertTreeSelectionModels(new Object[0]);
        this.assertSelectionModels(new Object[0]);
        panel.getBroadcastObject().select(List.of(button));
        this.assertTreeSelectionModels(button);
        this.assertSelectionModels(button);
        panel.getBroadcastObject().select(Collections.emptyList());
        this.assertTreeSelectionModels(new Object[0]);
        this.assertSelectionModels(new Object[0]);
    }

    @Test
    public void test_ObjectEventListener_select_newComponent() throws Exception {
        final ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "  }", "  // filler filler filler", "}");
        this.assertTreeSelectionModels(new Object[0]);
        this.assertSelectionModels(new Object[0]);
        final ComponentInfo newButton = ComponentsTreePageTest.createJButton();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
                panel.getBroadcastObject().select(List.of(newButton));
            }
        });
        this.assertTreeSelectionModels(newButton);
        this.assertSelectionModels(newButton);
        panel.getBroadcastObject().select(Collections.emptyList());
        this.assertTreeSelectionModels(new Object[0]);
        this.assertSelectionModels(new Object[0]);
    }

    @Test
    public void test_TreeDropListener_dragAfterException() throws Exception {
        ComponentInfo inner;
        ComponentInfo button2;
        block5: {
            this.removeExceptionsListener();
            this.openContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.NORTH);", "    }", "    {", "      JPanel inner = new JPanel();", "      add(inner, BorderLayout.CENTER);", "    }", "  }", "}");
            System.setProperty("wbp.EditDomain.simulateCommandException", "true");
            EnvironmentUtils.setTestingTime((boolean)false);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)false);
            try {
                try {
                    button2 = (ComponentInfo)ComponentsTreePageTest.getJavaInfoByName("button");
                    inner = (ComponentInfo)ComponentsTreePageTest.getJavaInfoByName("inner");
                    this.tree.startDrag(button2).dragOn(inner).endDrag();
                }
                catch (CancelOperationError button2) {
                    System.clearProperty("wbp.EditDomain.simulateCommandException");
                    EnvironmentUtils.setTestingTime((boolean)true);
                    DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                System.clearProperty("wbp.EditDomain.simulateCommandException");
                EnvironmentUtils.setTestingTime((boolean)true);
                DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
                throw throwable;
            }
            System.clearProperty("wbp.EditDomain.simulateCommandException");
            EnvironmentUtils.setTestingTime((boolean)true);
            DesignerPlugin.setDisplayExceptionOnConsole((boolean)true);
        }
        IAction refreshAction = this.m_designPageActions.getRefreshAction();
        refreshAction.run();
        this.fetchContentFields();
        button2 = (ComponentInfo)ComponentsTreePageTest.getJavaInfoByName("button");
        inner = (ComponentInfo)ComponentsTreePageTest.getJavaInfoByName("inner");
        this.tree.startDrag(button2).dragOn(inner).endDrag();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JPanel inner = new JPanel();", "      add(inner, BorderLayout.CENTER);", "      {", "        JButton button = new JButton();", "        inner.add(button);", "      }", "    }", "  }", "}");
    }

    private static ComponentInfo createJButton() throws Exception {
        return (ComponentInfo)ComponentsTreePageTest.createJavaInfo("javax.swing.JButton");
    }
}

