/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import java.util.Locale;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.core.controls.CTableCombo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.StringPropertyInfo;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.NlsDialog;
import org.eclipse.wb.internal.core.nls.ui.SourceComposite;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.tests.designer.core.nls.ui.AbstractDialogTest;
import org.eclipse.wb.tests.gef.EventSender;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class SourceCompositeTest
extends AbstractDialogTest {
    @Test
    public void test_ITableTooltipProvider() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                TabItem[] tabItems = SourceCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                Table table = SourceCompositeTest.getSourceTable(context, tabItems[0]);
                SourceComposite sourceComposite = SourceCompositeTest.getSourceComposite(context, tabItems[0]);
                UiUtils.ITableTooltipProvider provider = (UiUtils.ITableTooltipProvider)ReflectionUtils.invokeMethod((Object)sourceComposite, (String)"createTooltipProvider()", (Object[])new Object[0]);
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.name", "My name"}, {"frame.title", "My JFrame"}});
                Shell newShell = new Shell();
                try {
                    Control control = provider.createTooltipControl(table.getItem(1), (Composite)newShell, 1);
                    SourceCompositeTest.assertNull((Object)control);
                    control = provider.createTooltipControl(table.getItem(0), (Composite)newShell, 0);
                    SourceCompositeTest.assertNull((Object)control);
                    control = provider.createTooltipControl(table.getItem(1), (Composite)newShell, 0);
                    SourceCompositeTest.assertNotNull((Object)control);
                    SourceCompositeTest.assertTrue((newShell.getChildren().length > 0 ? 1 : 0) != 0);
                }
                finally {
                    newShell.dispose();
                }
            }
        });
    }

    @Test
    public void test_contextMenu_removeLocale() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceCompositeTest.setFileContentSrc("test/messages_it.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame IT", "frame.name=My name IT"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                TabItem[] tabItems = SourceCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                Table table = SourceCompositeTest.getSourceTable(context, tabItems[0]);
                Menu tableMenu = table.getMenu();
                EventSender eventSender = new EventSender((Control)table);
                eventSender.postMouseMove(SourceCompositeTest.getItemLocation(table, 2, 10));
                tableMenu.notifyListeners(22, null);
                final MenuItem removeLocaleItem = SourceCompositeTest.findMenuItem(tableMenu, "Remove locale...");
                SourceCompositeTest.assertNotNull((Object)removeLocaleItem);
                context.executeAndCheck(new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        removeLocaleItem.notifyListeners(13, null);
                    }
                }, new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        ctx.useShell("Confirm");
                        ctx.clickButton("Cancel");
                        ctx.popShell();
                    }
                });
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.name", "My name", "My name IT"}, {"frame.title", "My JFrame", "My JFrame IT"}});
                context.executeAndCheck(new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        removeLocaleItem.notifyListeners(13, null);
                    }
                }, new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        ctx.useShell("Confirm");
                        ctx.clickButton("OK");
                        ctx.popShell();
                    }
                });
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.name", "My name"}, {"frame.title", "My JFrame"}});
            }
        });
        SourceCompositeTest.assertFalse((boolean)SourceCompositeTest.getFileSrc("test/messages_it.properties").exists());
    }

    @Test
    public void test_contextMenu_internalizeKey() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                TabItem[] tabItems = SourceCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                Table table = SourceCompositeTest.getSourceTable(context, tabItems[0]);
                Menu tableMenu = table.getMenu();
                EventSender eventSender = new EventSender((Control)table);
                table.select(0);
                eventSender.postMouseMove(SourceCompositeTest.getItemLocation(table, 0, 0));
                tableMenu.notifyListeners(22, null);
                final MenuItem internalizeItem = SourceCompositeTest.findMenuItem(tableMenu, "Internalize key...");
                SourceCompositeTest.assertNotNull((Object)internalizeItem);
                context.executeAndCheck(new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        internalizeItem.notifyListeners(13, null);
                    }
                }, new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        ctx.useShell("Confirm");
                        ctx.clickButton("Cancel");
                        ctx.popShell();
                    }
                });
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}});
                context.executeAndCheck(new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        internalizeItem.notifyListeners(13, null);
                    }
                }, new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        ctx.useShell("Confirm");
                        ctx.clickButton("OK");
                        ctx.popShell();
                    }
                });
                SourceCompositeTest.assertItems(table, new String[0][]);
            }
        });
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle('My JFrame');", "  }", "}");
        SourceCompositeTest.assertFalse((boolean)SourceCompositeTest.getFileContentSrc("test/messages.properties").contains("frame.title"));
    }

    @Test
    public void test_contextMenu_addLocale() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                TabItem[] tabItems = SourceCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                Table table = SourceCompositeTest.getSourceTable(context, tabItems[0]);
                Menu tableMenu = table.getMenu();
                EventSender eventSender = new EventSender((Control)table);
                table.select(0);
                eventSender.postMouseMove(SourceCompositeTest.getItemLocation(table, 0, 10));
                tableMenu.notifyListeners(22, null);
                final MenuItem addLocaleItem = SourceCompositeTest.findMenuItem(tableMenu, "Add locale...");
                SourceCompositeTest.assertNotNull((Object)addLocaleItem);
                context.executeAndCheck(new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        addLocaleItem.notifyListeners(13, null);
                    }
                }, new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        ctx.useShell("Choose Locale");
                        CTableCombo languagesCombo = ctx.findFirstWidget(CTableCombo.class);
                        int i = 0;
                        while (i < languagesCombo.getItemCount()) {
                            String item = languagesCombo.getItem(i);
                            if (item.startsWith("it - ")) {
                                languagesCombo.select(i);
                                languagesCombo.notifyListeners(13, null);
                                break;
                            }
                            ++i;
                        }
                        ctx.clickButton("OK");
                        ctx.popShell();
                    }
                });
                SourceCompositeTest.assertColumns(table, new String[]{"Key", "(default)", "it"});
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame", "My JFrame"}});
            }
        });
        SourceCompositeTest.assertTrue((boolean)SourceCompositeTest.getFileSrc("test/messages_it.properties").exists());
    }

    @Test
    public void test_contextMenu_addLocaleWithButton() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                context.executeAndCheck(new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        ctx.clickButton("New locale...");
                    }
                }, new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        ctx.useShell("Choose Locale");
                        ctx.clickButton("Cancel");
                        ctx.popShell();
                    }
                });
            }
        });
    }

    private static MenuItem findMenuItem(Menu menu, String text) {
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (item.getText().equals(text)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    @Test
    public void test_SourceComposite_edit() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame"));
        SourceCompositeTest.setFileContentSrc("test/messages_it.properties", SourceCompositeTest.getSourceDQ(""));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                SourceCompositeTest.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
                TabItem[] tabItems = SourceCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                SourceComposite sourceComposite = SourceCompositeTest.getSourceComposite(context, tabItems[0]);
                IEditableSource editableSource = (IEditableSource)ReflectionUtils.getFieldObject((Object)sourceComposite, (String)"m_source");
                Table table = SourceCompositeTest.getSourceTable(context, tabItems[0]);
                SourceCompositeTest.assertColumns(table, new String[]{"Key", "(default)", "it"});
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame", ""}});
                SourceCompositeTest.clickItem(table, 1, 0, 1);
                UiContext.findFirstWidget((Widget)table, Text.class).setFocus();
                EventSender.sendText("New title");
                EventSender.sendKey(13);
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertTrue((boolean)editableSource.getKeys().contains("frame.title"));
                SourceCompositeTest.assertEquals((Object)"New title", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.title"));
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "New title", ""}});
                SourceCompositeTest.clickItem(table, 0, 0, 1);
                EventSender.sendText("frame.title2");
                EventSender.sendKey(13);
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertFalse((boolean)editableSource.getKeys().contains("frame.title"));
                SourceCompositeTest.assertTrue((boolean)editableSource.getKeys().contains("frame.title2"));
                SourceCompositeTest.assertEquals((Object)"New title", (Object)editableSource.getValue(LocaleInfo.DEFAULT, "frame.title2"));
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title2", "New title", ""}});
                LocaleInfo localeInfo = new LocaleInfo(Locale.ITALIAN);
                SourceCompositeTest.assertNull((Object)editableSource.getValue(localeInfo, "frame.title2"));
                SourceCompositeTest.clickItem(table, 2, 0, 1);
                EventSender.sendText("title IT");
                EventSender.sendKey(13);
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertEquals((Object)"title IT", (Object)editableSource.getValue(localeInfo, "frame.title2"));
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title2", "New title", "title IT"}});
            }
        });
    }

    @Test
    public void test_SourceComposite_update_externalize() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "    setName(\"My name\");", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                SourceCompositeTest.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
                TabItem[] tabItems = SourceCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                SourceComposite sourceComposite = SourceCompositeTest.getSourceComposite(context, tabItems[0]);
                IEditableSource editableSource = (IEditableSource)ReflectionUtils.getFieldObject((Object)sourceComposite, (String)"m_source");
                Table table = SourceCompositeTest.getSourceTable(context, tabItems[0]);
                SourceCompositeTest.assertColumns(table, new String[]{"Key", "(default)"});
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}});
                GenericProperty nameProperty = (GenericProperty)SourceCompositeTest.this.m_contentJavaInfo.getPropertyByTitle("name");
                editableSource.externalize(new StringPropertyInfo(nameProperty), true);
                SourceCompositeTest.assertColumns(table, new String[]{"Key", "(default)"});
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}, {"Test.this.name", "My name"}});
            }
        });
    }

    @Test
    public void test_SourceComposite_update_renameOver() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "    setName(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.name\")); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                SourceCompositeTest.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
                TabItem[] tabItems = SourceCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                SourceComposite sourceComposite = SourceCompositeTest.getSourceComposite(context, tabItems[0]);
                final IEditableSource editableSource = (IEditableSource)ReflectionUtils.getFieldObject((Object)sourceComposite, (String)"m_source");
                Table table = SourceCompositeTest.getSourceTable(context, tabItems[0]);
                SourceCompositeTest.assertColumns(table, new String[]{"Key", "(default)"});
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.name", "My name"}, {"frame.title", "My JFrame"}});
                context.executeAndCheck(new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        editableSource.renameKey("frame.name", "frame.title");
                    }
                }, new UIRunnable(){

                    @Override
                    public void run(UiContext ctx) throws Exception {
                        ctx.useShell("Confirm");
                        ctx.clickButton("Yes, keep existing value");
                        ctx.popShell();
                    }
                });
                SourceCompositeTest.assertColumns(table, new String[]{"Key", "(default)"});
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}});
            }
        });
    }

    @Test
    public void test_SourceComposite_onlyCurrentForm() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  public Test() {", "    setTitle(ResourceBundle.getBundle(\"test.messages\").getString(\"frame.title\")); //$NON-NLS-1$ //$NON-NLS-2$", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                SourceCompositeTest.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
                TabItem[] tabItems = SourceCompositeTest.assertItems(tabFolder, new String[]{"test.messages", "Properties"});
                SourceComposite sourceComposite = SourceCompositeTest.getSourceComposite(context, tabItems[0]);
                Table table = SourceCompositeTest.getSourceTable(context, tabItems[0]);
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.name", "My name"}, {"frame.title", "My JFrame"}});
                Button onlyFormButton = context.getButtonByText((Widget)sourceComposite, "Show strings only for current form");
                onlyFormButton.setSelection(true);
                context.click((Widget)onlyFormButton);
                SourceCompositeTest.assertItems(table, new String[][]{{"frame.title", "My JFrame"}});
            }
        });
    }

    @Test
    public void test_SourceComposite_navigation() throws Exception {
        SourceCompositeTest.setFileContentSrc("test/messages.properties", SourceCompositeTest.getSourceDQ("#Direct ResourceBundle", "key.1=1 1", "key.2=2 1"));
        SourceCompositeTest.setFileContentSrc("test/messages_it.properties", SourceCompositeTest.getSourceDQ("#Direct ResourceBundle", "key.1=1 2", "key.2=2 2"));
        SourceCompositeTest.waitForAutoBuild();
        String initialSource = this.getTestSource("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        this.openDialogNLS(initialSource, new AbstractDialogTest.NLSDialogRunnable(){

            @Override
            public void run(UiContext context, NlsDialog dialog, TabFolder tabFolder) throws Exception {
                tabFolder.setSelection(0);
                Table table = SourceCompositeTest.getSourceTable(context, tabFolder.getItems()[0]);
                SourceCompositeTest.assertItems(table, new String[][]{{"key.1", "1 1", "1 2"}, {"key.2", "2 1", "2 2"}});
                SourceCompositeTest.clickItem(table, 1, 0, 1);
                EventSender.sendKey(9);
                EventSender.sendText("a b");
                EventSender.sendKey(13);
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertItems(table, new String[][]{{"key.1", "1 1", "a b"}, {"key.2", "2 1", "2 2"}});
                SourceCompositeTest.clickItem(table, 2, 0, 1);
                EventSender.sendKey(0x1000002);
                EventSender.sendText("b b");
                EventSender.sendKey(13);
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertItems(table, new String[][]{{"key.1", "1 1", "a b"}, {"key.2", "2 1", "b b"}});
                SourceCompositeTest.clickItem(table, 2, 1, 1);
                EventSender.sendKey(131072, 9);
                EventSender.sendText("b a");
                EventSender.sendKey(0x1000001);
                EventSender.sendText("a a");
                EventSender.sendKey(13);
                SourceCompositeTest.waitEventLoop(10);
                SourceCompositeTest.assertItems(table, new String[][]{{"key.1", "a a", "a b"}, {"key.2", "b a", "b b"}});
            }
        });
    }
}

