/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import javax.swing.JButton;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.UnknownAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.MethodParameterCreationSupport;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.MethodParameterVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.Test;

public class MethodParameterTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_creationSupport() throws Exception {
        ContainerInfo panel = this.parsePanel("public class Test extends JPanel {", "  public Test() {", "  }", "  public void createPart(Container parent) {", "  }", "}");
        ContainerInfo parent = (ContainerInfo)panel.getChildrenComponents().get(0);
        MethodParameterCreationSupport creation = (MethodParameterCreationSupport)parent.getCreationSupport();
        MethodParameterTest.assertEquals((Object)"parameter", (Object)creation.toString());
        MethodParameterTest.assertFalse((boolean)creation.isJavaInfo(null));
        SingleVariableDeclaration declaration = (SingleVariableDeclaration)creation.getNode();
        MethodParameterTest.assertEquals((Object)"parent", (Object)declaration.getName().getIdentifier());
    }

    @Test
    public void test_variableSupport() throws Exception {
        ContainerInfo panel = this.parsePanel("public class Test extends JPanel {", "  public Test() {", "  }", "  public void createPart(Container parent) {", "  }", "}");
        ContainerInfo parent = (ContainerInfo)panel.getChildrenComponents().get(0);
        MethodParameterCreationSupport creation = (MethodParameterCreationSupport)parent.getCreationSupport();
        MethodParameterTest.assertFalse((boolean)creation.canReorder());
        MethodParameterTest.assertFalse((boolean)creation.canReparent());
        MethodParameterVariableSupport variable = (MethodParameterVariableSupport)parent.getVariableSupport();
        MethodParameterTest.assertEquals((Object)"parent", (Object)variable.toString());
        MethodParameterTest.assertEquals((Object)"parent in createPart(...)", (Object)variable.getTitle());
        MethodDeclaration methodDeclaration = AstNodeUtils.getEnclosingMethod((ASTNode)parent.getCreationSupport().getNode());
        MethodParameterTest.assertTarget(variable.getStatementTarget(), methodDeclaration.getBody(), null, true);
        MethodParameterTest.assertTrue((boolean)variable.hasName());
        MethodParameterTest.assertEquals((Object)"parent", (Object)variable.getName());
        Block targetBlock = MethodParameterTest.getTypeDeclaration((JavaInfo)panel).getMethods()[1].getBody();
        NodeTarget target22 = new NodeTarget(new StatementTarget(targetBlock, true));
        MethodParameterTest.assertTrue((boolean)variable.hasExpression(target22));
        MethodParameterTest.assertEquals((Object)"parent", (Object)variable.getReferenceExpression(target22));
        MethodParameterTest.assertEquals((Object)"parent.", (Object)variable.getAccessExpression(target22));
        NodeTarget target = MethodParameterTest.getNodeBlockTarget((JavaInfo)panel, true, new int[0]);
        MethodParameterTest.assertFalse((boolean)variable.hasExpression(target));
        try {
            variable.getReferenceExpression(target);
            MethodParameterTest.fail();
        }
        catch (IllegalArgumentException target22) {
            // empty catch block
        }
        TypeDeclaration targetType = MethodParameterTest.getTypeDeclaration((JavaInfo)panel);
        target22 = new NodeTarget(new BodyDeclarationTarget(targetType, true));
        MethodParameterTest.assertFalse((boolean)variable.hasExpression(target22));
        try {
            variable.getReferenceExpression(target22);
            MethodParameterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MethodParameterTest.assertFalse((boolean)variable.canConvertLocalToField());
        try {
            variable.convertLocalToField();
            MethodParameterTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        MethodParameterTest.assertFalse((boolean)variable.canConvertFieldToLocal());
        try {
            variable.convertFieldToLocal();
            MethodParameterTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Property variableProperty = parent.getPropertyByTitle("Variable");
        MethodParameterTest.assertEquals((Object)"parent", (Object)variableProperty.getValue());
        parent.getVariableSupport().setName("newName");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "  }", "  public void createPart(Container newName) {", "  }", "}");
        MethodParameterTest.assertEquals((Object)"newName", (Object)variableProperty.getValue());
    }

    @Test
    public void test_variableSupport_isJavaInfo() throws Exception {
        ContainerInfo panel = this.parsePanel("public class Test extends JPanel {", "  public Test() {", "  }", "  public void createPart(Container parent) {", "    parent.add(new JButton());", "  }", "}");
        ContainerInfo parent = (ContainerInfo)panel.getChildrenComponents().get(0);
        MethodParameterVariableSupport variable = (MethodParameterVariableSupport)parent.getVariableSupport();
        MethodDeclaration createPartMethod = AstNodeUtils.getEnclosingMethod((ASTNode)parent.getCreationSupport().getNode());
        ExpressionStatement statement = (ExpressionStatement)DomGenerics.statements((Block)createPartMethod.getBody()).get(0);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        Expression expectedParentNode = invocation.getExpression();
        MethodParameterTest.assertTrue((boolean)variable.isJavaInfo((ASTNode)expectedParentNode));
        MethodParameterTest.assertFalse((boolean)variable.isJavaInfo((ASTNode)this.m_lastEditor.getAstUnit()));
    }

    @Test
    public void test_variableSupport_getExpression_invokedMethod() throws Exception {
        ContainerInfo panel = this.parsePanel("public class Test extends JPanel {", "  public Test() {", "  }", "  public void createPart(Container parent) {", "    fillParent(parent);", "    noParent();", "  }", "  public void fillParent(Container otherParentName) {", "  }", "  public void noParent() {", "  }", "}");
        ContainerInfo parent = (ContainerInfo)panel.getChildrenComponents().get(0);
        VariableSupport variable = parent.getVariableSupport();
        NodeTarget target = MethodParameterTest.getNodeStatementTarget((JavaInfo)panel, "createPart(java.awt.Container)", false, new int[0]);
        MethodParameterTest.assertTrue((boolean)variable.hasExpression(target));
        MethodParameterTest.assertEquals((Object)"parent", (Object)variable.getReferenceExpression(target));
        target = MethodParameterTest.getNodeStatementTarget((JavaInfo)panel, "fillParent(java.awt.Container)", false, new int[0]);
        MethodParameterTest.assertTrue((boolean)variable.hasExpression(target));
        MethodParameterTest.assertEquals((Object)"otherParentName", (Object)variable.getReferenceExpression(target));
        target = MethodParameterTest.getNodeStatementTarget((JavaInfo)panel, "noParent()", false, new int[0]);
        MethodParameterTest.assertFalse((boolean)variable.hasExpression(target));
        try {
            variable.getReferenceExpression(target);
            MethodParameterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_variableSupport_isValidStatementForChild() throws Exception {
        ContainerInfo panel = this.parsePanel("public class Test extends JPanel {", "  public Test() {", "    int statementOutsiteOfMethod;", "  }", "  public void createPart(Container parent) {", "    int statementInMethod;", "  }", "}");
        ContainerInfo parent = (ContainerInfo)panel.getChildrenComponents().get(0);
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)panel);
        MethodParameterVariableSupport variable = (MethodParameterVariableSupport)parent.getVariableSupport();
        Statement statementOutsiteOfMethod = MethodParameterTest.getStatement(typeDeclaration.getMethods()[0].getBody(), 0);
        MethodParameterTest.assertFalse((boolean)variable.isValidStatementForChild(statementOutsiteOfMethod));
        Statement statementInMethod = MethodParameterTest.getStatement(typeDeclaration.getMethods()[1].getBody(), 0);
        MethodParameterTest.assertTrue((boolean)variable.isValidStatementForChild(statementInMethod));
    }

    @Test
    public void test_variableSupport_superConstructor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test(JButton button) {", "    super(null);", "  }", "}");
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)panel);
        MethodDeclaration constructor = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"<init>(javax.swing.JButton)");
        SingleVariableDeclaration parameter = (SingleVariableDeclaration)DomGenerics.parameters((MethodDeclaration)constructor).get(0);
        MethodParameterCreationSupport creationSupport = new MethodParameterCreationSupport(parameter);
        JavaInfo button = JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)creationSupport);
        MethodParameterVariableSupport variableSupport = new MethodParameterVariableSupport(button, parameter);
        Statement expectedStatement = (Statement)DomGenerics.statements((Block)constructor.getBody()).get(0);
        MethodParameterTest.assertTarget(variableSupport.getStatementTarget(), null, expectedStatement, false);
    }

    private ContainerInfo parsePanel(String ... lines) throws Exception {
        ContainerInfo panel = this.parseContainer(lines);
        panel.refresh();
        MethodDeclaration constructor = ((ThisCreationSupport)panel.getCreationSupport()).getConstructor();
        TypeDeclaration typeDeclaration = (TypeDeclaration)constructor.getParent();
        MethodDeclaration method_createPart = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"createPart(java.awt.Container)");
        SingleVariableDeclaration parentParameter = (SingleVariableDeclaration)method_createPart.parameters().get(0);
        MethodParameterCreationSupport creationSupport = new MethodParameterCreationSupport(parentParameter);
        ContainerInfo parent = (ContainerInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("java.awt.Container"), (CreationSupport)creationSupport);
        parent.bindToExpression((Expression)parentParameter.getName());
        parent.setVariableSupport((VariableSupport)new MethodParameterVariableSupport((JavaInfo)parent, parentParameter));
        panel.addChild((ObjectInfo)parent);
        parent.setAssociation((Association)new UnknownAssociation());
        JavaInfoUtils.getState((JavaInfo)panel).getFlowDescription().addStartMethod(method_createPart);
        return panel;
    }
}

