/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.util.Lists;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.tests.common.PropertyWithTitle;
import org.junit.Test;

public class PropertyUtilsTest
extends SwingModelTest {
    @Test
    public void test_getText() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton('my text'));", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("enabled");
        PropertyUtilsTest.assertNotNull((Object)property);
        PropertyUtilsTest.assertNull((Object)PropertyUtils.getText((Property)property));
        property = button.getPropertyByTitle("text");
        PropertyUtilsTest.assertNotNull((Object)property);
        PropertyUtilsTest.assertEquals((Object)"my text", (Object)PropertyUtils.getText((Property)property));
    }

    @Test
    public void test_getTitles_asArray() throws Exception {
        PropertyWithTitle property_1 = new PropertyWithTitle("a");
        PropertyWithTitle property_2 = new PropertyWithTitle("b");
        PropertyUtilsTest.assertArrayEquals((Object[])PropertyUtils.getTitles((Property[])new Property[]{property_1, property_2}), (Object[])new String[]{"a", "b"});
    }

    @Test
    public void test_getTitles_asList() throws Exception {
        PropertyWithTitle property_1 = new PropertyWithTitle("a");
        PropertyWithTitle property_2 = new PropertyWithTitle("b");
        List<PropertyWithTitle> properties = List.of(property_1, property_2);
        List<String> expectedTitles = List.of("a", "b");
        PropertyUtilsTest.assertEquals((Object)PropertyUtils.getTitles(properties), expectedTitles);
    }

    @Test
    public void test_getByTitle_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton myButton = new JButton('text');", "    add(myButton);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property[] properties = button.getProperties();
        PropertyUtilsTest.assertNotNull((Object)PropertyUtils.getByTitle((Property[])properties, (String)"enabled"));
        PropertyUtilsTest.assertNull((Object)PropertyUtils.getByTitle((Property[])properties, (String)"noSuchProperty"));
    }

    @Test
    public void test_getByTitle_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton myButton = new JButton('text');", "    add(myButton);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        List<Property> properties = List.of(button.getProperties());
        PropertyUtilsTest.assertNotNull((Object)PropertyUtils.getByTitle(properties, (String)"enabled"));
        PropertyUtilsTest.assertNull((Object)PropertyUtils.getByTitle(properties, (String)"noSuchProperty"));
    }

    @Test
    public void test_getByPath_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text');", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = PropertyUtils.getByPath((ObjectInfo)button, (String)"enabled");
        PropertyUtilsTest.assertNotNull((Object)property);
        PropertyUtilsTest.assertEquals((Object)"enabled", (Object)property.getTitle());
        property = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/text");
        PropertyUtilsTest.assertNotNull((Object)property);
        PropertyUtilsTest.assertEquals((Object)"text", (Object)property.getTitle());
        property = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/text/noChildren");
        PropertyUtilsTest.assertNull((Object)property);
        property = PropertyUtils.getByPath((ObjectInfo)button, (String)"noSuchProperty");
        PropertyUtilsTest.assertNull((Object)property);
        property = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor/noSuchProperty");
        PropertyUtilsTest.assertNull((Object)property);
    }

    @Test
    public void test_getByPath_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text');", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ArrayList properties = Lists.newArrayList((Object[])button.getProperties());
        Property property = PropertyUtils.getByPath((List)properties, (String)"enabled");
        PropertyUtilsTest.assertNotNull((Object)property);
        PropertyUtilsTest.assertEquals((Object)"enabled", (Object)property.getTitle());
        property = PropertyUtils.getByPath((List)properties, (String)"Constructor/text");
        PropertyUtilsTest.assertNotNull((Object)property);
        PropertyUtilsTest.assertEquals((Object)"text", (Object)property.getTitle());
        property = PropertyUtils.getByPath((List)properties, (String)"noSuchProperty");
        PropertyUtilsTest.assertNull((Object)property);
    }

    @Test
    public void test_getChildren() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text', null);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)PropertyUtilsTest.getJavaInfoByName("button");
        Property constructorProperty = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constructor");
        Object[] subProperties = PropertyUtils.getChildren((Property)constructorProperty);
        Assertions.assertThat((Object[])subProperties).hasSize(2);
        PropertyUtilsTest.assertEquals((Object)"text", (Object)subProperties[0].getTitle());
        PropertyUtilsTest.assertEquals((Object)"icon", (Object)subProperties[1].getTitle());
    }

    @Test
    public void test_getExcludeByTitlePredicate() throws Exception {
        Predicate predicate = PropertyUtils.getExcludeByTitlePredicate((String[])new String[]{"a", "c"});
        PropertyWithTitle property = new PropertyWithTitle("a");
        PropertyUtilsTest.assertFalse((boolean)predicate.test(property));
        property = new PropertyWithTitle("b");
        PropertyUtilsTest.assertTrue((boolean)predicate.test(property));
        property = new PropertyWithTitle("c");
        PropertyUtilsTest.assertFalse((boolean)predicate.test(property));
    }

    @Test
    public void test_getIncludeByTitlePredicate() throws Exception {
        Predicate predicate = PropertyUtils.getIncludeByTitlePredicate((String[])new String[]{"a", "c"});
        PropertyWithTitle property = new PropertyWithTitle("a");
        PropertyUtilsTest.assertTrue((boolean)predicate.test(property));
        property = new PropertyWithTitle("b");
        PropertyUtilsTest.assertFalse((boolean)predicate.test(property));
        property = new PropertyWithTitle("c");
        PropertyUtilsTest.assertTrue((boolean)predicate.test(property));
    }

    @Test
    public void test_getProperties_withPredicate() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Property[] properties = panel.getProperties();
        Object[] titles = PropertyUtils.getTitles((Property[])properties);
        Assertions.assertThat((Object[])titles).contains((Object[])new String[]{"enabled"});
        Predicate predicate = PropertyUtils.getExcludeByTitlePredicate((String[])new String[]{"enabled"});
        List properties2 = PropertyUtils.getProperties((ObjectInfo)panel, (Predicate)predicate);
        List titles2 = PropertyUtils.getTitles((List)properties2);
        ((ListAssert)Assertions.assertThat((List)titles2).doesNotContain((Object[])new String[]{"enabled"})).contains((Object[])new String[]{"background"});
    }

    @Test
    public void test_getExcludeByTitlePredicate_forParameter() throws Exception {
        PropertyUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        PropertyUtilsTest.setFileContentSrc("test/MyPanel.wbp-component.xml", PropertyUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='exclude-parameter'>a c</parameter>", "  </parameters>", "</component>"));
        PropertyUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Predicate predicate = PropertyUtils.getExcludeByTitlePredicate((ObjectInfo)panel, (String)"exclude-parameter");
        PropertyWithTitle property = new PropertyWithTitle("a");
        PropertyUtilsTest.assertFalse((boolean)predicate.test(property));
        property = new PropertyWithTitle("b");
        PropertyUtilsTest.assertTrue((boolean)predicate.test(property));
        property = new PropertyWithTitle("c");
        PropertyUtilsTest.assertFalse((boolean)predicate.test(property));
    }

    @Test
    public void test_getProperties_excludeByParameter() throws Exception {
        PropertyUtilsTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        PropertyUtilsTest.setFileContentSrc("test/MyPanel.wbp-component.xml", PropertyUtilsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='exclude-parameter'>enabled visible</parameter>", "  </parameters>", "</component>"));
        PropertyUtilsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Object properties = panel.getProperties();
        Object titles = PropertyUtils.getTitles((Property[])properties);
        Assertions.assertThat((Object[])titles).contains((Object[])new String[]{"enabled", "visible"});
        properties = PropertyUtils.getProperties_excludeByParameter((ObjectInfo)panel, (String)"exclude-parameter");
        titles = PropertyUtils.getTitles((List)properties);
        ((ListAssert)Assertions.assertThat((List)titles).doesNotContain((Object[])new String[]{"enabled", "visible"})).contains((Object[])new String[]{"background"});
    }

    @Test
    public void test_filterProperties() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        Object properties = panel.getProperties();
        Object titles = PropertyUtils.getTitles((Property[])properties);
        Assertions.assertThat((Object[])titles).contains((Object[])new String[]{"enabled"});
        properties = Lists.newArrayList((Object[])panel.getProperties());
        Assertions.assertThat((int)properties.size()).isGreaterThan(10);
        PropertyUtils.filterProperties((List)properties, (Predicate)PropertyUtils.getIncludeByTitlePredicate((String[])new String[]{"enabled"}));
        titles = PropertyUtils.getTitles((List)properties);
        ((ListAssert)Assertions.assertThat((List)titles).hasSize(1)).contains((Object[])new String[]{"enabled"});
    }
}

