/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.IPaletteSite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.editor.palette.PaletteManager;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.factory.FactoryAddCommand;
import org.eclipse.wb.internal.core.model.util.factory.FactoryCreateAction;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.After;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class FactoryCreateActionTest
extends SwingModelTest {
    private FactoryCreateAction action;

    @Override
    @After
    public void tearDown() throws Exception {
        this.action = null;
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    private ICompilationUnit findFactoryUnit(JavaInfo component) throws Exception {
        this.action = new FactoryCreateAction(component);
        return (ICompilationUnit)ReflectionUtils.invokeMethod((Object)this.action, (String)"findFactoryUnit()", (Object[])new Object[0]);
    }

    @Test
    public void test_findFactoryUnit_noUnits() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryCreateActionTest.assertNull((Object)this.findFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_findFactoryUnit_noTagOrDescription() throws Exception {
        FactoryCreateActionTest.setFileContentSrc("test/StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryCreateActionTest.assertNull((Object)this.findFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_findFactoryUnit_tag() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  /**", "  * @wbp.factory", "  */", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryCreateActionTest.assertEquals((Object)factoryUnit, (Object)this.findFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_findFactoryUnit_tagInComment() throws Exception {
        FactoryCreateActionTest.setFileContentSrc("test/StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  public static JButton createButton(String text) {", "    // @wbp.factory  -  here this tag means nothing", "    return new JButton(text);", "  }", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryCreateActionTest.assertNull((Object)this.findFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_findFactoryUnit_description() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryCreateActionTest.setFileContentSrc("test/StaticFactory_.wbp-factory.xml", FactoryCreateActionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <parameter type='java.lang.String'/>", "  </method>", "</factory>"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryCreateActionTest.assertEquals((Object)factoryUnit, (Object)this.findFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_findFactoryUnit_descriptionNoMethods() throws Exception {
        FactoryCreateActionTest.setFileContentSrc("test/StaticFactory_.java", this.getTestSource("public final class StaticFactory_ {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryCreateActionTest.setFileContentSrc("test/StaticFactory_.wbp-factory.xml", FactoryCreateActionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "</factory>"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryCreateActionTest.assertNull((Object)this.findFactoryUnit((JavaInfo)panel));
    }

    @Test
    public void test_validate() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IJavaProject javaProject = m_testProject.getJavaProject();
        IProject project = m_testProject.getProject();
        IPackageFragmentRoot validRoot = javaProject.getPackageFragmentRoot((IResource)project.getFolder("src"));
        IPackageFragment validPackage = validRoot.getPackageFragment("test");
        String validClass = "MyFactory";
        String validMethod = "createComponent";
        String message = this.callValidate((JavaInfo)button, null, null, validClass, validMethod);
        FactoryCreateActionTest.assertTrue((boolean)message.contains("source folder"));
        FactoryCreateActionTest.assertTrue((boolean)message.contains("invalid"));
        IPackageFragmentRoot invalidRoot = javaProject.getPackageFragmentRoot((IResource)project.getFolder("src2"));
        String message2 = this.callValidate((JavaInfo)button, invalidRoot, null, validClass, validMethod);
        FactoryCreateActionTest.assertTrue((boolean)message2.contains("source folder"));
        FactoryCreateActionTest.assertTrue((boolean)message2.contains("invalid"));
        message = this.callValidate((JavaInfo)button, validRoot, null, validClass, validMethod);
        FactoryCreateActionTest.assertTrue((boolean)message.contains("package"));
        FactoryCreateActionTest.assertTrue((boolean)message.contains("invalid"));
        IPackageFragment invalidPackage = validRoot.getPackageFragment("test2");
        message2 = this.callValidate((JavaInfo)button, validRoot, invalidPackage, validClass, validMethod);
        FactoryCreateActionTest.assertTrue((boolean)message2.contains("package"));
        FactoryCreateActionTest.assertTrue((boolean)message2.contains("invalid"));
        IPackageFragment defaultPackage = validRoot.getPackageFragment("");
        message2 = this.callValidate((JavaInfo)button, validRoot, defaultPackage, validClass, validMethod);
        FactoryCreateActionTest.assertTrue((boolean)message2.contains("package"));
        FactoryCreateActionTest.assertTrue((boolean)message2.contains("default"));
        message = this.callValidate((JavaInfo)button, validRoot, validPackage, "", validMethod);
        FactoryCreateActionTest.assertTrue((boolean)message.contains("class name"));
        FactoryCreateActionTest.assertTrue((boolean)message.contains("empty"));
        message = this.callValidate((JavaInfo)button, validRoot, validPackage, "bad.name", validMethod);
        FactoryCreateActionTest.assertTrue((boolean)message.contains("class name"));
        FactoryCreateActionTest.assertTrue((boolean)message.contains("dot"));
        message = this.callValidate((JavaInfo)button, validRoot, validPackage, "bad name", validMethod);
        FactoryCreateActionTest.assertTrue((boolean)message.contains("identifier"));
        message = this.callValidate((JavaInfo)button, validRoot, validPackage, validClass, "");
        FactoryCreateActionTest.assertTrue((boolean)message.contains("method name"));
        FactoryCreateActionTest.assertTrue((boolean)message.contains("empty"));
        message = this.callValidate((JavaInfo)button, validRoot, validPackage, validClass, "bad method name");
        FactoryCreateActionTest.assertTrue((boolean)message.contains("identifier"));
        message = this.callValidate((JavaInfo)button, validRoot, validPackage, validClass, validMethod);
        FactoryCreateActionTest.assertNull((Object)message);
    }

    @Test
    public void test_validate_existingMethod() throws Exception {
        FactoryCreateActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createComponent() {", "    return null;", "  }", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.action = new FactoryCreateAction((JavaInfo)button);
        this.generate_configureDefaultTarget();
        String message = this.generate_configureInvocations((JavaInfo)button, new int[0], new String[0], new int[0][]);
        FactoryCreateActionTest.assertNotNull((Object)message);
        FactoryCreateActionTest.assertTrue((boolean)message.contains("already exists"));
    }

    private String callValidate(JavaInfo component, IPackageFragmentRoot root, IPackageFragment pkg, String className, String methodName) throws Exception {
        this.action = new FactoryCreateAction(component);
        ReflectionUtils.setField((Object)this.action, (String)"m_sourceFolder", (Object)root);
        ReflectionUtils.setField((Object)this.action, (String)"m_package", (Object)pkg);
        ReflectionUtils.setField((Object)this.action, (String)"m_className", (Object)className);
        ReflectionUtils.setField((Object)this.action, (String)"m_methodName", (Object)methodName);
        return this.generate_configureInvocations(component, new int[0], new String[0], new int[0][]);
    }

    @Test
    public void test_preview() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text');", "    add(button);", "  }", "}");
        String unitSource = this.m_lastEditor.getSource();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.action = new FactoryCreateAction((JavaInfo)button);
        this.generate_configureDefaultTarget();
        this.generate_configureInvocations((JavaInfo)button, new int[0], new String[0], new int[0][]);
        m_getSource_ignoreSpacesCheck = true;
        String expectedSource = FactoryCreateActionTest.getSourceDQ("  /**", "   * @wbp.factory", "   */", "  public static JButton createComponent() {", "    JButton button = new JButton('text');", "    return button;", "  }");
        String previewSource = (String)ReflectionUtils.invokeMethod2((Object)this.action, (String)"getFactoryPreviewSource");
        FactoryCreateActionTest.assertEquals((Object)StringUtils.chomp((String)expectedSource), (Object)previewSource);
        FactoryCreateActionTest.assertEditor(unitSource, this.m_lastEditor);
    }

    @Test
    public void test_generate_sameFactoryClass() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text');", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.action = new FactoryCreateAction((JavaInfo)button);
        IJavaProject javaProject = m_testProject.getJavaProject();
        IProject project = m_testProject.getProject();
        IPackageFragmentRoot srcFolder = javaProject.getPackageFragmentRoot((IResource)project.getFolder("src"));
        IPackageFragment testPackage = srcFolder.getPackageFragment("test");
        ReflectionUtils.setField((Object)this.action, (String)"m_sourceFolder", (Object)srcFolder);
        ReflectionUtils.setField((Object)this.action, (String)"m_package", (Object)testPackage);
        ReflectionUtils.setField((Object)this.action, (String)"m_className", (Object)"Test");
        ReflectionUtils.setField((Object)this.action, (String)"m_methodName", (Object)"createButton");
        String errorMessage = this.generate_configureInvocations((JavaInfo)button, new int[0], new String[0], new int[0][]);
        FactoryCreateActionTest.assertNull((Object)errorMessage);
        ReflectionUtils.invokeMethod2((Object)this.action, (String)"generate", Boolean.TYPE, (Object)true);
        m_getSource_ignoreSpacesCheck = true;
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = createButton();", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "  /**", "   * @wbp.factory", "   */", "  public static JButton createButton() {", "    JButton button = new JButton('text');", "    return button;", "  }", "}");
    }

    @Test
    public void test_generate_newFactoryClass() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text');", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.callGenerate(button, new int[0], new String[0], new int[0][]);
        ICompilationUnit factoryUnit = m_testProject.getJavaProject().findType("test.StaticFactory").getCompilationUnit();
        FactoryCreateActionTest.assertNotNull((String)"New factory class test.StaticFactory should be created.", (Object)factoryUnit);
        try {
            m_getSource_ignoreSpacesCheck = true;
            FactoryCreateActionTest.assertEquals((Object)FactoryCreateActionTest.getSourceDQ("package test;", "import javax.swing.JButton;", "", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   */", "  public static JButton createComponent() {", "    JButton button = new JButton('text');", "    return button;", "  }", "}").trim(), (Object)factoryUnit.getSource());
            this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createComponent();", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
        }
        finally {
            factoryUnit.delete(true, null);
        }
    }

    @Test
    public void test_generate_addFactoryOnPalette() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        PaletteManager manager = new PaletteManager((JavaInfo)panel, panel.getDescription().getToolkit().getId());
        manager.reloadPalette();
        ArgumentCaptor factoryCommand = ArgumentCaptor.forClass(FactoryAddCommand.class);
        IPaletteSite paletteSite = (IPaletteSite)Mockito.mock(IPaletteSite.class);
        IPaletteSite.Helper.setSite((ObjectInfo)panel, (IPaletteSite)paletteSite);
        CategoryInfo categoryInfo = (CategoryInfo)manager.getPalette().getCategories().get(0);
        this.action = new FactoryCreateAction((JavaInfo)button);
        ReflectionUtils.setField((Object)this.action, (String)"m_paletteCategory", (Object)categoryInfo);
        this.callGenerate2(button, new int[0], new String[0], new int[0][]);
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   */", "  public static JButton createComponent() {", "    JButton button = new JButton();", "    return button;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createComponent();", "    add(button);", "  }", "}");
        ((IPaletteSite)Mockito.verify((Object)paletteSite)).addCommand((Command)factoryCommand.capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{paletteSite});
        FactoryCreateActionTest.assertNotNull((Object)factoryCommand.getValue());
        FactoryCreateActionTest.assertEquals((Object)"createComponent()", (Object)ReflectionUtils.getFieldObject((Object)factoryCommand.getValue(), (String)"m_methodSignature"));
        FactoryCreateActionTest.assertEquals((Object)categoryInfo.getId(), (Object)ReflectionUtils.getFieldObject((Object)factoryCommand.getValue(), (String)"m_categoryId"));
    }

    @Test
    public void test_generate_creationParameters_0() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text');", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.callGenerate(button, new int[0], new String[0], new int[0][]);
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   */", "  public static JButton createComponent() {", "    JButton button = new JButton('text');", "    return button;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createComponent();", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
    }

    @Test
    public void test_generate_creationParameters_1() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text', null);", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.callGenerate(button, new int[1], new String[0], new int[0][]);
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   * @wbp.factory.parameter.source text 'text'", "   */", "  public static JButton createComponent(String text) {", "    JButton button = new JButton(text, null);", "    return button;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createComponent('text');", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
    }

    @Test
    public void test_generate_creationParameters_2() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text', null);", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.callGenerate(button, nArray, new String[0], new int[0][]);
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   * @wbp.factory.parameter.source text 'text'", "   * @wbp.factory.parameter.source icon null", "   */", "  public static JButton createComponent(String text, Icon icon) {", "    JButton button = new JButton(text, icon);", "    return button;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createComponent('text', null);", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
    }

    @Test
    public void test_generate_uniqueParameterNames() throws Exception {
        FactoryCreateActionTest.setFileContentSrc("test/Text.java", this.getTestSource("public class Text extends JButton {", "  public Text(String text) {", "    setText(text);", "  }", "}"));
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    Text button = new Text('text');", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.callGenerate(button, new int[1], new String[0], new int[0][]);
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   * @wbp.factory.parameter.source text_1 'text'", "   */", "  public static Text createComponent(String text_1) {", "    Text text = new Text(text_1);", "    return text;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    Text button = StaticFactory.createComponent('text');", "    add(button);", "  }", "}");
    }

    @Test
    public void test_generate_invocationParameters_1() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text');", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.callGenerate(button, new int[0], new String[]{"setSelected(boolean)"}, new int[][]{new int[1]});
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   * @wbp.factory.parameter.source selected true", "   */", "  public static JButton createComponent(boolean selected) {", "    JButton button = new JButton('text');", "    button.setSelected(selected);", "    return button;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createComponent(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
    }

    @Test
    public void test_generate_invocationParameters_2() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text');", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.callGenerate(button, new int[0], new String[]{"setSelected(boolean)", "setAutoscrolls(boolean)"}, new int[][]{new int[1], new int[1]});
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   * @wbp.factory.parameter.source selected true", "   * @wbp.factory.parameter.source autoscrolls true", "   */", "  public static JButton createComponent(boolean selected, boolean autoscrolls) {", "    JButton button = new JButton('text');", "    button.setSelected(selected);", "    button.setAutoscrolls(autoscrolls);", "    return button;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createComponent(true, true);", "    add(button);", "  }", "}");
    }

    @Test
    public void test_generate_creation_invocation_parameters() throws Exception {
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton('text');", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.callGenerate(button, new int[1], new String[]{"setSelected(boolean)", "setAutoscrolls(boolean)"}, new int[][]{new int[1], new int[1]});
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   * @wbp.factory.parameter.source text 'text'", "   * @wbp.factory.parameter.source selected true", "   * @wbp.factory.parameter.source autoscrolls true", "   */", "  public static JButton createComponent(String text, boolean selected, boolean autoscrolls) {", "    JButton button = new JButton(text);", "    button.setSelected(selected);", "    button.setAutoscrolls(autoscrolls);", "    return button;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createComponent('text', true, true);", "    add(button);", "  }", "}");
    }

    @Test
    public void test_generate_invocations() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    boolean selected = true;", "    button.setSelected(selected);", "    button.setAutoscrolls(true);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.action = new FactoryCreateAction((JavaInfo)button);
        Object invocation = this.generate_findInvocation("setAutoscrolls(boolean)");
        FactoryCreateActionTest.assertTrue((boolean)((Boolean)ReflectionUtils.getFieldObject((Object)invocation, (String)"m_canExtract")));
        invocation = this.generate_findInvocation("setSelected(boolean)");
        FactoryCreateActionTest.assertFalse((boolean)((Boolean)ReflectionUtils.getFieldObject((Object)invocation, (String)"m_canExtract")));
    }

    @Test
    public void test_generate_getClass_parameter() throws Exception {
        FactoryCreateActionTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public void setClazz(Class clazz) {", "  }", "}"));
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.setClazz(getClass());", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.callGenerate(button, new int[0], new String[]{"setClazz(java.lang.Class)"}, new int[][]{new int[1]});
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   * @wbp.factory.parameter.source clazz {wbp_class}", "   */", "  public static MyButton createComponent(Class clazz) {", "    MyButton myButton = new MyButton();", "    myButton.setClazz(clazz);", "    return myButton;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = StaticFactory.createComponent(getClass());", "    add(button);", "  }", "}");
    }

    @Test
    public void test_generate_getClass_asValue() throws Exception {
        FactoryCreateActionTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public void setClazz(Class clazz) {", "  }", "}"));
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton();", "    button.setClazz(getClass());", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.callGenerate(button, new int[0], new String[]{"setClazz(java.lang.Class)"}, new int[][]{new int[0]});
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   */", "  public static MyButton createComponent() {", "    MyButton myButton = new MyButton();", "    myButton.setClazz(Test.class);", "    return myButton;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = StaticFactory.createComponent();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_generate_skipAnonymousCreations() throws Exception {
        FactoryCreateActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.addKeyListener(new KeyAdapter() {});", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.action = new FactoryCreateAction((JavaInfo)button);
        Object invocation = this.generate_findInvocation("addKeyListener(java.awt.event.KeyListener)");
        FactoryCreateActionTest.assertNull((Object)invocation);
    }

    @Test
    public void test_generate_dontExtractSetBounds() throws Exception {
        FactoryCreateActionTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setSelected(true);", "    button.setBounds(0, 0, 100, 100);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.action = new FactoryCreateAction((JavaInfo)button);
        Object invocation = this.generate_findInvocation("setBounds(int,int,int,int)");
        FactoryCreateActionTest.assertNull((Object)invocation);
        invocation = this.generate_findInvocation("setSelected(boolean)");
        FactoryCreateActionTest.assertTrue((boolean)((Boolean)ReflectionUtils.getFieldObject((Object)invocation, (String)"m_canExtract")));
        FactoryCreateActionTest.assertTrue((boolean)((Boolean)ReflectionUtils.getFieldObject((Object)invocation, (String)"m_extract")));
    }

    private void callGenerate(ComponentInfo component, int[] creationParameters, String[] invocationSignatures, int[][] invocationParameters) throws Exception {
        this.action = new FactoryCreateAction((JavaInfo)component);
        this.callGenerate2(component, creationParameters, invocationSignatures, invocationParameters);
    }

    private void callGenerate2(ComponentInfo component, int[] creationParameters, String[] invocationSignatures, int[][] invocationParameters) throws Exception {
        this.generate_configureDefaultTarget();
        String errorMessage = this.generate_configureInvocations((JavaInfo)component, creationParameters, invocationSignatures, invocationParameters);
        FactoryCreateActionTest.assertNull((Object)errorMessage);
        ReflectionUtils.invokeMethod2((Object)this.action, (String)"generate", Boolean.TYPE, (Object)true);
    }

    private void generate_configureDefaultTarget() throws Exception {
        IJavaProject javaProject = m_testProject.getJavaProject();
        IProject project = m_testProject.getProject();
        IPackageFragmentRoot srcFolder = javaProject.getPackageFragmentRoot((IResource)project.getFolder("src"));
        IPackageFragment testPackage = srcFolder.getPackageFragment("test");
        ReflectionUtils.setField((Object)this.action, (String)"m_sourceFolder", (Object)srcFolder);
        ReflectionUtils.setField((Object)this.action, (String)"m_package", (Object)testPackage);
        ReflectionUtils.setField((Object)this.action, (String)"m_className", (Object)"StaticFactory");
        ReflectionUtils.setField((Object)this.action, (String)"m_methodName", (Object)"createComponent");
    }

    private String generate_configureInvocations(JavaInfo component, int[] creationParameters, String[] invocationSignatures, int[][] invocationParameters) throws Exception {
        FactoryCreateActionTest.assertEquals((long)invocationSignatures.length, (long)invocationParameters.length);
        Object creationInfo = ReflectionUtils.getFieldObject((Object)this.action, (String)"m_creationInfo");
        this.generate_fillParameters(creationInfo, creationParameters);
        List invocations = (List)ReflectionUtils.getFieldObject((Object)this.action, (String)"m_invocations");
        for (Object invocation : invocations) {
            ReflectionUtils.setField(invocation, (String)"m_extract", (Object)Boolean.FALSE);
        }
        int i = 0;
        while (i < invocationSignatures.length) {
            String signature = invocationSignatures[i];
            Object invocation = this.generate_findInvocation(signature);
            FactoryCreateActionTest.assertNotNull((String)("Can not find invocation with signature: " + signature), (Object)invocation);
            ReflectionUtils.setField((Object)invocation, (String)"m_extract", (Object)Boolean.TRUE);
            this.generate_fillParameters(invocation, invocationParameters[i]);
            ++i;
        }
        return (String)ReflectionUtils.invokeMethod2((Object)this.action, (String)"validate");
    }

    private Object generate_findInvocation(String signature) throws Exception {
        List invocations = (List)ReflectionUtils.getFieldObject((Object)this.action, (String)"m_invocations");
        for (Object invocation : invocations) {
            if (!signature.equals(ReflectionUtils.getFieldObject(invocation, (String)"m_signature"))) continue;
            return invocation;
        }
        return null;
    }

    private void generate_fillParameters(Object invocation, int[] parameters) throws Exception {
        List arguments = (List)ReflectionUtils.getFieldObject((Object)invocation, (String)"m_arguments");
        int[] nArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            Object argument = arguments.get(index);
            ReflectionUtils.setField(argument, (String)"m_parameter", (Object)Boolean.TRUE);
            ++n2;
        }
    }

    @Test
    public void test_generate_creationParameters_parent() throws Exception {
        ICompilationUnit factoryUnit = this.prepare_generate_creationParameters_parent();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton(this, true);", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.callGenerate(button, nArray, new String[0], new int[0][]);
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   * @wbp.factory.parameter.source enabled true", "   */", "  public static MyButton createComponent(Container parent, boolean enabled) {", "    MyButton myButton = new MyButton(parent, enabled);", "    return myButton;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = StaticFactory.createComponent(this, true);", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "  }", "}");
    }

    @Test
    public void test_generate_creationParameters_parent_usingDialog() throws Exception {
        ICompilationUnit factoryUnit = this.prepare_generate_creationParameters_parent();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = new MyButton(this, true);", "    button.setSelected(true);", "    button.setAutoscrolls(true);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final IAction createAction = FactoryCreateActionTest.getCreateFactoryAction((JavaInfo)button);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                createAction.run();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Create factory");
                context.getTextByLabel("&Class:").setText("StaticFactory");
                TreeItem treeItem = context.getTreeItem("setSelected(boolean)");
                UiContext.setChecked(treeItem, false);
                context.clickButton("OK");
            }
        });
        m_getSource_ignoreSpacesCheck = true;
        FactoryCreateActionTest.assertEquals((Object)this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "  /**", "   * @wbp.factory", "   */", "  public static MyButton createMyButton(Container parent) {", "    MyButton myButton = new MyButton(parent, true);", "    myButton.setAutoscrolls(true);", "    return myButton;", "  }", "}"), (Object)factoryUnit.getSource());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    MyButton button = StaticFactory.createMyButton(this);", "    button.setSelected(true);", "  }", "}");
    }

    private static IAction getCreateFactoryAction(JavaInfo javaInfo) throws Exception {
        IMenuManager contextMenu = FactoryCreateActionTest.getContextMenu(new ObjectInfo[]{javaInfo});
        IMenuManager factoryMenu = FactoryCreateActionTest.findChildMenuManager((IContributionManager)contextMenu, "Factory");
        return FactoryCreateActionTest.findChildAction((IContributionManager)factoryMenu, "Create factory...");
    }

    private ICompilationUnit prepare_generate_creationParameters_parent() throws Exception {
        FactoryCreateActionTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container, boolean enabled) {", "    container.add(this);", "  }", "}"));
        FactoryCreateActionTest.setFileContentSrc("test/MyButton.wbp-component.xml", FactoryCreateActionTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "      <parameter type='boolean'/>", "    </constructor>", "  </constructors>", "</component>"));
        ICompilationUnit factoryUnit = this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public final class StaticFactory {", "}"));
        FactoryCreateActionTest.waitForAutoBuild();
        return factoryUnit;
    }
}

