/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.util.ExposeComponentSupport;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class ExposeComponentSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_1_unsupportedVariable() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        IAction exposeAction = ExposeComponentSupportTest.getExposeAction((ComponentInfo)panel);
        ExposeComponentSupportTest.assertNull((Object)exposeAction);
    }

    @Test
    public void test_2_alreadyExposed() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button = new JButton();", "  public Test() {", "    add(button);", "  }", "  public JButton getButton() {", "    return button;", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IAction exposeAction = ExposeComponentSupportTest.getExposeAction(button);
        ExposeComponentSupportTest.assertNull((Object)exposeAction);
    }

    @Test
    public void test_returnWithoutExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button = new JButton();", "  public Test() {", "    add(button);", "  }", "  public void foo() {", "    return;", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IAction exposeAction = ExposeComponentSupportTest.getExposeAction(button);
        ExposeComponentSupportTest.assertNotNull((Object)exposeAction);
    }

    @Test
    public void test_abstractMethod() throws Exception {
        ContainerInfo panel = this.parseContainer("public abstract class Test extends JPanel {", "  private final JButton button = new JButton();", "  public Test() {", "    add(button);", "  }", "  public abstract void foo();", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IAction exposeAction = ExposeComponentSupportTest.getExposeAction(button);
        ExposeComponentSupportTest.assertNotNull((Object)exposeAction);
    }

    @Test
    public void test_3_hasAction() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IAction exposeAction = ExposeComponentSupportTest.getExposeAction(button);
        ExposeComponentSupportTest.assertNotNull((Object)exposeAction);
    }

    @Test
    public void test_expose() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ReflectionUtils.invokeMethod(ExposeComponentSupport.class, (String)"expose(org.eclipse.wb.core.model.JavaInfo,java.lang.String,java.lang.String)", (Object[])new Object[]{button, "getButton", "public"});
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "  public JButton getButton() {", "    return button;", "  }", "}");
    }

    private static IAction getExposeAction(ComponentInfo button) {
        MenuManager menuManager = ExposeComponentSupportTest.getDesignerMenuManager();
        String text = "Expose component...";
        ExposeComponentSupport.contribute((JavaInfo)button, (IContributionManager)menuManager, (String)text);
        return ExposeComponentSupportTest.findChildAction((IContributionManager)menuManager, text);
    }
}

