/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.table;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.IPropertyTooltipSite;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.eclipse.wb.tests.designer.core.model.property.table.AbstractPropertyTableTest;
import org.eclipse.wb.tests.gef.EventSender;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class PropertyTableTooltipTest
extends AbstractPropertyTableTest {
    private static final PropertyEditor stringEditor = StringPropertyEditor.INSTANCE;

    @Test
    public void test_1_noProperty() throws Exception {
        AbstractPropertyTableTest.TestProperty property = new AbstractPropertyTableTest.TestProperty("text", true, "New button", stringEditor);
        this.m_propertyTable.setInput(new Property[]{property});
        PropertyTableTooltipTest.waitEventLoop(10);
        PropertyTableTooltipTest.assertShellCount(2);
        this.doHoverTooltip(50, 100);
        PropertyTableTooltipTest.assertShellCount(2);
    }

    @Test
    public void test_2_shortPropertyTitle() throws Exception {
        AbstractPropertyTableTest.TestProperty property = new AbstractPropertyTableTest.TestProperty("text", true, "New button", stringEditor);
        this.m_propertyTable.setInput(new Property[]{property});
        PropertyTableTooltipTest.waitEventLoop(10);
        PropertyTableTooltipTest.assertShellCount(2);
        this.doHoverTitleTooltip();
        PropertyTableTooltipTest.assertShellCount(2);
    }

    @Test
    public void test_3_longPropertyTitle_hideExit() throws Exception {
        this.prepare_test_3_showTooltip();
        this.m_sender.postMouseMove(100, 15);
        PropertyTableTooltipTest.waitEventLoop(10);
        this.m_sender.postMouseMove(50, 100);
        PropertyTableTooltipTest.waitEventLoop(10);
        PropertyTableTooltipTest.assertShellCount(2);
    }

    @Test
    public void test_3_longPropertyTitle_hideClick() throws Exception {
        this.prepare_test_3_showTooltip();
        this.m_sender.postMouseMove(55, 10);
        EventSender.postMouseDown(1);
        EventSender.postMouseUp(1);
        PropertyTableTooltipTest.waitEventLoop(10);
        PropertyTableTooltipTest.assertShellCount(2);
    }

    private void prepare_test_3_showTooltip() throws Exception {
        AbstractPropertyTableTest.TestProperty property = new AbstractPropertyTableTest.TestProperty("textTextText0123456789", true, "New button", stringEditor);
        this.m_propertyTable.setInput(new Property[]{property});
        PropertyTableTooltipTest.waitEventLoop(10);
        PropertyTableTooltipTest.assertShellCount(2);
        this.doHoverTitleTooltip();
        PropertyTableTooltipTest.assertShellCount(3);
    }

    @Test
    public void test_4_textProvider() throws Exception {
        AbstractPropertyTableTest.TestProperty property = new AbstractPropertyTableTest.TestProperty("text", true, "New button", stringEditor){

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == PropertyTooltipProvider.class) {
                    return adapter.cast(new PropertyTooltipTextProvider(){

                        protected String getText(Property _property) {
                            return "aaaaaa bbbbb ccccccc dddddddd eeeeeee fffffffff ggggggggg hhhhhh iiiii jjjjj.";
                        }
                    });
                }
                return (T)super.getAdapter(adapter);
            }
        };
        this.m_propertyTable.setInput(new Property[]{property});
        this.doHoverTitleTooltip();
        PropertyTableTooltipTest.assertShellCount(3);
        PropertyTableTooltipTest.assertTrue((Display.getCurrent().getShells()[2].getSize().y > 30 ? 1 : 0) != 0);
    }

    @Test
    public void test_5_emptyProvider() throws Exception {
        AbstractPropertyTableTest.TestProperty property = new AbstractPropertyTableTest.TestProperty("text", true, "New button", stringEditor){

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == PropertyTooltipProvider.class) {
                    return adapter.cast(new PropertyTooltipProvider(){

                        public Control createTooltipControl(Property _property, Composite parent, int availableWidth, IPropertyTooltipSite site) {
                            return null;
                        }
                    });
                }
                return (T)super.getAdapter(adapter);
            }
        };
        this.m_propertyTable.setInput(new Property[]{property});
        this.doHoverTitleTooltip();
        PropertyTableTooltipTest.assertShellCount(2);
    }

    @Test
    public void test_6_textProviderBelow() throws Exception {
        AbstractPropertyTableTest.TestProperty property = new AbstractPropertyTableTest.TestProperty("text", true, "New button", stringEditor){

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == PropertyTooltipProvider.class) {
                    return adapter.cast(new PropertyTooltipTextProvider(){

                        public int getTooltipPosition() {
                            return 1;
                        }

                        protected String getText(Property _property) {
                            return "My tooltip below.";
                        }
                    });
                }
                return (T)super.getAdapter(adapter);
            }
        };
        this.m_propertyTable.setInput(new Property[]{property});
        this.doHoverTitleTooltip();
        PropertyTableTooltipTest.assertShellCount(3);
        PropertyTableTooltipTest.assertTrue((Display.getCurrent().getShells()[2].getLocation().y > this.m_shell.getLocation().y + 27 + 10 ? 1 : 0) != 0);
        this.m_sender.postMouseMove(55, 12);
        PropertyTableTooltipTest.waitEventLoop(10);
        EventSender.postMouseMoveAbs(this.m_shell.getLocation());
        PropertyTableTooltipTest.waitEventLoop(10);
        PropertyTableTooltipTest.assertShellCount(2);
    }

    @Test
    public void test_7_value_noTooltip() throws Exception {
        AbstractPropertyTableTest.TestProperty property = new AbstractPropertyTableTest.TestProperty("text", true, "New button", stringEditor);
        this.m_propertyTable.setInput(new Property[]{property});
        PropertyTableTooltipTest.waitEventLoop(10);
        PropertyTableTooltipTest.assertShellCount(2);
        this.doHoverValueTooltip();
        PropertyTableTooltipTest.waitEventLoop(10);
        PropertyTableTooltipTest.assertShellCount(2);
    }

    @Test
    public void test_8_value_textTooltip() throws Exception {
        AbstractPropertyTableTest.TestProperty property = new AbstractPropertyTableTest.TestProperty("text", true, "New button 01234567890123456789", stringEditor);
        this.m_propertyTable.setInput(new Property[]{property});
        PropertyTableTooltipTest.waitEventLoop(10);
        PropertyTableTooltipTest.assertShellCount(2);
        this.doHoverValueTooltip();
        PropertyTableTooltipTest.waitEventLoop(10);
        PropertyTableTooltipTest.assertShellCount(3);
    }

    private static void assertShellCount(int count) {
        PropertyTableTooltipTest.assertEquals((long)count, (long)Display.getCurrent().getShells().length);
    }

    private void doHoverTitleTooltip() throws InterruptedException {
        this.doHoverTooltip(this.m_propertyTable.forTests_getSplitter() - 10, 10);
    }

    private void doHoverValueTooltip() throws InterruptedException {
        this.doHoverTooltip(this.m_propertyTable.forTests_getSplitter() + 10, 10);
    }

    private void doHoverTooltip(int x, int y) throws InterruptedException {
        this.m_sender.moveTo(x, y);
        PropertyTableTooltipTest.waitEventLoop(10);
        this.m_sender.mouseHover(x, y);
        PropertyTableTooltipTest.waitEventLoop(10);
    }
}

