/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import java.util.List;
import java.util.Map;
import javax.swing.SwingConstants;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.StaticFieldPropertyEditor;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;
import org.mockito.Mockito;

public class StaticFieldPropertyEditorTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_configure_1() throws Exception {
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(SwingConstants.class, new String[]{"LEFT", "RIGHT"});
        Class<SwingConstants> e_class = SwingConstants.class;
        String m_classSourceName = "javax.swing.SwingConstants";
        Object[] e_names = new String[]{"LEFT", "RIGHT"};
        Object[] e_titles = new String[]{"LEFT", "RIGHT"};
        Object[] e_values = new Object[]{2, 4};
        this.assertConfiguration(editor, e_class, m_classSourceName, e_names, e_titles, e_values);
    }

    @Test
    public void test_configure_2() throws Exception {
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(SwingConstants.class, new String[]{"LEFT", "noSuchField", "RIGHT"});
        Class<SwingConstants> e_class = SwingConstants.class;
        String m_classSourceName = "javax.swing.SwingConstants";
        Object[] e_names = new String[]{"LEFT", "RIGHT"};
        Object[] e_titles = new String[]{"LEFT", "RIGHT"};
        Object[] e_values = new Object[]{2, 4};
        this.assertConfiguration(editor, e_class, m_classSourceName, e_names, e_titles, e_values);
    }

    @Test
    public void test_configure_3() throws Exception {
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(SwingConstants.class, new String[]{"LEFT:asLeft", "RIGHT:asRight"});
        Class<SwingConstants> e_class = SwingConstants.class;
        String m_classSourceName = "javax.swing.SwingConstants";
        Object[] e_names = new String[]{"LEFT", "RIGHT"};
        Object[] e_titles = new String[]{"asLeft", "asRight"};
        Object[] e_values = new Object[]{2, 4};
        this.assertConfiguration(editor, e_class, m_classSourceName, e_names, e_titles, e_values);
    }

    @Test
    public void test_configure_4() throws Exception {
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(SwingConstants.class, new String[]{"LEFT", "*remove", "RIGHT"});
        Class<SwingConstants> e_class = SwingConstants.class;
        String m_classSourceName = "javax.swing.SwingConstants";
        Object[] objectArray = new String[3];
        objectArray[0] = "LEFT";
        objectArray[2] = "RIGHT";
        Object[] e_names = objectArray;
        Object[] e_titles = new String[]{"LEFT", "", "RIGHT"};
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = 2;
        objectArray2[2] = 4;
        Object[] e_values = objectArray2;
        this.assertConfiguration(editor, e_class, m_classSourceName, e_names, e_titles, e_values);
    }

    @Test
    public void test_configure_5() throws Exception {
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(Foo.class, new String[]{"A", "B"});
        Class<Foo> e_class = Foo.class;
        String m_classSourceName = StaticFieldPropertyEditorTest.class.getName() + ".Foo";
        Object[] e_names = new String[]{"A", "B"};
        Object[] e_titles = new String[]{"A", "B"};
        Object[] e_values = new Object[]{1, 2};
        this.assertConfiguration(editor, e_class, m_classSourceName, e_names, e_titles, e_values);
    }

    @Test
    public void test_configure_6() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(this.m_lastState, Map.of("class", "javax.swing.SwingConstants", "fields", "LEFT RIGHT"));
        Class<SwingConstants> e_class = SwingConstants.class;
        String m_classSourceName = "javax.swing.SwingConstants";
        Object[] e_names = new String[]{"LEFT", "RIGHT"};
        Object[] e_titles = new String[]{"LEFT", "RIGHT"};
        Object[] e_values = new Object[]{2, 4};
        this.assertConfiguration(editor, e_class, m_classSourceName, e_names, e_titles, e_values);
    }

    @Test
    public void test_configure_7() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(this.m_lastState, Map.of("class", "javax.swing.SwingConstants", "field", List.of("LEFT", "RIGHT")));
        Class<SwingConstants> e_class = SwingConstants.class;
        String m_classSourceName = "javax.swing.SwingConstants";
        Object[] e_names = new String[]{"LEFT", "RIGHT"};
        Object[] e_titles = new String[]{"LEFT", "RIGHT"};
        Object[] e_values = new Object[]{2, 4};
        this.assertConfiguration(editor, e_class, m_classSourceName, e_names, e_titles, e_values);
    }

    @Test
    public void test_configure_8() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        try {
            StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
            editor.configure(this.m_lastState, Map.of("class", "javax.swing.SwingConstants"));
            StaticFieldPropertyEditorTest.fail();
        }
        catch (DesignerException designerException) {
            // empty catch block
        }
    }

    private void assertConfiguration(StaticFieldPropertyEditor editor, Class<?> e_class, String e_classSourceName, Object[] e_names, Object[] e_titles, Object[] e_values) throws Exception {
        StaticFieldPropertyEditorTest.assertSame(e_class, (Object)StaticFieldPropertyEditorTest.getFieldValue(editor, "m_class"));
        StaticFieldPropertyEditorTest.assertEquals((Object)e_classSourceName, (Object)StaticFieldPropertyEditorTest.getFieldValue(editor, "m_classSourceName"));
        Assertions.assertThat((Object[])((String[])StaticFieldPropertyEditorTest.getFieldValue(editor, "m_names"))).containsOnly(e_names);
        Assertions.assertThat((Object[])((String[])StaticFieldPropertyEditorTest.getFieldValue(editor, "m_titles"))).containsOnly(e_titles);
        StaticFieldPropertyEditorTest.assertTrue((boolean)ArrayUtils.isEquals((Object)e_values, (Object)StaticFieldPropertyEditorTest.getFieldValue(editor, "m_values")));
    }

    @Test
    public void test_getValueSource() throws Exception {
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(SwingConstants.class, new String[]{"LEFT", "*remove", "RIGHT"});
        StaticFieldPropertyEditorTest.assertEquals((Object)"javax.swing.SwingConstants.LEFT", (Object)editor.getValueSource((Object)2));
        StaticFieldPropertyEditorTest.assertNull((Object)editor.getValueSource(null));
        StaticFieldPropertyEditorTest.assertEquals((Object)"javax.swing.SwingConstants.RIGHT", (Object)editor.getValueSource((Object)4));
        StaticFieldPropertyEditorTest.assertNull((Object)editor.getValueSource((Object)1));
    }

    @Test
    public void test_getText() throws Exception {
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(SwingConstants.class, new String[]{"LEFT:asLeft", "*remove", "RIGHT"});
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getValue()).thenReturn((Object)2);
        StaticFieldPropertyEditorTest.assertEquals((Object)"asLeft", (Object)editor.getText(property));
        ((Property)Mockito.verify((Object)property)).getValue();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{property});
        Mockito.clearInvocations((Object[])new Property[]{property});
        Mockito.when((Object)property.getValue()).thenReturn((Object)4);
        StaticFieldPropertyEditorTest.assertEquals((Object)"RIGHT", (Object)editor.getText(property));
        ((Property)Mockito.verify((Object)property)).getValue();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{property});
        Mockito.clearInvocations((Object[])new Property[]{property});
        Mockito.when((Object)property.getValue()).thenReturn(Property.UNKNOWN_VALUE);
        StaticFieldPropertyEditorTest.assertEquals(null, (Object)editor.getText(property));
        ((Property)Mockito.verify((Object)property)).getValue();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{property});
    }

    @Test
    public void test_getClipboardSource() throws Exception {
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(SwingConstants.class, new String[]{"LEFT", "RIGHT"});
        GenericProperty property = (GenericProperty)Mockito.mock(GenericProperty.class);
        Mockito.when((Object)property.getValue()).thenReturn((Object)2);
        StaticFieldPropertyEditorTest.assertEquals((Object)"javax.swing.SwingConstants.LEFT", (Object)editor.getClipboardSource(property));
        ((GenericProperty)Mockito.verify((Object)property)).getValue();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{property});
    }

    @Test
    public void test_setValue_1() throws Exception {
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(SwingConstants.class, new String[]{"LEFT", "RIGHT"});
        GenericProperty property = (GenericProperty)Mockito.mock(GenericProperty.class);
        editor.setValue((Property)property, (Object)2);
        ((GenericProperty)Mockito.verify((Object)property)).setExpression("javax.swing.SwingConstants.LEFT", (Object)2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{property});
    }

    @Test
    public void test_setValue_2() throws Exception {
        StaticFieldPropertyEditor editor = new StaticFieldPropertyEditor();
        editor.configure(SwingConstants.class, new String[]{"LEFT", "RIGHT"});
        Property property = (Property)Mockito.mock(Property.class);
        editor.setValue(property, (Object)2);
        ((Property)Mockito.verify((Object)property)).setValue((Object)2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{property});
    }

    public static class Foo {
        public static final int A = 1;
        public static final int B = 2;
    }
}

