/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.DoubleObjectPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class DoubleObjectPropertyEditorTest
extends AbstractTextPropertyEditorTest {
    private static final DoubleObjectPropertyEditor EDITOR = DoubleObjectPropertyEditor.INSTANCE;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getText() throws Exception {
        DoubleObjectPropertyEditorTest.assert_getText(null, (TextDisplayPropertyEditor)EDITOR, Property.UNKNOWN_VALUE);
        DoubleObjectPropertyEditorTest.assert_getText("null", (TextDisplayPropertyEditor)EDITOR, null);
        DoubleObjectPropertyEditorTest.assert_getText("12.3", (TextDisplayPropertyEditor)EDITOR, 12.3);
    }

    @Test
    public void test_getEditorText() throws Exception {
        DoubleObjectPropertyEditorTest.assert_getEditorText(null, (TextDisplayPropertyEditor)EDITOR, Property.UNKNOWN_VALUE);
        DoubleObjectPropertyEditorTest.assert_getEditorText("null", (TextDisplayPropertyEditor)EDITOR, null);
        DoubleObjectPropertyEditorTest.assert_getEditorText("12.3", (TextDisplayPropertyEditor)EDITOR, 12.3);
    }

    @Test
    public void test_setEditorText_value() throws Exception {
        this.prepareDoublePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        DoubleObjectPropertyEditorTest.setTextEditorText(property, "12.3");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(12.3);", "  }", "}");
    }

    @Test
    public void test_setEditorText_null() throws Exception {
        this.prepareDoublePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        DoubleObjectPropertyEditorTest.setTextEditorText(property, "null");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo((Double) null);", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_emptyString() throws Exception {
        this.prepareDoublePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(12.3);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        DoubleObjectPropertyEditorTest.setTextEditorText(property, "");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_whitespaceString() throws Exception {
        this.prepareDoublePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(12.3);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        DoubleObjectPropertyEditorTest.setTextEditorText(property, " ");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_invalidValue() throws Exception {
        this.prepareDoublePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        final Property property = panel.getPropertyByTitle("foo");
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                DoubleObjectPropertyEditorTest.setTextEditorText(property, "notDouble");
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("foo");
                context.clickButton("OK");
            }
        });
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    private void prepareDoublePanel() throws Exception {
        DoubleObjectPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(Double foo) {", "  }", "}"));
        DoubleObjectPropertyEditorTest.waitForAutoBuild();
    }
}

