/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.DatePropertyEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.junit.Test;

public class DatePropertyEditorTest
extends AbstractTextPropertyEditorTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_configure_default() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.createEditor(DatePropertyEditor.class, parameters);
    }

    @Test
    public void test_configure() throws Exception {
        this.createEditor(DatePropertyEditor.class, this.getEditorParameters());
    }

    @Test
    public void test_setValue_default() throws Exception {
        this.configureContents(false);
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    DateComponent component = new DateComponent();", "    add(component);", "  }", "}");
        ComponentInfo componentInfo = (ComponentInfo)container.getChildrenComponents().get(0);
        Property dateProperty = componentInfo.getPropertyByTitle("date");
        DatePropertyEditorTest.assertNotNull((Object)dateProperty);
        DatePropertyEditorTest.assertInstanceOf(DatePropertyEditor.class, (Object)dateProperty.getEditor());
        DatePropertyEditor dateEditor = (DatePropertyEditor)dateProperty.getEditor();
        long currentTimeMillis = System.currentTimeMillis();
        Date rightNow = new Date(currentTimeMillis);
        dateProperty.setValue((Object)rightNow);
        DatePropertyEditorTest.assertEquals((Object)new SimpleDateFormat().format(rightNow), (Object)dateEditor.getText(dateProperty));
        this.assertEditor("import java.util.Date;", "public class Test extends JPanel {", "  public Test() {", "    DateComponent component = new DateComponent();", "    component.setDate(new Date(" + Long.valueOf(currentTimeMillis).toString() + "L));", "    add(component);", "  }", "}");
    }

    @Test
    public void test_setValue_custom() throws Exception {
        this.configureContents(true);
        ContainerInfo container = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    DateComponent component = new DateComponent();", "    add(component);", "  }", "}");
        ComponentInfo componentInfo = (ComponentInfo)container.getChildrenComponents().get(0);
        Property dateProperty = componentInfo.getPropertyByTitle("date");
        DatePropertyEditorTest.assertNotNull((Object)dateProperty);
        DatePropertyEditorTest.assertInstanceOf(DatePropertyEditor.class, (Object)dateProperty.getEditor());
        DatePropertyEditor dateEditor = (DatePropertyEditor)dateProperty.getEditor();
        Date currentDate = new Date(System.currentTimeMillis());
        String currentDateStr = new SimpleDateFormat("dd.MM.yyyy").format(currentDate);
        dateProperty.setValue((Object)currentDate);
        DatePropertyEditorTest.assertEquals((Object)currentDateStr, (Object)dateEditor.getText(dateProperty));
        this.assertEditor("import java.text.SimpleDateFormat;", "import java.text.ParsePosition;", "public class Test extends JPanel {", "  public Test() {", "    DateComponent component = new DateComponent();", "    component.setDate(new SimpleDateFormat('dd.MM.yyyy').parse('" + currentDateStr + "', new ParsePosition(0)));", "    add(component);", "  }", "}");
    }

    @Test
    public void test_setText_default() throws Exception {
        this.configureContents(false);
        long currentTimeMillis = System.currentTimeMillis();
        ContainerInfo container = this.parseContainer("import java.util.Date;", "public class Test extends JPanel {", "  public Test() {", "    DateComponent component = new DateComponent();", "    component.setDate(new Date(" + Long.valueOf(currentTimeMillis).toString() + "L));", "    add(component);", "  }", "}");
        ComponentInfo componentInfo = (ComponentInfo)container.getChildrenComponents().get(0);
        Property dateProperty = componentInfo.getPropertyByTitle("date");
        DatePropertyEditorTest.assertNotNull((Object)dateProperty);
        DatePropertyEditorTest.assertEquals((Object)new Date(currentTimeMillis), (Object)dateProperty.getValue());
        DatePropertyEditorTest.assertInstanceOf(DatePropertyEditor.class, (Object)dateProperty.getEditor());
        DatePropertyEditor dateEditor = (DatePropertyEditor)dateProperty.getEditor();
        Date newDate = new Date(0L);
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        String newDateStr = dateFormat.format(newDate);
        ReflectionUtils.invokeMethod((Object)dateEditor, (String)"setEditorText(org.eclipse.wb.internal.core.model.property.Property,java.lang.String)", (Object[])new Object[]{dateProperty, newDateStr});
        DatePropertyEditorTest.assertEquals((Object)newDateStr, (Object)dateEditor.getText(dateProperty));
        DatePropertyEditorTest.assertEquals((Object)newDate, (Object)dateProperty.getValue());
        this.assertEditor("import java.util.Date;", "public class Test extends JPanel {", "  public Test() {", "    DateComponent component = new DateComponent();", "    component.setDate(new Date(0L));", "    add(component);", "  }", "}");
    }

    @Test
    public void test_setText_custom() throws Exception {
        this.configureContents(true);
        ContainerInfo container = this.parseContainer("import java.util.Date;", "public class Test extends JPanel {", "  public Test() {", "    DateComponent component = new DateComponent();", "    component.setDate(new Date());", "    add(component);", "  }", "}");
        ComponentInfo componentInfo = (ComponentInfo)container.getChildrenComponents().get(0);
        Property dateProperty = componentInfo.getPropertyByTitle("date");
        DatePropertyEditorTest.assertNotNull((Object)dateProperty);
        DatePropertyEditorTest.assertInstanceOf(DatePropertyEditor.class, (Object)dateProperty.getEditor());
        DatePropertyEditor dateEditor = (DatePropertyEditor)dateProperty.getEditor();
        String newDateStr = "22.07.1941";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Date newDate = dateFormat.parse(newDateStr);
        ReflectionUtils.invokeMethod((Object)dateEditor, (String)"setEditorText(org.eclipse.wb.internal.core.model.property.Property,java.lang.String)", (Object[])new Object[]{dateProperty, newDateStr});
        DatePropertyEditorTest.assertEquals((Object)newDateStr, (Object)dateEditor.getText(dateProperty));
        DatePropertyEditorTest.assertEquals((Object)newDate, (Object)dateProperty.getValue());
        this.assertEditor("import java.util.Date;", "import java.text.SimpleDateFormat;", "import java.text.ParsePosition;", "public class Test extends JPanel {", "  public Test() {", "    DateComponent component = new DateComponent();", "    component.setDate(new SimpleDateFormat('dd.MM.yyyy').parse('" + newDateStr + "', new ParsePosition(0)));", "    add(component);", "  }", "}");
    }

    private Map<String, Object> getEditorParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("functions", DatePropertyEditorTest.getSourceDQ("import javax.swing.JTextField;", "import java.text.SimpleDateFormat;"));
        params.put("toString", "(new SimpleDateFormat(\"dd.MM.yyyy\")).format(value)");
        params.put("toDate", "(new SimpleDateFormat(\"dd.MM.yyyy\")).parse(value)");
        params.put("source", "new java.util.Date(\"%value%\")");
        return params;
    }

    private void configureContents(boolean custom) throws Exception {
        String[] stringArray;
        String[] stringArray2 = new String[]{"public class DateComponent extends JComponent {", "  public DateComponent(){", "  }", "  public void setDate(java.util.Date value){", "  }", "}"};
        if (custom) {
            String[] stringArray3 = new String[11];
            stringArray3[0] = "<?xml version='1.0' encoding='UTF-8'?>";
            stringArray3[1] = "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>";
            stringArray3[2] = "  <property id='setDate(java.util.Date)'>";
            stringArray3[3] = "    <editor id='customDate'>";
            stringArray3[4] = "      <parameter name='functions'>import javax.swing.JTextField; import java.text.SimpleDateFormat;</parameter>";
            stringArray3[5] = "      <parameter name='toString'>(new SimpleDateFormat(\"dd.MM.yyyy\")).format(value)</parameter>";
            stringArray3[6] = "      <parameter name='toDate'>(new SimpleDateFormat(\"dd.MM.yyyy\")).parse(value)</parameter>";
            stringArray3[7] = "      <parameter name='source'>new java.text.SimpleDateFormat(\"dd.MM.yyyy\").parse(\"%value%\", new java.text.ParsePosition(0))</parameter>";
            stringArray3[8] = "    </editor>";
            stringArray3[9] = "  </property>";
            stringArray = stringArray3;
            stringArray3[10] = "</component>";
        } else {
            String[] stringArray4 = new String[6];
            stringArray4[0] = "<?xml version='1.0' encoding='UTF-8'?>";
            stringArray4[1] = "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>";
            stringArray4[2] = "  <property id='setDate(java.util.Date)'>";
            stringArray4[3] = "    <editor id='customDate'/>";
            stringArray4[4] = "  </property>";
            stringArray = stringArray4;
            stringArray4[5] = "</component>";
        }
        this.setJavaContentSrc("test", "DateComponent", stringArray2, stringArray);
        DatePropertyEditorTest.waitForAutoBuild();
    }
}

