/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.creation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.editor.palette.PaletteEventListener;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.editor.palette.model.entry.StaticFactoryEntryInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.FactoryAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.SetterAccessor;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.model.variable.description.LocalUniqueVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.property.editor.icon.IconPropertyEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.junit.Test;

public class StaticFactoryCreationSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        StaticFactoryCreationSupportTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source text 'SF button'", "  */", "  public static JButton createButton(String text, Icon icon) {", "    return new JButton(text, icon);", "  }", "}"));
        StaticFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  Test() {", "    add(StaticFactory.createButton('button', null));", "  }", "}");
        StaticFactoryCreationSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        StaticFactoryCreationSupport creationSupport = (StaticFactoryCreationSupport)button.getCreationSupport();
        StaticFactoryCreationSupportTest.assertEquals((Object)"static factory: test.StaticFactory createButton(java.lang.String,javax.swing.Icon)", (Object)creationSupport.toString());
        StaticFactoryCreationSupportTest.assertTrue((boolean)creationSupport.canDelete());
        StaticFactoryCreationSupportTest.assertTrue((creationSupport.getNode() != null ? 1 : 0) != 0);
        StaticFactoryCreationSupportTest.assertInstanceOf(StaticFactoryCreationSupport.class, (Object)creationSupport.getLiveComponentCreation());
        FactoryMethodDescription description = creationSupport.getDescription();
        StaticFactoryCreationSupportTest.assertTrue((boolean)description.isFactory());
        StaticFactoryCreationSupportTest.assertEquals((Object)"test.StaticFactory", (Object)description.getDeclaringClass().getName());
        StaticFactoryCreationSupportTest.assertEquals((Object)"javax.swing.JButton", (Object)description.getReturnClass().getName());
        StaticFactoryCreationSupportTest.assertEquals((long)2L, (long)description.getParameters().size());
        ParameterDescription parameter = description.getParameter(0);
        StaticFactoryCreationSupportTest.assertEquals((Object)"text", (Object)parameter.getName());
        StaticFactoryCreationSupportTest.assertEquals((Object)"\"SF button\"", (Object)parameter.getDefaultSource());
        StaticFactoryCreationSupportTest.assertEquals((Object)"setText(java.lang.String)", (Object)parameter.getProperty());
        StaticFactoryCreationSupportTest.assertNotNull((Object)parameter.toString());
        StaticFactoryCreationSupportTest.assertInstanceOf(StringConverter.class, (Object)parameter.getConverter());
        StaticFactoryCreationSupportTest.assertInstanceOf(StringPropertyEditor.class, (Object)parameter.getEditor());
        parameter = description.getParameter(1);
        StaticFactoryCreationSupportTest.assertEquals((Object)"icon", (Object)parameter.getName());
        StaticFactoryCreationSupportTest.assertEquals((Object)"setIcon(javax.swing.Icon)", (Object)parameter.getProperty());
        StaticFactoryCreationSupportTest.assertSame(null, (Object)parameter.getConverter());
        StaticFactoryCreationSupportTest.assertInstanceOf(IconPropertyEditor.class, (Object)parameter.getEditor());
        GenericProperty textProperty = (GenericProperty)button.getPropertyByTitle("text");
        List<ExpressionAccessor> accessors = StaticFactoryCreationSupportTest.getGenericPropertyAccessors(textProperty);
        StaticFactoryCreationSupportTest.assertEquals((long)2L, (long)accessors.size());
        StaticFactoryCreationSupportTest.assertInstanceOf(SetterAccessor.class, (Object)accessors.get(0));
        StaticFactoryCreationSupportTest.assertInstanceOf(FactoryAccessor.class, (Object)accessors.get(1));
        StaticFactoryCreationSupportTest.assertTrue((boolean)textProperty.isModified());
        StaticFactoryCreationSupportTest.assertEquals((Object)"button", (Object)textProperty.getValue());
        StaticFactoryCreationSupportTest.assertRelatedNodes((JavaInfo)button, new String[]{"add(StaticFactory.createButton(\"button\", null))"});
        textProperty.setValue((Object)"12345");
        StaticFactoryCreationSupportTest.assertRelatedNodes((JavaInfo)button, new String[]{"add(StaticFactory.createButton(\"12345\", null))"});
        textProperty.setValue(Property.UNKNOWN_VALUE);
        StaticFactoryCreationSupportTest.assertRelatedNodes((JavaInfo)button, new String[]{"add(StaticFactory.createButton(\"SF button\", null))"});
        StaticFactoryCreationSupportTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("// filler filler filler", "public final class Test extends JPanel {", "  Test() {", "  }", "}");
    }

    @Test
    public void test_parse2() throws Exception {
        StaticFactoryCreationSupportTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}"));
        StaticFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  Test() {", "    add(StaticFactory.createButton('button'));", "  }", "}");
        StaticFactoryCreationSupportTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GenericProperty textProperty = (GenericProperty)button.getPropertyByTitle("text");
        textProperty.setValue(Property.UNKNOWN_VALUE);
        StaticFactoryCreationSupportTest.assertRelatedNodes((JavaInfo)button, new String[]{"add(StaticFactory.createButton((String) null))"});
    }

    @Test
    public void test_parse_factoryMethodSpecific_ComponentDescription() throws Exception {
        StaticFactoryCreationSupportTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        StaticFactoryCreationSupportTest.setFileContentSrc("test/StaticFactory.createButton__.wbp-component.xml", StaticFactoryCreationSupportTest.getSource("<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-preferred names='enabled'/>", "</component>"));
        StaticFactoryCreationSupportTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = StaticFactory.createButton();", "      add(button);", "    }", "  }", "}");
        Object button = StaticFactoryCreationSupportTest.getJavaInfoByName("button");
        GenericPropertyDescription propertyDescription = button.getDescription().getProperty("setEnabled(boolean)");
        StaticFactoryCreationSupportTest.assertSame((Object)PropertyCategory.PREFERRED, (Object)propertyDescription.getCategory());
    }

    @Test
    public void test_parse_noFactory() throws Exception {
        StaticFactoryCreationSupportTest.setFileContentSrc("test/StaticFactory_.java", this.getTestSource("public class StaticFactory_ {", "  public static JButton createButton_noFactory() {", "    return new JButton();", "  }", "}"));
        StaticFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    add(StaticFactory_.createButton_noFactory());", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).isEmpty();
    }

    @Test
    public void test_parse_invalidParent() throws Exception {
        StaticFactoryCreationSupportTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public class StaticFactory {", "  public static JButton createButton(int parent) {", "    return new JButton();", "  }", "}"));
        StaticFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    StaticFactory.createButton(0);", "  }", "}");
        Assertions.assertThat((List)panel.getChildrenComponents()).isEmpty();
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        EditorWarning warning = (EditorWarning)warnings.get(0);
        StaticFactoryCreationSupportTest.assertEquals((Object)"No parent model for StaticFactory.createButton(0)", (Object)warning.getMessage());
    }

    @Test
    public void test_add() throws Exception {
        this.createModelCompilationUnit("test", "StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  /**", "  * @wbp.factory.parameter.source text_0 '000'", "  * @wbp.factory.parameter.source 1 '111'", "  */", "  public static JButton createButton2(String text_0, String text_1, String text_2, String text_3) {", "    return new JButton(text_0, null);", "  }", "}"));
        StaticFactoryCreationSupportTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", StaticFactoryCreationSupportTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton2'>", "    <parameter type='java.lang.String'/>", "    <parameter type='java.lang.String'/>", "    <parameter type='java.lang.String' defaultSource='\"222\"'/>", "    <parameter type='java.lang.String'/>", "  </method>", "</factory>"));
        StaticFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.StaticFactory"), (String)"createButton2(java.lang.String,java.lang.String,java.lang.String,java.lang.String)", (boolean)true);
        StaticFactoryCreationSupportTest.assertEquals((Object)"\"000\"", (Object)description.getParameter(0).getDefaultSource());
        StaticFactoryCreationSupportTest.assertEquals((Object)"\"111\"", (Object)description.getParameter(1).getDefaultSource());
        StaticFactoryCreationSupportTest.assertEquals((Object)"\"222\"", (Object)description.getParameter(2).getDefaultSource());
        StaticFactoryCreationSupportTest.assertEquals((Object)"(java.lang.String) null", (Object)description.getParameter(3).getDefaultSource());
        ComponentInfo newComponent = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)new StaticFactoryCreationSupport(description));
        SwingTestUtils.setGenerations(LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        try {
            flowLayout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = StaticFactory.createButton2('000', '111', '222', (String) null);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_add_withInvocation() throws Exception {
        StaticFactoryCreationSupportTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        StaticFactoryCreationSupportTest.setFileContentSrc("test/StaticFactory.wbp-factory.xml", StaticFactoryCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<factory>", "  <method name='createButton'>", "    <invocation signature='setText(java.lang.String)'><![CDATA['Static Button']]></invocation>", "  </method>", "</factory>"));
        StaticFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.StaticFactory"), (String)"createButton()", (boolean)true);
        ComponentInfo newComponent = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)new StaticFactoryCreationSupport(description));
        flowLayout.add(newComponent, null);
        StaticFactoryCreationSupportTest.assertAST(this.m_lastEditor);
        StaticFactoryCreationSupportTest.assertEquals((Object)this.getTestSource("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = StaticFactory.createButton();", "      add(button);", "      button.setText('Static Button');", "    }", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_add_localFactoryMethod() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "  }", "  /**", "  * @wbp.factory", "  */", "  private static JButton createButton() {", "    return new JButton();", "  }", "}");
        panel.refresh();
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.Test"), (String)"createButton()", (boolean)true);
        ComponentInfo newComponent = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)new StaticFactoryCreationSupport(description));
        flowLayout.add(newComponent, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = createButton();", "      add(button);", "    }", "  }", "  /**", "  * @wbp.factory", "  */", "  private static JButton createButton() {", "    return new JButton();", "  }", "}");
    }

    @Test
    public void test_parse_localFactoryMethod_contributeToPalette() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  Test() {", "  }", "  /**", "  * @wbp.factory", "  */", "  private static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}");
        ArrayList categories = new ArrayList();
        ((PaletteEventListener)panel.getBroadcast(PaletteEventListener.class)).categories(categories);
        Assertions.assertThat(categories).hasSize(1);
        CategoryInfo factoriesCategory = (CategoryInfo)categories.get(0);
        StaticFactoryCreationSupportTest.assertEquals((Object)"Local Factories", (Object)factoriesCategory.getName());
        List entries = factoriesCategory.getEntries();
        Assertions.assertThat((List)entries).hasSize(1);
        StaticFactoryEntryInfo factoryEntry = (StaticFactoryEntryInfo)entries.get(0);
        StaticFactoryCreationSupportTest.assertEquals((Object)"test.Test", (Object)factoryEntry.getFactoryClassName());
        StaticFactoryCreationSupportTest.assertEquals((Object)"createButton(java.lang.String)", (Object)factoryEntry.getMethodSignature());
    }

    @Test
    public void test_canUseParent_CREATE_false() throws Exception {
        this.canUseParent_prepare_createButton();
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public final class Test extends JFrame {", "  Test() {", "  }", "}");
        ComponentInfo button = this.canUseParent_createButton();
        CreationSupport creationSupport = button.getCreationSupport();
        StaticFactoryCreationSupportTest.assertFalse((boolean)creationSupport.canUseParent((JavaInfo)frame));
        StaticFactoryCreationSupportTest.assertFalse((boolean)creationSupport.canUseParent((JavaInfo)frame));
    }

    @Test
    public void test_canUseParent_CREATE_true() throws Exception {
        this.canUseParent_prepare_createButton();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  Test() {", "  }", "}");
        ComponentInfo button = this.canUseParent_createButton();
        CreationSupport creationSupport = button.getCreationSupport();
        StaticFactoryCreationSupportTest.assertTrue((boolean)creationSupport.canUseParent((JavaInfo)panel));
        StaticFactoryCreationSupportTest.assertTrue((boolean)creationSupport.canUseParent((JavaInfo)panel));
    }

    @Test
    public void test_canUseParent_MOVE_true() throws Exception {
        this.canUseParent_prepare_createButton();
        ContainerInfo frame = this.parseContainer("public final class Test extends JFrame {", "  Test() {", "    {", "      JPanel panel_1 = new JPanel();", "      getContentPane().add(panel_1);", "      panel_1.add(StaticFactory.createButton(panel_1));", "    }", "    {", "      JPanel panel_2 = new JPanel();", "      getContentPane().add(panel_2);", "    }", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ContainerInfo panel_1 = (ContainerInfo)contentPane.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)contentPane.getChildrenComponents().get(1);
        ComponentInfo button = (ComponentInfo)panel_1.getChildrenComponents().get(0);
        CreationSupport creationSupport = button.getCreationSupport();
        StaticFactoryCreationSupportTest.assertTrue((boolean)creationSupport.canUseParent((JavaInfo)panel_2));
        StaticFactoryCreationSupportTest.assertTrue((boolean)creationSupport.canUseParent((JavaInfo)panel_2));
    }

    @Test
    public void test_canUseParent_MOVE_false() throws Exception {
        this.canUseParent_prepare_createButton();
        ContainerInfo frame = this.parseContainer("public final class Test extends JFrame {", "  Test() {", "    {", "      JPanel panel_1 = new JPanel();", "      getContentPane().add(panel_1);", "      panel_1.add(StaticFactory.createButton(panel_1));", "    }", "  }", "}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ContainerInfo panel_1 = (ContainerInfo)contentPane.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)panel_1.getChildrenComponents().get(0);
        CreationSupport creationSupport = button.getCreationSupport();
        StaticFactoryCreationSupportTest.assertFalse((boolean)creationSupport.canUseParent((JavaInfo)frame));
        StaticFactoryCreationSupportTest.assertFalse((boolean)creationSupport.canUseParent((JavaInfo)frame));
    }

    private void canUseParent_prepare_createButton() throws Exception {
        StaticFactoryCreationSupportTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(JPanel parent) {", "    return new JButton();", "  }", "}"));
        StaticFactoryCreationSupportTest.waitForAutoBuild();
    }

    private ComponentInfo canUseParent_createButton() throws Exception {
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("test.StaticFactory"), (String)"createButton(javax.swing.JPanel)", (boolean)true);
        return (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JButton.class, (CreationSupport)new StaticFactoryCreationSupport(description));
    }

    @Test
    public void test_parse_localFactoryMethod_singleInvocation() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  Test() {", "    add(createButton('A'));", "  }", "  /**", "  * @wbp.factory", "  */", "  private static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}");
        StaticFactoryCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(createButton('A'))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {static factory: test.Test createButton(java.lang.String)} {empty} {/add(createButton('A'))/}");
        panel.refresh();
        StaticFactoryCreationSupportTest.assertNoErrors((JavaInfo)panel);
        JPanel panelObject = (JPanel)panel.getObject();
        Assertions.assertThat((Object[])panelObject.getComponents()).hasSize(1);
    }

    @Test
    public void test_parse_localFactoryMethod_twoInvocations() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public final class Test extends JPanel {", "  Test() {", "    add(createButton('A'));", "    add(createButton('B'));", "  }", "  /**", "  * @wbp.factory", "  */", "  private static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}");
        StaticFactoryCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(createButton('A'))/ /add(createButton('B'))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {static factory: test.Test createButton(java.lang.String)} {empty} {/add(createButton('A'))/}", "  {static factory: test.Test createButton(java.lang.String)} {empty} {/add(createButton('B'))/}");
        panel.refresh();
        StaticFactoryCreationSupportTest.assertNoErrors((JavaInfo)panel);
        JPanel panelObject = (JPanel)panel.getObject();
        Assertions.assertThat((Object[])panelObject.getComponents()).hasSize(2);
    }

    @Test
    public void test_parse_localFactoryMethod_noConstructor() throws Exception {
        StaticFactoryCreationSupportTest.setFileContentSrc("test/BasePanel.java", this.getTestSource("public class BasePanel extends JPanel {", "  public BasePanel() {", "    createContents();", "  }", "  protected void createContents() {", "  }", "}"));
        StaticFactoryCreationSupportTest.waitForAutoBuild();
        this.m_waitForAutoBuild = true;
        ContainerInfo panel = this.parseContainer("public final class Test extends BasePanel {", "  protected void createContents() {", "    add(createButton('A'));", "    add(createButton('B'));", "  }", "  /**", "  * @wbp.factory", "  */", "  private static JButton createButton(String text) {", "    return new JButton(text);", "  }", "}");
        StaticFactoryCreationSupportTest.assertHierarchy("{this: test.BasePanel} {this} {/add(createButton('A'))/ /add(createButton('B'))/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {static factory: test.Test createButton(java.lang.String)} {empty} {/add(createButton('A'))/}", "  {static factory: test.Test createButton(java.lang.String)} {empty} {/add(createButton('B'))/}");
        panel.refresh();
        StaticFactoryCreationSupportTest.assertNoErrors((JavaInfo)panel);
        JPanel panelObject = (JPanel)panel.getObject();
        Assertions.assertThat((Object[])panelObject.getComponents()).hasSize(2);
    }
}

