/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.creation;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPOutputStream;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardCreationSupport;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.ImplicitFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class ImplicitFactoryCreationSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_String_parse() throws Exception {
        ContainerInfo panel = this.prepare_String_parse();
        ImplicitFactoryCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/ /bar.addItem('Some text')/}", "    {implicit-factory} {local-unique: component} {/bar.addItem('Some text')/ /component.setEnabled(false)/}");
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        JavaInfo component = (JavaInfo)bar.getChildrenJava().get(0);
        ImplicitFactoryCreationSupport creationSupport = (ImplicitFactoryCreationSupport)component.getCreationSupport();
        ImplicitFactoryCreationSupportTest.assertEquals((Object)"bar.addItem(\"Some text\")", (Object)this.m_lastEditor.getSource(creationSupport.getNode()));
        ImplicitFactoryCreationSupportTest.assertEquals((Object)"implicit-factory", (Object)creationSupport.toString());
        ImplicitFactoryCreationSupportTest.assertTrue((boolean)creationSupport.canReorder());
        ImplicitFactoryCreationSupportTest.assertFalse((boolean)creationSupport.canReparent());
        MethodDescription description = creationSupport.getDescription();
        ImplicitFactoryCreationSupportTest.assertEquals((Object)"addItem(java.lang.String)", (Object)description.getSignature());
        Property factoryProperty = component.getPropertyByTitle("Factory");
        Property[] factoryProperties = ImplicitFactoryCreationSupportTest.getSubProperties(factoryProperty);
        ImplicitFactoryCreationSupportTest.assertEquals((long)1L, (long)factoryProperties.length);
        Property textProperty = factoryProperties[0];
        ImplicitFactoryCreationSupportTest.assertEquals((Object)"text", (Object)textProperty.getTitle());
        ImplicitFactoryCreationSupportTest.assertEquals((Object)"Some text", (Object)textProperty.getValue());
    }

    @Test
    public void test_String_clipboard() throws Exception {
        ContainerInfo panel = this.prepare_String_parse();
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        JavaInfo component = (JavaInfo)bar.getChildrenJava().get(0);
        ImplicitFactoryCreationSupportTest.assertClipboardSource(component, "%parent%.addItem(\"Some text\")");
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)component);
        ImplicitFactoryCreationSupportTest.assertSerializabled(memento);
        ComponentInfo newComponent = (ComponentInfo)memento.create((JavaInfo)panel);
        JavaInfoUtils.add((JavaInfo)newComponent, null, (JavaInfo)bar, null);
        memento.apply();
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    {", "      JComponent component = bar.addItem('Some text');", "      component.setEnabled(false);", "    }", "    {", "      JComponent component = bar.addItem('Some text');", "      component.setEnabled(false);", "    }", "  }", "}");
    }

    private static void assertSerializabled(JavaInfoMemento memento) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(baos));
        oos.writeObject(memento);
        oos.close();
    }

    private ContainerInfo prepare_String_parse() throws Exception {
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyBar.java", this.getTestSource("public class MyBar extends JPanel {", "  public JComponent addItem(String text) {", "    JButton button = new JButton(text);", "    add(button);", "    return button;", "  }", "}"));
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyBar.wbp-component.xml", ImplicitFactoryCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addItem'>", "      <parameter type='java.lang.String'/>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        ImplicitFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    {", "      JComponent component = bar.addItem('Some text');", "      component.setEnabled(false);", "    }", "  }", "}");
        panel.refresh();
        return panel;
    }

    @Test
    public void test_Component_parse() throws Exception {
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyBar.java", this.getTestSource("public class MyBar extends JPanel {", "  public JComponent addItem(Component content) {", "    JPanel wrapper = new JPanel();", "    add(wrapper);", "    wrapper.add(content);", "    return wrapper;", "  }", "}"));
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyBar.wbp-component.xml", ImplicitFactoryCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addItem'>", "      <parameter type='java.awt.Component'/>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        ImplicitFactoryCreationSupportTest.waitForAutoBuild();
        this.parseContainer("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    //", "    JButton button = new JButton('my JButton');", "    JComponent component = bar.addItem(button);", "    component.setEnabled(false);", "  }", "}");
        ImplicitFactoryCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/ /bar.addItem(button)/}", "    {implicit-factory} {local-unique: component} {/bar.addItem(button)/ /component.setEnabled(false)/}", "      {new: javax.swing.JButton} {local-unique: button} {/new JButton('my JButton')/ /bar.addItem(button)/}");
        this.refresh();
        ComponentInfo component = (ComponentInfo)ImplicitFactoryCreationSupportTest.getJavaInfoByName("component");
        ComponentInfo button = (ComponentInfo)ImplicitFactoryCreationSupportTest.getJavaInfoByName("button");
        Property contentProperty = PropertyUtils.getByPath((ObjectInfo)component, (String)"Factory/content");
        ImplicitFactoryCreationSupportTest.assertNotNull((Object)contentProperty);
        Object[] contentProperties = ImplicitFactoryCreationSupportTest.getSubProperties(contentProperty);
        ImplicitFactoryCreationSupportTest.assertArrayEquals((Object[])contentProperties, (Object[])button.getProperties());
    }

    @Test
    public void test_sameMethodAndParent_CREATE() throws Exception {
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyBar.java", this.getTestSource("public class MyBar extends JPanel {", "  public JButton addButton() {", "    JButton button = new JButton();", "    add(button);", "    return button;", "  }", "}"));
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyBar.wbp-component.xml", ImplicitFactoryCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addButton'>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "</component>"));
        ImplicitFactoryCreationSupportTest.waitForAutoBuild();
        this.parseContainer("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "  }", "}");
        ImplicitFactoryCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        ContainerInfo bar = (ContainerInfo)ImplicitFactoryCreationSupportTest.getJavaInfoByName("bar");
        String signature = "addButton()";
        String invocationSource = "addButton()";
        ImplicitFactoryCreationSupport creationSupport = new ImplicitFactoryCreationSupport(signature, invocationSource);
        ComponentInfo newButton = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, (String)"javax.swing.JButton", (CreationSupport)creationSupport);
        ((FlowLayoutInfo)bar.getLayout()).add(newButton, null);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    {", "      JButton button = bar.addButton();", "    }", "  }", "}");
        ImplicitFactoryCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/ /bar.addButton()/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {implicit-factory} {local-unique: button} {/bar.addButton()/}");
        MethodDescription description = creationSupport.getDescription();
        ImplicitFactoryCreationSupportTest.assertNotNull((Object)description);
        ImplicitFactoryCreationSupportTest.assertEquals((Object)"addButton()", (Object)description.toString());
        Property[] properties = newButton.getProperties();
        Assertions.assertThat((int)properties.length).isGreaterThan(10);
    }

    @Test
    public void test_separateMethodAndParent_parse() throws Exception {
        this.prepare_separateMethodAndParent();
        ContainerInfo panel = this.parseContainer("class Test extends MyDialog {", "  Test() {", "    JPanel bar = new JPanel();", "    add(bar);", "    //", "    addButton(bar);", "  }", "}");
        ImplicitFactoryCreationSupportTest.assertHierarchy("{this: test.MyDialog} {this} {/add(bar)/ /addButton(bar)/}", "  {new: javax.swing.JPanel} {local-unique: bar} {/new JPanel()/ /add(bar)/ /addButton(bar)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {implicit-factory} {empty} {/addButton(bar)/}");
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)bar.getChildrenComponents().get(0);
        ImplicitFactoryCreationSupport creationSupport = (ImplicitFactoryCreationSupport)button.getCreationSupport();
        MethodDescription description = creationSupport.getDescription();
        ImplicitFactoryCreationSupportTest.assertNotNull((Object)description);
        ImplicitFactoryCreationSupportTest.assertEquals((Object)"addButton({java.awt.Container,parent})", (Object)description.toString());
        IClipboardCreationSupport clipboard = creationSupport.getClipboard();
        ImplicitFactoryCreationSupportTest.assertNull((Object)clipboard);
    }

    @Test
    public void test_separateMethodAndParent_CREATE() throws Exception {
        this.prepare_separateMethodAndParent();
        ContainerInfo panel = this.parseContainer("class Test extends MyDialog {", "  Test() {", "    JPanel bar = new JPanel();", "    add(bar);", "  }", "}");
        panel.refresh();
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        String signature = "addButton(java.awt.Container)";
        String invocationSource = TemplateUtils.format((String)"addButton({0})", (Object[])new Object[]{bar});
        ImplicitFactoryCreationSupport creationSupport = new ImplicitFactoryCreationSupport((JavaInfo)panel, signature, invocationSource);
        ComponentInfo newButton = (ComponentInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, (String)"javax.swing.JButton", (CreationSupport)creationSupport);
        ((FlowLayoutInfo)bar.getLayout()).add(newButton, null);
        this.assertEditor("class Test extends MyDialog {", "  Test() {", "    JPanel bar = new JPanel();", "    add(bar);", "    {", "      JButton button = addButton(bar);", "    }", "  }", "}");
        ImplicitFactoryCreationSupportTest.assertHierarchy("{this: test.MyDialog} {this} {/add(bar)/}", "  {new: javax.swing.JPanel} {local-unique: bar} {/new JPanel()/ /add(bar)/ /addButton(bar)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {implicit-factory} {local-unique: button} {/addButton(bar)/}");
        MethodDescription description = creationSupport.getDescription();
        ImplicitFactoryCreationSupportTest.assertNotNull((Object)description);
        ImplicitFactoryCreationSupportTest.assertEquals((Object)"addButton({java.awt.Container,parent})", (Object)description.toString());
        Property[] properties = newButton.getProperties();
        Assertions.assertThat((int)properties.length).isGreaterThan(10);
    }

    private void prepare_separateMethodAndParent() throws Exception {
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyDialog.java", this.getTestSource("public class MyDialog extends JPanel {", "  public JButton addButton(Container parent) {", "    JButton button = new JButton();", "    parent.add(button);", "    return button;", "  }", "}"));
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyDialog.wbp-component.xml", ImplicitFactoryCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addButton'>", "      <parameter type='java.awt.Container' parent='true'/>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        ImplicitFactoryCreationSupportTest.waitForAutoBuild();
    }

    @Test
    public void test_argumentToProperty() throws Exception {
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyBar.java", this.getTestSource("public class MyBar extends JPanel {", "  public JButton addButton(String text) {", "    JButton button = new JButton(text);", "    add(button);", "    return button;", "  }", "}"));
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyBar.wbp-component.xml", ImplicitFactoryCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addButton'>", "      <parameter type='java.lang.String' name='text' property='setText(java.lang.String)'/>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        ImplicitFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    //", "    JButton button = bar.addButton('Some text');", "    button.setEnabled(false);", "  }", "}");
        ImplicitFactoryCreationSupportTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(bar)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyBar} {local-unique: bar} {/new MyBar()/ /add(bar)/ /bar.addButton('Some text')/}", "    {implicit-factory} {local-unique: button} {/bar.addButton('Some text')/ /button.setEnabled(false)/}");
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        JavaInfo button = (JavaInfo)bar.getChildrenJava().get(0);
        Property textProperty = button.getPropertyByTitle("text");
        ImplicitFactoryCreationSupportTest.assertEquals((Object)"Some text", (Object)textProperty.getValue());
        textProperty.setValue((Object)"New text");
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    //", "    JButton button = bar.addButton('New text');", "    button.setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_materializeVariable() throws Exception {
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyBar.java", this.getTestSource("public class MyBar extends JPanel {", "  public JButton addButton() {", "    JButton button = new JButton();", "    add(button);", "    return button;", "  }", "}"));
        ImplicitFactoryCreationSupportTest.setFileContentSrc("test/MyBar.wbp-component.xml", ImplicitFactoryCreationSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addButton'>", "      <tag name='implicitFactory' value='true'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        ImplicitFactoryCreationSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    {", "      bar.addButton();", "    }", "  }", "}");
        ContainerInfo bar = (ContainerInfo)panel.getChildrenComponents().get(0);
        JavaInfo button = (JavaInfo)bar.getChildrenJava().get(0);
        Property textProperty = button.getPropertyByTitle("text");
        textProperty.setValue((Object)"New text");
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    MyBar bar = new MyBar();", "    add(bar);", "    {", "      JButton button = bar.addButton();", "      button.setText('New text');", "    }", "  }", "}");
    }
}

