/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model;

import java.lang.reflect.Field;
import java.util.List;
import javax.swing.JButton;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.InvocationChildArrayAssociation;
import org.eclipse.wb.internal.core.model.nonvisual.ArrayObjectInfo;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.After;
import org.junit.Test;

public class ArrayObjectTest
extends SwingModelTest {
    private ContainerInfo myPanel;
    private ArrayObjectInfo arrayInfo;
    private ComponentInfo localButton;
    private ComponentInfo emptyButton;

    @Override
    @After
    public void tearDown() throws Exception {
        Field[] fieldArray = ((Object)((Object)this)).getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().indexOf(36) == -1 && Object.class.isAssignableFrom(field.getType())) {
                field.setAccessible(true);
                field.set((Object)this, null);
            }
            ++n2;
        }
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        this.getParsedContainer();
        ArrayObjectTest.assertSame((Object)this.myPanel, (Object)this.arrayInfo.getParent());
        Assertions.assertThat((List)this.arrayInfo.getChildren()).isEmpty();
        ArrayObjectTest.assertTrue((boolean)this.arrayInfo.isRemoveOnEmpty());
        ArrayObjectTest.assertTrue((!this.arrayInfo.isHideInTree() ? 1 : 0) != 0);
        ArrayObjectTest.assertEquals((Object)this.arrayInfo.getItemClass(), JButton.class);
        this.checkArrayItem(this.localButton);
        ArrayObjectTest.assertInstanceOf(LocalVariableSupport.class, (Object)this.localButton.getVariableSupport());
        this.checkArrayItem(this.emptyButton);
        ArrayObjectTest.assertInstanceOf(EmptyVariableSupport.class, (Object)this.emptyButton.getVariableSupport());
    }

    @Test
    public void test_Presentation() throws Exception {
        this.getParsedContainer();
        IObjectPresentation presentation = this.arrayInfo.getPresentation();
        ArrayObjectTest.assertNotNull((Object)presentation.getIcon());
        ArrayObjectTest.assertEquals((Object)"addButtons(array)", (Object)presentation.getText());
        List childrenTree = presentation.getChildrenTree();
        Assertions.assertThat((List)childrenTree).hasSize(2);
        ArrayObjectTest.assertEquals((Object)childrenTree, (Object)this.myPanel.getChildrenComponents());
        Assertions.assertThat((List)childrenTree).containsOnly((Object[])new ObjectInfo[]{this.localButton, this.emptyButton});
        List childrenGraphical = presentation.getChildrenGraphical();
        Assertions.assertThat((List)childrenGraphical).isEmpty();
        Assertions.assertThat((List)this.myPanel.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{this.arrayInfo});
    }

    @Test
    public void test_deleteItem_withLocal() throws Exception {
        this.getParsedContainer();
        ((ListAssert)Assertions.assertThat((List)this.arrayInfo.getItems()).hasSize(2)).contains((Object[])new ObjectInfo[]{this.localButton});
        ArrayObjectTest.assertTrue((boolean)this.localButton.canDelete());
        this.localButton.delete();
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addButtons( new JButton[] { new JButton() } );", "  }", "}");
        Assertions.assertThat((List)this.arrayInfo.getItems()).containsOnly((Object[])new ObjectInfo[]{this.emptyButton});
        Assertions.assertThat((List)this.myPanel.getChildren()).doesNotContain((Object[])new ObjectInfo[]{this.localButton});
    }

    @Test
    public void test_deleteItem_withEmpty() throws Exception {
        this.getParsedContainer();
        ((ListAssert)Assertions.assertThat((List)this.arrayInfo.getItems()).hasSize(2)).contains((Object[])new ObjectInfo[]{this.emptyButton});
        ArrayObjectTest.assertTrue((boolean)this.emptyButton.canDelete());
        this.emptyButton.delete();
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button } );", "  }", "}");
        Assertions.assertThat((List)this.arrayInfo.getItems()).containsOnly((Object[])new ObjectInfo[]{this.localButton});
        Assertions.assertThat((List)this.myPanel.getChildren()).doesNotContain((Object[])new ObjectInfo[]{this.emptyButton});
    }

    @Test
    public void test_deleteAllItems() throws Exception {
        this.getParsedContainer();
        this.localButton.delete();
        this.emptyButton.delete();
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Assertions.assertThat((List)this.myPanel.getChildren()).doesNotContain((Object[])new ObjectInfo[]{this.arrayInfo, this.localButton, this.emptyButton});
    }

    @Test
    public void test_deleteArrayObjectInfo() throws Exception {
        this.getParsedContainer();
        ArrayObjectTest.assertTrue((boolean)this.arrayInfo.canDelete());
        this.arrayInfo.delete();
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        Assertions.assertThat((List)this.myPanel.getChildren()).doesNotContain((Object[])new ObjectInfo[]{this.arrayInfo, this.localButton, this.emptyButton});
    }

    @Test
    public void test_addItem() throws Exception {
        this.getParsedContainer();
        ArrayObjectTest.assertNotNull((Object)this.localButton);
        ArrayObjectTest.assertNotNull((Object)this.emptyButton);
        Object newButton = ArrayObjectTest.createJavaInfo("javax.swing.JButton");
        this.arrayInfo.command_CREATE(newButton, null);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton(), new JButton('New button') } );", "  }", "}");
        Assertions.assertThat((List)this.myPanel.getChildren(ArrayObjectInfo.class)).containsOnly((Object[])new ArrayObjectInfo[]{this.arrayInfo});
        Assertions.assertThat((List)this.myPanel.getChildrenComponents()).containsOnly((Object[])new JavaInfo[]{this.localButton, this.emptyButton, newButton});
        this.myPanel.refresh();
        ArrayObjectTest.assertNotNull((Object)this.localButton.getObject());
        ArrayObjectTest.assertNotNull((Object)this.emptyButton.getObject());
        ArrayObjectTest.assertNotNull((Object)newButton.getObject());
    }

    @Test
    public void test_moveItemInside() throws Exception {
        this.getParsedContainer();
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.localButton), (long)0L);
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.emptyButton), (long)1L);
        Assertions.assertThat((int)this.myPanel.getChildrenComponents().indexOf(this.localButton)).isLessThan(this.myPanel.getChildrenComponents().indexOf(this.emptyButton));
        this.arrayInfo.command_MOVE((JavaInfo)this.emptyButton, (JavaInfo)this.localButton);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { new JButton(), button } );", "  }", "}");
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.localButton), (long)1L);
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.emptyButton), (long)0L);
        Assertions.assertThat((int)this.myPanel.getChildrenComponents().indexOf(this.localButton)).isGreaterThan(this.myPanel.getChildrenComponents().indexOf(this.emptyButton));
        this.myPanel.refresh();
        ArrayObjectTest.assertNotNull((Object)this.localButton.getObject());
        ArrayObjectTest.assertNotNull((Object)this.emptyButton.getObject());
    }

    @Test
    public void test_moveItemBetween() throws Exception {
        this.getParsedContainer();
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.localButton), (long)0L);
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.emptyButton), (long)1L);
        Assertions.assertThat((int)this.myPanel.getChildrenComponents().indexOf(this.localButton)).isLessThan(this.myPanel.getChildrenComponents().indexOf(this.emptyButton));
        MethodInvocation newMethodInvocation = this.myPanel.addMethodInvocation("addButtons(javax.swing.JButton[])", "new javax.swing.JButton[]{}");
        Class itemType = ReflectionUtils.getClassByName((ClassLoader)EditorState.get((AstEditor)this.m_lastEditor).getEditorLoader(), (String)"javax.swing.JButton");
        ArrayObjectInfo newArrayInfo = new ArrayObjectInfo(this.m_lastEditor, "addButtonsNew", itemType, (ArrayCreation)newMethodInvocation.arguments().get(0));
        this.myPanel.addChild((ObjectInfo)newArrayInfo);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    addButtons(new JButton[]{});", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton() } );", "  }", "}");
        newArrayInfo.command_MOVE((JavaInfo)this.localButton, null);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons(new JButton[]{button});", "    addButtons( new JButton[] { new JButton() } );", "  }", "}");
        Assertions.assertThat((List)this.arrayInfo.getItems()).containsOnly((Object[])new ObjectInfo[]{this.emptyButton});
        Assertions.assertThat((List)newArrayInfo.getItems()).containsOnly((Object[])new ObjectInfo[]{this.localButton});
        Assertions.assertThat((List)this.myPanel.getChildrenComponents()).containsOnly((Object[])new ComponentInfo[]{this.localButton, this.emptyButton});
        Assertions.assertThat((List)this.myPanel.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{this.arrayInfo, newArrayInfo});
        this.myPanel.refresh();
        ArrayObjectTest.assertNotNull((Object)this.localButton.getObject());
        ArrayObjectTest.assertNotNull((Object)this.emptyButton.getObject());
        newArrayInfo.command_MOVE((JavaInfo)this.emptyButton, null);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons(new JButton[]{button, new JButton()});", "  }", "}");
        Assertions.assertThat((List)this.myPanel.getChildrenComponents()).containsOnly((Object[])new ComponentInfo[]{this.localButton, this.emptyButton});
        Assertions.assertThat((List)this.myPanel.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{newArrayInfo});
        Assertions.assertThat((List)newArrayInfo.getItems()).containsOnly((Object[])new ObjectInfo[]{this.localButton, this.emptyButton});
        this.myPanel.refresh();
        ArrayObjectTest.assertNotNull((Object)this.localButton.getObject());
        ArrayObjectTest.assertNotNull((Object)this.emptyButton.getObject());
    }

    @Test
    public void test_moveItemOutside() throws Exception {
        this.getParsedContainer(new String[]{"public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton() } );", "    {", "      JButton button_1 = new JButton();", "      button_1.setText('Button');", "      add(button_1);", "    }", "  }", "}"});
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.localButton), (long)0L);
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.emptyButton), (long)1L);
        Assertions.assertThat((int)this.myPanel.getChildrenComponents().indexOf(this.localButton)).isLessThan(this.myPanel.getChildrenComponents().indexOf(this.emptyButton));
        Assertions.assertThat((List)this.myPanel.getChildrenComponents()).hasSize(3);
        ComponentInfo newButton = (ComponentInfo)this.myPanel.getChildrenComponents().get(2);
        this.arrayInfo.command_MOVE((JavaInfo)newButton, (JavaInfo)this.emptyButton);
        this.assertEditor("public class Test extends MyPanel {", "  private JButton button_1;", "  public Test() {", "    JButton button = new JButton();", "    {", "      button_1 = new JButton();", "      button_1.setText('Button');", "    }", "    addButtons( new JButton[] { button, button_1, new JButton() } );", "  }", "}");
        Assertions.assertThat((List)this.arrayInfo.getItems()).containsOnly((Object[])new ObjectInfo[]{this.localButton, this.emptyButton, newButton});
        Assertions.assertThat((List)this.myPanel.getChildrenComponents()).containsOnly((Object[])new ComponentInfo[]{this.localButton, this.emptyButton, newButton});
        Assertions.assertThat((List)this.myPanel.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{this.arrayInfo});
        this.myPanel.refresh();
        ArrayObjectTest.assertNotNull((Object)this.localButton.getObject());
        ArrayObjectTest.assertNotNull((Object)this.emptyButton.getObject());
        ArrayObjectTest.assertNotNull((Object)newButton.getObject());
        newButton.delete();
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton() } );", "  }", "}");
        this.myPanel.refresh();
        ArrayObjectTest.assertNotNull((Object)this.localButton.getObject());
        ArrayObjectTest.assertNotNull((Object)this.emptyButton.getObject());
    }

    @Test
    public void test_moveItemOutside_inlined() throws Exception {
        this.getParsedContainer(new String[]{"public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton() } );", "    add(new JButton('Button'));", "  }", "}"});
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.localButton), (long)0L);
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.emptyButton), (long)1L);
        Assertions.assertThat((int)this.myPanel.getChildrenComponents().indexOf(this.localButton)).isLessThan(this.myPanel.getChildrenComponents().indexOf(this.emptyButton));
        Assertions.assertThat((List)this.myPanel.getChildrenComponents()).hasSize(3);
        ComponentInfo newButton = (ComponentInfo)this.myPanel.getChildrenComponents().get(2);
        this.arrayInfo.command_MOVE((JavaInfo)newButton, (JavaInfo)this.emptyButton);
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton('Button'), new JButton() } );", "  }", "}");
        Assertions.assertThat((List)this.arrayInfo.getItems()).containsOnly((Object[])new ObjectInfo[]{this.localButton, this.emptyButton, newButton});
        Assertions.assertThat((List)this.myPanel.getChildrenComponents()).containsOnly((Object[])new ComponentInfo[]{this.localButton, this.emptyButton, newButton});
        Assertions.assertThat((List)this.myPanel.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{this.arrayInfo});
        this.myPanel.refresh();
        ArrayObjectTest.assertNotNull((Object)this.localButton.getObject());
        ArrayObjectTest.assertNotNull((Object)this.emptyButton.getObject());
        ArrayObjectTest.assertNotNull((Object)newButton.getObject());
        newButton.delete();
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton() } );", "  }", "}");
        this.myPanel.refresh();
        ArrayObjectTest.assertNotNull((Object)this.localButton.getObject());
        ArrayObjectTest.assertNotNull((Object)this.emptyButton.getObject());
    }

    @Test
    public void test_moveItemOutside_inlining() throws Exception {
        this.getParsedContainer();
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.localButton), (long)0L);
        ArrayObjectTest.assertEquals((long)this.arrayInfo.getItems().indexOf(this.emptyButton), (long)1L);
        Assertions.assertThat((int)this.myPanel.getChildrenComponents().indexOf(this.localButton)).isLessThan(this.myPanel.getChildrenComponents().indexOf(this.emptyButton));
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)this.myPanel.getLayout();
        ComponentInfo newButton = ArrayObjectTest.createComponent("javax.swing.JButton");
        flowLayout.add(newButton, null);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton() } );", "    {", "      JButton button_1 = new JButton('New button');", "      add(button_1);", "    }", "  }", "}");
        Assertions.assertThat((List)this.myPanel.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{this.arrayInfo, newButton});
        Assertions.assertThat((List)this.myPanel.getChildrenComponents()).containsOnly((Object[])new ComponentInfo[]{this.localButton, this.emptyButton, newButton});
        this.arrayInfo.command_MOVE((JavaInfo)newButton, (JavaInfo)this.emptyButton);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton('New button'), new JButton() } );", "  }", "}");
        Assertions.assertThat((List)this.arrayInfo.getItems()).containsOnly((Object[])new ObjectInfo[]{this.localButton, this.emptyButton, newButton});
        Assertions.assertThat((List)this.myPanel.getChildrenComponents()).containsOnly((Object[])new ComponentInfo[]{this.localButton, this.emptyButton, newButton});
        Assertions.assertThat((List)this.myPanel.getPresentation().getChildrenTree()).containsOnly((Object[])new ObjectInfo[]{this.arrayInfo});
        this.myPanel.refresh();
        ArrayObjectTest.assertNotNull((Object)this.localButton.getObject());
        ArrayObjectTest.assertNotNull((Object)this.emptyButton.getObject());
        ArrayObjectTest.assertNotNull((Object)newButton.getObject());
        newButton.delete();
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton() } );", "  }", "}");
        this.myPanel.refresh();
        ArrayObjectTest.assertNotNull((Object)this.localButton.getObject());
        ArrayObjectTest.assertNotNull((Object)this.emptyButton.getObject());
    }

    private void checkArrayItem(ComponentInfo item) {
        Association association = item.getAssociation();
        ArrayObjectTest.assertInstanceOf(InvocationChildArrayAssociation.class, (Object)association);
        ArrayObjectTest.assertSame((Object)item, (Object)association.getJavaInfo());
    }

    private void getParsedContainer() throws Exception {
        this.getParsedContainer(new String[]{"// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    JButton button = new JButton();", "    addButtons( new JButton[] { button, new JButton() } );", "  }", "}"});
    }

    private void getParsedContainer(String[] sourceLines) throws Exception {
        this.configureProject2();
        this.myPanel = this.parseContainer(sourceLines);
        Assertions.assertThat((List)this.myPanel.getChildren(ArrayObjectInfo.class)).hasSize(1);
        Assertions.assertThat((int)this.myPanel.getChildren(ComponentInfo.class).size()).isGreaterThanOrEqualTo(2);
        this.arrayInfo = (ArrayObjectInfo)this.myPanel.getChildren(ArrayObjectInfo.class).get(0);
        this.localButton = (ComponentInfo)this.myPanel.getChildrenComponents().get(0);
        this.emptyButton = (ComponentInfo)this.myPanel.getChildrenComponents().get(1);
    }

    private void configureProject2() throws Exception {
        ArrayObjectTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addButtons(JButton[] buttons) {", "  }", "}"));
        ArrayObjectTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ArrayObjectTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='addButtons'>", "      <parameter type='javax.swing.JButton[]' child='true'>", "        <tag name='arrayObject.removeOnEmpty' value='true'/>", "      </parameter>", "    </method>", "  </methods>", "</component>"));
        ArrayObjectTest.waitForAutoBuild();
    }
}

