/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval.other;

import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.Before;
import org.junit.Test;

public class FieldTest
extends AbstractEngineTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            FieldTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_beanFieldValue() throws Exception {
        FieldTest.setFileContentSrc("test/TestBean.java", FieldTest.getSourceDQ("package test;", "class TestBean {", "  public int value = 5;", "}"));
        FieldTest.waitForAutoBuild();
        FieldTest.assertEquals((Object)5, (Object)this.evaluateExpression("new TestBean().value", "int"));
    }

    @Test
    public void test_localFieldValue_thisQualifier() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {", "  private int value = 5;", "  int foo() {", "    return this.value;", "  }", "}");
        FieldTest.assertEquals((Object)5, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_localFieldValue_defaultValue_false() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {", "  private boolean value;", "  boolean foo() {", "    return this.value;", "  }", "}");
        FieldTest.assertEquals((Object)false, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_localFieldValue_defaultValue_zero() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {", "  private int value;", "  int foo() {", "    return this.value;", "  }", "}");
        FieldTest.assertEquals((Object)0, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_localFieldValue_defaultValue_null() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {", "  private Object value;", "  Object foo() {", "    return this.value;", "  }", "}");
        FieldTest.assertEquals(null, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }

    @Test
    public void test_localFieldValue_noQualifier() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {", "  private int value = 5;", "  int foo() {", "    return value;", "  }", "}");
        FieldTest.assertEquals((Object)5, (Object)this.evaluateSingleMethod(typeDeclaration, "foo()"));
    }
}

