/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.eclipse.wb.tests.designer.tests.Activator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.osgi.framework.Bundle;

public final class TestUtils {
    private static final String EXTENSION_ID = "testExtension";
    private static Bundle m_contributionBundle;

    private TestUtils() {
    }

    public static IFile createImagePNG(TestProject testProject, String path, int width, int height) throws Exception {
        byte[] bytes = TestUtils.createImagePNG(width, height);
        IFile file = testProject.getProject().getFile((IPath)new Path(path));
        IOUtils2.setFileContents((IFile)file, (InputStream)new ByteArrayInputStream(bytes));
        return file;
    }

    public static byte[] createImagePNG(int width, int height) {
        Image image = new Image(null, width, height);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{image.getImageData()};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        imageLoader.save((OutputStream)baos, 5);
        image.dispose();
        return baos.toByteArray();
    }

    public static void closeAllViews() {
        while (Display.getCurrent().readAndDispatch()) {
        }
        IWorkbenchPage activePage = DesignerPlugin.getActivePage();
        IViewReference[] viewReferences = activePage.getViewReferences();
        if (viewReferences.length != 0) {
            IViewReference[] iViewReferenceArray = viewReferences;
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewReference = iViewReferenceArray[n2];
                activePage.hideView(viewReference);
                ++n2;
            }
            TestUtils.waitEventLoop(100);
        }
    }

    public static void closeAllEditors() {
        while (Display.getCurrent().readAndDispatch()) {
        }
        IWorkbenchPage activePage = DesignerPlugin.getActivePage();
        activePage.closeAllEditors(false);
    }

    private static Bundle getContributorBundle() {
        if (m_contributionBundle != null) {
            return m_contributionBundle;
        }
        return Activator.getDefault().getBundle();
    }

    public static void setContributionBundle(Bundle contributionBundle) {
        m_contributionBundle = contributionBundle;
    }

    private static String getQualifiedExtensionId(String simpleId) {
        return TestUtils.getContributorBundle().getSymbolicName() + "." + simpleId;
    }

    public static void addDynamicExtension(String pointId, String contribution) {
        TestUtils.addDynamicExtension(pointId, EXTENSION_ID, contribution);
    }

    public static void addDynamicExtension(String pointId, String extensionId, String contribution) {
        contribution = "<extension point='%pointId%' id='%extensionId%'>\n" + (String)contribution + "\n</extension>";
        TestUtils.addDynamicExtension2(pointId, extensionId, (String)contribution);
    }

    public static void addDynamicExtension2(String pointId, String extensionId, String contribution) {
        contribution = "<plugin>\n" + (String)contribution + "\n</plugin>";
        contribution = StringUtils.replace((String)contribution, (String)"%pointId%", (String)pointId);
        contribution = StringUtils.replace((String)contribution, (String)"%extensionId%", (String)extensionId);
        Bundle bundle = TestUtils.getContributorBundle();
        IContributor contributor = ContributorFactoryOSGi.createContributor((Bundle)bundle);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        Object userToken = ((ExtensionRegistry)registry).getTemporaryUserToken();
        registry.addContribution((InputStream)new ByteArrayInputStream(((String)contribution).getBytes()), contributor, false, null, null, userToken);
        String qualifiedExtensionId = TestUtils.getQualifiedExtensionId(extensionId);
        while (ExternalFactoriesHelper.getExtension((String)pointId, (String)qualifiedExtensionId) == null) {
            TestUtils.waitEventLoop(1);
        }
    }

    public static void removeDynamicExtension(String pointId) {
        TestUtils.removeDynamicExtension(pointId, EXTENSION_ID);
    }

    public static void removeDynamicExtension_noWait(String pointId) {
        TestUtils.doRemoveDynamicExtension(pointId, EXTENSION_ID);
    }

    public static void removeDynamicExtension(String pointId, String extensionId) {
        String qualifiedExtensionId = TestUtils.getQualifiedExtensionId(extensionId);
        while (ExternalFactoriesHelper.getExtension((String)pointId, (String)qualifiedExtensionId) != null) {
            TestUtils.doRemoveDynamicExtension(pointId, extensionId);
            TestUtils.waitEventLoop(1);
        }
    }

    private static void doRemoveDynamicExtension(String pointId, String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension extension = registry.getExtension(pointId, TestUtils.getQualifiedExtensionId(extensionId));
        Object userToken = ((ExtensionRegistry)registry).getTemporaryUserToken();
        registry.removeExtension(extension, userToken);
    }

    public static void waitEventLoop(int time) {
        long start = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            while (Display.getCurrent().readAndDispatch()) {
            }
        } while (System.currentTimeMillis() - start < (long)time);
    }

    public static void runWizard(IWizard wizard, IStructuredSelection selection) {
        IWorkbenchWindow workbenchWindow = DesignerPlugin.getActiveWorkbenchWindow();
        if (wizard instanceof IWorkbenchWizard) {
            ((IWorkbenchWizard)wizard).init(workbenchWindow.getWorkbench(), selection);
        }
        WizardDialog dialog = new WizardDialog(workbenchWindow.getShell(), wizard);
        dialog.create();
        String title = wizard.getWindowTitle();
        if (title != null) {
            dialog.getShell().setText(title);
        }
        dialog.open();
    }

    public static String createTemporaryJar(String entryName, String content) throws Exception {
        File tempFile = File.createTempFile("wbpTests", ".jar");
        tempFile.deleteOnExit();
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(tempFile));
        jarOutputStream.putNextEntry(new ZipEntry(entryName));
        jarOutputStream.write(content.getBytes());
        jarOutputStream.closeEntry();
        jarOutputStream.close();
        return tempFile.getAbsolutePath();
    }

    public static void sortTestSuiteMethods(Class<?> clazz, TestSuite suite) {
        try {
            final List<String> sourceMethodNames = TestUtils.getSourceMethodNames(clazz);
            Vector<TestCase> tests = TestUtils.getTestsVector(suite);
            Collections.sort(tests, new Comparator<TestCase>(){

                @Override
                public int compare(TestCase o1, TestCase o2) {
                    String method_1 = o1.getName();
                    String method_2 = o2.getName();
                    if ("test_setUp".equals(method_1)) {
                        return -1;
                    }
                    if ("test_setUp".equals(method_2)) {
                        return 1;
                    }
                    if ("test_tearDown".equals(method_1)) {
                        return 1;
                    }
                    if ("test_tearDown".equals(method_2)) {
                        return -1;
                    }
                    return sourceMethodNames.indexOf(method_1) - sourceMethodNames.indexOf(method_2);
                }
            });
        }
        catch (Throwable e) {
            ReflectionUtils.propagate((Throwable)e);
        }
    }

    private static List<String> getSourceMethodNames(Class<?> testClass) throws Exception {
        final ArrayList<String> sourceMethodNames = new ArrayList<String>();
        String classPath = testClass.getName().replace('.', '/') + ".class";
        InputStream classStream = testClass.getClassLoader().getResourceAsStream(classPath);
        ClassReader classReader = new ClassReader(classStream);
        classReader.accept(new ClassVisitor(589824){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                sourceMethodNames.add(name);
                return new MethodVisitor(589824){};
            }
        }, 0);
        return sourceMethodNames;
    }

    private static Vector<TestCase> getTestsVector(TestSuite suite) throws Exception {
        Field testsField = TestSuite.class.getDeclaredField("fTests");
        testsField.setAccessible(true);
        Vector tests = (Vector)testsField.get(suite);
        return tests;
    }
}

