/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.geometry;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.geometry.AbstractGeometryDialog;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.support.PointSupport;

public final class PointPropertyEditor
extends TextDialogPropertyEditor {
    public static final PropertyEditor INSTANCE = new PointPropertyEditor();

    private PointPropertyEditor() {
    }

    protected String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value == Property.UNKNOWN_VALUE) {
            return null;
        }
        return PointSupport.toString(value);
    }

    protected void openDialog(Property property) throws Exception {
        Object value = property.getValue();
        Object point = value == Property.UNKNOWN_VALUE ? PointSupport.newPoint(0, 0) : PointSupport.getPointCopy(value);
        PointDialog pointDialog = new PointDialog(property.getTitle(), point);
        int result = pointDialog.open();
        if (result == 9) {
            property.setValue(Property.UNKNOWN_VALUE);
        } else if (result == 0) {
            property.setValue(point);
        }
    }

    private static final class PointDialog
    extends AbstractGeometryDialog {
        public PointDialog(String title, Object point) {
            super(title, point);
        }

        protected void createEditors() {
            this.createEditor(ModelMessages.PointPropertyEditor_xLabel, "x");
            this.createEditor(ModelMessages.PointPropertyEditor_yLabel, "y");
        }
    }
}

