/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.AnonymousTypeDeclaration;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.ListGatherer;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;

public class AstNodeUtils {
    public static final Comparator<ASTNode> SORT_BY_POSITION = new Comparator<ASTNode>(){

        @Override
        public int compare(ASTNode o1, ASTNode o2) {
            return o1.getStartPosition() - o2.getStartPosition();
        }
    };
    public static final Comparator<ASTNode> SORT_BY_REVERSE_POSITION = new Comparator<ASTNode>(){

        @Override
        public int compare(ASTNode o1, ASTNode o2) {
            return o2.getStartPosition() - o1.getStartPosition();
        }
    };
    public static String NO_TYPE_BINDING_NAME = "__WBP_NO_TYPE_BINDING";
    private static final Map<ITypeBinding, Map<String, Boolean>> m_isSuccessorOf = new WeakHashMap<ITypeBinding, Map<String, Boolean>>();
    public static String NO_METHOD_BINDING_SIGNATURE = "__WBP_NO_METHOD_BINDING";
    private static final int VISIBILITY_MASK = 7;

    private AstNodeUtils() {
    }

    public static IMethodBinding getMethodBinding(MethodInvocation invocation) {
        Assert.isNotNull((Object)invocation);
        IMethodBinding binding = (IMethodBinding)invocation.getProperty("METHOD_BINDING");
        if (binding != null) {
            return binding;
        }
        return invocation.resolveMethodBinding();
    }

    public static IMethodBinding getMethodBinding(SuperMethodInvocation invocation) {
        Assert.isNotNull((Object)invocation);
        IMethodBinding binding = (IMethodBinding)invocation.getProperty("METHOD_BINDING");
        if (binding != null) {
            return binding;
        }
        return invocation.resolveMethodBinding();
    }

    public static IMethodBinding getMethodBinding(MethodDeclaration methodDeclaration) {
        Assert.isNotNull((Object)methodDeclaration);
        IMethodBinding binding = (IMethodBinding)methodDeclaration.getProperty("METHOD_BINDING");
        if (binding != null) {
            return binding;
        }
        return methodDeclaration.resolveBinding();
    }

    /*
     * WARNING - void declaration
     */
    public static IVariableBinding getVariableBinding(ASTNode node) {
        ASTNode aSTNode;
        FieldAccess binding;
        ASTNode aSTNode2;
        SimpleName binding2;
        Assert.isNotNull((Object)node);
        IVariableBinding binding3 = (IVariableBinding)node.getProperty("VARIABLE_BINDING");
        if (binding3 != null) {
            return binding3;
        }
        ASTNode aSTNode3 = node;
        if (aSTNode3 instanceof VariableDeclaration) {
            void variableDeclaration;
            binding3 = (VariableDeclaration)aSTNode3;
            VariableDeclaration cfr_ignored_0 = (VariableDeclaration)aSTNode3;
            binding2 = variableDeclaration.resolveBinding();
            if (binding2 != null) {
                return binding2;
            }
        }
        if ((aSTNode2 = node) instanceof SimpleName) {
            void simpleName;
            binding2 = (SimpleName)aSTNode2;
            SimpleName cfr_ignored_1 = (SimpleName)aSTNode2;
            binding = simpleName.resolveBinding();
            if (binding instanceof IVariableBinding) {
                return (IVariableBinding)binding;
            }
        }
        if ((aSTNode = node) instanceof FieldAccess) {
            void fieldAccess;
            binding = (FieldAccess)aSTNode;
            FieldAccess cfr_ignored_2 = (FieldAccess)aSTNode;
            return fieldAccess.resolveFieldBinding();
        }
        return null;
    }

    public static ITypeBinding getTypeBinding(Expression expression) {
        Assert.isNotNull((Object)expression);
        ITypeBinding binding = (ITypeBinding)expression.getProperty("TYPE_BINDING");
        if (binding != null) {
            return binding;
        }
        return expression.resolveTypeBinding();
    }

    public static ITypeBinding getTypeBinding(AnonymousClassDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        ITypeBinding binding = (ITypeBinding)declaration.getProperty("TYPE_BINDING");
        if (binding != null) {
            return binding;
        }
        return declaration.resolveBinding();
    }

    public static ITypeBinding getTypeBinding(Type type) {
        Assert.isNotNull((Object)type);
        ITypeBinding binding = (ITypeBinding)type.getProperty("TYPE_BINDING");
        if (binding != null) {
            return binding;
        }
        return type.resolveBinding();
    }

    public static ITypeBinding getTypeBinding(TypeDeclaration typeDeclaration) {
        return AstNodeUtils.getTypeBinding((AbstractTypeDeclaration)typeDeclaration);
    }

    public static ITypeBinding getTypeBinding(AbstractTypeDeclaration typeDeclaration) {
        Assert.isNotNull((Object)typeDeclaration);
        ITypeBinding binding = (ITypeBinding)typeDeclaration.getProperty("TYPE_BINDING");
        if (binding != null) {
            return binding;
        }
        binding = typeDeclaration.resolveBinding();
        Assert.isTrueException((binding != null ? 1 : 0) != 0, (int)204, (Object[])new Object[]{typeDeclaration});
        return binding;
    }

    public static ITypeBinding getTypeBinding(SingleVariableDeclaration parameter) {
        Assert.isNotNull((Object)parameter);
        IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)parameter);
        if (variableBinding == null) {
            return null;
        }
        return variableBinding.getType();
    }

    public static ITypeBinding getTypeBinding(VariableDeclaration variable) {
        Assert.isNotNull((Object)variable);
        if (variable.getParent() instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)variable.getParent();
            return AstNodeUtils.getTypeBinding(fieldDeclaration.getType());
        }
        if (variable instanceof SingleVariableDeclaration) {
            return AstNodeUtils.getTypeBinding((SingleVariableDeclaration)variable);
        }
        if (variable.getParent() instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement statement = (VariableDeclarationStatement)variable.getParent();
            return AstNodeUtils.getTypeBinding(statement.getType());
        }
        VariableDeclarationExpression statement = (VariableDeclarationExpression)variable.getParent();
        return AstNodeUtils.getTypeBinding(statement.getType());
    }

    public static ITypeBinding getTypeBindingArgument(ITypeBinding typeBinding, int typeArgumentIndex) {
        ITypeBinding[] typeArgumentBindings = typeBinding.getTypeArguments();
        if (typeArgumentBindings.length != 0) {
            ITypeBinding typeArgumentBinding = typeArgumentBindings[typeArgumentIndex];
            return typeArgumentBinding;
        }
        ITypeBinding[] typeParameters = typeBinding.getTypeDeclaration().getTypeParameters();
        return typeParameters[typeArgumentIndex].getTypeBounds()[0];
    }

    public static ITypeBinding getTypeBindingArgument(ITypeBinding typeBinding, String baseClassName, int typeParameterIndex) {
        while (typeBinding != null) {
            String qualifiedName = AstNodeUtils.getFullyQualifiedName(typeBinding, false);
            if (baseClassName.equals(qualifiedName)) {
                return AstNodeUtils.getTypeBindingArgument(typeBinding, typeParameterIndex);
            }
            typeBinding = typeBinding.getSuperclass();
        }
        throw new IllegalArgumentException(baseClassName + " is not super class for given binding.");
    }

    private static ITypeBinding getTypeVariableBound(ITypeBinding typeBinding) {
        Assert.isLegal((boolean)typeBinding.isTypeVariable());
        ITypeBinding[] typeBounds = typeBinding.getTypeBounds();
        if (typeBounds.length != 0) {
            return typeBounds[0];
        }
        return null;
    }

    public static ITypeBinding getGenericDeclaringClass(ITypeBinding typeBinding) {
        ITypeBinding declaringClass = typeBinding.getDeclaringClass();
        if (declaringClass != null) {
            return declaringClass.getTypeDeclaration();
        }
        return declaringClass;
    }

    public static String getFullyQualifiedName(Expression expression, boolean runtime) {
        ITypeBinding binding = AstNodeUtils.getTypeBinding(expression);
        String fullyQualifiedName = AstNodeUtils.getFullyQualifiedName(binding, runtime);
        if (binding != null && binding.isAnonymous()) {
            fullyQualifiedName = AstNodeUtils.getFullyQualifiedName_appendAnonymous(expression, runtime, fullyQualifiedName);
        }
        return fullyQualifiedName;
    }

    private static String getFullyQualifiedName_appendAnonymous(Expression expression, final boolean runtime, String fullyQualifiedName) {
        final AnonymousClassDeclaration acd = ((ClassInstanceCreation)expression).getAnonymousClassDeclaration();
        final String[] suffix = new String[1];
        expression.getRoot().accept(new ASTVisitor(){
            private final int[] m_counts = new int[32];
            private int m_level = 0;

            public boolean visit(AnonymousClassDeclaration node) {
                int n = this.m_level;
                this.m_counts[n] = this.m_counts[n] + 1;
                if (node == acd) {
                    StringBuilder sb = new StringBuilder();
                    String separator = runtime ? "$" : ".";
                    int i = 0;
                    while (i <= this.m_level) {
                        sb.append(separator);
                        sb.append(this.m_counts[i]);
                        ++i;
                    }
                    suffix[0] = sb.toString();
                }
                this.m_counts[++this.m_level] = 0;
                return suffix[0] == null;
            }

            public void endVisit(AnonymousClassDeclaration node) {
                --this.m_level;
            }
        });
        fullyQualifiedName = StringUtils.stripEnd((String)fullyQualifiedName, (String)"$.");
        fullyQualifiedName = (String)fullyQualifiedName + suffix[0];
        return fullyQualifiedName;
    }

    public static String getFullyQualifiedName(Type type, boolean runtime) {
        ITypeBinding binding = AstNodeUtils.getTypeBinding(type);
        return AstNodeUtils.getFullyQualifiedName(binding, runtime);
    }

    public static String getFullyQualifiedName(final TypeDeclaration typeDeclaration, final boolean runtime) {
        String key = "getFullyQualifiedName_TypeDeclaration";
        return AstNodeUtils.getValue((ASTNode)typeDeclaration, key, new RunnableObjectEx<String>(){

            public String runObject() throws Exception {
                ITypeBinding binding = AstNodeUtils.getTypeBinding(typeDeclaration);
                return AstNodeUtils.getFullyQualifiedName(binding, runtime);
            }
        });
    }

    public static String getFullyQualifiedName(SingleVariableDeclaration parameter, boolean runtime) {
        ITypeBinding binding = AstNodeUtils.getTypeBinding(parameter);
        return AstNodeUtils.getFullyQualifiedName(binding, runtime);
    }

    public static String getFullyQualifiedName(ITypeBinding binding, boolean runtime) {
        return AstNodeUtils.getFullyQualifiedName(binding, runtime, false);
    }

    public static String getFullyQualifiedName(ITypeBinding binding, boolean runtime, boolean withGenerics) {
        ITypeBinding[] typeArguments;
        Object scope;
        if (binding == null) {
            return NO_TYPE_BINDING_NAME;
        }
        if (binding.isPrimitive()) {
            return binding.getName();
        }
        if (binding.isArray()) {
            StringBuilder sb = new StringBuilder();
            ITypeBinding elementType = binding.getElementType();
            String elementTypeQualifiedName = AstNodeUtils.getFullyQualifiedName(elementType, runtime);
            sb.append(elementTypeQualifiedName);
            int i = 0;
            while (i < binding.getDimensions()) {
                sb.append("[]");
                ++i;
            }
            return sb.toString();
        }
        ITypeBinding declaringType = binding.getDeclaringClass();
        if (declaringType == null) {
            IPackageBinding packageBinding = binding.getPackage();
            scope = packageBinding == null || packageBinding.isUnnamed() ? "" : packageBinding.getName() + ".";
        } else {
            if (binding.isTypeVariable()) {
                return binding.getName();
            }
            scope = AstNodeUtils.getFullyQualifiedName(declaringType, runtime);
            scope = runtime ? (String)scope + "$" : (String)scope + ".";
        }
        String jdtName = binding.getName();
        String name = StringUtils.substringBefore((String)jdtName, (String)"<");
        if (withGenerics && (typeArguments = binding.getTypeArguments()).length != 0) {
            StringBuilder sb = new StringBuilder(name);
            sb.append("<");
            ITypeBinding[] iTypeBindingArray = typeArguments;
            int n = typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeArgument = iTypeBindingArray[n2];
                if (sb.charAt(sb.length() - 1) != '<') {
                    sb.append(",");
                }
                String typeArgumentName = AstNodeUtils.getFullyQualifiedName(typeArgument, runtime, withGenerics);
                sb.append(typeArgumentName);
                ++n2;
            }
            sb.append(">");
            name = sb.toString();
        }
        return (String)scope + name;
    }

    public static boolean isSuccessorOf(Expression expression, Class<?> clazz) {
        return AstNodeUtils.isSuccessorOf(AstNodeUtils.getTypeBinding(expression), clazz);
    }

    public static boolean isSuccessorOf(Expression expression, ITypeBinding requiredBinding) {
        return AstNodeUtils.isSuccessorOf(AstNodeUtils.getTypeBinding(expression), requiredBinding);
    }

    public static boolean isSuccessorOf(Expression expression, String className) {
        return AstNodeUtils.isSuccessorOf(AstNodeUtils.getTypeBinding(expression), className);
    }

    public static boolean isSuccessorOf(SingleVariableDeclaration parameter, String className) {
        return AstNodeUtils.isSuccessorOf(AstNodeUtils.getTypeBinding(parameter), className);
    }

    public static boolean isSuccessorOf(Type type, String className) {
        return AstNodeUtils.isSuccessorOf(AstNodeUtils.getTypeBinding(type), className);
    }

    public static boolean isSuccessorOf(TypeDeclaration type, String className) {
        return AstNodeUtils.isSuccessorOf(AstNodeUtils.getTypeBinding(type), className);
    }

    public static boolean isSuccessorOf(AnonymousClassDeclaration declaration, String className) {
        return AstNodeUtils.isSuccessorOf(AstNodeUtils.getTypeBinding(declaration), className);
    }

    public static boolean isSuccessorOf(ITypeBinding binding, Class<?> clazz) {
        Assert.isNotNull(clazz);
        return AstNodeUtils.isSuccessorOf(binding, clazz.getName());
    }

    public static boolean isSuccessorOf(ITypeBinding binding, ITypeBinding requiredBinding) {
        Assert.isNotNull((Object)requiredBinding);
        return AstNodeUtils.isSuccessorOf(binding, AstNodeUtils.getFullyQualifiedName(requiredBinding, false));
    }

    public static boolean isSuccessorOf(ITypeBinding binding, String className) {
        Boolean result;
        Assert.isNotNull((Object)className);
        if (binding == null) {
            return "java.lang.Object".equals(className);
        }
        Map<String, Boolean> classNameResults = m_isSuccessorOf.get(binding);
        if (classNameResults == null) {
            classNameResults = new TreeMap<String, Boolean>();
            m_isSuccessorOf.put(binding, classNameResults);
        }
        if ((result = classNameResults.get(className)) == null) {
            result = AstNodeUtils.isSuccessorOf0(binding, className);
            classNameResults.put(className, result);
        }
        return result;
    }

    private static boolean isSuccessorOf0(ITypeBinding binding, String className) {
        if (AstNodeUtils.getFullyQualifiedName(binding, false).equals(className)) {
            return true;
        }
        if (binding.isArray() && "java.lang.Object".equals(className)) {
            return true;
        }
        boolean result = AstNodeUtils.isSuccessorOf(binding.getSuperclass(), className);
        if (result) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = binding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interfaceBinding = iTypeBindingArray[n2];
            if (AstNodeUtils.isSuccessorOf(interfaceBinding, className)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isSuccessorOf(ITypeBinding binding, String ... classNames) {
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            if (AstNodeUtils.isSuccessorOf(binding, className)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static TypeDeclaration getTypeByName(CompilationUnit compilationUnit, String typeName) {
        Assert.isNotNull((Object)compilationUnit);
        Assert.isNotNull((Object)typeName);
        for (TypeDeclaration typeDeclaration : DomGenerics.types(compilationUnit)) {
            ITypeBinding typeBinding = typeDeclaration.resolveBinding();
            if (typeBinding == null || !typeBinding.getName().equals(typeName)) continue;
            return typeDeclaration;
        }
        return null;
    }

    public static TypeDeclaration getTypeByQualifiedName(CompilationUnit compilationUnit, final String typeName) {
        Assert.isNotNull((Object)compilationUnit);
        Assert.isNotNull((Object)typeName);
        final TypeDeclaration[] typeDeclaration = new TypeDeclaration[1];
        compilationUnit.accept(new ASTVisitor(){

            public void postVisit(ASTNode node) {
                ClassInstanceCreation creation;
                String _typeName;
                if (typeDeclaration[0] == null && node.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY && ((ClassInstanceCreation)node.getParent()).getAnonymousClassDeclaration() != null && (_typeName = AstNodeUtils.getFullyQualifiedName((Expression)(creation = (ClassInstanceCreation)node.getParent()), true)).equals(typeName)) {
                    AnonymousClassDeclaration anonymousClassDeclaration = creation.getAnonymousClassDeclaration();
                    typeDeclaration[0] = AnonymousTypeDeclaration.create(anonymousClassDeclaration);
                }
            }

            public boolean visit(SimpleName node) {
                String _typeName;
                if (typeDeclaration[0] == null && node.getLocationInParent() == TypeDeclaration.NAME_PROPERTY && (_typeName = AstNodeUtils.getFullyQualifiedName((Expression)node, true)).equals(typeName)) {
                    typeDeclaration[0] = (TypeDeclaration)node.getParent();
                }
                return typeDeclaration[0] == null;
            }
        });
        return typeDeclaration[0];
    }

    public static TypeDeclaration getTypeDeclaration(ClassInstanceCreation creation) {
        final String typeName = AstNodeUtils.getFullyQualifiedName(AstNodeUtils.getTypeBinding((Expression)creation), false);
        ListGatherer<TypeDeclaration> gatherer = new ListGatherer<TypeDeclaration>(){

            public boolean visit(TypeDeclaration node) {
                if (AstNodeUtils.getFullyQualifiedName(node, false).equals(typeName)) {
                    this.addResult(node);
                    return false;
                }
                return true;
            }
        };
        CompilationUnit compilationUnit = (CompilationUnit)creation.getRoot();
        compilationUnit.accept((ASTVisitor)gatherer);
        return (TypeDeclaration)gatherer.getUniqueResult();
    }

    public static String getMethodSignature(MethodInvocation methodInvocation) {
        Assert.isNotNull((Object)methodInvocation);
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(methodInvocation);
        return AstNodeUtils.getMethodSignature(methodBinding);
    }

    public static String getMethodSignature(MethodDeclaration methodDeclaration) {
        Assert.isNotNull((Object)methodDeclaration);
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(methodDeclaration);
        return AstNodeUtils.getMethodSignature(methodBinding);
    }

    public static String getMethodSignature(IMethodBinding methodBinding) {
        return AstNodeUtils.getMethodSignature(methodBinding, false);
    }

    public static String getMethodGenericSignature(IMethodBinding methodBinding) {
        return AstNodeUtils.getMethodSignature(methodBinding.getMethodDeclaration(), false);
    }

    public static String getMethodDeclarationSignature(IMethodBinding methodBinding) {
        return AstNodeUtils.getMethodSignature(methodBinding.getMethodDeclaration(), true);
    }

    private static String getMethodSignature(IMethodBinding methodBinding, boolean declaration) {
        if (methodBinding == null) {
            return NO_METHOD_BINDING_SIGNATURE;
        }
        StringBuilder buffer = new StringBuilder();
        if (methodBinding.isConstructor()) {
            buffer.append("<init>");
        } else {
            buffer.append(methodBinding.getName());
        }
        buffer.append('(');
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            ITypeBinding elementType;
            ITypeBinding parameterType = parameterTypes[i];
            if (i != 0) {
                buffer.append(',');
            }
            ITypeBinding iTypeBinding = elementType = parameterType.isArray() ? parameterType.getElementType() : parameterType;
            if (declaration && elementType.isTypeVariable()) {
                ITypeBinding variableBinding = AstNodeUtils.getTypeVariableBound(elementType);
                if (variableBinding == null) {
                    buffer.append("java.lang.Object");
                } else {
                    buffer.append(AstNodeUtils.getFullyQualifiedName(variableBinding, false));
                }
                if (parameterType.isArray()) {
                    buffer.append("[]");
                }
            } else {
                buffer.append(AstNodeUtils.getFullyQualifiedName(parameterType, false));
            }
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static List<String> getMethodSignatures(List<MethodDeclaration> methodDeclarations) {
        ArrayList<String> signatures = new ArrayList<String>();
        for (MethodDeclaration methodDeclaration : methodDeclarations) {
            signatures.add(AstNodeUtils.getMethodSignature(methodDeclaration));
        }
        return signatures;
    }

    public static MethodDeclaration getMethodBySignature(TypeDeclaration typeDeclaration, String signature) {
        Assert.isNotNull((Object)typeDeclaration);
        return AstNodeUtils.getMethodBySignature(DomGenerics.bodyDeclarations(typeDeclaration), signature);
    }

    /*
     * WARNING - void declaration
     */
    public static MethodDeclaration getMethodBySignature(List<BodyDeclaration> bodyDeclarations, String signature) {
        Assert.isNotNull(bodyDeclarations);
        Assert.isNotNull((Object)signature);
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            void methodDeclaration;
            BodyDeclaration bodyDeclaration2 = bodyDeclaration;
            if (!(bodyDeclaration2 instanceof MethodDeclaration)) continue;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)bodyDeclaration2;
            MethodDeclaration cfr_ignored_1 = (MethodDeclaration)bodyDeclaration2;
            if (!AstNodeUtils.getMethodSignature((MethodDeclaration)methodDeclaration).equals(signature)) continue;
            return methodDeclaration;
        }
        return null;
    }

    public static IMethodBinding getMethodBySignature(ITypeBinding typeBinding, String signature) {
        while (typeBinding != null) {
            IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding method = iMethodBindingArray[n2];
                if (AstNodeUtils.getMethodSignature(method).equals(signature)) {
                    return method;
                }
                ++n2;
            }
            typeBinding = typeBinding.getSuperclass();
        }
        return null;
    }

    public static MethodDeclaration getLocalMethodDeclaration(final MethodInvocation invocation) {
        String key;
        ASTNode unit = invocation.getRoot();
        Set<String> allNames = AstNodeUtils.getValue(unit, key = "getLocalMethodDeclaration.allMethods", new RunnableObjectEx<Set<String>>(){

            public Set<String> runObject() throws Exception {
                MethodDeclaration[] methods;
                TreeSet<String> names = new TreeSet<String>();
                TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)invocation);
                MethodDeclaration[] methodDeclarationArray = methods = typeDeclaration.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodDeclaration method = methodDeclarationArray[n2];
                    names.add(method.getName().getIdentifier());
                    ++n2;
                }
                return names;
            }
        });
        if (!allNames.contains(invocation.getName().getIdentifier())) {
            return null;
        }
        String key2 = "getLocalMethodDeclaration";
        return AstNodeUtils.getValue((ASTNode)invocation, key2, new RunnableObjectEx<MethodDeclaration>(){

            public MethodDeclaration runObject() throws Exception {
                return AstNodeUtils.getLocalMethodDeclaration0(invocation);
            }
        });
    }

    private static MethodDeclaration getLocalMethodDeclaration0(MethodInvocation invocation) {
        String targetTypeName;
        String enclosedTypeName;
        Assert.isNotNull((Object)invocation);
        TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)invocation);
        Expression targetExpression = invocation.getExpression();
        if (targetExpression != null && !(targetExpression instanceof ThisExpression) && !(enclosedTypeName = AstNodeUtils.getFullyQualifiedName(typeDeclaration, false)).equals(targetTypeName = AstNodeUtils.getFullyQualifiedName(targetExpression, false))) {
            return null;
        }
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(invocation);
        if (methodBinding == null) {
            return null;
        }
        String methodSignature = AstNodeUtils.getMethodSignature(methodBinding);
        return AstNodeUtils.getMethodBySignature(typeDeclaration, methodSignature);
    }

    public static List<MethodInvocation> getMethodInvocations(final MethodDeclaration methodDeclaration) {
        String key = "getMethodInvocations";
        return AstNodeUtils.getValue((ASTNode)methodDeclaration, key, new RunnableObjectEx<List<MethodInvocation>>(){

            public List<MethodInvocation> runObject() throws Exception {
                return AstNodeUtils.getMethodInvocations0(methodDeclaration);
            }
        });
    }

    private static List<MethodInvocation> getMethodInvocations0(MethodDeclaration methodDeclaration) {
        final ArrayList<MethodInvocation> invocations = new ArrayList<MethodInvocation>();
        IMethodBinding requiredBinding = AstNodeUtils.getMethodBinding(methodDeclaration);
        if (requiredBinding == null) {
            return invocations;
        }
        final String requiredType = AstNodeUtils.getFullyQualifiedName(requiredBinding.getDeclaringClass(), false);
        final String requiredSignature = AstNodeUtils.getMethodSignature(methodDeclaration);
        TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)methodDeclaration);
        typeDeclaration.accept(new ASTVisitor(){

            public void endVisit(MethodInvocation node) {
                IMethodBinding binding = AstNodeUtils.getMethodBinding(node);
                if (binding != null) {
                    String signature = AstNodeUtils.getMethodSignature(binding);
                    String type = AstNodeUtils.getFullyQualifiedName(binding.getDeclaringClass(), false);
                    if (signature.equals(requiredSignature) && type.equals(requiredType)) {
                        invocations.add(node);
                    }
                }
            }
        });
        return invocations;
    }

    /*
     * WARNING - void declaration
     */
    public static MethodDeclaration getMethodByName(TypeDeclaration typeDeclaration, String name) {
        Assert.isNotNull((Object)typeDeclaration);
        Assert.isNotNull((Object)name);
        List<BodyDeclaration> bodyDeclarations = DomGenerics.bodyDeclarations(typeDeclaration);
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            void methodDeclaration;
            BodyDeclaration bodyDeclaration2 = bodyDeclaration;
            if (!(bodyDeclaration2 instanceof MethodDeclaration)) continue;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)bodyDeclaration2;
            MethodDeclaration cfr_ignored_1 = (MethodDeclaration)bodyDeclaration2;
            if (!methodDeclaration.getName().getIdentifier().equals(name)) continue;
            return methodDeclaration;
        }
        return null;
    }

    public static String getSignature(ConstructorInvocation invocation) {
        Assert.isNotNull((Object)invocation);
        IMethodBinding methodBinding = AstNodeUtils.getBinding(invocation);
        return AstNodeUtils.getMethodSignature(methodBinding);
    }

    public static IMethodBinding getBinding(ConstructorInvocation invocation) {
        Assert.isNotNull((Object)invocation);
        return invocation.resolveConstructorBinding();
    }

    public static MethodDeclaration getConstructor(ConstructorInvocation invocation) {
        TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)invocation);
        String signature = AstNodeUtils.getSignature(invocation);
        return AstNodeUtils.getMethodBySignature(typeDeclaration, signature);
    }

    public static String getSuperSignature(SuperConstructorInvocation invocation) {
        Assert.isNotNull((Object)invocation);
        IMethodBinding methodBinding = AstNodeUtils.getSuperBinding(invocation);
        return AstNodeUtils.getMethodSignature(methodBinding);
    }

    public static IMethodBinding getSuperBinding(SuperConstructorInvocation invocation) {
        Assert.isNotNull((Object)invocation);
        IMethodBinding binding = (IMethodBinding)invocation.getProperty("METHOD_BINDING");
        if (binding != null) {
            return binding;
        }
        return invocation.resolveConstructorBinding();
    }

    public static String getCreationSignature(ClassInstanceCreation creation) {
        Assert.isNotNull((Object)creation);
        IMethodBinding methodBinding = AstNodeUtils.getCreationBinding(creation);
        return AstNodeUtils.getMethodSignature(methodBinding);
    }

    public static IMethodBinding getCreationBinding(ClassInstanceCreation creation) {
        Assert.isNotNull((Object)creation);
        IMethodBinding binding = (IMethodBinding)creation.getProperty("METHOD_BINDING");
        if (binding != null) {
            return binding;
        }
        return creation.resolveConstructorBinding();
    }

    public static MethodDeclaration getLocalConstructorDeclaration(final ClassInstanceCreation creation) {
        String key = "getLocalConstructorDeclaration";
        return AstNodeUtils.getValue((ASTNode)creation, key, new RunnableObjectEx<MethodDeclaration>(){

            public MethodDeclaration runObject() throws Exception {
                return AstNodeUtils.getLocalConstructorDeclaration0(creation);
            }
        });
    }

    private static MethodDeclaration getLocalConstructorDeclaration0(ClassInstanceCreation creation) {
        Assert.isNotNull((Object)creation);
        TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)creation);
        String enclosedTypeName = AstNodeUtils.getFullyQualifiedName(typeDeclaration, false);
        String createdTypeName = AstNodeUtils.getFullyQualifiedName((Expression)creation, false);
        if (!enclosedTypeName.equals(createdTypeName)) {
            return null;
        }
        IMethodBinding constructorBinding = AstNodeUtils.getCreationBinding(creation);
        String constructorSignature = AstNodeUtils.getMethodSignature(constructorBinding);
        return AstNodeUtils.getMethodBySignature(typeDeclaration, constructorSignature);
    }

    public static List<ConstructorInvocation> getConstructorInvocations(final MethodDeclaration methodDeclaration) {
        String key = "getConstructorInvocations";
        return AstNodeUtils.getValue((ASTNode)methodDeclaration, key, new RunnableObjectEx<List<ConstructorInvocation>>(){

            public List<ConstructorInvocation> runObject() throws Exception {
                return AstNodeUtils.getConstructorInvocations0(methodDeclaration);
            }
        });
    }

    private static List<ConstructorInvocation> getConstructorInvocations0(MethodDeclaration methodDeclaration) {
        final ArrayList<ConstructorInvocation> invocations = new ArrayList<ConstructorInvocation>();
        IMethodBinding requiredBinding = AstNodeUtils.getMethodBinding(methodDeclaration);
        if (requiredBinding == null) {
            return invocations;
        }
        final String requiredSignature = AstNodeUtils.getMethodSignature(methodDeclaration);
        TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)methodDeclaration);
        typeDeclaration.accept(new ASTVisitor(){

            public void endVisit(ConstructorInvocation node) {
                String signature;
                IMethodBinding binding = AstNodeUtils.getBinding(node);
                if (binding != null && (signature = AstNodeUtils.getMethodSignature(binding)).equals(requiredSignature)) {
                    invocations.add(node);
                }
            }
        });
        return invocations;
    }

    public static List<ClassInstanceCreation> getClassInstanceCreations(MethodDeclaration constructor) {
        final ArrayList<ClassInstanceCreation> creations = new ArrayList<ClassInstanceCreation>();
        final IMethodBinding constructorBinding = AstNodeUtils.getMethodBinding(constructor);
        constructor.getRoot().accept(new ASTVisitor(){

            public void endVisit(ClassInstanceCreation node) {
                IMethodBinding creationBinding = AstNodeUtils.getCreationBinding(node);
                if (creationBinding == constructorBinding) {
                    creations.add(node);
                }
            }
        });
        return creations;
    }

    public static List<MethodDeclaration> getConstructors(TypeDeclaration typeDeclaration) {
        ArrayList<MethodDeclaration> constructors = new ArrayList<MethodDeclaration>();
        MethodDeclaration[] methodDeclarationArray = typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (method.isConstructor()) {
                constructors.add(method);
            }
            ++n2;
        }
        return constructors;
    }

    public static List<ClassInstanceCreation> getClassInstanceCreations(TypeDeclaration type) {
        final ArrayList<ClassInstanceCreation> creations = new ArrayList<ClassInstanceCreation>();
        final String typeName = AstNodeUtils.getFullyQualifiedName(type, false);
        type.getRoot().accept(new ASTVisitor(){

            public void endVisit(ClassInstanceCreation node) {
                String nodeName = AstNodeUtils.getFullyQualifiedName((Expression)node, false);
                if (typeName.equals(nodeName)) {
                    creations.add(node);
                }
            }
        });
        return creations;
    }

    public static boolean hasJavaDocTag(BodyDeclaration declaration, String tagName) {
        return AstNodeUtils.getJavaDocTag(declaration, tagName) != null;
    }

    public static TagElement getJavaDocTag(BodyDeclaration declaration, String tagName) {
        Javadoc javadoc = declaration.getJavadoc();
        if (javadoc != null) {
            for (TagElement tagElement : DomGenerics.tags(javadoc)) {
                if (!tagName.equals(tagElement.getTagName())) continue;
                return tagElement;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMethodInvocation(ASTNode node, String signature) {
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void invocation;
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            return AstNodeUtils.getMethodSignature((MethodInvocation)invocation).equals(signature);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMethodInvocation(ASTNode node, String expressionType, String signature) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = node;
        if (aSTNode2 instanceof MethodInvocation) {
            void invocation;
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode2;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode2;
            if (AstNodeUtils.getMethodSignature((MethodInvocation)invocation).equals(signature)) {
                Expression expression = invocation.getExpression();
                if (expression == null) {
                    return expressionType == null;
                }
                return AstNodeUtils.isSuccessorOf(expression, expressionType);
            }
        }
        if ((aSTNode = node) instanceof SuperMethodInvocation) {
            void invocation;
            SuperMethodInvocation expression = (SuperMethodInvocation)aSTNode;
            SuperMethodInvocation cfr_ignored_1 = (SuperMethodInvocation)aSTNode;
            IMethodBinding methodBinding = AstNodeUtils.getMethodBinding((SuperMethodInvocation)invocation);
            return AstNodeUtils.isSuccessorOf(methodBinding.getDeclaringClass(), expressionType) && AstNodeUtils.getMethodSignature(methodBinding).equals(signature);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMethodInvocation(ASTNode node, String expressionType, String[] signatures) {
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void invocation;
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            Expression expression = invocation.getExpression();
            if (expression == null ? expressionType != null : !AstNodeUtils.isSuccessorOf(expression, expressionType)) {
                return false;
            }
            String signature = AstNodeUtils.getMethodSignature((MethodInvocation)invocation);
            String[] stringArray = signatures;
            int n = signatures.length;
            int n2 = 0;
            while (n2 < n) {
                String testSignature = stringArray[n2];
                if (signature.equals(testSignature)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isCreation(ASTNode node, String typeName, String signature) {
        ASTNode aSTNode = node;
        if (aSTNode instanceof ClassInstanceCreation) {
            void creation;
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)aSTNode;
            ClassInstanceCreation cfr_ignored_0 = (ClassInstanceCreation)aSTNode;
            if (AstNodeUtils.getFullyQualifiedName((Expression)creation, false).equals(typeName)) {
                return AstNodeUtils.getCreationSignature((ClassInstanceCreation)creation).equals(signature);
            }
        }
        return false;
    }

    public static boolean isCreation(ASTNode node, String typeName, String[] signatures) {
        if (node instanceof ClassInstanceCreation) {
            String[] stringArray = signatures;
            int n = signatures.length;
            int n2 = 0;
            while (n2 < n) {
                String signature = stringArray[n2];
                if (AstNodeUtils.isCreation(node, typeName, signature)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean hasVisibility(int modifiers, int visibilityMask) {
        return (modifiers & 7 & visibilityMask) != 0;
    }

    public static boolean isStatic(BodyDeclaration bodyDeclaration) {
        int modifiers = bodyDeclaration.getModifiers();
        return Modifier.isStatic((int)modifiers);
    }

    public static boolean isStatic(IMethodBinding methodBinding) {
        int modifiers = methodBinding.getModifiers();
        return Modifier.isStatic((int)modifiers);
    }

    public static boolean isStatic(ITypeBinding typeBinding) {
        int modifiers = typeBinding.getModifiers();
        return Modifier.isStatic((int)modifiers);
    }

    public static boolean isAbstract(IMethodBinding methodBinding) {
        int modifiers = methodBinding.getModifiers();
        return Modifier.isAbstract((int)modifiers);
    }

    public static boolean isAbstract(MethodDeclaration method) {
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(method);
        return AstNodeUtils.isAbstract(methodBinding);
    }

    public static boolean isAbstract(ITypeBinding typeBinding) {
        int modifiers = typeBinding.getModifiers();
        return Modifier.isAbstract((int)modifiers);
    }

    public static boolean isAbstract(TypeDeclaration type) {
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(type);
        return AstNodeUtils.isAbstract(typeBinding);
    }

    public static List<IMethodBinding> getMethodBindings(ITypeBinding typeBinding, int visibilityMask) {
        ArrayList<IMethodBinding> methods = new ArrayList<IMethodBinding>();
        AstNodeUtils.addMethodBindings(methods, typeBinding, visibilityMask);
        return methods;
    }

    public static List<IVariableBinding> getFieldBindings(ITypeBinding typeBinding, int visibilityMask) {
        ArrayList<IVariableBinding> fields = new ArrayList<IVariableBinding>();
        AstNodeUtils.addFieldBindings(fields, typeBinding, visibilityMask);
        return fields;
    }

    private static void addMethodBindings(List<IMethodBinding> methods, ITypeBinding typeBinding, int visibilityMask) {
        if (typeBinding != null) {
            IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding methodBinding = iMethodBindingArray[n2];
                if (AstNodeUtils.hasVisibility(methodBinding.getModifiers(), visibilityMask)) {
                    methods.add(methodBinding);
                }
                ++n2;
            }
            AstNodeUtils.addMethodBindings(methods, typeBinding.getSuperclass(), visibilityMask &= 0xFFFFFFFD);
        }
    }

    private static void addFieldBindings(List<IVariableBinding> fields, ITypeBinding typeBinding, int visibilityMask) {
        if (typeBinding != null) {
            IVariableBinding[] iVariableBindingArray = typeBinding.getDeclaredFields();
            int n = iVariableBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableBinding fieldBinding = iVariableBindingArray[n2];
                if (AstNodeUtils.hasVisibility(fieldBinding.getModifiers(), visibilityMask)) {
                    fields.add(fieldBinding);
                }
                ++n2;
            }
            AstNodeUtils.addFieldBindings(fields, typeBinding.getSuperclass(), visibilityMask &= 0xFFFFFFFD);
        }
    }

    public static Expression getFieldAssignment(ASTNode node) {
        QualifiedName qualifiedName;
        FieldAccess fieldAccess;
        if (node.getLocationInParent() == FieldAccess.EXPRESSION_PROPERTY && (fieldAccess = (FieldAccess)node.getParent()).getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
            return fieldAccess;
        }
        if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY && (qualifiedName = (QualifiedName)node.getParent()).getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
            return qualifiedName;
        }
        return null;
    }

    public static Expression getFieldAccessQualifier(Expression fieldAccess) {
        if (fieldAccess instanceof FieldAccess) {
            return ((FieldAccess)fieldAccess).getExpression();
        }
        if (fieldAccess instanceof QualifiedName) {
            return ((QualifiedName)fieldAccess).getQualifier();
        }
        return null;
    }

    public static SimpleName getFieldAccessName(Expression fieldAccess) {
        if (fieldAccess instanceof FieldAccess) {
            return ((FieldAccess)fieldAccess).getName();
        }
        if (fieldAccess instanceof QualifiedName) {
            return ((QualifiedName)fieldAccess).getName();
        }
        return null;
    }

    public static VariableDeclarationFragment getFieldFragmentByName(TypeDeclaration typeDeclaration, String fieldName) {
        FieldDeclaration[] fieldDeclarationArray = typeDeclaration.getFields();
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : DomGenerics.fragments(fieldDeclaration)) {
                if (!fieldName.equals(fragment.getName().getIdentifier())) continue;
                return fragment;
            }
            ++n2;
        }
        return null;
    }

    public static ASTNode getEnclosingNode(ASTNode root, final int position) {
        final ASTNode[] result = new ASTNode[1];
        root.accept(new ASTVisitor(){

            public void postVisit(ASTNode node) {
                int start = node.getStartPosition();
                int length = node.getLength();
                if (result[0] == null && start <= position && position < start + length) {
                    result[0] = node;
                }
            }
        });
        return result[0];
    }

    public static Statement getEnclosingStatement(ASTNode node) {
        return AstNodeUtils.getEnclosingNode(node, Statement.class);
    }

    public static Block getEnclosingBlock(ASTNode node) {
        return AstNodeUtils.getEnclosingNode(node, Block.class);
    }

    public static FieldDeclaration getEnclosingFieldDeclaration(ASTNode node) {
        return AstNodeUtils.getEnclosingNode(node, FieldDeclaration.class);
    }

    public static MethodDeclaration getEnclosingMethod(ASTNode node) {
        return AstNodeUtils.getEnclosingNode(node, MethodDeclaration.class);
    }

    public static MethodDeclaration getEnclosingMethod(TypeDeclaration type, ASTNode node) {
        MethodDeclaration[] methods;
        MethodDeclaration[] methodDeclarationArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (AstNodeUtils.contains((ASTNode)method, node)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static TypeDeclaration getEnclosingType(ASTNode node) {
        return AstNodeUtils.getEnclosingNode(node, TypeDeclaration.class);
    }

    public static TypeDeclaration getEnclosingTypeTop(ASTNode node) {
        TypeDeclaration declaringType;
        TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType(node);
        while ((declaringType = AstNodeUtils.getEnclosingType(typeDeclaration.getParent())) != null) {
            typeDeclaration = declaringType;
        }
        return typeDeclaration;
    }

    public static <T> T getEnclosingNode(ASTNode node, Class<T> resultClass) {
        while (node != null) {
            if (resultClass.isAssignableFrom(node.getClass())) {
                return (T)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public static TypeDeclaration getParentType(MethodDeclaration methodDeclaration) {
        ASTNode parentNode = methodDeclaration.getParent();
        if (parentNode instanceof AnonymousClassDeclaration) {
            return AnonymousTypeDeclaration.create((AnonymousClassDeclaration)parentNode);
        }
        return (TypeDeclaration)parentNode;
    }

    public static ASTNode getCommonParent(ASTNode node_1, ASTNode node_2) {
        Assert.isNotNull((Object)node_1, (String)"Null node_1");
        Assert.isNotNull((Object)node_2, (String)"Null node_2");
        HashSet<ASTNode> ancestors = new HashSet<ASTNode>();
        ASTNode node = node_1.getParent();
        while (node != null) {
            ancestors.add(node);
            node = node.getParent();
        }
        node = node_2.getParent();
        while (!ancestors.contains(node)) {
            node = node.getParent();
        }
        return node;
    }

    public static Block getCommonBlock(ASTNode node_1, ASTNode node_2) {
        ASTNode commonParent = AstNodeUtils.getCommonParent(node_1, node_2);
        return AstNodeUtils.getEnclosingBlock(commonParent);
    }

    public static Statement getStatementWithinBlock(Block block, ASTNode node) {
        List<Statement> statements = DomGenerics.statements(block);
        while (node != null) {
            if (statements.contains(node)) {
                return (Statement)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public static Statement getNextStatement(Statement statement) {
        Block block = (Block)statement.getParent();
        List<Statement> statements = DomGenerics.statements(block);
        return (Statement)GenericsUtils.getNextOrNull(statements, (Object)statement);
    }

    public static boolean isDanglingNode(ASTNode node) {
        return !(node.getRoot() instanceof CompilationUnit);
    }

    public static boolean contains(ASTNode node_1, ASTNode node_2) {
        while (node_2 != null) {
            if (node_1 != (node_2 = node_2.getParent())) continue;
            return true;
        }
        return false;
    }

    public static void removeDanglingNodes(Iterable<? extends ASTNode> nodes) {
        Iterator<? extends ASTNode> I = nodes.iterator();
        while (I.hasNext()) {
            ASTNode node = I.next();
            if (!AstNodeUtils.isDanglingNode(node)) continue;
            I.remove();
        }
    }

    public static int getSourceBegin(ASTNode node) {
        return node.getStartPosition();
    }

    public static int getSourceEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength();
    }

    public static void setSourceBegin(ASTNode node, int begin) {
        node.setSourceRange(begin, node.getLength());
    }

    public static void setSourceBegin_keepEnd(ASTNode node, int begin) {
        int delta = node.getStartPosition() - begin;
        int newLength = node.getLength() + delta;
        node.setSourceRange(begin, newLength);
    }

    public static void setSourceEnd(ASTNode targetNode, ASTNode sourceNode) {
        int begin = targetNode.getStartPosition();
        int end = AstNodeUtils.getSourceEnd(sourceNode);
        targetNode.setSourceRange(begin, end - begin);
    }

    public static void setSourceLength(ASTNode node, int length) {
        node.setSourceRange(node.getStartPosition(), length);
    }

    public static void moveNode(ASTNode nodeToMove, int targetPosition) {
        int sourcePosition = nodeToMove.getStartPosition();
        final int moveDelta = targetPosition - sourcePosition;
        nodeToMove.accept(new ASTVisitor(true){

            public void postVisit(ASTNode node) {
                node.setSourceRange(node.getStartPosition() + moveDelta, node.getLength());
            }
        });
    }

    public static void copySourceRange(ASTNode targetNode, ASTNode sourceNode) {
        targetNode.setSourceRange(sourceNode.getStartPosition(), sourceNode.getLength());
    }

    public static void setSourceRange(ASTNode targetNode, ASTNode beginNode, ASTNode endNode) {
        int beginPosition = AstNodeUtils.getSourceBegin(beginNode);
        int endPosition = AstNodeUtils.getSourceEnd(endNode);
        targetNode.setSourceRange(beginPosition, endPosition - beginPosition);
    }

    public static void setSourceRange(ASTNode targetNode, ASTNode sourceNode, int delta) {
        targetNode.setSourceRange(sourceNode.getStartPosition(), sourceNode.getLength() + delta);
    }

    public static void setSourceRange(ASTNode targetNode, ASTNode beginNode, ASTNode endNode, int delta) {
        int begin = AstNodeUtils.getSourceBegin(beginNode);
        int end = AstNodeUtils.getSourceEnd(endNode) + delta;
        targetNode.setSourceRange(begin, end - begin);
    }

    public static List<VariableDeclaration> getVariableDeclarationsAll(ASTNode root) {
        ListGatherer<VariableDeclaration> gatherer = new ListGatherer<VariableDeclaration>(){

            public void postVisit(ASTNode node) {
                if (node instanceof VariableDeclaration) {
                    this.addResult((VariableDeclaration)node);
                }
            }
        };
        root.accept((ASTVisitor)gatherer);
        return gatherer.getResultList();
    }

    public static List<VariableDeclaration> getVariableDeclarationsAfter(ASTNode root, int position) {
        ListGatherer<VariableDeclaration> gatherer;
        block3: {
            TypeDeclaration targetType;
            block2: {
                ASTNode targetNode = AstNodeUtils.getEnclosingNode(root, position);
                gatherer = new ListGatherer<VariableDeclaration>(){

                    public void postVisit(ASTNode node) {
                        if (node instanceof VariableDeclaration) {
                            this.addResult((VariableDeclaration)node);
                        }
                    }
                };
                Block targetBlock = AstNodeUtils.getEnclosingBlock(targetNode);
                targetType = AstNodeUtils.getEnclosingType(targetNode);
                if (targetBlock == null) break block2;
                for (Statement statement : DomGenerics.statements(targetBlock)) {
                    if (statement.getStartPosition() < position) continue;
                    statement.accept((ASTVisitor)gatherer);
                }
                break block3;
            }
            if (targetType == null) break block3;
            for (BodyDeclaration bodyDeclaration : DomGenerics.bodyDeclarations(targetType)) {
                if (bodyDeclaration instanceof FieldDeclaration) continue;
                bodyDeclaration.accept((ASTVisitor)gatherer);
            }
        }
        return gatherer.getResultList();
    }

    /*
     * WARNING - void declaration
     */
    public static List<VariableDeclaration> getVariableDeclarationsVisibleAt(ASTNode root, int position) {
        ArrayList<VariableDeclaration> declarations = new ArrayList<VariableDeclaration>();
        ASTNode node = AstNodeUtils.getEnclosingNode(root, position);
        ASTNode aSTNode = node;
        if (aSTNode instanceof Block) {
            void block;
            Block block2 = (Block)aSTNode;
            Block cfr_ignored_0 = (Block)aSTNode;
            for (Statement statement : DomGenerics.statements((Block)block)) {
                if (statement.getStartPosition() >= position) continue;
                AstNodeUtils.addStatementVariableDeclarations(declarations, statement);
            }
        }
        while (node != null) {
            ASTNode aSTNode2;
            ASTNode aSTNode3;
            ASTNode aSTNode4 = node;
            if (aSTNode4 instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration;
                TypeDeclaration cfr_ignored_1 = (TypeDeclaration)aSTNode4;
                TypeDeclaration cfr_ignored_2 = (TypeDeclaration)aSTNode4;
                Statement statement = typeDeclaration.getFields();
                int n = ((FieldDeclaration[])statement).length;
                int n2 = 0;
                while (n2 < n) {
                    MethodDeclaration fieldDeclaration = statement[n2];
                    declarations.addAll(DomGenerics.fragments((FieldDeclaration)fieldDeclaration));
                    ++n2;
                }
            }
            if ((aSTNode3 = node) instanceof MethodDeclaration) {
                void method;
                MethodDeclaration cfr_ignored_3 = (MethodDeclaration)aSTNode3;
                MethodDeclaration cfr_ignored_4 = (MethodDeclaration)aSTNode3;
                declarations.addAll(DomGenerics.parameters((MethodDeclaration)method));
            }
            if ((aSTNode2 = node) instanceof Statement) {
                Statement cfr_ignored_5 = (Statement)aSTNode2;
                Statement cfr_ignored_6 = (Statement)aSTNode2;
                if (node.getParent() instanceof Block) {
                    void statement;
                    Block block = (Block)statement.getParent();
                    for (Statement siblingStatement : DomGenerics.statements(block)) {
                        if (siblingStatement == statement) break;
                        AstNodeUtils.addStatementVariableDeclarations(declarations, siblingStatement);
                    }
                }
            }
            node = node.getParent();
        }
        return declarations;
    }

    /*
     * WARNING - void declaration
     */
    private static void addStatementVariableDeclarations(List<VariableDeclaration> declarations, Statement statement) {
        Statement statement2 = statement;
        if (statement2 instanceof VariableDeclarationStatement) {
            void variableStatement;
            VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement2;
            VariableDeclarationStatement cfr_ignored_0 = (VariableDeclarationStatement)statement2;
            declarations.addAll(DomGenerics.fragments((VariableDeclarationStatement)variableStatement));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isVariable(ASTNode variable) {
        ASTNode aSTNode = variable;
        if (aSTNode instanceof FieldAccess) {
            void fieldAccess;
            FieldAccess fieldAccess2 = (FieldAccess)aSTNode;
            FieldAccess cfr_ignored_0 = (FieldAccess)aSTNode;
            return fieldAccess.getExpression() instanceof ThisExpression;
        }
        if (variable instanceof SimpleName) {
            StructuralPropertyDescriptor locationInParent = variable.getLocationInParent();
            if (locationInParent == MethodInvocation.NAME_PROPERTY || locationInParent == SimpleType.NAME_PROPERTY || locationInParent == FieldAccess.NAME_PROPERTY || locationInParent == QualifiedName.NAME_PROPERTY || locationInParent == MethodDeclaration.NAME_PROPERTY || locationInParent == TypeDeclaration.NAME_PROPERTY) {
                return false;
            }
            return AstNodeUtils.getVariableBinding(variable) != null;
        }
        return false;
    }

    public static String getVariableName(ASTNode variable) {
        return AstNodeUtils.getVariableSimpleName(variable).getIdentifier();
    }

    public static SimpleName getVariableSimpleName(ASTNode variable) {
        if (variable instanceof FieldAccess) {
            return ((FieldAccess)variable).getName();
        }
        return (SimpleName)variable;
    }

    /*
     * WARNING - void declaration
     */
    public static Expression getActualVariableExpression(Expression expression) {
        MethodDeclaration method;
        MethodDeclaration enclosingMethod;
        ASTNode lastAssignment;
        if (AstNodeUtils.isVariable((ASTNode)expression) && (lastAssignment = ExecutionFlowUtils.getLastAssignment(new ExecutionFlowDescription(enclosingMethod = AstNodeUtils.getEnclosingMethod((ASTNode)expression)), (ASTNode)expression)) != null && ((method = AstNodeUtils.getEnclosingMethod(lastAssignment)) == null || method == enclosingMethod)) {
            ASTNode aSTNode = lastAssignment;
            if (aSTNode instanceof Assignment) {
                void assignment;
                Assignment assignment2 = (Assignment)aSTNode;
                Assignment cfr_ignored_0 = (Assignment)aSTNode;
                return assignment.getRightHandSide();
            }
            ASTNode aSTNode2 = lastAssignment;
            if (aSTNode2 instanceof VariableDeclarationFragment) {
                void fragment;
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)aSTNode2;
                VariableDeclarationFragment cfr_ignored_1 = (VariableDeclarationFragment)aSTNode2;
                Expression initializer = fragment.getInitializer();
                if (initializer != null) {
                    return initializer;
                }
            }
        }
        return expression;
    }

    public static String getPackageName(CompilationUnit unit) {
        PackageDeclaration packageDeclaration = unit.getPackage();
        return packageDeclaration != null ? packageDeclaration.getName().getFullyQualifiedName() : "";
    }

    public static boolean areLiterals(List<Expression> expressions) {
        for (Expression expression : expressions) {
            if (AstNodeUtils.isLiteral(expression)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isLiteral(Expression expression) {
        if (expression instanceof BooleanLiteral || expression instanceof NumberLiteral || expression instanceof StringLiteral || expression instanceof NullLiteral || expression instanceof QualifiedName) {
            return true;
        }
        Expression expression2 = expression;
        if (expression2 instanceof CastExpression) {
            void castExpression;
            CastExpression castExpression2 = (CastExpression)expression2;
            CastExpression cfr_ignored_0 = (CastExpression)expression2;
            return AstNodeUtils.isLiteral(castExpression.getExpression());
        }
        Expression expression3 = expression;
        if (expression3 instanceof PrefixExpression) {
            void prefixExpression;
            PrefixExpression prefixExpression2 = (PrefixExpression)expression3;
            PrefixExpression cfr_ignored_1 = (PrefixExpression)expression3;
            return AstNodeUtils.isLiteral(prefixExpression.getOperand());
        }
        Expression expression4 = expression;
        if (expression4 instanceof InfixExpression) {
            void infixExpression;
            InfixExpression infixExpression2 = (InfixExpression)expression4;
            InfixExpression cfr_ignored_2 = (InfixExpression)expression4;
            List<Expression> operands = DomGenerics.allOperands((InfixExpression)infixExpression);
            return AstNodeUtils.areLiterals(operands);
        }
        return false;
    }

    private static <T> T getValue(ASTNode node, String key, RunnableObjectEx<T> evaluator) {
        if (node == null) {
            return (T)ExecutionUtils.runObject(evaluator);
        }
        String keyValue = "ASTNodeUtilities." + key;
        String keyHas = keyValue + ".has";
        if (node.getProperty(keyHas) == Boolean.TRUE && AstNodeUtils.isCacheUpToDate(node, key)) {
            Object value = node.getProperty(keyValue);
            return (T)value;
        }
        Object value = ExecutionUtils.runObject(evaluator);
        node.setProperty(keyValue, value);
        node.setProperty(keyHas, (Object)Boolean.TRUE);
        return (T)value;
    }

    private static boolean isCacheUpToDate(ASTNode node, String key) {
        String keyStamp = "ASTNodeUtilities." + key + ".stamp";
        long currentStamp = node.getAST().modificationCount();
        Long nodeStamp = (Long)node.getProperty(keyStamp);
        node.setProperty(keyStamp, (Object)currentStamp);
        return nodeStamp != null && nodeStamp == currentStamp;
    }
}

