/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util.factory;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jface.action.Action;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.FactoryParentAssociation;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;

public final class FactoryApplyAction
extends Action {
    private final JavaInfo m_component;
    private final FactoryMethodDescription m_description;
    private final AstEditor m_editor;
    private boolean m_hasParentArgument;
    private final List<GenericPropertyImpl> m_genericProperties = new ArrayList<GenericPropertyImpl>();

    public FactoryApplyAction(JavaInfo component, FactoryMethodDescription description) {
        this.m_component = component;
        this.m_description = description;
        this.m_editor = this.m_component.getEditor();
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription(FactoryApplyAction.this.m_editor, FactoryApplyAction.this.m_description.getReturnClass());
                FactoryApplyAction.this.setImageDescriptor(componentDescription.getIcon());
                FactoryApplyAction.this.setText(CodeUtils.getShortClass(FactoryApplyAction.this.m_description.getDeclaringClass().getName()) + "." + FactoryApplyAction.this.m_description.getName() + "(...)");
            }
        });
    }

    public void run() {
        ExecutionUtils.run((ObjectInfo)this.m_component, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                FactoryApplyAction.this.prepareGenericProperties();
                if (FactoryApplyAction.this.m_component.getCreationSupport() instanceof ConstructorCreationSupport) {
                    FactoryApplyAction.this.runConstructor();
                }
            }
        });
    }

    private void runConstructor() throws Exception {
        ConstructorCreationSupport oldCreationSupport = (ConstructorCreationSupport)this.m_component.getCreationSupport();
        ClassInstanceCreation oldExpression = oldCreationSupport.getCreation();
        List<Expression> oldArguments = DomGenerics.arguments(oldExpression);
        String newSource = this.m_description.getDeclaringClass().getName() + "." + this.m_description.getName() + "(";
        newSource = newSource + StringUtils.join(this.getFactoryArguments(oldArguments).iterator(), (String)", ");
        newSource = newSource + ")";
        StaticFactoryCreationSupport newCreationSupport = new StaticFactoryCreationSupport(this.m_description);
        this.m_component.setCreationSupport(newCreationSupport);
        MethodInvocation newExpression = (MethodInvocation)this.m_component.replaceExpression((Expression)oldExpression, newSource);
        newCreationSupport.add_setSourceExpression((Expression)newExpression);
        if (this.m_hasParentArgument) {
            this.m_component.setAssociation(new FactoryParentAssociation(newExpression));
        }
    }

    private List<String> getFactoryArguments(List<Expression> oldArguments) throws Exception {
        ArrayList<String> arguments = new ArrayList<String>();
        for (ParameterDescription parameter : this.m_description.getParameters()) {
            if (parameter.isParent()) {
                this.m_hasParentArgument = true;
                arguments.add(TemplateUtils.getExpression(this.m_component.getParentJava()));
                continue;
            }
            GenericPropertyImpl property = this.getGenericProperty(parameter.getProperty());
            if (property != null) {
                Expression expression = ((GenericProperty)property).getExpression();
                if (oldArguments.contains(expression)) {
                    arguments.add(this.m_editor.getSource((ASTNode)expression));
                    continue;
                }
                if (expression.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY && (expression instanceof NullLiteral || expression instanceof BooleanLiteral || expression instanceof NumberLiteral || expression instanceof StringLiteral)) {
                    arguments.add(this.m_editor.getSource((ASTNode)expression));
                    this.m_editor.removeEnclosingStatement((ASTNode)expression);
                    continue;
                }
            }
            arguments.add(parameter.getDefaultSource());
        }
        return arguments;
    }

    /*
     * WARNING - void declaration
     */
    private void prepareGenericProperties() throws Exception {
        Property[] propertyArray = this.m_component.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            Property property2 = property;
            if (property2 instanceof GenericPropertyImpl) {
                void genericProperty;
                GenericPropertyImpl cfr_ignored_0 = (GenericPropertyImpl)property2;
                GenericPropertyImpl cfr_ignored_1 = (GenericPropertyImpl)property2;
                if (genericProperty.getExpression() != null) {
                    this.m_genericProperties.add((GenericPropertyImpl)property);
                }
            }
            ++n2;
        }
    }

    private GenericPropertyImpl getGenericProperty(String id) {
        for (GenericPropertyImpl property : this.m_genericProperties) {
            if (property.getDescription() == null || !property.getDescription().getId().equals(id)) continue;
            return property;
        }
        return null;
    }
}

