/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;

public final class ConstantSelectionPropertyEditor
extends AbstractComboPropertyEditor
implements IConfigurablePropertyObject {
    private String m_typeName;
    private final PropertyEditorPresentation m_presentation = new ButtonPropertyEditorPresentation(){

        protected void onClick(PropertyTable propertyTable, Property property) throws Exception {
            ConstantSelectionPropertyEditor.this.openDialog(property);
        }
    };

    public final PropertyEditorPresentation getPresentation() {
        return this.m_presentation;
    }

    protected String getText(Property _property) throws Exception {
        GenericProperty property = (GenericProperty)_property;
        IField field = ConstantSelectionPropertyEditor.getField(property);
        if (field != null) {
            return field.getElementName();
        }
        return null;
    }

    protected void addItems(Property _property, CCombo3 combo) throws Exception {
        GenericProperty property = (GenericProperty)_property;
        IType type = ConstantSelectionPropertyEditor.getType(property);
        List<IField> fields = this.getFields(type);
        int index = 0;
        while (index < fields.size()) {
            IField field = fields.get(index);
            combo.add(field.getElementName());
            combo.setData("" + index, (Object)field);
            ++index;
        }
    }

    protected void selectItem(Property _property, CCombo3 combo) throws Exception {
        GenericProperty property = (GenericProperty)_property;
        combo.select(-1);
        IField field = ConstantSelectionPropertyEditor.getField(property);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (combo.getData("" + i) == field) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    protected void toPropertyEx(Property _property, CCombo3 combo, int index) throws Exception {
        GenericProperty property = (GenericProperty)_property;
        IField field = (IField)combo.getData("" + index);
        ConstantSelectionPropertyEditor.setField(property, field);
    }

    public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
        if (location == null) {
            this.openDialog(property);
            return false;
        }
        return super.activate(propertyTable, property, location);
    }

    private void openDialog(Property _property) throws Exception {
        GenericProperty property = (GenericProperty)_property;
        ConstantSelection_Dialog dialog = new ConstantSelection_Dialog(DesignerPlugin.getShell(), property.getJavaInfo(), ConstantSelectionPropertyEditor.getField(property));
        if (dialog.open() == 0) {
            ConstantSelectionPropertyEditor.setField(property, dialog.m_selectedField);
        }
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        this.m_typeName = (String)parameters.get("type");
        Assert.isNotNull((Object)this.m_typeName, (String)"'type' attribute in %s.", (Object[])new Object[]{parameters});
    }

    public static IField selectField(Shell parentShell, String typeName, JavaInfo javaInfo, Set<IType> additionalTypes, IField currentField) throws Exception {
        ConstantSelectionPropertyEditor editor = new ConstantSelectionPropertyEditor();
        editor.m_typeName = typeName;
        ConstantSelectionPropertyEditor constantSelectionPropertyEditor = editor;
        constantSelectionPropertyEditor.getClass();
        ConstantSelection_Dialog dialog = constantSelectionPropertyEditor.new ConstantSelection_Dialog(parentShell, javaInfo, currentField);
        dialog.m_additionalTypes.addAll(additionalTypes);
        if (dialog.open() == 0) {
            return dialog.m_selectedField;
        }
        return null;
    }

    public List<IField> getFields(IType type) throws Exception {
        ArrayList<IField> fields = new ArrayList<IField>();
        if (type != null) {
            IField[] iFieldArray = type.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                String typeName;
                boolean isConstant;
                IField field = iFieldArray[n2];
                int flags = field.getFlags();
                boolean bl = isConstant = Flags.isPublic((int)flags) && Flags.isStatic((int)flags) && Flags.isFinal((int)flags);
                if ((!type.isClass() || isConstant) && (typeName = CodeUtils.getResolvedTypeName(type, field.getTypeSignature())).equals(this.m_typeName)) {
                    fields.add(field);
                }
                ++n2;
            }
        }
        Collections.sort(fields, new Comparator<IField>(){

            @Override
            public int compare(IField field1, IField field2) {
                return field1.getElementName().compareTo(field2.getElementName());
            }
        });
        return fields;
    }

    private static IType getType(GenericProperty property) throws Exception {
        IField field = ConstantSelectionPropertyEditor.getField(property);
        return field != null ? field.getDeclaringType() : null;
    }

    private static IField getField(GenericProperty property) throws Exception {
        IJavaProject javaProject = property.getJavaInfo().getEditor().getJavaProject();
        Expression expression = property.getExpression();
        return ConstantSelectionPropertyEditor.getField(javaProject, expression);
    }

    /*
     * WARNING - void declaration
     */
    public static IField getField(IJavaProject javaProject, Expression expression) throws Exception {
        Expression expression2 = expression;
        if (expression2 instanceof QualifiedName) {
            void qualifiedName;
            QualifiedName qualifiedName2 = (QualifiedName)expression2;
            QualifiedName cfr_ignored_0 = (QualifiedName)expression2;
            Name qualifier = qualifiedName.getQualifier();
            String typeName = AstNodeUtils.getFullyQualifiedName((Expression)qualifier, true);
            String fieldName = qualifiedName.getName().getIdentifier();
            return CodeUtils.findField(javaProject, typeName, fieldName);
        }
        Expression expression3 = expression;
        if (expression3 instanceof SimpleName) {
            ITypeBinding declaringClass;
            void simpleName;
            SimpleName qualifier = (SimpleName)expression3;
            SimpleName cfr_ignored_1 = (SimpleName)expression3;
            IVariableBinding binding = AstNodeUtils.getVariableBinding((ASTNode)simpleName);
            if (binding != null && (declaringClass = binding.getDeclaringClass()) != null) {
                String typeName = AstNodeUtils.getFullyQualifiedName(declaringClass, false);
                String fieldName = simpleName.getIdentifier();
                return CodeUtils.findField(javaProject, typeName, fieldName);
            }
        }
        return null;
    }

    private static void setField(GenericProperty property, IField field) throws Exception {
        String code = ConstantSelectionPropertyEditor.getFieldCode(property.getJavaInfo(), field);
        property.setExpression(code, Property.UNKNOWN_VALUE);
    }

    public static String getFieldCode(JavaInfo javaInfo, IField field) throws Exception {
        IType fieldType = field.getDeclaringType();
        String fieldName = field.getElementName();
        if (JavaInfoUtils.isLocalField(javaInfo, field)) {
            return fieldName;
        }
        String typeName = fieldType.getFullyQualifiedName();
        return typeName + "." + fieldName;
    }

    private Set<IType> getUsedTypes(JavaInfo javaInfo) throws Exception {
        HashSet<IType> types = new HashSet<IType>();
        this.collectUsedTypes(types, javaInfo.getRootJava());
        return types;
    }

    private void collectUsedTypes(Set<IType> types, JavaInfo javaInfo) throws Exception {
        Property[] propertyArray = javaInfo.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            this.addUsedTypes(types, property);
            ++n2;
        }
        for (JavaInfo child : javaInfo.getChildrenJava()) {
            this.collectUsedTypes(types, child);
        }
    }

    private void addUsedTypes(Set<IType> types, Property property) throws Exception {
        Object propertyEditor;
        if (property.getEditor() instanceof ConstantSelectionPropertyEditor) {
            IType type;
            propertyEditor = (ConstantSelectionPropertyEditor)property.getEditor();
            if (propertyEditor.m_typeName.equals(this.m_typeName) && (type = ConstantSelectionPropertyEditor.getType((GenericProperty)property)) != null) {
                types.add(type);
            }
        }
        if ((propertyEditor = property.getEditor()) instanceof IComplexPropertyEditor) {
            Property[] properties;
            Property[] propertyArray = properties = ((IComplexPropertyEditor)propertyEditor).getProperties(property);
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                Property subProperty = propertyArray[n2];
                this.addUsedTypes(types, subProperty);
                ++n2;
            }
        }
    }

    private List<IType> getLocalTypes(JavaInfo javaInfo) throws Exception {
        ArrayList<IType> types = new ArrayList<IType>();
        IJavaProject javaProject = javaInfo.getEditor().getJavaProject();
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration(javaInfo);
        String typeName = AstNodeUtils.getFullyQualifiedName(typeDeclaration, false);
        this.addLocalTypes(javaProject, types, typeName);
        for (Type interfaceType : DomGenerics.superInterfaces(typeDeclaration)) {
            String interfaceQualifiedName = AstNodeUtils.getFullyQualifiedName(interfaceType, false);
            this.addLocalTypes(javaProject, types, interfaceQualifiedName);
        }
        return types;
    }

    private void addLocalTypes(IJavaProject javaProject, List<IType> types, String typeName) throws Exception {
        IType type = javaProject.findType(typeName);
        if (type != null && !this.getFields(type).isEmpty()) {
            types.add(type);
        }
    }

    private class ConstantSelection_Dialog
    extends ResizableDialog {
        private static final int ADD_TYPE_ID = 1025;
        private final JavaInfo m_javaInfo;
        private final IField m_currentField;
        private final IType m_currentType;
        private final Set<IType> m_additionalTypes;
        private TableViewer m_typesViewer;
        private Text m_filterText;
        private TableViewer m_fieldsViewer;
        private IField m_selectedField;

        public ConstantSelection_Dialog(Shell parentShell, JavaInfo javaInfo, IField currentField) {
            super(parentShell, (AbstractUIPlugin)DesignerPlugin.getDefault());
            this.m_additionalTypes = new HashSet<IType>();
            this.m_javaInfo = javaInfo;
            this.m_currentField = currentField;
            this.m_currentType = this.m_currentField != null ? this.m_currentField.getDeclaringType() : null;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            GridLayoutFactory.create((Composite)container).columns(2);
            Group group = new Group(container, 0);
            GridDataFactory.create((Control)group).grab().fill();
            GridLayoutFactory.create((Composite)group);
            group.setText(ModelMessages.ConstantSelectionPropertyEditor_typesGroup);
            this.m_typesViewer = new TableViewer((Composite)group, 67584);
            Table table = this.m_typesViewer.getTable();
            GridDataFactory.create((Control)table).hintC(50, 15).grab().fill();
            this.m_typesViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
            this.m_typesViewer.setContentProvider((IContentProvider)new TypeContentProvider());
            this.m_typesViewer.setInput(new Object());
            this.m_typesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent e) {
                    ConstantSelection_Dialog.this.onTypeSelected();
                }
            });
            group = new Group(container, 0);
            GridDataFactory.create((Control)group).grab().fill();
            GridLayoutFactory.create((Composite)group).columns(2);
            group.setText(ModelMessages.ConstantSelectionPropertyEditor_fieldsGroup);
            Label label = new Label((Composite)group, 0);
            label.setText(ModelMessages.ConstantSelectionPropertyEditor_filterLabel);
            this.m_filterText = new Text((Composite)group, 2048);
            GridDataFactory.create((Control)this.m_filterText).grabH().fillH();
            this.m_filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ConstantSelection_Dialog.this.onFilterModify();
                }
            });
            this.m_fieldsViewer = new TableViewer((Composite)group, 67584);
            table = this.m_fieldsViewer.getTable();
            GridDataFactory.create((Control)table).spanH(2).hintC(50, 15).grab().fill();
            this.m_fieldsViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
            this.m_fieldsViewer.setContentProvider((IContentProvider)new FieldContentProvider());
            this.m_fieldsViewer.addFilter((ViewerFilter)new FieldFilter());
            this.m_fieldsViewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent e) {
                    ConstantSelection_Dialog.this.okPressed();
                }
            });
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    if (ConstantSelection_Dialog.this.m_currentType != null) {
                        ConstantSelection_Dialog.this.m_typesViewer.setSelection((ISelection)new StructuredSelection((Object)ConstantSelection_Dialog.this.m_currentType));
                    } else {
                        ConstantSelection_Dialog.this.m_typesViewer.getTable().select(0);
                        ConstantSelection_Dialog.this.onTypeSelected();
                    }
                }
            });
            IDialogSettings settings = this.getDialogSettings();
            String filter = settings.get("filter");
            if (filter != null) {
                this.m_filterText.setText(filter);
                this.onFilterModify();
            }
            return container;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(ModelMessages.ConstantSelectionPropertyEditor_title);
        }

        public boolean close() {
            String filter = this.m_filterText.getText();
            boolean closed = super.close();
            if (closed) {
                IDialogSettings settings = this.getDialogSettings();
                settings.put("filter", filter);
            }
            return closed;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1025, ModelMessages.ConstantSelectionPropertyEditor_addTypeButton, false);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void okPressed() {
            IStructuredSelection selection = (IStructuredSelection)this.m_fieldsViewer.getSelection();
            this.m_selectedField = (IField)selection.getFirstElement();
            super.okPressed();
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 1025) {
                this.onAddType();
            }
            super.buttonPressed(buttonId);
        }

        private void onTypeSelected() {
            IStructuredSelection selection = (IStructuredSelection)this.m_typesViewer.getSelection();
            IType type = (IType)selection.getFirstElement();
            this.m_fieldsViewer.setInput((Object)type);
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    if (ConstantSelection_Dialog.this.m_currentField != null) {
                        ConstantSelection_Dialog.this.m_fieldsViewer.setSelection((ISelection)new StructuredSelection((Object)ConstantSelection_Dialog.this.m_currentField));
                        Table table = ConstantSelection_Dialog.this.m_fieldsViewer.getTable();
                        table.setFocus();
                        int selectionIndex = table.getSelectionIndex();
                        if (selectionIndex != -1) {
                            table.setSelection(selectionIndex);
                        }
                    }
                }
            });
        }

        private void onAddType() {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    IJavaProject javaProject = ConstantSelection_Dialog.this.m_javaInfo.getEditor().getJavaProject();
                    IType type = JdtUiUtils.selectType(ConstantSelection_Dialog.this.getShell(), javaProject);
                    if (type != null) {
                        ConstantSelection_Dialog.this.m_additionalTypes.add(type);
                        ConstantSelection_Dialog.this.m_typesViewer.refresh();
                        ConstantSelection_Dialog.this.m_typesViewer.setSelection((ISelection)new StructuredSelection((Object)type));
                    }
                }
            });
        }

        private void onFilterModify() {
            this.m_fieldsViewer.refresh();
        }

        private class FieldContentProvider
        implements IStructuredContentProvider {
            private FieldContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                final IType type = (IType)inputElement;
                return (Object[])ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<Object[]>(){

                    public Object[] runObject() throws Exception {
                        return ConstantSelectionPropertyEditor.this.getFields(type).toArray();
                    }
                });
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        private class FieldFilter
        extends ViewerFilter {
            private FieldFilter() {
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IField field = (IField)element;
                String filter = ConstantSelection_Dialog.this.m_filterText.getText().toLowerCase();
                return field.getElementName().toLowerCase().startsWith(filter);
            }
        }

        private class TypeContentProvider
        implements IStructuredContentProvider {
            private TypeContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<Object[]>(){

                    public Object[] runObject() throws Exception {
                        HashSet<IType> types = new HashSet<IType>();
                        types.addAll(((TypeContentProvider)TypeContentProvider.this).ConstantSelection_Dialog.this.m_additionalTypes);
                        types.addAll(ConstantSelectionPropertyEditor.this.getUsedTypes(((TypeContentProvider)TypeContentProvider.this).ConstantSelection_Dialog.this.m_javaInfo));
                        types.addAll(ConstantSelectionPropertyEditor.this.getLocalTypes(((TypeContentProvider)TypeContentProvider.this).ConstantSelection_Dialog.this.m_javaInfo));
                        return types.toArray();
                    }
                });
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

