/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gefTree;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gef.EditPolicy;
import org.eclipse.wb.core.gef.IEditPartConfigurator;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gefTree.policy.generic.FlowContainerLayoutEditPolicy;
import org.eclipse.wb.internal.core.gefTree.policy.generic.SimpleContainerLayoutEditPolicy;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.generic.FlowContainerConfigurable;
import org.eclipse.wb.internal.core.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerFactory;
import org.eclipse.wb.internal.core.model.nonvisual.FlowContainerGroupInfo;

public final class GenericContainersConfigurator
implements IEditPartConfigurator {
    public void configure(EditPart context, EditPart editPart) {
        if (editPart.getModel() instanceof JavaInfo) {
            JavaInfo component = (JavaInfo)((Object)editPart.getModel());
            this.configureComponent(editPart, component);
        }
    }

    private void configureComponent(EditPart editPart, JavaInfo component) {
        this.configureSimpleContainer(editPart, component);
        this.configureFlowContainer(editPart, component);
    }

    private void configureSimpleContainer(EditPart editPart, JavaInfo component) {
        List<SimpleContainer> containers = new SimpleContainerFactory(component, false).get();
        for (SimpleContainer container : containers) {
            SimpleContainerLayoutEditPolicy layoutPolicy = new SimpleContainerLayoutEditPolicy((ObjectInfo)component, container);
            editPart.installEditPolicy((Object)container, (EditPolicy)layoutPolicy);
        }
    }

    private void configureFlowContainer(EditPart editPart, JavaInfo component) {
        List<FlowContainer> containers = new FlowContainerFactory(component, false).get();
        for (FlowContainer container : containers) {
            FlowContainerLayoutEditPolicy layoutPolicy = new FlowContainerLayoutEditPolicy((ObjectInfo)component, container);
            editPart.installEditPolicy((Object)container, (EditPolicy)layoutPolicy);
            if (!(component instanceof AbstractComponentInfo) || !(container instanceof FlowContainerConfigurable)) continue;
            this.configureGroupInfo(editPart, (AbstractComponentInfo)component, (FlowContainerConfigurable)container);
        }
    }

    private void configureGroupInfo(EditPart editPart, JavaInfo component, FlowContainerConfigurable container) {
        String groupName = container.getGroupName();
        if (StringUtils.isEmpty((String)groupName)) {
            return;
        }
        FlowContainerGroupInfo groupInfo = this.getGroupInfoByName(component, groupName);
        if (groupInfo != null) {
            groupInfo.addContainer(container);
        }
    }

    private FlowContainerGroupInfo getGroupInfoByName(JavaInfo component, String groupName) {
        FlowContainerGroupInfo groupInfo;
        List groupInfos = component.getChildren(FlowContainerGroupInfo.class);
        for (FlowContainerGroupInfo groupInfo2 : groupInfos) {
            if (!groupInfo2.getCaption().equals(groupName)) continue;
            return groupInfo2;
        }
        try {
            groupInfo = new FlowContainerGroupInfo(component.getEditor(), component, groupName);
        }
        catch (Exception e) {
            DesignerPlugin.log((String)("FlowContainerGroupInfo creation error: " + e.getMessage()), (Throwable)e);
            groupInfo = null;
        }
        return groupInfo;
    }
}

