/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pshelf;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.nebula.widgets.pshelf.AbstractRenderer;
import org.eclipse.nebula.widgets.pshelf.PShelfItem;
import org.eclipse.nebula.widgets.pshelf.PaletteShelfRenderer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class PShelf
extends Canvas {
    private ArrayList<PShelfItem> items = new ArrayList();
    private AbstractRenderer renderer;
    private PShelfItem openItem;
    private PShelfItem focusItem;
    private PShelfItem mouseDownItem;
    private PShelfItem hoverItem;
    private int itemHeight = 0;
    private ArrayList<Integer> yCoordinates = new ArrayList();
    private double animationSpeed = 0.02;
    private boolean redrawOnAnimation;

    private static int checkStyle(int style) {
        int mask = 100665408;
        return style & mask | 0x20000000;
    }

    public PShelf(Composite parent, int style) {
        super(parent, PShelf.checkStyle(style));
        this.setRenderer(new PaletteShelfRenderer());
        this.addPaintListener(event -> this.onPaint(event.gc));
        this.addListener(11, event -> this.onResize());
        this.addListener(4, event -> {
            PShelfItem item = this.getItem(new Point(1, event.y));
            if (item == null) {
                return;
            }
            if (item == this.mouseDownItem && item != this.openItem) {
                this.openItem(item, true);
            }
        });
        this.addListener(3, event -> {
            PShelfItem pShelfItem = this.mouseDownItem = this.getItem(new Point(1, event.y));
        });
        this.addDisposeListener(event -> this.onDispose());
        this.addListener(7, event -> {
            this.hoverItem = null;
            this.redraw();
        });
        this.addMouseMoveListener(e -> {
            PShelfItem item = this.getItem(new Point(1, e.y));
            if (item != this.hoverItem) {
                this.hoverItem = item;
                this.redraw();
            }
        });
    }

    public void setRenderer(AbstractRenderer renderer) {
        this.checkWidget();
        if (renderer == null) {
            SWT.error((int)4);
        }
        if (renderer.isDisposed()) {
            SWT.error((int)24);
        }
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.renderer = renderer;
        renderer.initialize((Control)this);
        this.computeItemHeight();
        this.onResize();
        this.redraw();
    }

    public AbstractRenderer getRenderer() {
        this.checkWidget();
        return this.renderer;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = new Point(wHint, hHint);
        if (wHint == -1 || hHint == -1) {
            if (this.openItem != null) {
                Point prefSize = this.openItem.getBody().computeSize(-1, -1);
                if (wHint == -1) {
                    size.x = prefSize.x;
                }
                if (hHint == -1) {
                    size.y = prefSize.y + this.items.size() * this.itemHeight;
                }
            } else {
                return super.computeSize(wHint, hHint, changed);
            }
        }
        return size;
    }

    private void onDispose() {
        this.renderer.dispose();
    }

    private void onPaint(GC gc) {
        gc.setAdvanced(true);
        if (gc.getAdvanced()) {
            gc.setTextAntialias(1);
        }
        Color back = this.getBackground();
        Color fore = this.getForeground();
        int index = 0;
        for (PShelfItem item : this.items) {
            gc.setBackground(back);
            gc.setForeground(fore);
            Integer y = this.yCoordinates.get(index);
            this.renderer.setBounds(0, y, this.getClientArea().width, this.itemHeight);
            this.renderer.setSelected(item == this.openItem);
            this.renderer.setFocus(this.isFocusControl() && this.focusItem == item);
            this.renderer.setHover(item == this.hoverItem);
            this.renderer.paint(gc, (Object)item);
            ++index;
        }
    }

    private void computeItemYCoordinates() {
        this.yCoordinates.clear();
        int y = this.getClientArea().y;
        int i = 0;
        Iterator<PShelfItem> iter = this.items.iterator();
        while (iter.hasNext()) {
            ++i;
            PShelfItem item = iter.next();
            this.yCoordinates.add(new Integer(y));
            y += this.itemHeight;
            if (item != this.openItem) continue;
            y = this.getClientArea().y + this.getClientArea().height - this.itemHeight * (this.items.size() - i);
        }
    }

    void createItem(PShelfItem item, int index) {
        if (index == -1) {
            this.items.add(item);
        } else {
            this.items.add(index, item);
        }
        this.computeItemHeight();
        if (this.openItem == null) {
            this.openItem(item, false);
        }
        this.onResize();
    }

    void removeItem(PShelfItem item) {
        this.computeItemHeight();
        this.items.remove((Object)item);
        if (this.openItem == item) {
            this.openItem = null;
            if (this.items.size() > 0) {
                this.openItem(this.items.get(0), false);
            }
        }
        this.onResize();
    }

    private void openItem(PShelfItem item, boolean animation) {
        PShelfItem previousOpen = this.openItem;
        this.openItem = item;
        this.focusItem = item;
        item.getBodyParent().setBounds(0, 0, 0, 0);
        item.getBodyParent().setVisible(true);
        item.getBody().layout();
        if (animation && (this.getStyle() & 0x40) == 0) {
            if (!this.redrawOnAnimation) {
                previousOpen.getBodyParent().setRedraw(false);
                item.getBodyParent().setRedraw(false);
            }
            if (this.items.indexOf((Object)item) < this.items.indexOf((Object)previousOpen)) {
                this.animateOpen(item, previousOpen, false);
            } else {
                this.animateOpen(previousOpen, item, true);
            }
            if (!this.redrawOnAnimation) {
                previousOpen.getBodyParent().setRedraw(true);
                item.getBodyParent().setRedraw(true);
            }
        } else {
            if (previousOpen != null && !previousOpen.isDisposed()) {
                previousOpen.getBodyParent().setBounds(0, 0, 0, 0);
            }
            if ((this.getStyle() & 0x40) != 0) {
                this.items.remove((Object)item);
                this.items.add(0, item);
            }
            this.onResize();
        }
        if (previousOpen != null) {
            previousOpen.getBodyParent().setVisible(false);
        }
        this.redraw();
        this.getDisplay().update();
        Event e = new Event();
        e.item = this.openItem;
        this.notifyListeners(13, e);
        this.computeItemYCoordinates();
        this.onResize();
    }

    private void animateOpen(PShelfItem previousItem, PShelfItem newItem, boolean openFromBottom) {
        double percentOfWork = 0.0;
        while (percentOfWork < 1.0) {
            this.yCoordinates.clear();
            int yTop = this.getClientArea().y;
            int yBottom = this.getClientArea().y + this.getClientArea().height - this.itemHeight * (this.items.size() - (this.items.indexOf((Object)newItem) + 1));
            int totalShrinkingGrowingArea = this.getClientArea().height - this.itemHeight * this.items.size();
            int collapsingGrowingSpace = (int)((double)totalShrinkingGrowingArea * (openFromBottom ? 1.0 - percentOfWork : percentOfWork));
            boolean addedCollapsingSpace = false;
            int i = 0;
            while (i < this.items.size()) {
                if (i <= this.items.indexOf((Object)previousItem)) {
                    this.yCoordinates.add(new Integer(yTop));
                    yTop += this.itemHeight;
                } else if (i > this.items.indexOf((Object)newItem)) {
                    this.yCoordinates.add(new Integer(yBottom));
                    yBottom += this.itemHeight;
                } else {
                    if (!addedCollapsingSpace) {
                        yTop += collapsingGrowingSpace;
                        addedCollapsingSpace = true;
                    }
                    this.yCoordinates.add(new Integer(yTop));
                    yTop += this.itemHeight;
                }
                ++i;
            }
            this.sizeClients();
            this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, true);
            this.update();
            percentOfWork += this.animationSpeed;
        }
        this.computeItemYCoordinates();
        this.redraw();
    }

    void onResize() {
        this.computeItemYCoordinates();
        this.sizeClients();
        int clientHeight = this.getClientArea().height - this.itemHeight * this.items.size();
        for (PShelfItem item : this.items) {
            item.getBody().setBounds(0, 0, this.getClientArea().width, clientHeight);
        }
    }

    private void sizeClients() {
        if (this.openItem == null) {
            return;
        }
        if (this.items.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.items.size()) {
            PShelfItem item = this.items.get(i);
            int y = this.yCoordinates.get(i);
            int nextY = 0;
            nextY = i + 1 < this.items.size() ? this.yCoordinates.get(i + 1) : this.getClientArea().y + this.getClientArea().height;
            int clientHeight = nextY - y - this.itemHeight;
            if (clientHeight > 0) {
                item.getBodyParent().setVisible(true);
                item.getBodyParent().setBounds(0, y + this.itemHeight, this.getClientArea().width, clientHeight);
            } else {
                item.getBodyParent().setVisible(false);
            }
            ++i;
        }
    }

    void computeItemHeight() {
        GC gc = new GC((Drawable)this);
        for (PShelfItem item : this.items) {
            this.itemHeight = Math.max(this.renderer.computeSize((GC)gc, (int)0, (int)-1, (Object)((Object)item)).y, this.itemHeight);
        }
        gc.dispose();
    }

    public PShelfItem getItem(Point point) {
        this.checkWidget();
        int y1 = 0;
        int y2 = 0;
        if (point == null) {
            SWT.error((int)4);
        }
        for (PShelfItem item : this.items) {
            if (point.y >= y1 && point.y <= (y2 += this.itemHeight) - 1) {
                return item;
            }
            y1 += this.itemHeight;
            if (item != this.openItem) continue;
            y1 += this.openItem.getBodyParent().getSize().y;
            y2 += this.openItem.getBodyParent().getSize().y;
        }
        return null;
    }

    public void setSelection(PShelfItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (!this.items.contains((Object)item)) {
            return;
        }
        if (this.openItem == item) {
            return;
        }
        this.openItem(item, true);
    }

    public PShelfItem getSelection() {
        this.checkWidget();
        return this.openItem;
    }

    public PShelfItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new PShelfItem[this.items.size()]);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void removeAll() {
        this.checkWidget();
        while (!this.items.isEmpty()) {
            this.items.get(0).dispose();
        }
        this.onResize();
    }

    public void setAnimationSpeed(double animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    public void setRedrawOnAmination(boolean redrawOnAnimation) {
        this.redrawOnAnimation = redrawOnAnimation;
    }
}

