import type { Disposable, DocumentSelector, FormattingOptions, ProviderResult, ServiceContext, LanguageServicePlugin } from '@volar/language-service';
import * as html from 'vscode-html-languageservice';
import { TextDocument } from 'vscode-languageserver-textdocument';
export interface Provide {
    'html/htmlDocument': (document: TextDocument) => html.HTMLDocument | undefined;
    'html/languageService': () => html.LanguageService;
    'html/documentContext': () => html.DocumentContext;
}
export declare function create({ documentSelector, useDefaultDataProvider, getDocumentContext, isFormattingEnabled, isAutoCreateQuotesEnabled, isAutoClosingTagsEnabled, getFormattingOptions, getCompletionConfiguration, getHoverSettings, getCustomData, onDidChangeCustomData, }?: {
    documentSelector?: DocumentSelector;
    useDefaultDataProvider?: boolean;
    isFormattingEnabled?(document: TextDocument, context: ServiceContext): ProviderResult<boolean>;
    isAutoCreateQuotesEnabled?(document: TextDocument, context: ServiceContext): ProviderResult<boolean>;
    isAutoClosingTagsEnabled?(document: TextDocument, context: ServiceContext): ProviderResult<boolean>;
    getDocumentContext?(context: ServiceContext): html.DocumentContext;
    getFormattingOptions?(document: TextDocument, options: FormattingOptions, context: ServiceContext): ProviderResult<html.HTMLFormatConfiguration>;
    getCompletionConfiguration?(document: TextDocument, context: ServiceContext): ProviderResult<html.CompletionConfiguration | undefined>;
    getHoverSettings?(document: TextDocument, context: ServiceContext): ProviderResult<html.HoverSettings | undefined>;
    getCustomData?(context: ServiceContext): ProviderResult<html.IHTMLDataProvider[]>;
    onDidChangeCustomData?(listener: () => void, context: ServiceContext): Disposable;
}): LanguageServicePlugin;
//# sourceMappingURL=index.d.ts.map