"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.notEmpty = exports.sleep = exports.stringToSnapshot = exports.isEqualRange = exports.isInsideRange = exports.findOverlapCodeRange = void 0;
function findOverlapCodeRange(start, end, map, filter) {
    let mappedStart;
    let mappedEnd;
    for (const [mapped, mapping] of map.getGeneratedOffsets(start)) {
        if (filter(mapping.data)) {
            mappedStart = mapped;
            break;
        }
    }
    for (const [mapped, mapping] of map.getGeneratedOffsets(end)) {
        if (filter(mapping.data)) {
            mappedEnd = mapped;
            break;
        }
    }
    if (mappedStart === undefined || mappedEnd === undefined) {
        for (const mapping of map.mappings) {
            if (filter(mapping.data)) {
                const mappingStart = mapping.sourceOffsets[0];
                const mappingEnd = mapping.sourceOffsets[mapping.sourceOffsets.length - 1] + mapping.lengths[mapping.lengths.length - 1];
                const overlap = getOverlapRange(start, end, mappingStart, mappingEnd);
                if (overlap) {
                    const curMappedStart = (overlap.start - mappingStart) + mapping.generatedOffsets[0];
                    mappedStart = mappedStart === undefined ? curMappedStart : Math.min(mappedStart, curMappedStart);
                    const lastGeneratedLength = (mapping.generatedLengths ?? mapping.lengths)[mapping.generatedOffsets.length - 1];
                    const curMappedEndOffset = Math.min(overlap.end - mapping.sourceOffsets[mapping.sourceOffsets.length - 1], lastGeneratedLength);
                    const curMappedEnd = mapping.generatedOffsets[mapping.generatedOffsets.length - 1] + curMappedEndOffset;
                    mappedEnd = mappedEnd === undefined ? curMappedEnd : Math.max(mappedEnd, curMappedEnd);
                }
            }
        }
    }
    if (mappedStart !== undefined && mappedEnd !== undefined) {
        return {
            start: mappedStart,
            end: mappedEnd,
        };
    }
}
exports.findOverlapCodeRange = findOverlapCodeRange;
function getOverlapRange(range1Start, range1End, range2Start, range2End) {
    const start = Math.max(range1Start, range2Start);
    const end = Math.min(range1End, range2End);
    if (start > end) {
        return undefined;
    }
    return {
        start,
        end,
    };
}
function isInsideRange(parent, child) {
    if (child.start.line < parent.start.line) {
        return false;
    }
    if (child.end.line > parent.end.line) {
        return false;
    }
    if (child.start.line === parent.start.line && child.start.character < parent.start.character) {
        return false;
    }
    if (child.end.line === parent.end.line && child.end.character > parent.end.character) {
        return false;
    }
    return true;
}
exports.isInsideRange = isInsideRange;
function isEqualRange(a, b) {
    return a.start.line === b.start.line
        && a.start.character === b.start.character
        && a.end.line === b.end.line
        && a.end.character === b.end.character;
}
exports.isEqualRange = isEqualRange;
function stringToSnapshot(str) {
    return {
        getText: (start, end) => str.substring(start, end),
        getLength: () => str.length,
        getChangeRange: () => undefined,
    };
}
exports.stringToSnapshot = stringToSnapshot;
function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
exports.sleep = sleep;
function notEmpty(value) {
    return value !== null && value !== undefined;
}
exports.notEmpty = notEmpty;
//# sourceMappingURL=common.js.map