/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.model;

import java.util.Observable;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertyType;

public class Property
extends Observable
implements IProperty {
    private String _name;
    private String _label;
    private String _value;
    private IPropertyType _type;
    private boolean _isEnabled = true;
    private boolean _isReadOnly = false;

    public Property(IProperty property) {
        this._name = property.getKey();
        this._label = property.getLabel();
        this._value = property.getValue();
        this._type = property.getType();
        this._isEnabled = property.isEnabled();
        this.touch();
    }

    public Property(String name, String value, IPropertyType type, boolean isEnabled) {
        this._name = name;
        this._value = value;
        this._type = type;
        this._isEnabled = isEnabled;
        this.touch();
    }

    public String getKey() {
        return this._name;
    }

    public void setLabel(String label) {
        if (!this.stringsAreEqual(this._label, label)) {
            this._label = label;
            this.touch();
        }
    }

    public String getLabel() {
        if (this._label == null) {
            return this._name;
        }
        return this._label;
    }

    public void setValue(String value) {
        if (!this.stringsAreEqual(this._value, value)) {
            this._value = value;
            this.touch();
        }
    }

    public String getValue() {
        return this._value;
    }

    public void setType(IPropertyType type) {
        if (this._type != type) {
            this._type = type;
            this.touch();
        }
    }

    public IPropertyType getType() {
        return this._type;
    }

    public void setEnabled(boolean flag) {
        if (this._isEnabled != flag) {
            this._isEnabled = flag;
            this.touch();
        }
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setReadOnly(boolean flag) {
        if (this._isReadOnly != flag) {
            this._isReadOnly = flag;
            this.touch();
        }
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    private boolean stringsAreEqual(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private void touch() {
        this.setChanged();
        this.notifyObservers();
    }
}

