"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const language_service_1 = require("@volar/language-service");
function register(htmlLs) {
    return (pugDoc, pos) => {
        const htmlPos = pugDoc.map.toGeneratedPosition(pos);
        if (!htmlPos)
            return;
        const htmlResult = htmlLs.findDocumentHighlights(pugDoc.map.virtualFileDocument, htmlPos, pugDoc.htmlDocument);
        return language_service_1.transformer.asLocations(htmlResult, htmlRange => pugDoc.map.toSourceRange(htmlRange));
    };
}
exports.register = register;
//# sourceMappingURL=documentHighlight.js.map