/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguageProvider;
import org.eclipse.mylyn.wikitext.util.Messages;

public class ServiceLocator {
    protected final ClassLoader classLoader;
    private static Object implementationClassLock = new Object();
    private static Class<? extends ServiceLocator> implementationClass;
    private static Pattern CLASS_NAME_PATTERN;

    protected ServiceLocator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceLocator getInstance(ClassLoader classLoader) {
        Object object = implementationClassLock;
        synchronized (object) {
            if (implementationClass != null) {
                try {
                    return implementationClass.getConstructor(ClassLoader.class).newInstance(classLoader);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return new ServiceLocator(classLoader);
    }

    public static ServiceLocator getInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            ServiceLocator.class.getClassLoader();
        }
        return ServiceLocator.getInstance(loader);
    }

    public MarkupLanguage getMarkupLanguage(String languageName) throws IllegalArgumentException {
        String className;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)languageName) ? 1 : 0) != 0, (Object)"Must provide a languageName");
        Pattern classNamePattern = Pattern.compile("\\s*([^\\s#]+)?#?.*");
        ArrayList names = new ArrayList();
        ArrayList languages = new ArrayList();
        MarkupLanguage[] result = new MarkupLanguage[1];
        this.loadMarkupLanguages(language -> {
            if (languageName.equals(language.getName())) {
                result[0] = language;
                return false;
            }
            languages.add(language);
            names.add(language.getName());
            return true;
        });
        if (result[0] != null) {
            return result[0];
        }
        Matcher matcher = classNamePattern.matcher(languageName);
        if (matcher.matches() && (className = matcher.group(1)) != null) {
            for (MarkupLanguage language2 : languages) {
                if (!className.equals(language2.getClass().getName())) continue;
                return language2;
            }
            try {
                Class<?> clazz = Class.forName(className, true, this.classLoader);
                if (MarkupLanguage.class.isAssignableFrom(clazz)) {
                    MarkupLanguage instance = (MarkupLanguage)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    return instance;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Collections.sort(names);
        StringBuilder buf = new StringBuilder();
        for (String name : names) {
            if (buf.length() != 0) {
                buf.append(", ");
            }
            buf.append('\'');
            buf.append(name);
            buf.append('\'');
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("ServiceLocator.4"), languageName, buf.length() == 0 ? Messages.getString("ServiceLocator.5") : Messages.getString("ServiceLocator.6") + buf));
    }

    public Set<MarkupLanguage> getAllMarkupLanguages() {
        HashSet<MarkupLanguage> markupLanguages = new HashSet<MarkupLanguage>();
        this.loadMarkupLanguages(language -> {
            markupLanguages.add(language);
            return true;
        });
        return this.filterDuplicates(markupLanguages);
    }

    private Set<MarkupLanguage> filterDuplicates(Set<MarkupLanguage> markupLanguages) {
        HashMultimap markupLanguageClassesByName = HashMultimap.create();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (MarkupLanguage language : markupLanguages) {
            if (!markupLanguageClassesByName.put((Object)language.getName(), language.getClass())) continue;
            builder.add((Object)language);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setImplementation(Class<? extends ServiceLocator> implementationClass) {
        Object object = implementationClassLock;
        synchronized (object) {
            ServiceLocator.implementationClass = implementationClass;
        }
    }

    void loadMarkupLanguages(MarkupLanguageVisitor visitor) {
        for (ResourceDescriptor descriptor : this.discoverServiceResources()) {
            List<String> classNames = this.readServiceClassNames(descriptor.getUrl());
            for (String className : classNames) {
                try {
                    Class<?> clazz = this.loadClass(descriptor, className);
                    if (MarkupLanguage.class.isAssignableFrom(clazz)) {
                        MarkupLanguage instance = (MarkupLanguage)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (visitor.accept(instance)) continue;
                        return;
                    }
                    if (!MarkupLanguageProvider.class.isAssignableFrom(clazz)) continue;
                    MarkupLanguageProvider provider = (MarkupLanguageProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    for (MarkupLanguage language : provider.getMarkupLanguages()) {
                        if (visitor.accept(language)) continue;
                        return;
                    }
                }
                catch (Exception e) {
                    this.logFailure(className, e);
                }
            }
        }
    }

    void logFailure(String className, Exception e) {
        Logger.getLogger(ServiceLocator.class.getName()).log(Level.WARNING, MessageFormat.format(Messages.getString("ServiceLocator.0"), className), e);
    }

    protected Class<?> loadClass(ResourceDescriptor resource, String className) throws ClassNotFoundException {
        return Class.forName(className, true, this.classLoader);
    }

    protected List<ResourceDescriptor> discoverServiceResources() {
        ArrayList<ResourceDescriptor> serviceResources = new ArrayList<ResourceDescriptor>();
        for (String serviceResourceName : this.getClasspathServiceResourceNames()) {
            try {
                Enumeration<URL> resources = this.classLoader.getResources(serviceResourceName);
                while (resources.hasMoreElements()) {
                    serviceResources.add(new ResourceDescriptor(resources.nextElement()));
                }
            }
            catch (IOException e) {
                this.logReadServiceClassNamesFailure(e);
            }
        }
        return serviceResources;
    }

    protected List<String> getClasspathServiceResourceNames() {
        ArrayList<CallSite> paths = new ArrayList<CallSite>();
        for (String suffix : new String[]{"services/" + MarkupLanguage.class.getName(), "services/" + MarkupLanguageProvider.class.getName()}) {
            for (String prefix : new String[]{"", "META-INF/"}) {
                paths.add((CallSite)((Object)(prefix + suffix)));
            }
        }
        return List.copyOf(paths);
    }

    protected List<String> readServiceClassNames(URL url) {
        List<String> list;
        block8: {
            InputStream stream = url.openStream();
            try {
                list = this.readServiceClassNames(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logReadServiceClassNamesFailure(e);
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    List<String> readServiceClassNames(InputStream stream) {
        ArrayList<String> serviceClassNames = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                String className;
                Matcher matcher = CLASS_NAME_PATTERN.matcher(line);
                if (!matcher.matches() || (className = matcher.group(1)) == null) continue;
                serviceClassNames.add(className);
            }
        }
        catch (IOException e) {
            this.logReadServiceClassNamesFailure(e);
        }
        return serviceClassNames;
    }

    void logReadServiceClassNamesFailure(IOException e) {
        Logger.getLogger(ServiceLocator.class.getName()).log(Level.SEVERE, Messages.getString("ServiceLocator.1"), e);
    }

    static {
        CLASS_NAME_PATTERN = Pattern.compile("\\s*([^\\s#]+)?#?.*");
    }

    static interface MarkupLanguageVisitor {
        public boolean accept(MarkupLanguage var1);
    }

    protected static class ResourceDescriptor {
        private final URL url;

        public ResourceDescriptor(URL url) {
            this.url = Objects.requireNonNull(url);
        }

        public URL getUrl() {
            return this.url;
        }
    }
}

