/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.ide.dialogs.IElementFilter;

public class ResourceTreeAndListGroup
extends EventManager {
    private CheckListener checkListener = new CheckListener();
    private SelectionListener selectionListener = new SelectionListener();
    private TreeListener treeListener = new TreeListener();
    private Object root;
    private Object currentTreeSelection;
    private Collection expandedTreeNodes = new HashSet();
    private Map checkedStateStore = new HashMap(9);
    private HashSet whiteCheckedTreeItems = new HashSet();
    private ITreeContentProvider treeContentProvider;
    private IStructuredContentProvider listContentProvider;
    private ILabelProvider treeLabelProvider;
    private ILabelProvider listLabelProvider;
    private CheckboxTreeViewer treeViewer;
    private CheckboxTableViewer listViewer;
    private static int PREFERRED_HEIGHT = 150;

    public ResourceTreeAndListGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, boolean useHeightHint) {
        this.root = rootObject;
        this.treeContentProvider = treeContentProvider;
        this.listContentProvider = listContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.listLabelProvider = listLabelProvider;
        this.createContents(parent, style, useHeightHint);
    }

    protected void aboutToOpen() {
        Object primary;
        this.determineWhiteCheckedDescendents(this.root);
        this.checkNewTreeElements(this.treeContentProvider.getElements(this.root));
        this.currentTreeSelection = null;
        Object[] elements = this.treeContentProvider.getElements(this.root);
        Object object = primary = elements.length > 0 ? elements[0] : null;
        if (primary != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(primary));
        }
        this.treeViewer.getControl().setFocus();
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.addListenerObject(listener);
    }

    private boolean areAllChildrenWhiteChecked(Object treeElement) {
        Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!this.whiteCheckedTreeItems.contains(element)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean areAllElementsChecked(Object treeElement) {
        List checkedElements = (List)this.checkedStateStore.get(treeElement);
        if (checkedElements == null) {
            return false;
        }
        return this.getListItemsSize(treeElement) == checkedElements.size();
    }

    private void checkNewTreeElements(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentElement = objectArray[n2];
            boolean checked = this.checkedStateStore.containsKey(currentElement);
            this.treeViewer.setChecked(currentElement, checked);
            this.treeViewer.setGrayed(currentElement, checked && !this.whiteCheckedTreeItems.contains(currentElement));
            ++n2;
        }
    }

    private void createContents(Composite parent, int style, boolean useHeightHint) {
        Composite composite = new Composite(parent, style);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite, useHeightHint);
        this.createListViewer(composite, useHeightHint);
        this.initialize();
    }

    private void createListViewer(Composite parent, boolean useHeightHint) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        this.listViewer.setUseHashlookup(true);
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.addCheckStateListener((ICheckStateListener)this.checkListener);
    }

    private void createTreeViewer(Composite parent, boolean useHeightHint) {
        Tree tree = new Tree(parent, 2080);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addTreeListener((ITreeViewerListener)this.treeListener);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this.checkListener);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
    }

    private boolean determineShouldBeAtLeastGrayChecked(Object treeElement) {
        List checked = (List)this.checkedStateStore.get(treeElement);
        if (checked != null && !checked.isEmpty()) {
            return true;
        }
        if (this.expandedTreeNodes.contains(treeElement)) {
            Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.checkedStateStore.containsKey(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean determineShouldBeWhiteChecked(Object treeElement) {
        return this.areAllChildrenWhiteChecked(treeElement) && this.areAllElementsChecked(treeElement);
    }

    private void determineWhiteCheckedDescendents(Object treeElement) {
        Object[] objectArray = this.treeContentProvider.getElements(treeElement);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.determineWhiteCheckedDescendents(child);
            ++n2;
        }
        if (this.determineShouldBeWhiteChecked(treeElement)) {
            this.setWhiteChecked(treeElement, true);
        }
    }

    public void expandAll() {
        this.treeViewer.expandAll();
    }

    public void collapseAll() {
        this.treeViewer.collapseAll();
    }

    private void expandTreeElement(Object item) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
            if (this.expandedTreeNodes.contains(item)) {
                this.checkNewTreeElements(this.treeContentProvider.getChildren(item));
            } else {
                this.expandedTreeNodes.add(item);
                if (this.whiteCheckedTreeItems.contains(item)) {
                    Object[] objectArray = this.treeContentProvider.getChildren(item);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (!this.whiteCheckedTreeItems.contains(child)) {
                            this.setWhiteChecked(child, true);
                            this.treeViewer.setChecked(child, true);
                            this.checkedStateStore.put(child, new ArrayList());
                        }
                        ++n2;
                    }
                    this.setListForWhiteSelection(item);
                }
            }
        });
    }

    private void findAllSelectedListElements(Object treeElement, String parentLabel, boolean addAll, IElementFilter filter, IProgressMonitor monitor) throws InterruptedException {
        String fullLabel = null;
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (monitor != null) {
            fullLabel = this.getFullLabel(treeElement, parentLabel);
            monitor.subTask(fullLabel);
        }
        if (addAll) {
            filter.filterElements(this.listContentProvider.getElements(treeElement), monitor);
        } else if (this.checkedStateStore.containsKey(treeElement)) {
            filter.filterElements((Collection)this.checkedStateStore.get(treeElement), monitor);
        }
        Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (addAll) {
                this.findAllSelectedListElements(child, fullLabel, true, filter, monitor);
            } else if (this.checkedStateStore.containsKey(child)) {
                this.findAllSelectedListElements(child, fullLabel, this.whiteCheckedTreeItems.contains(child), filter, monitor);
            }
            ++n2;
        }
    }

    private void findAllWhiteCheckedItems(Object treeElement, Collection result) {
        if (this.whiteCheckedTreeItems.contains(treeElement)) {
            result.add(treeElement);
        } else {
            Collection listChildren = (Collection)this.checkedStateStore.get(treeElement);
            if (listChildren == null) {
                return;
            }
            result.addAll(listChildren);
            Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.findAllWhiteCheckedItems(child, result);
                ++n2;
            }
        }
    }

    public void getAllCheckedListItems(IElementFilter filter, IProgressMonitor monitor) throws InterruptedException {
        Object[] objectArray = this.treeContentProvider.getChildren(this.root);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.findAllSelectedListElements(child, null, this.whiteCheckedTreeItems.contains(child), filter, monitor);
            ++n2;
        }
    }

    public boolean isEveryItemChecked() {
        Object[] objectArray = this.treeContentProvider.getChildren(this.root);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!this.whiteCheckedTreeItems.contains(element)) {
                if (!this.treeViewer.getGrayed(element)) {
                    return false;
                }
                if (!this.isEveryChildrenChecked(element)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean isEveryChildrenChecked(Object treeElement) {
        Object[] listItems;
        List checked = (List)this.checkedStateStore.get(treeElement);
        if (checked != null && !checked.isEmpty() && (listItems = this.listContentProvider.getElements(treeElement)).length != checked.size()) {
            return false;
        }
        Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (!this.whiteCheckedTreeItems.contains(element)) {
                if (!this.treeViewer.getGrayed(element)) {
                    return false;
                }
                if (!this.isEveryChildrenChecked(element)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public List getAllCheckedListItems() {
        final ArrayList returnValue = new ArrayList();
        IElementFilter passThroughFilter = new IElementFilter(){

            @Override
            public void filterElements(Collection elements, IProgressMonitor monitor) {
                returnValue.addAll(elements);
            }

            @Override
            public void filterElements(Object[] elements, IProgressMonitor monitor) {
                returnValue.addAll(Arrays.asList(elements));
            }
        };
        try {
            this.getAllCheckedListItems(passThroughFilter, null);
        }
        catch (InterruptedException interruptedException) {
            return Collections.EMPTY_LIST;
        }
        return returnValue;
    }

    public List getAllListItems() {
        final ArrayList returnValue = new ArrayList();
        IElementFilter passThroughFilter = new IElementFilter(){

            @Override
            public void filterElements(Collection elements, IProgressMonitor monitor) {
                returnValue.addAll(elements);
            }

            @Override
            public void filterElements(Object[] elements, IProgressMonitor monitor) {
                returnValue.addAll(Arrays.asList(elements));
            }
        };
        try {
            Object[] objectArray = this.treeContentProvider.getChildren(this.root);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.findAllSelectedListElements(child, null, true, passThroughFilter, null);
                ++n2;
            }
        }
        catch (InterruptedException interruptedException) {
            return Collections.EMPTY_LIST;
        }
        return returnValue;
    }

    public List getAllWhiteCheckedItems() {
        ArrayList result = new ArrayList();
        Object[] objectArray = this.treeContentProvider.getChildren(this.root);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.findAllWhiteCheckedItems(child, result);
            ++n2;
        }
        return result;
    }

    public int getCheckedElementCount() {
        return this.checkedStateStore.size();
    }

    private String getFullLabel(Object treeElement, String parentLabel) {
        String label = parentLabel;
        if (parentLabel == null) {
            label = "";
        }
        Path parentName = new Path(label);
        String elementText = this.treeLabelProvider.getText(treeElement);
        if (elementText == null) {
            return parentName.toString();
        }
        return parentName.append(elementText).toString();
    }

    private int getListItemsSize(Object treeElement) {
        Object[] elements = this.listContentProvider.getElements(treeElement);
        return elements.length;
    }

    private void grayCheckHierarchy(Object treeElement) {
        this.expandTreeElement(treeElement);
        if (this.checkedStateStore.containsKey(treeElement)) {
            return;
        }
        this.checkedStateStore.put(treeElement, new ArrayList());
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent != null) {
            this.grayCheckHierarchy(parent);
        }
    }

    private void grayUpdateHierarchy(Object treeElement) {
        Object parent;
        boolean shouldBeAtLeastGray = this.determineShouldBeAtLeastGrayChecked(treeElement);
        this.treeViewer.setGrayChecked(treeElement, shouldBeAtLeastGray);
        if (this.whiteCheckedTreeItems.contains(treeElement)) {
            this.whiteCheckedTreeItems.remove(treeElement);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.grayUpdateHierarchy(parent);
        }
    }

    public void initialCheckListItem(Object element) {
        Object parent = this.treeContentProvider.getParent(element);
        this.selectAndReveal(parent);
        this.listViewer.setChecked(element, true);
        this.listItemChecked(element, true, false);
        this.grayUpdateHierarchy(parent);
    }

    public void initialCheckTreeItem(Object element) {
        this.treeItemChecked(element, true);
        this.selectAndReveal(element);
    }

    private void selectAndReveal(Object treeElement) {
        this.treeViewer.reveal(treeElement);
        StructuredSelection selection = new StructuredSelection(treeElement);
        this.treeViewer.setSelection((ISelection)selection);
    }

    private void initialize() {
        this.treeViewer.setInput(this.root);
        this.expandedTreeNodes = new HashSet();
        this.expandedTreeNodes.add(this.root);
    }

    private void listItemChecked(Object listElement, boolean state, boolean updatingFromSelection) {
        List checkedListItems = (List)this.checkedStateStore.get(this.currentTreeSelection);
        if (!this.expandedTreeNodes.contains(this.currentTreeSelection)) {
            this.expandTreeElement(this.currentTreeSelection);
        }
        if (state) {
            if (checkedListItems == null) {
                this.grayCheckHierarchy(this.currentTreeSelection);
                checkedListItems = (List)this.checkedStateStore.get(this.currentTreeSelection);
            }
            checkedListItems.add(listElement);
        } else {
            checkedListItems.remove(listElement);
            if (checkedListItems.isEmpty()) {
                this.ungrayCheckHierarchy(this.currentTreeSelection);
            }
        }
        if (checkedListItems.size() > 0) {
            this.checkedStateStore.put(this.currentTreeSelection, checkedListItems);
        }
        if (updatingFromSelection) {
            this.grayUpdateHierarchy(this.currentTreeSelection);
        }
    }

    private void notifyCheckStateChangeListeners(final CheckStateChangedEvent event) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ICheckStateListener checkStateListener = (ICheckStateListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    checkStateListener.checkStateChanged(event);
                }
            });
            ++n2;
        }
    }

    private void populateListViewer(Object treeElement) {
        this.listViewer.setInput(treeElement);
        if (!this.expandedTreeNodes.contains(treeElement) && this.whiteCheckedTreeItems.contains(treeElement)) {
            BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
                this.setListForWhiteSelection(treeElement);
                this.listViewer.setAllChecked(true);
            });
        } else {
            List listItemsToCheck = (List)this.checkedStateStore.get(treeElement);
            if (listItemsToCheck != null) {
                Iterator listItemsEnum = listItemsToCheck.iterator();
                while (listItemsEnum.hasNext()) {
                    this.listViewer.setChecked(listItemsEnum.next(), true);
                }
            }
        }
    }

    private void primeHierarchyForSelection(Object item, Set selectedNodes) {
        if (selectedNodes.contains(item)) {
            return;
        }
        this.checkedStateStore.put(item, new ArrayList());
        this.expandedTreeNodes.add(item);
        selectedNodes.add(item);
        Object parent = this.treeContentProvider.getParent(item);
        if (parent != null) {
            this.primeHierarchyForSelection(parent, selectedNodes);
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.removeListenerObject(listener);
    }

    public void setAllSelections(boolean selection) {
        if (this.root == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), () -> {
            this.setTreeChecked(this.root, selection);
            this.listViewer.setAllChecked(selection);
        });
    }

    private void setListForWhiteSelection(Object treeElement) {
        ArrayList<Object> listItemsChecked = new ArrayList<Object>(Arrays.asList(this.listContentProvider.getElements(treeElement)));
        this.checkedStateStore.put(treeElement, listItemsChecked);
    }

    public void setListProviders(IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
        this.listViewer.setContentProvider((IContentProvider)contentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.listContentProvider = contentProvider;
        this.listLabelProvider = labelProvider;
    }

    public void setListComparator(ViewerComparator comparator) {
        this.listViewer.setComparator(comparator);
    }

    public void setRoot(Object newRoot) {
        this.root = newRoot;
        this.initialize();
    }

    private void setTreeChecked(Object treeElement, boolean state) {
        if (treeElement.equals(this.currentTreeSelection)) {
            this.listViewer.setAllChecked(state);
        }
        if (state) {
            this.setListForWhiteSelection(treeElement);
        } else {
            this.checkedStateStore.remove(treeElement);
        }
        this.setWhiteChecked(treeElement, state);
        this.treeViewer.setChecked(treeElement, state);
        this.treeViewer.setGrayed(treeElement, false);
        if (this.expandedTreeNodes.contains(treeElement)) {
            Object[] objectArray = this.treeContentProvider.getChildren(treeElement);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.setTreeChecked(child, state);
                ++n2;
            }
        }
    }

    public void setTreeProviders(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        List items;
        if (this.root == null) {
            items = Collections.emptyList();
        } else {
            items = this.getAllWhiteCheckedItems();
            for (Object object : items) {
                this.setTreeChecked(object, false);
            }
        }
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeContentProvider = contentProvider;
        this.treeLabelProvider = labelProvider;
        for (Object object : items) {
            this.setTreeChecked(object, true);
        }
    }

    public void setTreeComparator(ViewerComparator comparator) {
        this.treeViewer.setComparator(comparator);
    }

    private void setWhiteChecked(Object treeElement, boolean isWhiteChecked) {
        if (isWhiteChecked) {
            if (!this.whiteCheckedTreeItems.contains(treeElement)) {
                this.whiteCheckedTreeItems.add(treeElement);
            }
        } else {
            this.whiteCheckedTreeItems.remove(treeElement);
        }
    }

    private void treeItemChecked(Object treeElement, boolean state) {
        this.setTreeChecked(treeElement, state);
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent == null || parent instanceof IWorkspaceRoot) {
            return;
        }
        if (state) {
            this.grayCheckHierarchy(parent);
        } else {
            this.ungrayCheckHierarchy(parent);
        }
        this.grayUpdateHierarchy(parent);
    }

    private void ungrayCheckHierarchy(Object treeElement) {
        Object parent;
        if (!this.determineShouldBeAtLeastGrayChecked(treeElement)) {
            this.checkedStateStore.remove(treeElement);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.ungrayCheckHierarchy(parent);
        }
    }

    public void updateSelections(Map items) {
        Object displayItems;
        this.listViewer.setAllChecked(false);
        this.treeViewer.setCheckedElements(new Object[0]);
        this.whiteCheckedTreeItems = new HashSet();
        HashSet selectedNodes = new HashSet();
        this.checkedStateStore = new HashMap();
        for (Map.Entry entry : items.entrySet()) {
            Object key = entry.getKey();
            List selections = (List)entry.getValue();
            this.checkedStateStore.put(key, selections);
            selectedNodes.add(key);
            Object parent = this.treeContentProvider.getParent(key);
            if (parent == null) continue;
            this.primeHierarchyForSelection(parent, selectedNodes);
        }
        this.treeViewer.setCheckedElements(this.checkedStateStore.keySet().toArray());
        this.treeViewer.setGrayedElements(this.checkedStateStore.keySet().toArray());
        if (this.currentTreeSelection != null && (displayItems = items.get(this.currentTreeSelection)) != null) {
            this.listViewer.setCheckedElements(((List)displayItems).toArray());
        }
    }

    public void setFocus() {
        Object[] elements;
        this.treeViewer.getTree().setFocus();
        if (this.treeViewer.getStructuredSelection().isEmpty() && (elements = this.treeContentProvider.getElements(this.root)).length > 0) {
            StructuredSelection selection = new StructuredSelection(elements[0]);
            this.treeViewer.setSelection((ISelection)selection);
        }
    }

    private class CheckListener
    implements ICheckStateListener {
        private CheckListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            BusyIndicator.showWhile((Display)ResourceTreeAndListGroup.this.treeViewer.getControl().getDisplay(), () -> {
                if (event.getCheckable().equals(ResourceTreeAndListGroup.this.treeViewer)) {
                    ResourceTreeAndListGroup.this.treeItemChecked(event.getElement(), event.getChecked());
                } else {
                    ResourceTreeAndListGroup.this.listItemChecked(event.getElement(), event.getChecked(), true);
                }
                ResourceTreeAndListGroup.this.notifyCheckStateChangeListeners(event);
            });
        }
    }

    private class SelectionListener
    implements ISelectionChangedListener {
        private SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = event.getStructuredSelection();
            Object selectedElement = selection.getFirstElement();
            if (selectedElement == null) {
                ResourceTreeAndListGroup.this.currentTreeSelection = null;
                ResourceTreeAndListGroup.this.listViewer.setInput(ResourceTreeAndListGroup.this.currentTreeSelection);
                return;
            }
            if (selectedElement != ResourceTreeAndListGroup.this.currentTreeSelection) {
                ResourceTreeAndListGroup.this.populateListViewer(selectedElement);
            }
            ResourceTreeAndListGroup.this.currentTreeSelection = selectedElement;
        }
    }

    private class TreeListener
    implements ITreeViewerListener {
        private TreeListener() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            ResourceTreeAndListGroup.this.expandTreeElement(event.getElement());
        }
    }
}

