/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;
import org.eclipse.wtp.releng.tools.component.ui.internal.WorkspaceFileLocation;

public class InitComponentManager
extends Job
implements IResourceProxyVisitor {
    private List scannableComps;

    public InitComponentManager() {
        super(ComponentManager.getManager().getMessage("JOB_INIT_COMPONENT_MANAGER"));
    }

    public IStatus run(IProgressMonitor monitor) {
        this.init();
        return new Status(0, "org.eclipse.wtp.releng.tools.component.ui", 0, "", null);
    }

    private void init() {
        this.scannableComps = new ArrayList();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                projects[i].accept((IResourceProxyVisitor)this, 2);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        ComponentManager manager = ComponentManager.getManager();
        Iterator it = this.scannableComps.iterator();
        while (it.hasNext()) {
            manager.addScannableComponent((ComponentXML)it.next());
        }
        this.scannableComps = null;
    }

    public boolean visit(IResourceProxy resProxy) {
        if (resProxy.getType() == 1 && resProxy.getName().equals("component.xml")) {
            IFile file = (IFile)resProxy.requestResource();
            WorkspaceFileLocation location = new WorkspaceFileLocation(file);
            ComponentXML compXML = new ComponentXML();
            compXML.setLocation((ILocation)location);
            try {
                compXML.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ComponentManager manager = ComponentManager.getManager();
            manager.addCompRef(compXML);
            Collection plugins = compXML.getPlugins();
            Iterator it = plugins.iterator();
            while (it.hasNext()) {
                if (!manager.isWorkspacePlugin(((Plugin)it.next()).getId())) continue;
                if (this.scannableComps == null) {
                    this.scannableComps = new ArrayList();
                }
                this.scannableComps.add(compXML);
                break;
            }
        }
        return true;
    }
}

