/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.progress;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.internal.ComponentEntry;
import org.eclipse.wtp.releng.tools.component.internal.ComponentSummary;

public class APITestCoverageSummary
extends ComponentSummary {
    private static final String ROOT_TAG_NAME = "component-api-tc-summary";
    private String refFileName;

    public APITestCoverageSummary(String refFileName) {
        this.refFileName = refFileName;
    }

    public void add(ComponentAPI compAPI) {
        APITestCoverageEntry entry = new APITestCoverageEntry();
        int apiCount = 0;
        int testCoverageCount = 0;
        entry.setCompName(compAPI.getName());
        Iterator it = compAPI.getPackageAPIs().iterator();
        while (it.hasNext()) {
            PackageAPI pkgAPI = (PackageAPI)it.next();
            Iterator classAPIsIt = pkgAPI.getClassAPIs().iterator();
            while (classAPIsIt.hasNext()) {
                ClassAPI classAPI = (ClassAPI)classAPIsIt.next();
                Collection methodAPIs = classAPI.getMethodAPIs();
                apiCount += methodAPIs.size();
                Iterator methodAPIsIt = methodAPIs.iterator();
                while (methodAPIsIt.hasNext()) {
                    MethodAPI methodAPI = (MethodAPI)methodAPIsIt.next();
                    if (methodAPI.countTestcases() <= 0) continue;
                    ++testCoverageCount;
                }
            }
        }
        entry.setApiCount(apiCount);
        entry.setTestCoverageCount(testCoverageCount);
        String ref = compAPI.getLocation().getAbsolutePath();
        int i = ref.lastIndexOf(47);
        if (i != -1) {
            ref = ref.substring(0, i + 1);
        }
        entry.setRef(String.valueOf(ref) + this.refFileName);
        this.add(entry);
    }

    public void saveAsHTML(String xsl, ILocation html) throws TransformerConfigurationException, TransformerException, IOException {
        this.saveAsHTML(html, xsl, ROOT_TAG_NAME);
    }

    public void save(ILocation location) throws IOException {
        this.save(location, ROOT_TAG_NAME);
    }

    private class APITestCoverageEntry
    extends ComponentEntry {
        private int apiCount = 0;
        private int testCoverageCount = 0;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<component-api-tc ");
            sb.append(this.toAttribute("name", this.getCompName()));
            sb.append(this.toAttribute("api-count", String.valueOf(this.apiCount)));
            sb.append(this.toAttribute("test-coverage-count", String.valueOf(this.testCoverageCount)));
            sb.append(this.toAttribute("missing-coverage-count", String.valueOf(this.apiCount - this.testCoverageCount)));
            sb.append(this.toAttribute("ref", this.getRef()));
            sb.append("/>");
            return sb.toString();
        }

        public int getApiCount() {
            return this.apiCount;
        }

        public void setApiCount(int apiCount) {
            this.apiCount = apiCount;
        }

        public int getTestCoverageCount() {
            return this.testCoverageCount;
        }

        public void setTestCoverageCount(int testCoverageCount) {
            this.testCoverageCount = testCoverageCount;
        }
    }
}

