/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.test.internal.performance.results.AbstractResults;
import org.eclipse.test.internal.performance.results.ComponentResults;
import org.eclipse.test.internal.performance.results.DB_Results;
import org.eclipse.test.internal.performance.results.ScenarioResults;

public class PerformanceResults
extends AbstractResults {
    final String baselineName;
    final String baselinePrefix;
    private String scenarioPattern;
    private List components;
    String[] configNames;
    String[] sortedConfigNames;
    private String[] configBoxes;
    private String[] sortedConfigBoxes;
    private String configPattern;

    public PerformanceResults(String name, String baseline, boolean print) {
        super(null, name);
        this.baselineName = baseline;
        this.baselinePrefix = baseline.substring(0, baseline.lastIndexOf(95));
        this.print = print;
    }

    public String getBaselineName() {
        return this.baselineName;
    }

    String getBaselinePrefix() {
        return this.baselinePrefix;
    }

    String getBuildDate() {
        return PerformanceResults.getBuildDate(this.name, this.baselinePrefix);
    }

    public List getComponents() {
        return this.components;
    }

    public List getComponentScenarios(String componentName) {
        ComponentResults componentResults = (ComponentResults)this.getResults(componentName);
        if (componentResults == null) {
            return null;
        }
        return Collections.unmodifiableList(componentResults.children);
    }

    public List getComponentSummaryScenarios(String componentName, String config) {
        if (componentName == null) {
            int size = this.size();
            ArrayList scenarios = new ArrayList();
            int i = 0;
            while (i < size) {
                ComponentResults componentResults = (ComponentResults)this.children.get(i);
                scenarios.addAll(componentResults.getSummaryScenarios(true, config));
                ++i;
            }
            return scenarios;
        }
        ComponentResults componentResults = (ComponentResults)this.getResults(componentName);
        return componentResults.getSummaryScenarios(false, config);
    }

    public String[] getConfigBoxes(boolean sort) {
        return sort ? this.sortedConfigBoxes : this.configBoxes;
    }

    public String[] getConfigNames(boolean sort) {
        return sort ? this.sortedConfigNames : this.configNames;
    }

    String getConfigurationsPattern() {
        if (this.configPattern == null) {
            int length;
            int n = length = this.sortedConfigNames == null ? 0 : this.sortedConfigNames.length;
            if (length == 0) {
                return null;
            }
            this.configPattern = this.sortedConfigNames[0];
            int refLength = this.configPattern.length();
            int i = 1;
            while (i < length) {
                String config = this.sortedConfigNames[i];
                StringBuffer newConfig = null;
                if (refLength != config.length()) {
                    return null;
                }
                int j = 0;
                while (j < refLength) {
                    char c = this.configPattern.charAt(j);
                    if (config.charAt(j) != c) {
                        if (newConfig == null) {
                            newConfig = new StringBuffer(refLength);
                            if (j == 0) {
                                return null;
                            }
                            newConfig.append(this.configPattern.substring(0, j));
                        }
                        newConfig.append('_');
                    } else if (newConfig != null) {
                        newConfig.append(c);
                    }
                    ++j;
                }
                if (newConfig != null) {
                    this.configPattern = newConfig.toString();
                }
                ++i;
            }
        }
        return this.configPattern;
    }

    PerformanceResults getPerformance() {
        return this;
    }

    public ScenarioResults getScenarioResults(String scenarioName) {
        ComponentResults componentResults = (ComponentResults)this.getResults(DB_Results.getComponentNameFromScenario(scenarioName));
        return componentResults == null ? null : (ScenarioResults)componentResults.getResults(scenarioName);
    }

    public void read(String[][] configs, String pattern) {
        this.read(configs, pattern, null);
    }

    public void read(String[][] configs, String pattern, File dataDir) {
        int i;
        int length;
        this.scenarioPattern = pattern;
        StringBuffer buffer = new StringBuffer("Read performance results until build '");
        buffer.append(this.name);
        if (this.scenarioPattern == null) {
            buffer.append("':");
        } else {
            buffer.append("' using scenario pattern '");
            buffer.append(this.scenarioPattern);
            buffer.append("':");
        }
        this.println(buffer);
        if (configs == null) {
            length = CONFIGS.length;
            this.configNames = new String[length];
            this.sortedConfigNames = new String[length];
            this.configBoxes = new String[length];
            i = 0;
            while (i < length) {
                this.configNames[i] = this.sortedConfigNames[i] = CONFIGS[i];
                this.configBoxes[i] = BOXES[i];
                ++i;
            }
        } else {
            length = configs.length;
            this.configNames = new String[length];
            this.sortedConfigNames = new String[length];
            this.configBoxes = new String[length];
            i = 0;
            while (i < length) {
                this.configNames[i] = this.sortedConfigNames[i] = configs[i][0];
                this.configBoxes[i] = configs[i][1];
                ++i;
            }
        }
        Arrays.sort(this.sortedConfigNames);
        length = this.sortedConfigNames.length;
        this.sortedConfigBoxes = new String[length];
        i = 0;
        while (i < length) {
            int j = 0;
            while (j < length) {
                if (this.sortedConfigNames[i] == this.configNames[j]) {
                    this.sortedConfigBoxes[i] = this.configBoxes[j];
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.print("\t+ get corresponding scenarios for build: " + this.name);
        long start = System.currentTimeMillis();
        Map allScenarios = DB_Results.queryAllScenarios(this.scenarioPattern, this.name);
        this.println(" -> " + (System.currentTimeMillis() - start) + "ms");
        List allComponents = DB_Results.getAllComponents();
        int size = allComponents.size();
        this.components = new ArrayList(size);
        int i2 = 0;
        while (i2 < size) {
            String componentName = (String)allComponents.get(i2);
            List scenarios = (List)allScenarios.get(componentName);
            if (scenarios != null) {
                this.components.add(componentName);
                ComponentResults componentResults = new ComponentResults((AbstractResults)this, componentName);
                this.addChild(componentResults, true);
                componentResults.read(scenarios, dataDir);
            }
            ++i2;
        }
        this.printGlobalTime(start);
    }
}

