/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IBytecodeVisitor;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ICodeAttribute;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.ILineNumberAttribute;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.wtp.releng.tools.component.IClazz;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.internal.FieldRef;
import org.eclipse.wtp.releng.tools.component.internal.InternalByteCodeVisitor;
import org.eclipse.wtp.releng.tools.component.internal.MethodRef;

public class Clazz
implements IClazz {
    private ILocation location;
    private String name;
    private IClassFileReader reader;
    private List methodRefs;
    private List fieldRefs;

    public Clazz(ILocation location) {
        this.location = location;
        this.reader = null;
    }

    private void init() {
        if (this.reader == null) {
            try {
                this.reader = new ClassFileReader(this.getInputBytes(), 47);
            }
            catch (ClassFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] getInputBytes() throws IOException {
        InputStream in = null;
        byte[] fBuffer = new byte[8192];
        ByteArrayOutputStream fBytesOut = new ByteArrayOutputStream(8192);
        try {
            try {
                fBytesOut.reset();
                in = this.location.getInputStream();
                int read = in.read(fBuffer);
                while (read != -1) {
                    fBytesOut.write(fBuffer, 0, read);
                    read = in.read(fBuffer);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            in.close();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        in.close();
        return fBytesOut.toByteArray();
    }

    public Set getReferencedTypes() {
        this.init();
        HashSet<String> types = new HashSet<String>();
        IConstantPool constantPool = this.reader.getConstantPool();
        int poolSize = constantPool.getConstantPoolCount();
        int i = 0;
        while (i < poolSize) {
            block3: {
                String signature;
                block4: {
                    if (constantPool.getEntryKind(i) != 7) break block3;
                    IConstantPoolEntry classEntry = constantPool.decodeEntry(i);
                    signature = new String(classEntry.getClassInfoName());
                    int index = signature.lastIndexOf(91);
                    if (index <= -1) break block4;
                    if (signature.length() - (index + 1) == 1) break block3;
                    signature = Signature.toString((String)signature);
                    signature = signature.substring(0, signature.length() - 2 * (index + 1));
                    signature = signature.replace('.', '$');
                }
                String typeName = signature.replace('/', '.');
                types.add(typeName);
            }
            ++i;
        }
        return types;
    }

    public List getMethodRefs(List includes, List excludes, boolean genLineInfo) {
        if (this.methodRefs == null) {
            List[] splitedIncludes = this.splitFilters(includes);
            List[] splitedExcludes = this.splitFilters(excludes);
            this.getRefs(splitedIncludes[0], splitedIncludes[1], splitedExcludes[0], splitedExcludes[1], genLineInfo);
        }
        return this.methodRefs;
    }

    public void resetMethodRefs() {
        this.methodRefs = null;
    }

    public List getFieldRefs(List includes, List excludes, boolean genLineInfo) {
        if (this.fieldRefs == null) {
            List[] splitedIncludes = this.splitFilters(includes);
            List[] splitedExcludes = this.splitFilters(excludes);
            this.getRefs(splitedIncludes[0], splitedIncludes[1], splitedExcludes[0], splitedExcludes[1], genLineInfo);
        }
        return this.fieldRefs;
    }

    public void resetFieldRefs() {
        this.fieldRefs = null;
    }

    private List[] splitFilters(List filters) {
        ArrayList<String> filtersStart = null;
        ArrayList<String> filtersMatch = null;
        if (filters != null) {
            Iterator it = filters.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (s.charAt(0) == '*' && s.charAt(s.length() - 1) == '*') {
                    if (filtersMatch == null) {
                        filtersMatch = new ArrayList<String>(1);
                    }
                    filtersMatch.add(s.substring(1, s.length() - 1));
                    continue;
                }
                if (filtersStart == null) {
                    filtersStart = new ArrayList<String>(1);
                }
                filtersStart.add(s);
            }
        }
        return new List[]{filtersStart, filtersMatch};
    }

    private void getRefs(List includes, List includesMatch, List excludes, List excludesMatch, boolean debug) {
        MethodRef methodRef;
        this.methodRefs = new ArrayList(1);
        this.fieldRefs = new ArrayList(1);
        IConstantPoolEntry[] refs = this.getConstantPoolEntries(10);
        int i = 0;
        while (i < refs.length) {
            if (this.isIncludeClass(includes, includesMatch, excludes, excludesMatch, this.decodeClassName(refs[i].getClassName()))) {
                methodRef = new MethodRef();
                methodRef.setPoolEntry(refs[i]);
                this.methodRefs.add(methodRef);
            }
            ++i;
        }
        refs = this.getConstantPoolEntries(11);
        i = 0;
        while (i < refs.length) {
            if (this.isIncludeClass(includes, includesMatch, excludes, excludesMatch, this.decodeClassName(refs[i].getClassName()))) {
                methodRef = new MethodRef();
                methodRef.setPoolEntry(refs[i]);
                this.methodRefs.add(methodRef);
            }
            ++i;
        }
        refs = this.getConstantPoolEntries(9);
        i = 0;
        while (i < refs.length) {
            if (this.isIncludeClass(includes, includesMatch, excludes, excludesMatch, this.decodeClassName(refs[i].getClassName()))) {
                FieldRef fieldRef = new FieldRef();
                fieldRef.setPoolEntry(refs[i]);
                this.fieldRefs.add(fieldRef);
            }
            ++i;
        }
        if (debug) {
            IMethodInfo[] methodInfos = this.getMethodInfo();
            int i2 = 0;
            while (i2 < methodInfos.length) {
                ILineNumberAttribute lineNumAttr;
                ICodeAttribute codeAttr = methodInfos[i2].getCodeAttribute();
                if (codeAttr != null && (lineNumAttr = codeAttr.getLineNumberAttribute()) != null) {
                    InternalByteCodeVisitor byteCodeVisitor = new InternalByteCodeVisitor(this.methodRefs, this.fieldRefs, lineNumAttr);
                    try {
                        codeAttr.traverse((IBytecodeVisitor)byteCodeVisitor);
                    }
                    catch (ClassFormatException e) {
                        e.printStackTrace();
                    }
                }
                ++i2;
            }
        }
    }

    public String getName() {
        if (this.name == null) {
            this.init();
            this.name = this.decodeClassName(this.reader.getClassName());
        }
        return this.name;
    }

    public String getSuperClass() {
        this.init();
        char[] superClass = this.reader.getSuperclassName();
        if (superClass != null) {
            return this.decodeClassName(superClass);
        }
        return null;
    }

    public String[] getInterfaces() {
        this.init();
        char[][] interfaceNames = this.reader.getInterfaceNames();
        String[] interfaces = new String[interfaceNames.length];
        int i = 0;
        while (i < interfaces.length) {
            interfaces[i] = this.decodeClassName(interfaceNames[i]);
            ++i;
        }
        return interfaces;
    }

    public IFieldInfo[] getFieldInfo() {
        this.init();
        return this.reader.getFieldInfos();
    }

    public IMethodInfo[] getMethodInfo() {
        this.init();
        return this.reader.getMethodInfos();
    }

    public IConstantPoolEntry[] getConstantPoolEntries(int kind) {
        this.init();
        Vector<IConstantPoolEntry> entries = new Vector<IConstantPoolEntry>();
        IConstantPool pool = this.reader.getConstantPool();
        int poolSize = pool.getConstantPoolCount();
        int i = 0;
        while (i < poolSize) {
            if (pool.getEntryKind(i) == kind) {
                entries.add(pool.decodeEntry(i));
            }
            ++i;
        }
        return entries.toArray(new IConstantPoolEntry[0]);
    }

    public boolean isInterface() {
        this.init();
        return (this.reader.getAccessFlags() & 0x200) == 512;
    }

    public int getAccessFlags() {
        this.init();
        return this.reader.getAccessFlags();
    }

    private String decodeClassName(char[] name) {
        return new String(name).replace('/', '.');
    }

    private boolean isIncludeClass(List classIncludes, List classIncludesMatch, List classExcludes, List classExcludesMatch, String className) {
        Iterator it;
        if (classExcludes != null) {
            it = classExcludes.iterator();
            while (it.hasNext()) {
                if (!className.startsWith((String)it.next())) continue;
                return false;
            }
        }
        if (classExcludesMatch != null) {
            it = classExcludesMatch.iterator();
            while (it.hasNext()) {
                if (className.indexOf((String)it.next()) == -1) continue;
                return false;
            }
        }
        if (classIncludes != null && classIncludes.size() > 0 || classIncludesMatch != null && classIncludesMatch.size() > 0) {
            if (classIncludes != null) {
                it = classIncludes.iterator();
                while (it.hasNext()) {
                    if (!className.startsWith((String)it.next())) continue;
                    return true;
                }
            }
            if (classIncludesMatch != null) {
                it = classIncludesMatch.iterator();
                while (it.hasNext()) {
                    if (className.indexOf((String)it.next()) == -1) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void resetClazz() {
        this.reader = null;
        this.methodRefs = null;
        this.fieldRefs = null;
    }
}

