/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.JavadocCoverage;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.osgi.framework.Bundle;

public class JavadocVisitor
extends ASTVisitor {
    private ComponentAPI compAPI;
    private String pluginId;
    private String packageName;
    private Map imports;
    private List classAPIs;

    public JavadocVisitor(ComponentAPI compAPI, String pluginId) {
        super(true);
        this.compAPI = compAPI;
        this.pluginId = pluginId;
        this.packageName = null;
        this.imports = new HashMap();
        this.classAPIs = new ArrayList();
    }

    public boolean visit(PackageDeclaration node) {
        this.packageName = node.getName().getFullyQualifiedName();
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        String fullName = node.getName().getFullyQualifiedName();
        int i = fullName.lastIndexOf(46);
        String localName = i != -1 ? fullName.substring(i + 1) : fullName;
        this.imports.put(localName, fullName);
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        String className;
        ClassAPI classAPI;
        PackageAPI pkgAPI;
        int modifiers = node.getModifiers();
        if (!Modifier.isPrivate((int)modifiers) && (pkgAPI = this.compAPI.getPackageAPI(this.packageName)) != null && (classAPI = pkgAPI.getClassAPI(className = this.getClassName(node.getName().getFullyQualifiedName()))) != null) {
            this.classAPIs.add(classAPI);
            Javadoc javadoc = node.getJavadoc();
            if (javadoc != null) {
                Iterator it = javadoc.tags().iterator();
                while (it.hasNext()) {
                    TagElement tag = (TagElement)it.next();
                    String tagName = tag.getTagName();
                    if (tagName == null || !tagName.equals("@since")) continue;
                    return true;
                }
            }
            classAPI.getJavadocCoverage().setHasSince(Boolean.FALSE);
            return true;
        }
        return false;
    }

    public void endVisit(TypeDeclaration node) {
        String className;
        ClassAPI classAPI;
        PackageAPI pkgAPI;
        int modifiers = node.getModifiers();
        if (!Modifier.isPrivate((int)modifiers) && (pkgAPI = this.compAPI.getPackageAPI(this.packageName)) != null && (classAPI = pkgAPI.getClassAPI(className = this.getClassName(node.getName().getFullyQualifiedName()))) != null) {
            this.classAPIs.remove(this.classAPIs.size() - 1);
        }
    }

    private String getClassName(String name) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.classAPIs.size()) {
            sb.append(((ClassAPI)this.classAPIs.get(i)).getName());
            sb.append('$');
            ++i;
        }
        sb.append(name);
        return sb.toString();
    }

    public boolean visit(MethodDeclaration node) {
        if (node.getParent().getNodeType() == 1) {
            return false;
        }
        ClassAPI classAPI = (ClassAPI)this.classAPIs.get(this.classAPIs.size() - 1);
        if (classAPI != null && !Modifier.isPrivate((int)node.getModifiers())) {
            String returnTypeString;
            boolean isConstructor = node.isConstructor();
            String methodName = isConstructor ? "&lt;init>" : node.getName().getFullyQualifiedName();
            List parameters = node.parameters();
            ArrayList<String> params = new ArrayList<String>(parameters.size());
            ArrayList<String> inputs = new ArrayList<String>(parameters.size());
            Iterator it = parameters.iterator();
            while (it.hasNext()) {
                SingleVariableDeclaration parameter = (SingleVariableDeclaration)it.next();
                params.add(parameter.getName().getIdentifier());
                inputs.add(this.getTypeString(parameter));
            }
            boolean hasReturn = isConstructor;
            Type returnType = node.getReturnType2();
            String string = returnTypeString = !isConstructor ? returnType.toString() : PrimitiveType.VOID.toString();
            if (!hasReturn && returnType instanceof PrimitiveType && ((PrimitiveType)returnType).getPrimitiveTypeCode() == PrimitiveType.VOID) {
                hasReturn = true;
            }
            List exs = node.thrownExceptions();
            ArrayList<String> thrownExceptions = new ArrayList<String>(exs.size());
            Iterator it2 = exs.iterator();
            while (it2.hasNext()) {
                Name name = (Name)it2.next();
                thrownExceptions.add(name.getFullyQualifiedName());
            }
            MethodAPI methodAPI = classAPI.getMethodAPI(methodName, inputs, returnTypeString);
            boolean hasJavadoc = false;
            Javadoc javadoc = node.getJavadoc();
            if (javadoc != null) {
                hasJavadoc = true;
                Iterator it3 = javadoc.tags().iterator();
                while (it3.hasNext()) {
                    MethodRef methodRef;
                    Object fragment;
                    List fragments;
                    TagElement tag = (TagElement)it3.next();
                    String tagName = tag.getTagName();
                    if (tagName == null) continue;
                    if (tagName.equals("@return")) {
                        hasReturn = tag.fragments().size() > 0;
                        continue;
                    }
                    if (tagName.equals("@param")) {
                        fragments = tag.fragments();
                        if (fragments.size() <= 1 || !((fragment = fragments.get(0)) instanceof SimpleName)) continue;
                        params.remove(((SimpleName)fragment).getIdentifier());
                        continue;
                    }
                    if (tagName.equals("@throws") || tagName.equals("@exception")) {
                        fragments = tag.fragments();
                        if (fragments.size() <= 1 || !((fragment = fragments.get(0)) instanceof Name)) continue;
                        thrownExceptions.remove(((Name)fragment).getFullyQualifiedName());
                        continue;
                    }
                    if (!(tagName.equals("@see") ? (fragments = tag.fragments()).size() > 0 && (fragment = fragments.get(0)) instanceof MethodRef && methodName.equals((methodRef = (MethodRef)fragment).getName().getFullyQualifiedName()) : tagName.equals("@inheritDoc"))) continue;
                    return true;
                }
            } else if (methodAPI != null && !isConstructor) {
                StringBuffer qualifiedClassName = new StringBuffer();
                qualifiedClassName.append(this.packageName);
                qualifiedClassName.append('.');
                qualifiedClassName.append(classAPI.getName());
                if (this.inheritJavadoc(qualifiedClassName.toString(), methodName, inputs)) {
                    return true;
                }
            }
            if (!(methodAPI == null || hasJavadoc && hasReturn && params.size() <= 0 && thrownExceptions.size() <= 0)) {
                Iterator it4;
                JavadocCoverage javadocCoverage = methodAPI.getJavadocCoverage();
                if (!hasJavadoc) {
                    javadocCoverage.setHasDoc(Boolean.FALSE);
                }
                if (!hasReturn) {
                    javadocCoverage.setHasReturn(Boolean.FALSE);
                }
                if (params.size() > 0) {
                    it4 = params.iterator();
                    while (it4.hasNext()) {
                        javadocCoverage.addMissingParam((String)it4.next());
                    }
                }
                if (thrownExceptions.size() > 0) {
                    it4 = thrownExceptions.iterator();
                    while (it4.hasNext()) {
                        javadocCoverage.addMissingThrow((String)it4.next());
                    }
                }
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean inheritJavadoc(String className, String methodName, List params) {
        if (this.pluginId == null) return false;
        Bundle bundle = Platform.getBundle((String)this.pluginId);
        if (bundle == null) return false;
        try {
            Class clazz = bundle.loadClass(className);
            if (clazz == null) return false;
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (true) {
                if (i >= interfaces.length) {
                    return this.hasMethod(clazz.getSuperclass(), methodName, params);
                }
                if (this.hasMethod(interfaces[i], methodName, params)) {
                    return true;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return false;
    }

    private boolean hasMethod(Class clazz, String methodName, List params) {
        if (clazz == null) {
            return false;
        }
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] paramClasses;
            if (methods[i].getName().equals(methodName) && (paramClasses = methods[i].getParameterTypes()).length == params.size()) {
                boolean paramsMatched = true;
                int j = 0;
                while (j < paramClasses.length) {
                    if (!paramClasses[j].getName().endsWith((String)params.get(j))) {
                        paramsMatched = false;
                        break;
                    }
                    ++j;
                }
                if (paramsMatched) {
                    return true;
                }
            }
            ++i;
        }
        if (!clazz.getName().equals("java.lang.Object")) {
            Class<?>[] interfaces = clazz.getInterfaces();
            int i2 = 0;
            while (i2 < interfaces.length) {
                if (this.hasMethod(interfaces[i2], methodName, params)) {
                    return true;
                }
                ++i2;
            }
            return this.hasMethod(clazz.getSuperclass(), methodName, params);
        }
        return false;
    }

    private String getTypeString(SingleVariableDeclaration svd) {
        int dim = svd.getExtraDimensions();
        StringBuffer sb = new StringBuffer();
        sb.append(svd.getType().toString());
        int i = 0;
        while (i < dim) {
            sb.append("[]");
            ++i;
        }
        return sb.toString();
    }

    public boolean visit(FieldDeclaration node) {
        VariableDeclarationFragment varDeclFragment;
        String fieldName;
        FieldAPI fieldAPI;
        ClassAPI classAPI = (ClassAPI)this.classAPIs.get(this.classAPIs.size() - 1);
        if (classAPI != null && !Modifier.isPrivate((int)node.getModifiers()) && (fieldAPI = classAPI.getFieldAPI(fieldName = (varDeclFragment = (VariableDeclarationFragment)node.fragments().iterator().next()).getName().getFullyQualifiedName())) != null && node.getJavadoc() == null) {
            fieldAPI.setJavadocCoverage(new JavadocCoverage());
        }
        return true;
    }
}

